// services/network/public/mojom/cross_origin_embedder_policy.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.RequestDestination');
goog.require('url.mojom.Url');




goog.provide('network.mojom.CrossOriginEmbedderPolicyValue');
goog.provide('network.mojom.CrossOriginEmbedderPolicyValueSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyValueSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyValue = {
  
  kNone: 0,
  kRequireCorp: 1,
  kCredentialless: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('network.mojom.CrossOriginEmbedderPolicyReporter');
goog.provide('network.mojom.CrossOriginEmbedderPolicyReporterReceiver');
goog.provide('network.mojom.CrossOriginEmbedderPolicyReporterCallbackRouter');
goog.provide('network.mojom.CrossOriginEmbedderPolicyReporterInterface');
goog.provide('network.mojom.CrossOriginEmbedderPolicyReporterRemote');
goog.provide('network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CrossOriginEmbedderPolicyReporter.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CrossOriginEmbedderPolicyReporterInterface = class {
  
  /**
   * @param { !url.mojom.Url } blockedUrl
   * @param { !network.mojom.RequestDestination } destination
   * @param { !boolean } reportOnly
   */

  queueCorpViolationReport(blockedUrl, destination, reportOnly) {}
  
  /**
   * @param { !network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver } receiver
   */

  clone(receiver) {}
};

/**
 * @export
 * @implements { network.mojom.CrossOriginEmbedderPolicyReporterInterface }
 */
network.mojom.CrossOriginEmbedderPolicyReporterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } blockedUrl
   * @param { !network.mojom.RequestDestination } destination
   * @param { !boolean } reportOnly
   */

  queueCorpViolationReport(
      blockedUrl,
      destination,
      reportOnly) {
    this.proxy.sendMessage(
        0,
        network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        [
          blockedUrl,
          destination,
          reportOnly
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        1,
        network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CrossOriginEmbedderPolicyReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyReporterReceiver = class {
  /**
   * @param {!network.mojom.CrossOriginEmbedderPolicyReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CrossOriginEmbedderPolicyReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CrossOriginEmbedderPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CrossOriginEmbedderPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        impl.queueCorpViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CrossOriginEmbedderPolicyReporter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CrossOriginEmbedderPolicyReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CrossOriginEmbedderPolicyReporterRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CrossOriginEmbedderPolicyReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CrossOriginEmbedderPolicyReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyReporterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CrossOriginEmbedderPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CrossOriginEmbedderPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCorpViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        this.queueCorpViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CrossOriginEmbedderPolicySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginEmbedderPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CrossOriginEmbedderPolicySpec.$,
    'CrossOriginEmbedderPolicy',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        network.mojom.CrossOriginEmbedderPolicyValueSpec.$,
        network.mojom.CrossOriginEmbedderPolicyValue.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingEndpoint', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnlyValue', 4,
        0,
        network.mojom.CrossOriginEmbedderPolicyValueSpec.$,
        network.mojom.CrossOriginEmbedderPolicyValue.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnlyReportingEndpoint', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CrossOriginEmbedderPolicy');

/** @record */
network.mojom.CrossOriginEmbedderPolicy = class {
  constructor() {
    /** @export { !network.mojom.CrossOriginEmbedderPolicyValue } */
    this.value;
    /** @export { (string|undefined) } */
    this.reportingEndpoint;
    /** @export { !network.mojom.CrossOriginEmbedderPolicyValue } */
    this.reportOnlyValue;
    /** @export { (string|undefined) } */
    this.reportOnlyReportingEndpoint;
  }
};



mojo.internal.Struct(
    network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
    'CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params',
    [
      mojo.internal.StructField(
        'blockedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destination', 8,
        0,
        network.mojom.RequestDestinationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnly', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params');

/** @record */
network.mojom.CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.blockedUrl;
    /** @export { !network.mojom.RequestDestination } */
    this.destination;
    /** @export { !boolean } */
    this.reportOnly;
  }
};



mojo.internal.Struct(
    network.mojom.CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
    'CrossOriginEmbedderPolicyReporter_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CrossOriginEmbedderPolicyReporter_Clone_Params');

/** @record */
network.mojom.CrossOriginEmbedderPolicyReporter_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.CrossOriginEmbedderPolicyReporterPendingReceiver } */
    this.receiver;
  }
};

