// services/network/public/mojom/cookie_access_observer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CookieAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CookieAccessObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.CookieAccessObserverInterface }
 */
network.mojom.CookieAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CookieAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CookieAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CookieAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!network.mojom.CookieAccessDetails> } details
   */

  onCookiesAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        network.mojom.CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieAccessObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        1,
        network.mojom.CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CookieAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CookieAccessObserverReceiver = class {
  /**
   * @param {!network.mojom.CookieAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CookieAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CookieAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        impl.onCookiesAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CookieAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CookieAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CookieAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CookieAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CookieAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CookieAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CookieAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCookiesAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        this.onCookiesAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieAccessObserver_OnCookiesAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieAccessDetailsSpec.TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieAccessDetails_Type = {
  
  kRead: 0,
  kChange: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    network.mojom.CookieAccessDetailsSpec.$,
    'CookieAccessDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.CookieAccessDetailsSpec.TypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 24,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 32,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieList', 40,
        0,
        mojo.internal.Array(network.mojom.CookieOrLineWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsRequestId', 48,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdTagged', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 56,
        0,
        network.mojom.CookieSettingOverridesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
network.mojom.CookieAccessDetails = class {
  constructor() {
    /** @export { !network.mojom.CookieAccessDetails_Type } */
    this.type;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (url.mojom.Origin|undefined) } */
    this.frameOrigin;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !Array<!network.mojom.CookieOrLineWithAccessResult> } */
    this.cookieList;
    /** @export { (string|undefined) } */
    this.devtoolsRequestId;
    /** @export { !boolean } */
    this.isAdTagged;
    /** @export { !network.mojom.CookieSettingOverrides } */
    this.cookieSettingOverrides;
  }
};



mojo.internal.Struct(
    network.mojom.CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
    'CookieAccessObserver_OnCookiesAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        mojo.internal.Array(network.mojom.CookieAccessDetailsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.CookieAccessObserver_OnCookiesAccessed_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.CookieAccessDetails> } */
    this.details;
  }
};



mojo.internal.Struct(
    network.mojom.CookieAccessObserver_Clone_ParamsSpec.$,
    'CookieAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.CookieAccessObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.CookieAccessObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieAccessObserverPendingReceiver } */
    this.listener;
  }
};

