// services/network/public/mojom/cert_verifier_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cert_verifier_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-params-data.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-import-headers.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace cert_verifier::mojom {
RequestParams::RequestParams()
    : certificate(),
      hostname(),
      flags(),
      ocsp_response(),
      sct_list() {}

RequestParams::RequestParams(
    const ::scoped_refptr<::net::X509Certificate>& certificate_in,
    const std::string& hostname_in,
    int32_t flags_in,
    const std::string& ocsp_response_in,
    const std::string& sct_list_in)
    : certificate(std::move(certificate_in)),
      hostname(std::move(hostname_in)),
      flags(std::move(flags_in)),
      ocsp_response(std::move(ocsp_response_in)),
      sct_list(std::move(sct_list_in)) {}

RequestParams::~RequestParams() = default;

void RequestParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "certificate"), this->certificate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<::net::X509Certificate>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hostname"), this->hostname,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ocsp_response"), this->ocsp_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sct_list"), this->sct_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierConfig::CertVerifierConfig()
    : enable_rev_checking(),
      require_rev_checking_local_anchors(),
      enable_sha1_local_anchors() {}

CertVerifierConfig::CertVerifierConfig(
    bool enable_rev_checking_in,
    bool require_rev_checking_local_anchors_in,
    bool enable_sha1_local_anchors_in)
    : enable_rev_checking(std::move(enable_rev_checking_in)),
      require_rev_checking_local_anchors(std::move(require_rev_checking_local_anchors_in)),
      enable_sha1_local_anchors(std::move(enable_sha1_local_anchors_in)) {}

CertVerifierConfig::~CertVerifierConfig() = default;

void CertVerifierConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_rev_checking"), this->enable_rev_checking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_rev_checking_local_anchors"), this->require_rev_checking_local_anchors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_sha1_local_anchors"), this->enable_sha1_local_anchors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertVerifierConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

URLLoaderFactoryConnector::IPCStableHashFunction URLLoaderFactoryConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::URLLoaderFactoryConnector>(message.name())) {
    case messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory: {
      return &URLLoaderFactoryConnector::CreateURLLoaderFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* URLLoaderFactoryConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::URLLoaderFactoryConnector>(message.name())) {
      case messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory:
            return "Receive cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory";
    }
  } else {
    switch (static_cast<messages::URLLoaderFactoryConnector>(message.name())) {
      case messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory:
            return "Receive reply cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t URLLoaderFactoryConnector::CreateURLLoaderFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x246cfd05;  // IPCStableHash for cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

URLLoaderFactoryConnectorProxy::URLLoaderFactoryConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderFactoryConnectorProxy::CreateURLLoaderFactory(
    ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> in_url_loader_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_url_loader_factory,
    &params->url_loader_factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid url_loader_factory in URLLoaderFactoryConnector.CreateURLLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactoryConnector::Name_);
  message.set_method_name("CreateURLLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool URLLoaderFactoryConnectorStubDispatch::Accept(
    URLLoaderFactoryConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::URLLoaderFactoryConnector>(message->header()->name)) {
    case messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory: {
      DCHECK(message->is_serialized());
      internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for URLLoaderFactoryConnector.0
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactoryConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateURLLoaderFactory(        
        std::move(p_url_loader_factory));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderFactoryConnectorStubDispatch::AcceptWithResponder(
    URLLoaderFactoryConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::URLLoaderFactoryConnector>(message->header()->name)) {
    case messages::URLLoaderFactoryConnector::kCreateURLLoaderFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kURLLoaderFactoryConnectorValidationInfo[] = {
    { &internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::Validate,
     nullptr /* no response */},
};

bool URLLoaderFactoryConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cert_verifier::mojom::URLLoaderFactoryConnector::Name_,
    kURLLoaderFactoryConnectorValidationInfo);
}

// The declaration includes the definition on other builds.

CertVerifierService::IPCStableHashFunction CertVerifierService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertVerifierService>(message.name())) {
    case messages::CertVerifierService::kEnableNetworkAccess: {
      return &CertVerifierService::EnableNetworkAccess_Sym::IPCStableHash;
    }
    case messages::CertVerifierService::kVerify: {
      return &CertVerifierService::Verify_Sym::IPCStableHash;
    }
    case messages::CertVerifierService::kVerify2QwacBinding: {
      return &CertVerifierService::Verify2QwacBinding_Sym::IPCStableHash;
    }
    case messages::CertVerifierService::kSetConfig: {
      return &CertVerifierService::SetConfig_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertVerifierService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertVerifierService>(message.name())) {
      case messages::CertVerifierService::kEnableNetworkAccess:
            return "Receive cert_verifier::mojom::CertVerifierService::EnableNetworkAccess";
      case messages::CertVerifierService::kVerify:
            return "Receive cert_verifier::mojom::CertVerifierService::Verify";
      case messages::CertVerifierService::kVerify2QwacBinding:
            return "Receive cert_verifier::mojom::CertVerifierService::Verify2QwacBinding";
      case messages::CertVerifierService::kSetConfig:
            return "Receive cert_verifier::mojom::CertVerifierService::SetConfig";
    }
  } else {
    switch (static_cast<messages::CertVerifierService>(message.name())) {
      case messages::CertVerifierService::kEnableNetworkAccess:
            return "Receive reply cert_verifier::mojom::CertVerifierService::EnableNetworkAccess";
      case messages::CertVerifierService::kVerify:
            return "Receive reply cert_verifier::mojom::CertVerifierService::Verify";
      case messages::CertVerifierService::kVerify2QwacBinding:
            return "Receive reply cert_verifier::mojom::CertVerifierService::Verify2QwacBinding";
      case messages::CertVerifierService::kSetConfig:
            return "Receive reply cert_verifier::mojom::CertVerifierService::SetConfig";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertVerifierService::EnableNetworkAccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb596f653;  // IPCStableHash for cert_verifier::mojom::CertVerifierService::EnableNetworkAccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierService::Verify_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b9a0cdf;  // IPCStableHash for cert_verifier::mojom::CertVerifierService::Verify
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierService::Verify2QwacBinding_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0da86f4c;  // IPCStableHash for cert_verifier::mojom::CertVerifierService::Verify2QwacBinding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierService::SetConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf80fe0a5;  // IPCStableHash for cert_verifier::mojom::CertVerifierService::SetConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CertVerifierService_Verify2QwacBinding_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierService_Verify2QwacBinding_ForwardToCallback(
      CertVerifierService::Verify2QwacBindingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierService_Verify2QwacBinding_ForwardToCallback(const CertVerifierService_Verify2QwacBinding_ForwardToCallback&) = delete;
  CertVerifierService_Verify2QwacBinding_ForwardToCallback& operator=(const CertVerifierService_Verify2QwacBinding_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierService::Verify2QwacBindingCallback callback_;
};

CertVerifierServiceProxy::CertVerifierServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceProxy::EnableNetworkAccess(
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> in_reconnector) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierService::EnableNetworkAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reconnector"), in_reconnector,
                        "<value of type ::mojo::PendingRemote<URLLoaderFactoryConnector>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierService::kEnableNetworkAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_EnableNetworkAccess_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_url_loader_factory,
    &params->url_loader_factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid url_loader_factory in CertVerifierService.EnableNetworkAccess request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::URLLoaderFactoryConnectorInterfaceBase>>(
    in_reconnector,
    &params->reconnector,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("EnableNetworkAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertVerifierServiceProxy::Verify(
    const ::net::CertVerifier::RequestParams& in_params, const ::net::NetLogSource& in_net_log_source, ::mojo::PendingRemote<CertVerifierRequest> in_cert_verifier_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierService::Verify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::net::CertVerifier::RequestParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_log_source"), in_net_log_source,
                        "<value of type const ::net::NetLogSource&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_verifier_request"), in_cert_verifier_request,
                        "<value of type ::mojo::PendingRemote<CertVerifierRequest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierService::kVerify), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_Verify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::cert_verifier::mojom::RequestParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in CertVerifierService.Verify request");
  mojo::internal::MessageFragment<
      typename decltype(params->net_log_source)::BaseType> net_log_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
    in_net_log_source,
    net_log_source_fragment);

  params->net_log_source.Set(
      net_log_source_fragment.is_null() ? nullptr : net_log_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->net_log_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null net_log_source in CertVerifierService.Verify request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierRequestInterfaceBase>>(
    in_cert_verifier_request,
    &params->cert_verifier_request,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->cert_verifier_request)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid cert_verifier_request in CertVerifierService.Verify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("Verify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertVerifierServiceProxy::Verify2QwacBinding(
    const std::string& in_binding, const std::string& in_hostname, const ::scoped_refptr<::net::X509Certificate>& in_tls_certificate, const ::net::NetLogSource& in_net_log_source, Verify2QwacBindingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierService::Verify2QwacBinding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binding"), in_binding,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hostname"), in_hostname,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tls_certificate"), in_tls_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_log_source"), in_net_log_source,
                        "<value of type const ::net::NetLogSource&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierService::kVerify2QwacBinding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_Verify2QwacBinding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binding)::BaseType> binding_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_binding,
    binding_fragment);

  params->binding.Set(
      binding_fragment.is_null() ? nullptr : binding_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->binding.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null binding in CertVerifierService.Verify2QwacBinding request");
  mojo::internal::MessageFragment<
      typename decltype(params->hostname)::BaseType> hostname_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hostname,
    hostname_fragment);

  params->hostname.Set(
      hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hostname.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hostname in CertVerifierService.Verify2QwacBinding request");
  mojo::internal::MessageFragment<
      typename decltype(params->tls_certificate)::BaseType> tls_certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_tls_certificate,
    tls_certificate_fragment);

  params->tls_certificate.Set(
      tls_certificate_fragment.is_null() ? nullptr : tls_certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tls_certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tls_certificate in CertVerifierService.Verify2QwacBinding request");
  mojo::internal::MessageFragment<
      typename decltype(params->net_log_source)::BaseType> net_log_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
    in_net_log_source,
    net_log_source_fragment);

  params->net_log_source.Set(
      net_log_source_fragment.is_null() ? nullptr : net_log_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->net_log_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null net_log_source in CertVerifierService.Verify2QwacBinding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("Verify2QwacBinding");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierService_Verify2QwacBinding_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceProxy::SetConfig(
    const ::net::CertVerifier::Config& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierService::SetConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::net::CertVerifier::Config&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierService::kSetConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_SetConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::cert_verifier::mojom::CertVerifierConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in CertVerifierService.SetConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("SetConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CertVerifierService_Verify2QwacBinding_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierService::Verify2QwacBindingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierService_Verify2QwacBinding_ProxyToResponder> proxy(
        new CertVerifierService_Verify2QwacBinding_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierService_Verify2QwacBinding_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierService_Verify2QwacBinding_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierService_Verify2QwacBinding_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertVerifierService::Verify2QwacBindingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::scoped_refptr<::net::X509Certificate>& in_verified_cert);
};

bool CertVerifierService_Verify2QwacBinding_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierService_Verify2QwacBinding_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierService_Verify2QwacBinding_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertVerifierService.2
  bool success = true;
  ::scoped_refptr<::net::X509Certificate> p_verified_cert{};
  CertVerifierService_Verify2QwacBinding_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVerifiedCert(&p_verified_cert))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_verified_cert));
  }
  return true;
}

void CertVerifierService_Verify2QwacBinding_ProxyToResponder::Run(
    const ::scoped_refptr<::net::X509Certificate>& in_verified_cert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply cert_verifier::mojom::CertVerifierService::Verify2QwacBinding", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("verified_cert"), in_verified_cert,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierService::kVerify2QwacBinding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_Verify2QwacBinding_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->verified_cert)::BaseType> verified_cert_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_verified_cert,
    verified_cert_fragment);

  params->verified_cert.Set(
      verified_cert_fragment.is_null() ? nullptr : verified_cert_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->verified_cert.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null verified_cert in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("Verify2QwacBinding");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CertVerifierServiceStubDispatch::Accept(
    CertVerifierService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertVerifierService>(message->header()->name)) {
    case messages::CertVerifierService::kEnableNetworkAccess: {
      DCHECK(message->is_serialized());
      internal::CertVerifierService_EnableNetworkAccess_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_EnableNetworkAccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierService.0
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      ::mojo::PendingRemote<URLLoaderFactoryConnector> p_reconnector{};
      CertVerifierService_EnableNetworkAccess_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success) {
        p_reconnector =
            input_data_view.TakeReconnector<decltype(p_reconnector)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableNetworkAccess(        
        std::move(p_url_loader_factory), 
        std::move(p_reconnector));
      return true;
    }
    case messages::CertVerifierService::kVerify: {
      DCHECK(message->is_serialized());
      internal::CertVerifierService_Verify_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_Verify_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierService.1
      bool success = true;
      ::net::CertVerifier::RequestParams p_params{};
      ::net::NetLogSource p_net_log_source{};
      ::mojo::PendingRemote<CertVerifierRequest> p_cert_verifier_request{};
      CertVerifierService_Verify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadNetLogSource(&p_net_log_source))
        success = false;
      if (success) {
        p_cert_verifier_request =
            input_data_view.TakeCertVerifierRequest<decltype(p_cert_verifier_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Verify(        
        std::move(p_params), 
        std::move(p_net_log_source), 
        std::move(p_cert_verifier_request));
      return true;
    }
    case messages::CertVerifierService::kVerify2QwacBinding: {
      break;
    }
    case messages::CertVerifierService::kSetConfig: {
      DCHECK(message->is_serialized());
      internal::CertVerifierService_SetConfig_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_SetConfig_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierService.3
      bool success = true;
      ::net::CertVerifier::Config p_config{};
      CertVerifierService_SetConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetConfig(        
        std::move(p_config));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceStubDispatch::AcceptWithResponder(
    CertVerifierService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertVerifierService>(message->header()->name)) {
    case messages::CertVerifierService::kEnableNetworkAccess: {
      break;
    }
    case messages::CertVerifierService::kVerify: {
      break;
    }
    case messages::CertVerifierService::kVerify2QwacBinding: {
      internal::CertVerifierService_Verify2QwacBinding_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierService_Verify2QwacBinding_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertVerifierService.2
      bool success = true;
      std::string p_binding{};
      std::string p_hostname{};
      ::scoped_refptr<::net::X509Certificate> p_tls_certificate{};
      ::net::NetLogSource p_net_log_source{};
      CertVerifierService_Verify2QwacBinding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinding(&p_binding))
        success = false;
      if (success && !input_data_view.ReadHostname(&p_hostname))
        success = false;
      if (success && !input_data_view.ReadTlsCertificate(&p_tls_certificate))
        success = false;
      if (success && !input_data_view.ReadNetLogSource(&p_net_log_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 2, false);
        return false;
      }
      auto callback =
          CertVerifierService_Verify2QwacBinding_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Verify2QwacBinding(        
        std::move(p_binding), 
        std::move(p_hostname), 
        std::move(p_tls_certificate), 
        std::move(p_net_log_source), std::move(callback));
      return true;
    }
    case messages::CertVerifierService::kSetConfig: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertVerifierServiceValidationInfo[] = {
    { &internal::CertVerifierService_EnableNetworkAccess_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertVerifierService_Verify_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertVerifierService_Verify2QwacBinding_Params_Data::Validate,
     &internal::CertVerifierService_Verify2QwacBinding_ResponseParams_Data::Validate},
    { &internal::CertVerifierService_SetConfig_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertVerifierServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierService::Name_,
    kCertVerifierServiceValidationInfo);
}

bool CertVerifierServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierService::Name_,
    kCertVerifierServiceValidationInfo);
}
// The declaration includes the definition on other builds.

CertVerifierServiceClient::IPCStableHashFunction CertVerifierServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertVerifierServiceClient>(message.name())) {
    case messages::CertVerifierServiceClient::kOnCertVerifierChanged: {
      return &CertVerifierServiceClient::OnCertVerifierChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertVerifierServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertVerifierServiceClient>(message.name())) {
      case messages::CertVerifierServiceClient::kOnCertVerifierChanged:
            return "Receive cert_verifier::mojom::CertVerifierServiceClient::OnCertVerifierChanged";
    }
  } else {
    switch (static_cast<messages::CertVerifierServiceClient>(message.name())) {
      case messages::CertVerifierServiceClient::kOnCertVerifierChanged:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceClient::OnCertVerifierChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertVerifierServiceClient::OnCertVerifierChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa430b2c;  // IPCStableHash for cert_verifier::mojom::CertVerifierServiceClient::OnCertVerifierChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CertVerifierServiceClientProxy::CertVerifierServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceClientProxy::OnCertVerifierChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send cert_verifier::mojom::CertVerifierServiceClient::OnCertVerifierChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceClient::kOnCertVerifierChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceClient_OnCertVerifierChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceClient::Name_);
  message.set_method_name("OnCertVerifierChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CertVerifierServiceClientStubDispatch::Accept(
    CertVerifierServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertVerifierServiceClient>(message->header()->name)) {
    case messages::CertVerifierServiceClient::kOnCertVerifierChanged: {
      DCHECK(message->is_serialized());
      internal::CertVerifierServiceClient_OnCertVerifierChanged_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceClient_OnCertVerifierChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierServiceClient.0
      bool success = true;
      CertVerifierServiceClient_OnCertVerifierChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCertVerifierChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceClientStubDispatch::AcceptWithResponder(
    CertVerifierServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertVerifierServiceClient>(message->header()->name)) {
    case messages::CertVerifierServiceClient::kOnCertVerifierChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertVerifierServiceClientValidationInfo[] = {
    { &internal::CertVerifierServiceClient_OnCertVerifierChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertVerifierServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierServiceClient::Name_,
    kCertVerifierServiceClientValidationInfo);
}

// The declaration includes the definition on other builds.

CertVerifierRequest::IPCStableHashFunction CertVerifierRequest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertVerifierRequest>(message.name())) {
    case messages::CertVerifierRequest::kComplete: {
      return &CertVerifierRequest::Complete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertVerifierRequest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertVerifierRequest>(message.name())) {
      case messages::CertVerifierRequest::kComplete:
            return "Receive cert_verifier::mojom::CertVerifierRequest::Complete";
    }
  } else {
    switch (static_cast<messages::CertVerifierRequest>(message.name())) {
      case messages::CertVerifierRequest::kComplete:
            return "Receive reply cert_verifier::mojom::CertVerifierRequest::Complete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertVerifierRequest::Complete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d708924;  // IPCStableHash for cert_verifier::mojom::CertVerifierRequest::Complete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CertVerifierRequestProxy::CertVerifierRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierRequestProxy::Complete(
    const ::net::CertVerifyResult& in_result, int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierRequest::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::net::CertVerifyResult&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierRequest::kComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierRequest_Complete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in CertVerifierRequest.Complete request");

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierRequest::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CertVerifierRequestStubDispatch::Accept(
    CertVerifierRequest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertVerifierRequest>(message->header()->name)) {
    case messages::CertVerifierRequest::kComplete: {
      DCHECK(message->is_serialized());
      internal::CertVerifierRequest_Complete_Params_Data* params =
          reinterpret_cast<internal::CertVerifierRequest_Complete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierRequest.0
      bool success = true;
      ::net::CertVerifyResult p_result{};
      int32_t p_net_error{};
      CertVerifierRequest_Complete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(        
        std::move(p_result), 
        std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierRequestStubDispatch::AcceptWithResponder(
    CertVerifierRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertVerifierRequest>(message->header()->name)) {
    case messages::CertVerifierRequest::kComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertVerifierRequestValidationInfo[] = {
    { &internal::CertVerifierRequest_Complete_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertVerifierRequestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierRequest::Name_,
    kCertVerifierRequestValidationInfo);
}



}  // cert_verifier::mojom


namespace mojo {


// static
bool StructTraits<::cert_verifier::mojom::RequestParams::DataView, ::cert_verifier::mojom::RequestParamsPtr>::Read(
    ::cert_verifier::mojom::RequestParams::DataView input,
    ::cert_verifier::mojom::RequestParamsPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::RequestParamsPtr result(::cert_verifier::mojom::RequestParams::New());
  
      if (success && !input.ReadCertificate(&result->certificate))
        success = false;
      if (success && !input.ReadHostname(&result->hostname))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadOcspResponse(&result->ocsp_response))
        success = false;
      if (success && !input.ReadSctList(&result->sct_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::CertVerifierConfig::DataView, ::cert_verifier::mojom::CertVerifierConfigPtr>::Read(
    ::cert_verifier::mojom::CertVerifierConfig::DataView input,
    ::cert_verifier::mojom::CertVerifierConfigPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::CertVerifierConfigPtr result(::cert_verifier::mojom::CertVerifierConfig::New());
  
      if (success)
        result->enable_rev_checking = input.enable_rev_checking();
      if (success)
        result->require_rev_checking_local_anchors = input.require_rev_checking_local_anchors();
      if (success)
        result->enable_sha1_local_anchors = input.enable_sha1_local_anchors();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cert_verifier::mojom {


void URLLoaderFactoryConnectorInterceptorForTesting::CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory) {
  GetForwardingInterface()->CreateURLLoaderFactory(
    std::move(url_loader_factory)
    );
}
URLLoaderFactoryConnectorAsyncWaiter::URLLoaderFactoryConnectorAsyncWaiter(
    URLLoaderFactoryConnector* proxy) : proxy_(proxy) {}

URLLoaderFactoryConnectorAsyncWaiter::~URLLoaderFactoryConnectorAsyncWaiter() = default;





void CertVerifierServiceInterceptorForTesting::EnableNetworkAccess(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> reconnector) {
  GetForwardingInterface()->EnableNetworkAccess(
    std::move(url_loader_factory)
    , 
    std::move(reconnector)
    );
}
void CertVerifierServiceInterceptorForTesting::Verify(const ::net::CertVerifier::RequestParams& params, const ::net::NetLogSource& net_log_source, ::mojo::PendingRemote<CertVerifierRequest> cert_verifier_request) {
  GetForwardingInterface()->Verify(
    std::move(params)
    , 
    std::move(net_log_source)
    , 
    std::move(cert_verifier_request)
    );
}
void CertVerifierServiceInterceptorForTesting::Verify2QwacBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, const ::net::NetLogSource& net_log_source, Verify2QwacBindingCallback callback) {
  GetForwardingInterface()->Verify2QwacBinding(
    std::move(binding)
    , 
    std::move(hostname)
    , 
    std::move(tls_certificate)
    , 
    std::move(net_log_source)
    , std::move(callback));
}
void CertVerifierServiceInterceptorForTesting::SetConfig(const ::net::CertVerifier::Config& config) {
  GetForwardingInterface()->SetConfig(
    std::move(config)
    );
}
CertVerifierServiceAsyncWaiter::CertVerifierServiceAsyncWaiter(
    CertVerifierService* proxy) : proxy_(proxy) {}

CertVerifierServiceAsyncWaiter::~CertVerifierServiceAsyncWaiter() = default;


void CertVerifierServiceAsyncWaiter::Verify2QwacBinding(
    const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, const ::net::NetLogSource& net_log_source, ::scoped_refptr<::net::X509Certificate>* out_verified_cert) {
  base::RunLoop loop;
  proxy_->Verify2QwacBinding(
      std::move(binding),
      std::move(hostname),
      std::move(tls_certificate),
      std::move(net_log_source),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::scoped_refptr<::net::X509Certificate>* out_verified_cert
,
             const ::scoped_refptr<::net::X509Certificate>& verified_cert) {*out_verified_cert = std::move(verified_cert);
            loop->Quit();
          },
          &loop,
          out_verified_cert));
  loop.Run();
}

::scoped_refptr<::net::X509Certificate> CertVerifierServiceAsyncWaiter::Verify2QwacBinding(
    const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, const ::net::NetLogSource& net_log_source) {
  ::scoped_refptr<::net::X509Certificate> async_wait_result;
  Verify2QwacBinding(std::move(binding),std::move(hostname),std::move(tls_certificate),std::move(net_log_source),&async_wait_result);
  return async_wait_result;
}




void CertVerifierServiceClientInterceptorForTesting::OnCertVerifierChanged() {
  GetForwardingInterface()->OnCertVerifierChanged();
}
CertVerifierServiceClientAsyncWaiter::CertVerifierServiceClientAsyncWaiter(
    CertVerifierServiceClient* proxy) : proxy_(proxy) {}

CertVerifierServiceClientAsyncWaiter::~CertVerifierServiceClientAsyncWaiter() = default;





void CertVerifierRequestInterceptorForTesting::Complete(const ::net::CertVerifyResult& result, int32_t net_error) {
  GetForwardingInterface()->Complete(
    std::move(result)
    , 
    std::move(net_error)
    );
}
CertVerifierRequestAsyncWaiter::CertVerifierRequestAsyncWaiter(
    CertVerifierRequest* proxy) : proxy_(proxy) {}

CertVerifierRequestAsyncWaiter::~CertVerifierRequestAsyncWaiter() = default;







}  // cert_verifier::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif