// services/network/public/mojom/cert_verifier_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('certVerifier.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
certVerifier.mojom.URLLoaderFactoryConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        certVerifier.mojom.URLLoaderFactoryConnector.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { certVerifier.mojom.URLLoaderFactoryConnectorInterface }
 */
certVerifier.mojom.URLLoaderFactoryConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!certVerifier.mojom.URLLoaderFactoryConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          certVerifier.mojom.URLLoaderFactoryConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!certVerifier.mojom.URLLoaderFactoryConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.URLLoaderFactoryPendingReceiver } urlLoaderFactory
   */

  createURLLoaderFactory(
      urlLoaderFactory) {
    this.proxy.sendMessage(
        0,
        certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        [
          urlLoaderFactory
        ],
        false);
  }
};

/**
 * An object which receives request messages for the URLLoaderFactoryConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
certVerifier.mojom.URLLoaderFactoryConnectorReceiver = class {
  /**
   * @param {!certVerifier.mojom.URLLoaderFactoryConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!certVerifier.mojom.URLLoaderFactoryConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        certVerifier.mojom.URLLoaderFactoryConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.URLLoaderFactoryConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        impl.createURLLoaderFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
certVerifier.mojom.URLLoaderFactoryConnector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.URLLoaderFactoryConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!certVerifier.mojom.URLLoaderFactoryConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new certVerifier.mojom.URLLoaderFactoryConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the URLLoaderFactoryConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
certVerifier.mojom.URLLoaderFactoryConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      certVerifier.mojom.URLLoaderFactoryConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.URLLoaderFactoryConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createURLLoaderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        this.createURLLoaderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
certVerifier.mojom.CertVerifierServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        certVerifier.mojom.CertVerifierService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { certVerifier.mojom.CertVerifierServiceInterface }
 */
certVerifier.mojom.CertVerifierServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!certVerifier.mojom.CertVerifierServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          certVerifier.mojom.CertVerifierServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!certVerifier.mojom.CertVerifierServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.URLLoaderFactoryRemote } urlLoaderFactory
   * @param { ?certVerifier.mojom.URLLoaderFactoryConnectorRemote } reconnector
   */

  enableNetworkAccess(
      urlLoaderFactory,
      reconnector) {
    this.proxy.sendMessage(
        0,
        certVerifier.mojom.CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        [
          urlLoaderFactory,
          reconnector
        ],
        false);
  }

  
  /**
   * @param { !certVerifier.mojom.RequestParams } params
   * @param { !network.mojom.NetLogSource } netLogSource
   * @param { !certVerifier.mojom.CertVerifierRequestRemote } certVerifierRequest
   */

  verify(
      params,
      netLogSource,
      certVerifierRequest) {
    this.proxy.sendMessage(
        1,
        certVerifier.mojom.CertVerifierService_Verify_ParamsSpec.$,
        null,
        [
          params,
          netLogSource,
          certVerifierRequest
        ],
        false);
  }

  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network.mojom.X509Certificate } tlsCertificate
   * @param { !network.mojom.NetLogSource } netLogSource
   * @return {!Promise<{
        verifiedCert: !network.mojom.X509Certificate,
   *  }>}
   */

  verify2QwacBinding(
      binding,
      hostname,
      tlsCertificate,
      netLogSource) {
    return this.proxy.sendMessage(
        2,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        [
          binding,
          hostname,
          tlsCertificate,
          netLogSource
        ],
        false);
  }

  
  /**
   * @param { !certVerifier.mojom.CertVerifierConfig } config
   */

  setConfig(
      config) {
    this.proxy.sendMessage(
        3,
        certVerifier.mojom.CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertVerifierService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceReceiver = class {
  /**
   * @param {!certVerifier.mojom.CertVerifierServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!certVerifier.mojom.CertVerifierServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        certVerifier.mojom.CertVerifierServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        impl.enableNetworkAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        certVerifier.mojom.CertVerifierService_Verify_ParamsSpec.$,
        null,
        impl.verify.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        impl.verify2QwacBinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        certVerifier.mojom.CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        impl.setConfig.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
certVerifier.mojom.CertVerifierService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!certVerifier.mojom.CertVerifierServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new certVerifier.mojom.CertVerifierServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CertVerifierService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      certVerifier.mojom.CertVerifierServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableNetworkAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        this.enableNetworkAccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        certVerifier.mojom.CertVerifierService_Verify_ParamsSpec.$,
        null,
        this.verify.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify2QwacBinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        this.verify2QwacBinding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        certVerifier.mojom.CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        this.setConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
certVerifier.mojom.CertVerifierServiceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        certVerifier.mojom.CertVerifierServiceClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { certVerifier.mojom.CertVerifierServiceClientInterface }
 */
certVerifier.mojom.CertVerifierServiceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!certVerifier.mojom.CertVerifierServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          certVerifier.mojom.CertVerifierServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!certVerifier.mojom.CertVerifierServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onCertVerifierChanged() {
    this.proxy.sendMessage(
        0,
        certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertVerifierServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceClientReceiver = class {
  /**
   * @param {!certVerifier.mojom.CertVerifierServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!certVerifier.mojom.CertVerifierServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        certVerifier.mojom.CertVerifierServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        impl.onCertVerifierChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
certVerifier.mojom.CertVerifierServiceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!certVerifier.mojom.CertVerifierServiceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new certVerifier.mojom.CertVerifierServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CertVerifierServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
certVerifier.mojom.CertVerifierServiceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      certVerifier.mojom.CertVerifierServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCertVerifierChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        this.onCertVerifierChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
certVerifier.mojom.CertVerifierRequestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        certVerifier.mojom.CertVerifierRequest.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { certVerifier.mojom.CertVerifierRequestInterface }
 */
certVerifier.mojom.CertVerifierRequestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!certVerifier.mojom.CertVerifierRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          certVerifier.mojom.CertVerifierRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!certVerifier.mojom.CertVerifierRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.CertVerifyResult } result
   * @param { !number } netError
   */

  complete(
      result,
      netError) {
    this.proxy.sendMessage(
        0,
        certVerifier.mojom.CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        [
          result,
          netError
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertVerifierRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
certVerifier.mojom.CertVerifierRequestReceiver = class {
  /**
   * @param {!certVerifier.mojom.CertVerifierRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!certVerifier.mojom.CertVerifierRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        certVerifier.mojom.CertVerifierRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
certVerifier.mojom.CertVerifierRequest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!certVerifier.mojom.CertVerifierRequestRemote}
   * @export
   */
  static getRemote() {
    let remote = new certVerifier.mojom.CertVerifierRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CertVerifierRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
certVerifier.mojom.CertVerifierRequestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      certVerifier.mojom.CertVerifierRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!certVerifier.mojom.CertVerifierRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        certVerifier.mojom.CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.RequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierService_EnableNetworkAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierService_Verify_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierService_SetConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
certVerifier.mojom.CertVerifierRequest_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    certVerifier.mojom.RequestParamsSpec.$,
    'RequestParams',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flags', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ocspResponse', 24,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctList', 32,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
certVerifier.mojom.RequestParams = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
    /** @export { !string } */
    this.hostname;
    /** @export { !number } */
    this.flags;
    /** @export { !mojoBase.mojom.ByteString } */
    this.ocspResponse;
    /** @export { !mojoBase.mojom.ByteString } */
    this.sctList;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierConfigSpec.$,
    'CertVerifierConfig',
    [
      mojo.internal.StructField(
        'enableRevChecking', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireRevCheckingLocalAnchors', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableSha1LocalAnchors', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.CertVerifierConfig = class {
  constructor() {
    /** @export { !boolean } */
    this.enableRevChecking;
    /** @export { !boolean } */
    this.requireRevCheckingLocalAnchors;
    /** @export { !boolean } */
    this.enableSha1LocalAnchors;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
    'URLLoaderFactoryConnector_CreateURLLoaderFactory_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.URLLoaderFactoryConnector_CreateURLLoaderFactory_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryPendingReceiver } */
    this.urlLoaderFactory;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
    'CertVerifierService_EnableNetworkAccess_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reconnector', 8,
        0,
        mojo.internal.InterfaceProxy(certVerifier.mojom.URLLoaderFactoryConnectorRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
certVerifier.mojom.CertVerifierService_EnableNetworkAccess_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryRemote } */
    this.urlLoaderFactory;
    /** @export { (certVerifier.mojom.URLLoaderFactoryConnectorRemote|undefined) } */
    this.reconnector;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierService_Verify_ParamsSpec.$,
    'CertVerifierService_Verify_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        certVerifier.mojom.RequestParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netLogSource', 8,
        0,
        network.mojom.NetLogSourceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certVerifierRequest', 16,
        0,
        mojo.internal.InterfaceProxy(certVerifier.mojom.CertVerifierRequestRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
certVerifier.mojom.CertVerifierService_Verify_Params = class {
  constructor() {
    /** @export { !certVerifier.mojom.RequestParams } */
    this.params;
    /** @export { !network.mojom.NetLogSource } */
    this.netLogSource;
    /** @export { !certVerifier.mojom.CertVerifierRequestRemote } */
    this.certVerifierRequest;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
    'CertVerifierService_Verify2QwacBinding_Params',
    [
      mojo.internal.StructField(
        'binding', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tlsCertificate', 16,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netLogSource', 24,
        0,
        network.mojom.NetLogSourceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
certVerifier.mojom.CertVerifierService_Verify2QwacBinding_Params = class {
  constructor() {
    /** @export { !string } */
    this.binding;
    /** @export { !string } */
    this.hostname;
    /** @export { !network.mojom.X509Certificate } */
    this.tlsCertificate;
    /** @export { !network.mojom.NetLogSource } */
    this.netLogSource;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
    'CertVerifierService_Verify2QwacBinding_ResponseParams',
    [
      mojo.internal.StructField(
        'verifiedCert', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.CertVerifierService_Verify2QwacBinding_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.verifiedCert;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierService_SetConfig_ParamsSpec.$,
    'CertVerifierService_SetConfig_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        certVerifier.mojom.CertVerifierConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
certVerifier.mojom.CertVerifierService_SetConfig_Params = class {
  constructor() {
    /** @export { !certVerifier.mojom.CertVerifierConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
    'CertVerifierServiceClient_OnCertVerifierChanged_Params',
    [
    ],
    [[0, 8],]);





/** @record */
certVerifier.mojom.CertVerifierServiceClient_OnCertVerifierChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    certVerifier.mojom.CertVerifierRequest_Complete_ParamsSpec.$,
    'CertVerifierRequest_Complete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        network.mojom.CertVerifyResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
certVerifier.mojom.CertVerifierRequest_Complete_Params = class {
  constructor() {
    /** @export { !network.mojom.CertVerifyResult } */
    this.result;
    /** @export { !number } */
    this.netError;
  }
};

