// services/network/public/mojom/accept_ch_frame_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  WebClientHintsType as network_mojom_WebClientHintsType,
  WebClientHintsTypeSpec as network_mojom_WebClientHintsTypeSpec
} from './web_client_hints_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AcceptCHFrameObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.AcceptCHFrameObserver', scope);
  }
}

/** @interface */
export class AcceptCHFrameObserverInterface {
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !Array<!network_mojom_WebClientHintsType> } acceptChFrame
   * @return {!Promise<{
        status: !number,
   *  }>}
   */

  onAcceptCHFrameReceived(origin, acceptChFrame) {}
  
  /**
   * @param { !AcceptCHFrameObserverPendingReceiver } listener
   */

  clone(listener) {}
}

/**
 * @implements { AcceptCHFrameObserverInterface }
 */
export class AcceptCHFrameObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AcceptCHFrameObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AcceptCHFrameObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AcceptCHFrameObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !Array<!network_mojom_WebClientHintsType> } acceptChFrame
   * @return {!Promise<{
        status: !number,
   *  }>}
   */

  onAcceptCHFrameReceived(
      origin,
      acceptChFrame) {
    return this.proxy.sendMessage(
        0,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsSpec.$,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsSpec.$,
        [
          origin,
          acceptChFrame
        ],
        false);
  }

  
  /**
   * @param { !AcceptCHFrameObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        1,
        AcceptCHFrameObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AcceptCHFrameObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AcceptCHFrameObserverReceiver {
  /**
   * @param {!AcceptCHFrameObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AcceptCHFrameObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AcceptCHFrameObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AcceptCHFrameObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsSpec.$,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsSpec.$,
        impl.onAcceptCHFrameReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AcceptCHFrameObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AcceptCHFrameObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.AcceptCHFrameObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AcceptCHFrameObserverRemote}
   */
  static getRemote() {
    let remote = new AcceptCHFrameObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AcceptCHFrameObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AcceptCHFrameObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AcceptCHFrameObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AcceptCHFrameObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAcceptCHFrameReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsSpec.$,
        AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsSpec.$,
        this.onAcceptCHFrameReceived.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AcceptCHFrameObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceptCHFrameObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsSpec.$,
    'AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'acceptChFrame', 8,
        0,
        mojo.internal.Array(network_mojom_WebClientHintsTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !Array<!network_mojom_WebClientHintsType> } */
    this.acceptChFrame;
  }
}



mojo.internal.Struct(
    AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsSpec.$,
    'AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.status;
  }
}



mojo.internal.Struct(
    AcceptCHFrameObserver_Clone_ParamsSpec.$,
    'AcceptCHFrameObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(AcceptCHFrameObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AcceptCHFrameObserver_Clone_Params {
  constructor() {
    /** @type { !AcceptCHFrameObserverPendingReceiver } */
    this.listener;
  }
}

