// services/metrics/public/mojom/ukm_interface.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_BLINK_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-features.h"  // IWYU pragma: export
#include "services/metrics/public/mojom/ukm_interface.mojom-shared.h"  // IWYU pragma: export
#include "services/metrics/public/mojom/ukm_interface.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ukm::mojom::blink {

class SingularUkmInterfaceProxy;

template <typename ImplRefTraits>
class SingularUkmInterfaceStub;

class SingularUkmInterfaceRequestValidator;


class SingularUkmInterface
    : public SingularUkmInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ukm.mojom.SingularUkmInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SingularUkmInterfaceInterfaceBase;
  using Proxy_ = SingularUkmInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SingularUkmInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = SingularUkmInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSubmitMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Submit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SingularUkmInterface() = default;

  virtual void Submit(UkmEntryPtr entry) = 0;
};

class UkmRecorderClientInterfaceProxy;

template <typename ImplRefTraits>
class UkmRecorderClientInterfaceStub;

class UkmRecorderClientInterfaceRequestValidator;


class UkmRecorderClientInterface
    : public UkmRecorderClientInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ukm.mojom.UkmRecorderClientInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UkmRecorderClientInterfaceInterfaceBase;
  using Proxy_ = UkmRecorderClientInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = UkmRecorderClientInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = UkmRecorderClientInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetParametersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetParameters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UkmRecorderClientInterface() = default;

  virtual void SetParameters(UkmRecorderParametersPtr params) = 0;
};

class UkmRecorderInterfaceProxy;

template <typename ImplRefTraits>
class UkmRecorderInterfaceStub;

class UkmRecorderInterfaceRequestValidator;


class UkmRecorderInterface
    : public UkmRecorderInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ukm.mojom.UkmRecorderInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UkmRecorderInterfaceInterfaceBase;
  using Proxy_ = UkmRecorderInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = UkmRecorderInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = UkmRecorderInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddEntryMinVersion = 0,
    kUpdateSourceURLMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSourceURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UkmRecorderInterface() = default;

  virtual void AddEntry(UkmEntryPtr entry) = 0;

  virtual void UpdateSourceURL(int64_t source_id, const ::blink::String& url) = 0;
};

class UkmRecorderFactoryProxy;

template <typename ImplRefTraits>
class UkmRecorderFactoryStub;

class UkmRecorderFactoryRequestValidator;


class UkmRecorderFactory
    : public UkmRecorderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ukm.mojom.UkmRecorderFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UkmRecorderFactoryInterfaceBase;
  using Proxy_ = UkmRecorderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = UkmRecorderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = UkmRecorderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateUkmRecorderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateUkmRecorder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UkmRecorderFactory() = default;

  virtual void CreateUkmRecorder(::mojo::PendingReceiver<UkmRecorderInterface> receiver, ::mojo::PendingRemote<UkmRecorderClientInterface> client_remote) = 0;
};



class  SingularUkmInterfaceProxy
    : public SingularUkmInterface {
 public:
  using InterfaceType = SingularUkmInterface;

  explicit SingularUkmInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Submit(UkmEntryPtr entry) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UkmRecorderClientInterfaceProxy
    : public UkmRecorderClientInterface {
 public:
  using InterfaceType = UkmRecorderClientInterface;

  explicit UkmRecorderClientInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetParameters(UkmRecorderParametersPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UkmRecorderInterfaceProxy
    : public UkmRecorderInterface {
 public:
  using InterfaceType = UkmRecorderInterface;

  explicit UkmRecorderInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddEntry(UkmEntryPtr entry) final;
  
  void UpdateSourceURL(int64_t source_id, const ::blink::String& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UkmRecorderFactoryProxy
    : public UkmRecorderFactory {
 public:
  using InterfaceType = UkmRecorderFactory;

  explicit UkmRecorderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateUkmRecorder(::mojo::PendingReceiver<UkmRecorderInterface> receiver, ::mojo::PendingRemote<UkmRecorderClientInterface> client_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SingularUkmInterfaceStubDispatch {
 public:
  static bool Accept(SingularUkmInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SingularUkmInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SingularUkmInterface>>
class SingularUkmInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SingularUkmInterfaceStub() = default;
  ~SingularUkmInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingularUkmInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SingularUkmInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UkmRecorderClientInterfaceStubDispatch {
 public:
  static bool Accept(UkmRecorderClientInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UkmRecorderClientInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UkmRecorderClientInterface>>
class UkmRecorderClientInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UkmRecorderClientInterfaceStub() = default;
  ~UkmRecorderClientInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderClientInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderClientInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UkmRecorderInterfaceStubDispatch {
 public:
  static bool Accept(UkmRecorderInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UkmRecorderInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UkmRecorderInterface>>
class UkmRecorderInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UkmRecorderInterfaceStub() = default;
  ~UkmRecorderInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UkmRecorderFactoryStubDispatch {
 public:
  static bool Accept(UkmRecorderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UkmRecorderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UkmRecorderFactory>>
class UkmRecorderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UkmRecorderFactoryStub() = default;
  ~UkmRecorderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UkmRecorderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SingularUkmInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UkmRecorderClientInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UkmRecorderInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UkmRecorderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  UkmEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UkmEntry, T>::value>;
  using DataView = UkmEntryDataView;
  using Data_ = internal::UkmEntry_Data;

  template <typename... Args>
  static UkmEntryPtr New(Args&&... args) {
    return UkmEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UkmEntryPtr From(const U& u) {
    return mojo::TypeConverter<UkmEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UkmEntry>::Convert(*this);
  }


  UkmEntry();

  UkmEntry(
      int64_t source_id,
      uint64_t event_hash,
      const ::blink::HashMap<uint64_t, int64_t>& metrics);


  ~UkmEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UkmEntryPtr>
  UkmEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UkmEntry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UkmEntry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UkmEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UkmEntry_UnserializedMessageContext<
            UserType, UkmEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UkmEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UkmEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UkmEntry_UnserializedMessageContext<
            UserType, UkmEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UkmEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t source_id;
  
  uint64_t event_hash;
  
  ::blink::HashMap<uint64_t, int64_t> metrics;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UkmEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UkmRecorderParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UkmRecorderParameters, T>::value>;
  using DataView = UkmRecorderParametersDataView;
  using Data_ = internal::UkmRecorderParameters_Data;

  template <typename... Args>
  static UkmRecorderParametersPtr New(Args&&... args) {
    return UkmRecorderParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UkmRecorderParametersPtr From(const U& u) {
    return mojo::TypeConverter<UkmRecorderParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UkmRecorderParameters>::Convert(*this);
  }


  UkmRecorderParameters();

  UkmRecorderParameters(
      bool is_enabled,
      ::blink::Vector<uint64_t> event_hash_bypass_list);


  ~UkmRecorderParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UkmRecorderParametersPtr>
  UkmRecorderParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UkmRecorderParameters::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UkmRecorderParameters::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UkmRecorderParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UkmRecorderParameters_UnserializedMessageContext<
            UserType, UkmRecorderParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UkmRecorderParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UkmRecorderParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UkmRecorderParameters_UnserializedMessageContext<
            UserType, UkmRecorderParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UkmRecorderParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_enabled;
  
  ::blink::Vector<uint64_t> event_hash_bypass_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UkmRecorderParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UkmEntryPtr UkmEntry::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(event_hash),
      mojo::Clone(metrics)
  );
}

template <typename T, UkmEntry::EnableIfSame<T>*>
bool UkmEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->event_hash, other_struct.event_hash))
    return false;
  if (!mojo::Equals(this->metrics, other_struct.metrics))
    return false;
  return true;
}

template <typename T, UkmEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.event_hash < rhs.event_hash)
    return true;
  if (rhs.event_hash < lhs.event_hash)
    return false;
  if (lhs.metrics < rhs.metrics)
    return true;
  if (rhs.metrics < lhs.metrics)
    return false;
  return false;
}
template <typename StructPtrType>
UkmRecorderParametersPtr UkmRecorderParameters::Clone() const {
  return New(
      mojo::Clone(is_enabled),
      mojo::Clone(event_hash_bypass_list)
  );
}

template <typename T, UkmRecorderParameters::EnableIfSame<T>*>
bool UkmRecorderParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->event_hash_bypass_list, other_struct.event_hash_bypass_list))
    return false;
  return true;
}

template <typename T, UkmRecorderParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.event_hash_bypass_list < rhs.event_hash_bypass_list)
    return true;
  if (rhs.event_hash_bypass_list < lhs.event_hash_bypass_list)
    return false;
  return false;
}


}  // ukm::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ukm::mojom::blink::UkmEntry::DataView,
                                         ::ukm::mojom::blink::UkmEntryPtr> {
  static bool IsNull(const ::ukm::mojom::blink::UkmEntryPtr& input) { return !input; }
  static void SetToNull(::ukm::mojom::blink::UkmEntryPtr* output) { output->reset(); }

  static decltype(::ukm::mojom::blink::UkmEntry::source_id) source_id(
      const ::ukm::mojom::blink::UkmEntryPtr& input) {
    return input->source_id;
  }

  static decltype(::ukm::mojom::blink::UkmEntry::event_hash) event_hash(
      const ::ukm::mojom::blink::UkmEntryPtr& input) {
    return input->event_hash;
  }

  static const decltype(::ukm::mojom::blink::UkmEntry::metrics)& metrics(
      const ::ukm::mojom::blink::UkmEntryPtr& input) {
    return input->metrics;
  }

  static bool Read(::ukm::mojom::blink::UkmEntry::DataView input, ::ukm::mojom::blink::UkmEntryPtr* output);
};


template <>
struct  StructTraits<::ukm::mojom::blink::UkmRecorderParameters::DataView,
                                         ::ukm::mojom::blink::UkmRecorderParametersPtr> {
  static bool IsNull(const ::ukm::mojom::blink::UkmRecorderParametersPtr& input) { return !input; }
  static void SetToNull(::ukm::mojom::blink::UkmRecorderParametersPtr* output) { output->reset(); }

  static decltype(::ukm::mojom::blink::UkmRecorderParameters::is_enabled) is_enabled(
      const ::ukm::mojom::blink::UkmRecorderParametersPtr& input) {
    return input->is_enabled;
  }

  static const decltype(::ukm::mojom::blink::UkmRecorderParameters::event_hash_bypass_list)& event_hash_bypass_list(
      const ::ukm::mojom::blink::UkmRecorderParametersPtr& input) {
    return input->event_hash_bypass_list;
  }

  static bool Read(::ukm::mojom::blink::UkmRecorderParameters::DataView input, ::ukm::mojom::blink::UkmRecorderParametersPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_BLINK_H_