// services/media_session/public/mojom/media_session.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/media_session.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/media_session.mojom-params-data.h"
#include "services/media_session/public/mojom/media_session.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/media_session.mojom-import-headers.h"
#include "services/media_session/public/mojom/media_session.mojom-test-utils.h"


namespace media_session::mojom {
MediaImage::MediaImage()
    : src(),
      type(),
      sizes() {}

MediaImage::MediaImage(
    const ::GURL& src_in,
    const ::std::u16string& type_in,
    std::vector<::gfx::Size> sizes_in)
    : src(std::move(src_in)),
      type(std::move(type_in)),
      sizes(std::move(sizes_in)) {}

MediaImage::~MediaImage() = default;

void MediaImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sizes"), this->sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChapterInformation::ChapterInformation()
    : title(),
      startTime(),
      artwork() {}

ChapterInformation::ChapterInformation(
    const ::std::u16string& title_in,
    ::base::TimeDelta startTime_in,
    std::vector<::media_session::MediaImage> artwork_in)
    : title(std::move(title_in)),
      startTime(std::move(startTime_in)),
      artwork(std::move(artwork_in)) {}

ChapterInformation::~ChapterInformation() = default;

void ChapterInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "startTime"), this->startTime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artwork"), this->artwork,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media_session::MediaImage>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChapterInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaMetadata::MediaMetadata()
    : title(),
      artist(),
      album(),
      source_title(),
      chapters() {}

MediaMetadata::MediaMetadata(
    const ::std::u16string& title_in,
    const ::std::u16string& artist_in,
    const ::std::u16string& album_in,
    const ::std::u16string& source_title_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      source_title(std::move(source_title_in)),
      chapters() {}

MediaMetadata::MediaMetadata(
    const ::std::u16string& title_in,
    const ::std::u16string& artist_in,
    const ::std::u16string& album_in,
    const ::std::u16string& source_title_in,
    std::optional<std::vector<::media_session::ChapterInformation>> chapters_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      source_title(std::move(source_title_in)),
      chapters(std::move(chapters_in)) {}

MediaMetadata::~MediaMetadata() = default;

void MediaMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artist"), this->artist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "album"), this->album,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_title"), this->source_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chapters"), this->chapters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::media_session::ChapterInformation>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaImageBitmap::MediaImageBitmap()
    : width(),
      height(),
      pixel_data(),
      color_type() {}

MediaImageBitmap::MediaImageBitmap(
    int32_t width_in,
    int32_t height_in,
    std::vector<uint8_t> pixel_data_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      pixel_data(std::move(pixel_data_in)),
      color_type() {}

MediaImageBitmap::MediaImageBitmap(
    int32_t width_in,
    int32_t height_in,
    std::vector<uint8_t> pixel_data_in,
    MediaImageBitmapColorType color_type_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      pixel_data(std::move(pixel_data_in)),
      color_type(std::move(color_type_in)) {}

MediaImageBitmap::~MediaImageBitmap() = default;

void MediaImageBitmap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data"), this->pixel_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_type"), this->color_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaImageBitmapColorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaImageBitmap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaPosition::MediaPosition()
    : playback_rate(),
      duration(),
      position(),
      last_updated_time(),
      end_of_media() {}

MediaPosition::MediaPosition(
    double playback_rate_in,
    ::base::TimeDelta duration_in,
    ::base::TimeDelta position_in,
    ::base::TimeTicks last_updated_time_in)
    : playback_rate(std::move(playback_rate_in)),
      duration(std::move(duration_in)),
      position(std::move(position_in)),
      last_updated_time(std::move(last_updated_time_in)),
      end_of_media() {}

MediaPosition::MediaPosition(
    double playback_rate_in,
    ::base::TimeDelta duration_in,
    ::base::TimeDelta position_in,
    ::base::TimeTicks last_updated_time_in,
    bool end_of_media_in)
    : playback_rate(std::move(playback_rate_in)),
      duration(std::move(duration_in)),
      position(std::move(position_in)),
      last_updated_time(std::move(last_updated_time_in)),
      end_of_media(std::move(end_of_media_in)) {}

MediaPosition::~MediaPosition() = default;

void MediaPosition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_rate"), this->playback_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_updated_time"), this->last_updated_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_media"), this->end_of_media,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaPosition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RemotePlaybackMetadata::RemotePlaybackMetadata()
    : video_codec(),
      audio_codec(),
      remote_playback_disabled(),
      remote_playback_started(),
      unused_field(),
      is_encrypted_media() {}

RemotePlaybackMetadata::RemotePlaybackMetadata(
    const std::string& video_codec_in,
    const std::string& audio_codec_in,
    bool remote_playback_disabled_in)
    : video_codec(std::move(video_codec_in)),
      audio_codec(std::move(audio_codec_in)),
      remote_playback_disabled(std::move(remote_playback_disabled_in)),
      remote_playback_started(),
      unused_field(),
      is_encrypted_media() {}

RemotePlaybackMetadata::RemotePlaybackMetadata(
    const std::string& video_codec_in,
    const std::string& audio_codec_in,
    bool remote_playback_disabled_in,
    bool remote_playback_started_in,
    const std::optional<std::string>& unused_field_in)
    : video_codec(std::move(video_codec_in)),
      audio_codec(std::move(audio_codec_in)),
      remote_playback_disabled(std::move(remote_playback_disabled_in)),
      remote_playback_started(std::move(remote_playback_started_in)),
      unused_field(std::move(unused_field_in)),
      is_encrypted_media() {}

RemotePlaybackMetadata::RemotePlaybackMetadata(
    const std::string& video_codec_in,
    const std::string& audio_codec_in,
    bool remote_playback_disabled_in,
    bool remote_playback_started_in,
    const std::optional<std::string>& unused_field_in,
    bool is_encrypted_media_in)
    : video_codec(std::move(video_codec_in)),
      audio_codec(std::move(audio_codec_in)),
      remote_playback_disabled(std::move(remote_playback_disabled_in)),
      remote_playback_started(std::move(remote_playback_started_in)),
      unused_field(std::move(unused_field_in)),
      is_encrypted_media(std::move(is_encrypted_media_in)) {}

RemotePlaybackMetadata::~RemotePlaybackMetadata() = default;

void RemotePlaybackMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codec"), this->video_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codec"), this->audio_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_playback_disabled"), this->remote_playback_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_playback_started"), this->remote_playback_started,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unused_field"), this->unused_field,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_encrypted_media"), this->is_encrypted_media,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemotePlaybackMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionInfo::MediaSessionInfo()
    : state(),
      force_duck(),
      playback_state(),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      deprecated_is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      deprecated_is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      deprecated_is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(),
      deprecated_is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(),
      camera_state(),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in,
    RemotePlaybackMetadataPtr remote_playback_metadata_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(std::move(remote_playback_metadata_in)),
      hide_metadata(),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in,
    RemotePlaybackMetadataPtr remote_playback_metadata_in,
    bool hide_metadata_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(std::move(remote_playback_metadata_in)),
      hide_metadata(std::move(hide_metadata_in)),
      ignore_for_active_session(),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in,
    RemotePlaybackMetadataPtr remote_playback_metadata_in,
    bool hide_metadata_in,
    bool ignore_for_active_session_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(std::move(remote_playback_metadata_in)),
      hide_metadata(std::move(hide_metadata_in)),
      ignore_for_active_session(std::move(ignore_for_active_session_in)),
      meets_visibility_threshold(),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in,
    RemotePlaybackMetadataPtr remote_playback_metadata_in,
    bool hide_metadata_in,
    bool ignore_for_active_session_in,
    bool meets_visibility_threshold_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(std::move(remote_playback_metadata_in)),
      hide_metadata(std::move(hide_metadata_in)),
      ignore_for_active_session(std::move(ignore_for_active_session_in)),
      meets_visibility_threshold(std::move(meets_visibility_threshold_in)),
      can_enter_browser_initiated_autopip() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool deprecated_is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const std::optional<std::string>& audio_sink_id_in,
    std::optional<std::vector<MediaAudioVideoState>> audio_video_states_in,
    MicrophoneState microphone_state_in,
    CameraState camera_state_in,
    bool muted_in,
    bool has_presentation_in,
    RemotePlaybackMetadataPtr remote_playback_metadata_in,
    bool hide_metadata_in,
    bool ignore_for_active_session_in,
    bool meets_visibility_threshold_in,
    bool can_enter_browser_initiated_autopip_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      deprecated_is_sensitive(std::move(deprecated_is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)),
      microphone_state(std::move(microphone_state_in)),
      camera_state(std::move(camera_state_in)),
      muted(std::move(muted_in)),
      has_presentation(std::move(has_presentation_in)),
      remote_playback_metadata(std::move(remote_playback_metadata_in)),
      hide_metadata(std::move(hide_metadata_in)),
      ignore_for_active_session(std::move(ignore_for_active_session_in)),
      meets_visibility_threshold(std::move(meets_visibility_threshold_in)),
      can_enter_browser_initiated_autopip(std::move(can_enter_browser_initiated_autopip_in)) {}

MediaSessionInfo::~MediaSessionInfo() = default;

void MediaSessionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaSessionInfo::SessionState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_duck"), this->force_duck,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_state"), this->playback_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaPlaybackState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_controllable"), this->is_controllable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_stop_for_gain_focus_loss"), this->prefer_stop_for_gain_focus_loss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deprecated_is_sensitive"), this->deprecated_is_sensitive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "picture_in_picture_state"), this->picture_in_picture_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaPictureInPictureState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deprecated_audio_video_state"), this->deprecated_audio_video_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaAudioVideoState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_sink_id"), this->audio_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_video_states"), this->audio_video_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<MediaAudioVideoState>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "microphone_state"), this->microphone_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MicrophoneState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_state"), this->camera_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CameraState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "muted"), this->muted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_presentation"), this->has_presentation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_playback_metadata"), this->remote_playback_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RemotePlaybackMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hide_metadata"), this->hide_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_for_active_session"), this->ignore_for_active_session,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meets_visibility_threshold"), this->meets_visibility_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_enter_browser_initiated_autopip"), this->can_enter_browser_initiated_autopip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaSessionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionDebugInfo::MediaSessionDebugInfo()
    : name(),
      owner(),
      state() {}

MediaSessionDebugInfo::MediaSessionDebugInfo(
    const std::string& name_in,
    const std::string& owner_in,
    const std::string& state_in)
    : name(std::move(name_in)),
      owner(std::move(owner_in)),
      state(std::move(state_in)) {}

MediaSessionDebugInfo::~MediaSessionDebugInfo() = default;
size_t MediaSessionDebugInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->owner);
  seed = mojo::internal::Hash(seed, this->state);
  return seed;
}

void MediaSessionDebugInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "owner"), this->owner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaSessionDebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MediaSessionObserver::IPCStableHashFunction MediaSessionObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaSessionObserver>(message.name())) {
    case messages::MediaSessionObserver::kMediaSessionInfoChanged: {
      return &MediaSessionObserver::MediaSessionInfoChanged_Sym::IPCStableHash;
    }
    case messages::MediaSessionObserver::kMediaSessionMetadataChanged: {
      return &MediaSessionObserver::MediaSessionMetadataChanged_Sym::IPCStableHash;
    }
    case messages::MediaSessionObserver::kMediaSessionActionsChanged: {
      return &MediaSessionObserver::MediaSessionActionsChanged_Sym::IPCStableHash;
    }
    case messages::MediaSessionObserver::kMediaSessionImagesChanged: {
      return &MediaSessionObserver::MediaSessionImagesChanged_Sym::IPCStableHash;
    }
    case messages::MediaSessionObserver::kMediaSessionPositionChanged: {
      return &MediaSessionObserver::MediaSessionPositionChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaSessionObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaSessionObserver>(message.name())) {
      case messages::MediaSessionObserver::kMediaSessionInfoChanged:
            return "Receive media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged";
      case messages::MediaSessionObserver::kMediaSessionMetadataChanged:
            return "Receive media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged";
      case messages::MediaSessionObserver::kMediaSessionActionsChanged:
            return "Receive media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged";
      case messages::MediaSessionObserver::kMediaSessionImagesChanged:
            return "Receive media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged";
      case messages::MediaSessionObserver::kMediaSessionPositionChanged:
            return "Receive media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged";
    }
  } else {
    switch (static_cast<messages::MediaSessionObserver>(message.name())) {
      case messages::MediaSessionObserver::kMediaSessionInfoChanged:
            return "Receive reply media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged";
      case messages::MediaSessionObserver::kMediaSessionMetadataChanged:
            return "Receive reply media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged";
      case messages::MediaSessionObserver::kMediaSessionActionsChanged:
            return "Receive reply media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged";
      case messages::MediaSessionObserver::kMediaSessionImagesChanged:
            return "Receive reply media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged";
      case messages::MediaSessionObserver::kMediaSessionPositionChanged:
            return "Receive reply media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaSessionObserver::MediaSessionInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb117245;  // IPCStableHash for media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionObserver::MediaSessionMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76bb7259;  // IPCStableHash for media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionObserver::MediaSessionActionsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c5c05ae;  // IPCStableHash for media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionObserver::MediaSessionImagesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x281b50d8;  // IPCStableHash for media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSessionObserver::MediaSessionPositionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb590ef00;  // IPCStableHash for media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaSessionObserverProxy::MediaSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionObserverProxy::MediaSessionInfoChanged(
    MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type MediaSessionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionObserver::kMediaSessionInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in MediaSessionObserver.MediaSessionInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionObserverProxy::MediaSessionMetadataChanged(
    const std::optional<::media_session::MediaMetadata>& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const std::optional<::media_session::MediaMetadata>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionObserver::kMediaSessionMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionObserverProxy::MediaSessionActionsChanged(
    const std::vector<MediaSessionAction>& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type const std::vector<MediaSessionAction>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionObserver::kMediaSessionActionsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType>
      action_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& action_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaSessionAction_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
    in_action,
    action_fragment,
    &action_validate_params);

  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action in MediaSessionObserver.MediaSessionActionsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionActionsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionObserverProxy::MediaSessionImagesChanged(
    const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& in_images) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images,
                        "<value of type const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionObserver::kMediaSessionImagesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaSessionImageType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::media_session::mojom::MediaSessionImageType, mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>>(
    in_images,
    images_fragment,
    &images_validate_params);

  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null images in MediaSessionObserver.MediaSessionImagesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionImagesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionObserverProxy::MediaSessionPositionChanged(
    const std::optional<::media_session::MediaPosition>& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const std::optional<::media_session::MediaPosition>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSessionObserver::kMediaSessionPositionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionPositionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaSessionObserverStubDispatch::Accept(
    MediaSessionObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaSessionObserver>(message->header()->name)) {
    case messages::MediaSessionObserver::kMediaSessionInfoChanged: {
      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionObserver.0
      bool success = true;
      MediaSessionInfoPtr p_info{};
      MediaSessionObserver_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(        
        std::move(p_info));
      return true;
    }
    case messages::MediaSessionObserver::kMediaSessionMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionObserver.1
      bool success = true;
      std::optional<::media_session::MediaMetadata> p_metadata{};
      MediaSessionObserver_MediaSessionMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionMetadataChanged(        
        std::move(p_metadata));
      return true;
    }
    case messages::MediaSessionObserver::kMediaSessionActionsChanged: {
      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionObserver.2
      bool success = true;
      std::vector<MediaSessionAction> p_action{};
      MediaSessionObserver_MediaSessionActionsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionActionsChanged(        
        std::move(p_action));
      return true;
    }
    case messages::MediaSessionObserver::kMediaSessionImagesChanged: {
      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionObserver.3
      bool success = true;
      base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>> p_images{};
      MediaSessionObserver_MediaSessionImagesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImages(&p_images))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionImagesChanged(        
        std::move(p_images));
      return true;
    }
    case messages::MediaSessionObserver::kMediaSessionPositionChanged: {
      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSessionObserver.4
      bool success = true;
      std::optional<::media_session::MediaPosition> p_position{};
      MediaSessionObserver_MediaSessionPositionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionPositionChanged(        
        std::move(p_position));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionObserverStubDispatch::AcceptWithResponder(
    MediaSessionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaSessionObserver>(message->header()->name)) {
    case messages::MediaSessionObserver::kMediaSessionInfoChanged: {
      break;
    }
    case messages::MediaSessionObserver::kMediaSessionMetadataChanged: {
      break;
    }
    case messages::MediaSessionObserver::kMediaSessionActionsChanged: {
      break;
    }
    case messages::MediaSessionObserver::kMediaSessionImagesChanged: {
      break;
    }
    case messages::MediaSessionObserver::kMediaSessionPositionChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaSessionObserverValidationInfo[] = {
    { &internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaSessionObserver::Name_,
    kMediaSessionObserverValidationInfo);
}

// The declaration includes the definition on other builds.

MediaSession::IPCStableHashFunction MediaSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaSession>(message.name())) {
    case messages::MediaSession::kGetMediaSessionInfo: {
      return &MediaSession::GetMediaSessionInfo_Sym::IPCStableHash;
    }
    case messages::MediaSession::kGetDebugInfo: {
      return &MediaSession::GetDebugInfo_Sym::IPCStableHash;
    }
    case messages::MediaSession::kStartDucking: {
      return &MediaSession::StartDucking_Sym::IPCStableHash;
    }
    case messages::MediaSession::kStopDucking: {
      return &MediaSession::StopDucking_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSuspend: {
      return &MediaSession::Suspend_Sym::IPCStableHash;
    }
    case messages::MediaSession::kResume: {
      return &MediaSession::Resume_Sym::IPCStableHash;
    }
    case messages::MediaSession::kAddObserver: {
      return &MediaSession::AddObserver_Sym::IPCStableHash;
    }
    case messages::MediaSession::kPreviousTrack: {
      return &MediaSession::PreviousTrack_Sym::IPCStableHash;
    }
    case messages::MediaSession::kNextTrack: {
      return &MediaSession::NextTrack_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSeek: {
      return &MediaSession::Seek_Sym::IPCStableHash;
    }
    case messages::MediaSession::kStop: {
      return &MediaSession::Stop_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSkipAd: {
      return &MediaSession::SkipAd_Sym::IPCStableHash;
    }
    case messages::MediaSession::kGetMediaImageBitmap: {
      return &MediaSession::GetMediaImageBitmap_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSeekTo: {
      return &MediaSession::SeekTo_Sym::IPCStableHash;
    }
    case messages::MediaSession::kScrubTo: {
      return &MediaSession::ScrubTo_Sym::IPCStableHash;
    }
    case messages::MediaSession::kEnterPictureInPicture: {
      return &MediaSession::EnterPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaSession::kExitPictureInPicture: {
      return &MediaSession::ExitPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSetAudioSinkId: {
      return &MediaSession::SetAudioSinkId_Sym::IPCStableHash;
    }
    case messages::MediaSession::kToggleMicrophone: {
      return &MediaSession::ToggleMicrophone_Sym::IPCStableHash;
    }
    case messages::MediaSession::kToggleCamera: {
      return &MediaSession::ToggleCamera_Sym::IPCStableHash;
    }
    case messages::MediaSession::kHangUp: {
      return &MediaSession::HangUp_Sym::IPCStableHash;
    }
    case messages::MediaSession::kRaise: {
      return &MediaSession::Raise_Sym::IPCStableHash;
    }
    case messages::MediaSession::kSetMute: {
      return &MediaSession::SetMute_Sym::IPCStableHash;
    }
    case messages::MediaSession::kRequestMediaRemoting: {
      return &MediaSession::RequestMediaRemoting_Sym::IPCStableHash;
    }
    case messages::MediaSession::kPreviousSlide: {
      return &MediaSession::PreviousSlide_Sym::IPCStableHash;
    }
    case messages::MediaSession::kNextSlide: {
      return &MediaSession::NextSlide_Sym::IPCStableHash;
    }
    case messages::MediaSession::kEnterAutoPictureInPicture: {
      return &MediaSession::EnterAutoPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaSession::kGetVisibility: {
      return &MediaSession::GetVisibility_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaSession>(message.name())) {
      case messages::MediaSession::kGetMediaSessionInfo:
            return "Receive media_session::mojom::MediaSession::GetMediaSessionInfo";
      case messages::MediaSession::kGetDebugInfo:
            return "Receive media_session::mojom::MediaSession::GetDebugInfo";
      case messages::MediaSession::kStartDucking:
            return "Receive media_session::mojom::MediaSession::StartDucking";
      case messages::MediaSession::kStopDucking:
            return "Receive media_session::mojom::MediaSession::StopDucking";
      case messages::MediaSession::kSuspend:
            return "Receive media_session::mojom::MediaSession::Suspend";
      case messages::MediaSession::kResume:
            return "Receive media_session::mojom::MediaSession::Resume";
      case messages::MediaSession::kAddObserver:
            return "Receive media_session::mojom::MediaSession::AddObserver";
      case messages::MediaSession::kPreviousTrack:
            return "Receive media_session::mojom::MediaSession::PreviousTrack";
      case messages::MediaSession::kNextTrack:
            return "Receive media_session::mojom::MediaSession::NextTrack";
      case messages::MediaSession::kSeek:
            return "Receive media_session::mojom::MediaSession::Seek";
      case messages::MediaSession::kStop:
            return "Receive media_session::mojom::MediaSession::Stop";
      case messages::MediaSession::kSkipAd:
            return "Receive media_session::mojom::MediaSession::SkipAd";
      case messages::MediaSession::kGetMediaImageBitmap:
            return "Receive media_session::mojom::MediaSession::GetMediaImageBitmap";
      case messages::MediaSession::kSeekTo:
            return "Receive media_session::mojom::MediaSession::SeekTo";
      case messages::MediaSession::kScrubTo:
            return "Receive media_session::mojom::MediaSession::ScrubTo";
      case messages::MediaSession::kEnterPictureInPicture:
            return "Receive media_session::mojom::MediaSession::EnterPictureInPicture";
      case messages::MediaSession::kExitPictureInPicture:
            return "Receive media_session::mojom::MediaSession::ExitPictureInPicture";
      case messages::MediaSession::kSetAudioSinkId:
            return "Receive media_session::mojom::MediaSession::SetAudioSinkId";
      case messages::MediaSession::kToggleMicrophone:
            return "Receive media_session::mojom::MediaSession::ToggleMicrophone";
      case messages::MediaSession::kToggleCamera:
            return "Receive media_session::mojom::MediaSession::ToggleCamera";
      case messages::MediaSession::kHangUp:
            return "Receive media_session::mojom::MediaSession::HangUp";
      case messages::MediaSession::kRaise:
            return "Receive media_session::mojom::MediaSession::Raise";
      case messages::MediaSession::kSetMute:
            return "Receive media_session::mojom::MediaSession::SetMute";
      case messages::MediaSession::kRequestMediaRemoting:
            return "Receive media_session::mojom::MediaSession::RequestMediaRemoting";
      case messages::MediaSession::kPreviousSlide:
            return "Receive media_session::mojom::MediaSession::PreviousSlide";
      case messages::MediaSession::kNextSlide:
            return "Receive media_session::mojom::MediaSession::NextSlide";
      case messages::MediaSession::kEnterAutoPictureInPicture:
            return "Receive media_session::mojom::MediaSession::EnterAutoPictureInPicture";
      case messages::MediaSession::kGetVisibility:
            return "Receive media_session::mojom::MediaSession::GetVisibility";
    }
  } else {
    switch (static_cast<messages::MediaSession>(message.name())) {
      case messages::MediaSession::kGetMediaSessionInfo:
            return "Receive reply media_session::mojom::MediaSession::GetMediaSessionInfo";
      case messages::MediaSession::kGetDebugInfo:
            return "Receive reply media_session::mojom::MediaSession::GetDebugInfo";
      case messages::MediaSession::kStartDucking:
            return "Receive reply media_session::mojom::MediaSession::StartDucking";
      case messages::MediaSession::kStopDucking:
            return "Receive reply media_session::mojom::MediaSession::StopDucking";
      case messages::MediaSession::kSuspend:
            return "Receive reply media_session::mojom::MediaSession::Suspend";
      case messages::MediaSession::kResume:
            return "Receive reply media_session::mojom::MediaSession::Resume";
      case messages::MediaSession::kAddObserver:
            return "Receive reply media_session::mojom::MediaSession::AddObserver";
      case messages::MediaSession::kPreviousTrack:
            return "Receive reply media_session::mojom::MediaSession::PreviousTrack";
      case messages::MediaSession::kNextTrack:
            return "Receive reply media_session::mojom::MediaSession::NextTrack";
      case messages::MediaSession::kSeek:
            return "Receive reply media_session::mojom::MediaSession::Seek";
      case messages::MediaSession::kStop:
            return "Receive reply media_session::mojom::MediaSession::Stop";
      case messages::MediaSession::kSkipAd:
            return "Receive reply media_session::mojom::MediaSession::SkipAd";
      case messages::MediaSession::kGetMediaImageBitmap:
            return "Receive reply media_session::mojom::MediaSession::GetMediaImageBitmap";
      case messages::MediaSession::kSeekTo:
            return "Receive reply media_session::mojom::MediaSession::SeekTo";
      case messages::MediaSession::kScrubTo:
            return "Receive reply media_session::mojom::MediaSession::ScrubTo";
      case messages::MediaSession::kEnterPictureInPicture:
            return "Receive reply media_session::mojom::MediaSession::EnterPictureInPicture";
      case messages::MediaSession::kExitPictureInPicture:
            return "Receive reply media_session::mojom::MediaSession::ExitPictureInPicture";
      case messages::MediaSession::kSetAudioSinkId:
            return "Receive reply media_session::mojom::MediaSession::SetAudioSinkId";
      case messages::MediaSession::kToggleMicrophone:
            return "Receive reply media_session::mojom::MediaSession::ToggleMicrophone";
      case messages::MediaSession::kToggleCamera:
            return "Receive reply media_session::mojom::MediaSession::ToggleCamera";
      case messages::MediaSession::kHangUp:
            return "Receive reply media_session::mojom::MediaSession::HangUp";
      case messages::MediaSession::kRaise:
            return "Receive reply media_session::mojom::MediaSession::Raise";
      case messages::MediaSession::kSetMute:
            return "Receive reply media_session::mojom::MediaSession::SetMute";
      case messages::MediaSession::kRequestMediaRemoting:
            return "Receive reply media_session::mojom::MediaSession::RequestMediaRemoting";
      case messages::MediaSession::kPreviousSlide:
            return "Receive reply media_session::mojom::MediaSession::PreviousSlide";
      case messages::MediaSession::kNextSlide:
            return "Receive reply media_session::mojom::MediaSession::NextSlide";
      case messages::MediaSession::kEnterAutoPictureInPicture:
            return "Receive reply media_session::mojom::MediaSession::EnterAutoPictureInPicture";
      case messages::MediaSession::kGetVisibility:
            return "Receive reply media_session::mojom::MediaSession::GetVisibility";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaSession::GetMediaSessionInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x286b48ec;  // IPCStableHash for media_session::mojom::MediaSession::GetMediaSessionInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::GetDebugInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5fd0eac;  // IPCStableHash for media_session::mojom::MediaSession::GetDebugInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::StartDucking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa54c7a4f;  // IPCStableHash for media_session::mojom::MediaSession::StartDucking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::StopDucking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3f91633;  // IPCStableHash for media_session::mojom::MediaSession::StopDucking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::Suspend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb2f44b2;  // IPCStableHash for media_session::mojom::MediaSession::Suspend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1de43c84;  // IPCStableHash for media_session::mojom::MediaSession::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb5f7b8d;  // IPCStableHash for media_session::mojom::MediaSession::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::PreviousTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fbbf24b;  // IPCStableHash for media_session::mojom::MediaSession::PreviousTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::NextTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3d27f4b;  // IPCStableHash for media_session::mojom::MediaSession::NextTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::Seek_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6dcf379b;  // IPCStableHash for media_session::mojom::MediaSession::Seek
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97d421ec;  // IPCStableHash for media_session::mojom::MediaSession::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::SkipAd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8744801a;  // IPCStableHash for media_session::mojom::MediaSession::SkipAd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::GetMediaImageBitmap_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57864144;  // IPCStableHash for media_session::mojom::MediaSession::GetMediaImageBitmap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::SeekTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64d8cc94;  // IPCStableHash for media_session::mojom::MediaSession::SeekTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::ScrubTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70f82acd;  // IPCStableHash for media_session::mojom::MediaSession::ScrubTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::EnterPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x491b1850;  // IPCStableHash for media_session::mojom::MediaSession::EnterPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::ExitPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ba578cd;  // IPCStableHash for media_session::mojom::MediaSession::ExitPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::SetAudioSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83ea1c7e;  // IPCStableHash for media_session::mojom::MediaSession::SetAudioSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::ToggleMicrophone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8bffe70;  // IPCStableHash for media_session::mojom::MediaSession::ToggleMicrophone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::ToggleCamera_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd788f3d;  // IPCStableHash for media_session::mojom::MediaSession::ToggleCamera
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::HangUp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cd52735;  // IPCStableHash for media_session::mojom::MediaSession::HangUp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::Raise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71b24431;  // IPCStableHash for media_session::mojom::MediaSession::Raise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::SetMute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8574eab;  // IPCStableHash for media_session::mojom::MediaSession::SetMute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::RequestMediaRemoting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c275ded;  // IPCStableHash for media_session::mojom::MediaSession::RequestMediaRemoting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::PreviousSlide_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90958f71;  // IPCStableHash for media_session::mojom::MediaSession::PreviousSlide
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::NextSlide_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ae80d55;  // IPCStableHash for media_session::mojom::MediaSession::NextSlide
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::EnterAutoPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92f5d476;  // IPCStableHash for media_session::mojom::MediaSession::EnterAutoPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaSession::GetVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x392c39ea;  // IPCStableHash for media_session::mojom::MediaSession::GetVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaSession_GetMediaSessionInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetMediaSessionInfo_ForwardToCallback(
      MediaSession::GetMediaSessionInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaSession_GetMediaSessionInfo_ForwardToCallback(const MediaSession_GetMediaSessionInfo_ForwardToCallback&) = delete;
  MediaSession_GetMediaSessionInfo_ForwardToCallback& operator=(const MediaSession_GetMediaSessionInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetMediaSessionInfoCallback callback_;
};

class MediaSession_GetDebugInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetDebugInfo_ForwardToCallback(
      MediaSession::GetDebugInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaSession_GetDebugInfo_ForwardToCallback(const MediaSession_GetDebugInfo_ForwardToCallback&) = delete;
  MediaSession_GetDebugInfo_ForwardToCallback& operator=(const MediaSession_GetDebugInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetDebugInfoCallback callback_;
};

class MediaSession_GetMediaImageBitmap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetMediaImageBitmap_ForwardToCallback(
      MediaSession::GetMediaImageBitmapCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaSession_GetMediaImageBitmap_ForwardToCallback(const MediaSession_GetMediaImageBitmap_ForwardToCallback&) = delete;
  MediaSession_GetMediaImageBitmap_ForwardToCallback& operator=(const MediaSession_GetMediaImageBitmap_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetMediaImageBitmapCallback callback_;
};

class MediaSession_GetVisibility_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetVisibility_ForwardToCallback(
      MediaSession::GetVisibilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaSession_GetVisibility_ForwardToCallback(const MediaSession_GetVisibility_ForwardToCallback&) = delete;
  MediaSession_GetVisibility_ForwardToCallback& operator=(const MediaSession_GetVisibility_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetVisibilityCallback callback_;
};

MediaSessionProxy::MediaSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionProxy::GetMediaSessionInfo(
    GetMediaSessionInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::GetMediaSessionInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetMediaSessionInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaSessionInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaSessionInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetMediaSessionInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaSessionProxy::GetDebugInfo(
    GetDebugInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::GetDebugInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetDebugInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetDebugInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetDebugInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaSessionProxy::StartDucking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::StartDucking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kStartDucking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_StartDucking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("StartDucking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::StopDucking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::StopDucking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kStopDucking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_StopDucking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("StopDucking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::Suspend(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::Suspend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type,
                        "<value of type MediaSession::SuspendType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Suspend_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
    in_suspend_type,
    &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::Resume(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::Resume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type,
                        "<value of type MediaSession::SuspendType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Resume_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
    in_suspend_type,
    &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::AddObserver(
    ::mojo::PendingRemote<MediaSessionObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MediaSessionObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MediaSession.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::PreviousTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::PreviousTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kPreviousTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_PreviousTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("PreviousTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::NextTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::NextTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kNextTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_NextTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("NextTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::Seek(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::Seek", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSeek), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Seek_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaSession.Seek request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Seek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::Stop(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type,
                        "<value of type MediaSession::SuspendType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Stop_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
    in_suspend_type,
    &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::SkipAd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::SkipAd");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSkipAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SkipAd_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SkipAd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::GetMediaImageBitmap(
    const ::media_session::MediaImage& in_image, int32_t in_minimum_size_px, int32_t in_desired_size_px, GetMediaImageBitmapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::GetMediaImageBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::media_session::MediaImage&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_size_px"), in_minimum_size_px,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_size_px"), in_desired_size_px,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetMediaImageBitmap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaImageBitmap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaImageDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image in MediaSession.GetMediaImageBitmap request");

  params->minimum_size_px = in_minimum_size_px;

  params->desired_size_px = in_desired_size_px;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaImageBitmap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetMediaImageBitmap_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaSessionProxy::SeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::SeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSeekTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaSession.SeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::ScrubTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::ScrubTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kScrubTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ScrubTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaSession.ScrubTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ScrubTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::EnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::EnterPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kEnterPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_EnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("EnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::ExitPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::ExitPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kExitPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ExitPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ExitPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::SetAudioSinkId(
    const std::optional<std::string>& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSetAudioSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::ToggleMicrophone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::ToggleMicrophone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kToggleMicrophone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ToggleMicrophone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ToggleMicrophone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::ToggleCamera(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::ToggleCamera");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kToggleCamera), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ToggleCamera_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ToggleCamera");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::HangUp(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::HangUp");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kHangUp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_HangUp_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("HangUp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::Raise(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::Raise");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kRaise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Raise_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Raise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::SetMute(
    bool in_mute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaSession::SetMute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mute"), in_mute,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kSetMute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SetMute_Params_Data> params(
          message);
  params.Allocate();

  params->mute = in_mute;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SetMute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::RequestMediaRemoting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::RequestMediaRemoting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kRequestMediaRemoting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_RequestMediaRemoting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("RequestMediaRemoting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::PreviousSlide(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::PreviousSlide");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kPreviousSlide), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_PreviousSlide_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("PreviousSlide");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::NextSlide(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::NextSlide");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kNextSlide), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_NextSlide_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("NextSlide");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::EnterAutoPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::EnterAutoPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kEnterAutoPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_EnterAutoPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("EnterAutoPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaSessionProxy::GetVisibility(
    GetVisibilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaSession::GetVisibility");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetVisibility_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetVisibility");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetVisibility_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaSession_GetMediaSessionInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaSession::GetMediaSessionInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaSession_GetMediaSessionInfo_ProxyToResponder> proxy(
        new MediaSession_GetMediaSessionInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaSession_GetMediaSessionInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetMediaSessionInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaSession_GetMediaSessionInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaSession::GetMediaSessionInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaSessionInfoPtr in_info);
};

bool MediaSession_GetMediaSessionInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaSession.0
  bool success = true;
  MediaSessionInfoPtr p_info{};
  MediaSession_GetMediaSessionInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void MediaSession_GetMediaSessionInfo_ProxyToResponder::Run(
    MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::MediaSession::GetMediaSessionInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type MediaSessionInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetMediaSessionInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaSessionInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaSession_GetDebugInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaSession::GetDebugInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaSession_GetDebugInfo_ProxyToResponder> proxy(
        new MediaSession_GetDebugInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaSession_GetDebugInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetDebugInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaSession_GetDebugInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaSession::GetDebugInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaSessionDebugInfoPtr in_info);
};

bool MediaSession_GetDebugInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaSession_GetDebugInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetDebugInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaSession.1
  bool success = true;
  MediaSessionDebugInfoPtr p_info{};
  MediaSession_GetDebugInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void MediaSession_GetDebugInfo_ProxyToResponder::Run(
    MediaSessionDebugInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::MediaSession::GetDebugInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type MediaSessionDebugInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetDebugInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionDebugInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetDebugInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaSession_GetMediaImageBitmap_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaSession::GetMediaImageBitmapCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaSession_GetMediaImageBitmap_ProxyToResponder> proxy(
        new MediaSession_GetMediaImageBitmap_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaSession_GetMediaImageBitmap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetMediaImageBitmap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaSession_GetMediaImageBitmap_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaSession::GetMediaImageBitmapCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_image);
};

bool MediaSession_GetMediaImageBitmap_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaSession.12
  bool success = true;
  ::SkBitmap p_image{};
  MediaSession_GetMediaImageBitmap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_image));
  }
  return true;
}

void MediaSession_GetMediaImageBitmap_ProxyToResponder::Run(
    const ::SkBitmap& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::MediaSession::GetMediaImageBitmap", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetMediaImageBitmap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaImageBitmap");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaSession_GetVisibility_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaSession::GetVisibilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaSession_GetVisibility_ProxyToResponder> proxy(
        new MediaSession_GetVisibility_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaSession_GetVisibility_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetVisibility_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaSession_GetVisibility_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaSession::GetVisibilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_sufficiently_visible_video);
};

bool MediaSession_GetVisibility_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaSession_GetVisibility_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetVisibility_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaSession.27
  bool success = true;
  bool p_has_sufficiently_visible_video{};
  MediaSession_GetVisibility_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_sufficiently_visible_video = input_data_view.has_sufficiently_visible_video();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_sufficiently_visible_video));
  }
  return true;
}

void MediaSession_GetVisibility_ProxyToResponder::Run(
    bool in_has_sufficiently_visible_video) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media_session::mojom::MediaSession::GetVisibility", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_sufficiently_visible_video"), in_has_sufficiently_visible_video,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaSession::kGetVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetVisibility_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_sufficiently_visible_video = in_has_sufficiently_visible_video;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetVisibility");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaSessionStubDispatch::Accept(
    MediaSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaSession>(message->header()->name)) {
    case messages::MediaSession::kGetMediaSessionInfo: {
      break;
    }
    case messages::MediaSession::kGetDebugInfo: {
      break;
    }
    case messages::MediaSession::kStartDucking: {
      DCHECK(message->is_serialized());
      internal::MediaSession_StartDucking_Params_Data* params =
          reinterpret_cast<internal::MediaSession_StartDucking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.2
      bool success = true;
      MediaSession_StartDucking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDucking(        );
      return true;
    }
    case messages::MediaSession::kStopDucking: {
      DCHECK(message->is_serialized());
      internal::MediaSession_StopDucking_Params_Data* params =
          reinterpret_cast<internal::MediaSession_StopDucking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.3
      bool success = true;
      MediaSession_StopDucking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopDucking(        );
      return true;
    }
    case messages::MediaSession::kSuspend: {
      DCHECK(message->is_serialized());
      internal::MediaSession_Suspend_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Suspend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.4
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Suspend_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(        
        std::move(p_suspend_type));
      return true;
    }
    case messages::MediaSession::kResume: {
      DCHECK(message->is_serialized());
      internal::MediaSession_Resume_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.5
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Resume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        
        std::move(p_suspend_type));
      return true;
    }
    case messages::MediaSession::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::MediaSession_AddObserver_Params_Data* params =
          reinterpret_cast<internal::MediaSession_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.6
      bool success = true;
      ::mojo::PendingRemote<MediaSessionObserver> p_observer{};
      MediaSession_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::MediaSession::kPreviousTrack: {
      DCHECK(message->is_serialized());
      internal::MediaSession_PreviousTrack_Params_Data* params =
          reinterpret_cast<internal::MediaSession_PreviousTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.7
      bool success = true;
      MediaSession_PreviousTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousTrack(        );
      return true;
    }
    case messages::MediaSession::kNextTrack: {
      DCHECK(message->is_serialized());
      internal::MediaSession_NextTrack_Params_Data* params =
          reinterpret_cast<internal::MediaSession_NextTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.8
      bool success = true;
      MediaSession_NextTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextTrack(        );
      return true;
    }
    case messages::MediaSession::kSeek: {
      DCHECK(message->is_serialized());
      internal::MediaSession_Seek_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Seek_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.9
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_Seek_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Seek(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaSession::kStop: {
      DCHECK(message->is_serialized());
      internal::MediaSession_Stop_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.10
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        
        std::move(p_suspend_type));
      return true;
    }
    case messages::MediaSession::kSkipAd: {
      DCHECK(message->is_serialized());
      internal::MediaSession_SkipAd_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SkipAd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.11
      bool success = true;
      MediaSession_SkipAd_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SkipAd(        );
      return true;
    }
    case messages::MediaSession::kGetMediaImageBitmap: {
      break;
    }
    case messages::MediaSession::kSeekTo: {
      DCHECK(message->is_serialized());
      internal::MediaSession_SeekTo_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SeekTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.13
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_SeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SeekTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaSession::kScrubTo: {
      DCHECK(message->is_serialized());
      internal::MediaSession_ScrubTo_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ScrubTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.14
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_ScrubTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrubTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaSession::kEnterPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaSession_EnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaSession_EnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.15
      bool success = true;
      MediaSession_EnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterPictureInPicture(        );
      return true;
    }
    case messages::MediaSession::kExitPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaSession_ExitPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ExitPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.16
      bool success = true;
      MediaSession_ExitPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPictureInPicture(        );
      return true;
    }
    case messages::MediaSession::kSetAudioSinkId: {
      DCHECK(message->is_serialized());
      internal::MediaSession_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.17
      bool success = true;
      std::optional<std::string> p_id{};
      MediaSession_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(        
        std::move(p_id));
      return true;
    }
    case messages::MediaSession::kToggleMicrophone: {
      DCHECK(message->is_serialized());
      internal::MediaSession_ToggleMicrophone_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ToggleMicrophone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.18
      bool success = true;
      MediaSession_ToggleMicrophone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleMicrophone(        );
      return true;
    }
    case messages::MediaSession::kToggleCamera: {
      DCHECK(message->is_serialized());
      internal::MediaSession_ToggleCamera_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ToggleCamera_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.19
      bool success = true;
      MediaSession_ToggleCamera_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleCamera(        );
      return true;
    }
    case messages::MediaSession::kHangUp: {
      DCHECK(message->is_serialized());
      internal::MediaSession_HangUp_Params_Data* params =
          reinterpret_cast<internal::MediaSession_HangUp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.20
      bool success = true;
      MediaSession_HangUp_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HangUp(        );
      return true;
    }
    case messages::MediaSession::kRaise: {
      DCHECK(message->is_serialized());
      internal::MediaSession_Raise_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Raise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.21
      bool success = true;
      MediaSession_Raise_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Raise(        );
      return true;
    }
    case messages::MediaSession::kSetMute: {
      DCHECK(message->is_serialized());
      internal::MediaSession_SetMute_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SetMute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.22
      bool success = true;
      bool p_mute{};
      MediaSession_SetMute_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mute = input_data_view.mute();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMute(        
        std::move(p_mute));
      return true;
    }
    case messages::MediaSession::kRequestMediaRemoting: {
      DCHECK(message->is_serialized());
      internal::MediaSession_RequestMediaRemoting_Params_Data* params =
          reinterpret_cast<internal::MediaSession_RequestMediaRemoting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.23
      bool success = true;
      MediaSession_RequestMediaRemoting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMediaRemoting(        );
      return true;
    }
    case messages::MediaSession::kPreviousSlide: {
      DCHECK(message->is_serialized());
      internal::MediaSession_PreviousSlide_Params_Data* params =
          reinterpret_cast<internal::MediaSession_PreviousSlide_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.24
      bool success = true;
      MediaSession_PreviousSlide_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousSlide(        );
      return true;
    }
    case messages::MediaSession::kNextSlide: {
      DCHECK(message->is_serialized());
      internal::MediaSession_NextSlide_Params_Data* params =
          reinterpret_cast<internal::MediaSession_NextSlide_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.25
      bool success = true;
      MediaSession_NextSlide_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextSlide(        );
      return true;
    }
    case messages::MediaSession::kEnterAutoPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaSession_EnterAutoPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaSession_EnterAutoPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaSession.26
      bool success = true;
      MediaSession_EnterAutoPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterAutoPictureInPicture(        );
      return true;
    }
    case messages::MediaSession::kGetVisibility: {
      break;
    }
  }
  return false;
}

// static
bool MediaSessionStubDispatch::AcceptWithResponder(
    MediaSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaSession>(message->header()->name)) {
    case messages::MediaSession::kGetMediaSessionInfo: {
      internal::MediaSession_GetMediaSessionInfo_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetMediaSessionInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaSession.0
      bool success = true;
      MediaSession_GetMediaSessionInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaSession_GetMediaSessionInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaSessionInfo(std::move(callback));
      return true;
    }
    case messages::MediaSession::kGetDebugInfo: {
      internal::MediaSession_GetDebugInfo_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetDebugInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaSession.1
      bool success = true;
      MediaSession_GetDebugInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 1, false);
        return false;
      }
      auto callback =
          MediaSession_GetDebugInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfo(std::move(callback));
      return true;
    }
    case messages::MediaSession::kStartDucking: {
      break;
    }
    case messages::MediaSession::kStopDucking: {
      break;
    }
    case messages::MediaSession::kSuspend: {
      break;
    }
    case messages::MediaSession::kResume: {
      break;
    }
    case messages::MediaSession::kAddObserver: {
      break;
    }
    case messages::MediaSession::kPreviousTrack: {
      break;
    }
    case messages::MediaSession::kNextTrack: {
      break;
    }
    case messages::MediaSession::kSeek: {
      break;
    }
    case messages::MediaSession::kStop: {
      break;
    }
    case messages::MediaSession::kSkipAd: {
      break;
    }
    case messages::MediaSession::kGetMediaImageBitmap: {
      internal::MediaSession_GetMediaImageBitmap_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetMediaImageBitmap_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaSession.12
      bool success = true;
      ::media_session::MediaImage p_image{};
      int32_t p_minimum_size_px{};
      int32_t p_desired_size_px{};
      MediaSession_GetMediaImageBitmap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success)
        p_minimum_size_px = input_data_view.minimum_size_px();
      if (success)
        p_desired_size_px = input_data_view.desired_size_px();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 12, false);
        return false;
      }
      auto callback =
          MediaSession_GetMediaImageBitmap_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaImageBitmap(        
        std::move(p_image), 
        std::move(p_minimum_size_px), 
        std::move(p_desired_size_px), std::move(callback));
      return true;
    }
    case messages::MediaSession::kSeekTo: {
      break;
    }
    case messages::MediaSession::kScrubTo: {
      break;
    }
    case messages::MediaSession::kEnterPictureInPicture: {
      break;
    }
    case messages::MediaSession::kExitPictureInPicture: {
      break;
    }
    case messages::MediaSession::kSetAudioSinkId: {
      break;
    }
    case messages::MediaSession::kToggleMicrophone: {
      break;
    }
    case messages::MediaSession::kToggleCamera: {
      break;
    }
    case messages::MediaSession::kHangUp: {
      break;
    }
    case messages::MediaSession::kRaise: {
      break;
    }
    case messages::MediaSession::kSetMute: {
      break;
    }
    case messages::MediaSession::kRequestMediaRemoting: {
      break;
    }
    case messages::MediaSession::kPreviousSlide: {
      break;
    }
    case messages::MediaSession::kNextSlide: {
      break;
    }
    case messages::MediaSession::kEnterAutoPictureInPicture: {
      break;
    }
    case messages::MediaSession::kGetVisibility: {
      internal::MediaSession_GetVisibility_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetVisibility_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaSession.27
      bool success = true;
      MediaSession_GetVisibility_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 27, false);
        return false;
      }
      auto callback =
          MediaSession_GetVisibility_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVisibility(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaSessionValidationInfo[] = {
    { &internal::MediaSession_GetMediaSessionInfo_Params_Data::Validate,
     &internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data::Validate},
    { &internal::MediaSession_GetDebugInfo_Params_Data::Validate,
     &internal::MediaSession_GetDebugInfo_ResponseParams_Data::Validate},
    { &internal::MediaSession_StartDucking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_StopDucking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_PreviousTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_NextTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_Seek_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_Stop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_SkipAd_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_GetMediaImageBitmap_Params_Data::Validate,
     &internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data::Validate},
    { &internal::MediaSession_SeekTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_ScrubTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_EnterPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_ExitPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_SetAudioSinkId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_ToggleMicrophone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_ToggleCamera_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_HangUp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_Raise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_SetMute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_RequestMediaRemoting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_PreviousSlide_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_NextSlide_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_EnterAutoPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaSession_GetVisibility_Params_Data::Validate,
     &internal::MediaSession_GetVisibility_ResponseParams_Data::Validate},
};

bool MediaSessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaSession::Name_,
    kMediaSessionValidationInfo);
}

bool MediaSessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media_session::mojom::MediaSession::Name_,
    kMediaSessionValidationInfo);
}


}  // media_session::mojom


namespace mojo {


// static
bool StructTraits<::media_session::mojom::MediaImage::DataView, ::media_session::mojom::MediaImagePtr>::Read(
    ::media_session::mojom::MediaImage::DataView input,
    ::media_session::mojom::MediaImagePtr* output) {
  bool success = true;
  ::media_session::mojom::MediaImagePtr result(::media_session::mojom::MediaImage::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::ChapterInformation::DataView, ::media_session::mojom::ChapterInformationPtr>::Read(
    ::media_session::mojom::ChapterInformation::DataView input,
    ::media_session::mojom::ChapterInformationPtr* output) {
  bool success = true;
  ::media_session::mojom::ChapterInformationPtr result(::media_session::mojom::ChapterInformation::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadStartTime(&result->startTime))
        success = false;
      if (success && !input.ReadArtwork(&result->artwork))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::MediaMetadata::DataView, ::media_session::mojom::MediaMetadataPtr>::Read(
    ::media_session::mojom::MediaMetadata::DataView input,
    ::media_session::mojom::MediaMetadataPtr* output) {
  bool success = true;
  ::media_session::mojom::MediaMetadataPtr result(::media_session::mojom::MediaMetadata::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadSourceTitle(&result->source_title))
        success = false;
      if (success && !input.ReadChapters(&result->chapters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::MediaImageBitmap::DataView, ::media_session::mojom::MediaImageBitmapPtr>::Read(
    ::media_session::mojom::MediaImageBitmap::DataView input,
    ::media_session::mojom::MediaImageBitmapPtr* output) {
  bool success = true;
  ::media_session::mojom::MediaImageBitmapPtr result(::media_session::mojom::MediaImageBitmap::New());
  
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
      if (success && !input.ReadColorType(&result->color_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::MediaPosition::DataView, ::media_session::mojom::MediaPositionPtr>::Read(
    ::media_session::mojom::MediaPosition::DataView input,
    ::media_session::mojom::MediaPositionPtr* output) {
  bool success = true;
  ::media_session::mojom::MediaPositionPtr result(::media_session::mojom::MediaPosition::New());
  
      if (success)
        result->playback_rate = input.playback_rate();
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success && !input.ReadLastUpdatedTime(&result->last_updated_time))
        success = false;
      if (success)
        result->end_of_media = input.end_of_media();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::RemotePlaybackMetadata::DataView, ::media_session::mojom::RemotePlaybackMetadataPtr>::Read(
    ::media_session::mojom::RemotePlaybackMetadata::DataView input,
    ::media_session::mojom::RemotePlaybackMetadataPtr* output) {
  bool success = true;
  ::media_session::mojom::RemotePlaybackMetadataPtr result(::media_session::mojom::RemotePlaybackMetadata::New());
  
      if (success && !input.ReadVideoCodec(&result->video_codec))
        success = false;
      if (success && !input.ReadAudioCodec(&result->audio_codec))
        success = false;
      if (success)
        result->remote_playback_disabled = input.remote_playback_disabled();
      if (success)
        result->remote_playback_started = input.remote_playback_started();
      if (success && !input.ReadUnusedField(&result->unused_field))
        success = false;
      if (success)
        result->is_encrypted_media = input.is_encrypted_media();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::MediaSessionInfo::DataView, ::media_session::mojom::MediaSessionInfoPtr>::Read(
    ::media_session::mojom::MediaSessionInfo::DataView input,
    ::media_session::mojom::MediaSessionInfoPtr* output) {
  bool success = true;
  ::media_session::mojom::MediaSessionInfoPtr result(::media_session::mojom::MediaSessionInfo::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->force_duck = input.force_duck();
      if (success && !input.ReadPlaybackState(&result->playback_state))
        success = false;
      if (success)
        result->is_controllable = input.is_controllable();
      if (success)
        result->prefer_stop_for_gain_focus_loss = input.prefer_stop_for_gain_focus_loss();
      if (success)
        result->deprecated_is_sensitive = input.deprecated_is_sensitive();
      if (success && !input.ReadPictureInPictureState(&result->picture_in_picture_state))
        success = false;
      if (success && !input.ReadDeprecatedAudioVideoState(&result->deprecated_audio_video_state))
        success = false;
      if (success && !input.ReadAudioSinkId(&result->audio_sink_id))
        success = false;
      if (success && !input.ReadAudioVideoStates(&result->audio_video_states))
        success = false;
      if (success && !input.ReadMicrophoneState(&result->microphone_state))
        success = false;
      if (success && !input.ReadCameraState(&result->camera_state))
        success = false;
      if (success)
        result->muted = input.muted();
      if (success)
        result->has_presentation = input.has_presentation();
      if (success && !input.ReadRemotePlaybackMetadata(&result->remote_playback_metadata))
        success = false;
      if (success)
        result->hide_metadata = input.hide_metadata();
      if (success)
        result->ignore_for_active_session = input.ignore_for_active_session();
      if (success)
        result->meets_visibility_threshold = input.meets_visibility_threshold();
      if (success)
        result->can_enter_browser_initiated_autopip = input.can_enter_browser_initiated_autopip();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::MediaSessionDebugInfo::DataView, ::media_session::mojom::MediaSessionDebugInfoPtr>::Read(
    ::media_session::mojom::MediaSessionDebugInfo::DataView input,
    ::media_session::mojom::MediaSessionDebugInfoPtr* output) {
  bool success = true;
  ::media_session::mojom::MediaSessionDebugInfoPtr result(::media_session::mojom::MediaSessionDebugInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadOwner(&result->owner))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_session::mojom {


void MediaSessionObserverInterceptorForTesting::MediaSessionInfoChanged(MediaSessionInfoPtr info) {
  GetForwardingInterface()->MediaSessionInfoChanged(
    std::move(info)
    );
}
void MediaSessionObserverInterceptorForTesting::MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) {
  GetForwardingInterface()->MediaSessionMetadataChanged(
    std::move(metadata)
    );
}
void MediaSessionObserverInterceptorForTesting::MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) {
  GetForwardingInterface()->MediaSessionActionsChanged(
    std::move(action)
    );
}
void MediaSessionObserverInterceptorForTesting::MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) {
  GetForwardingInterface()->MediaSessionImagesChanged(
    std::move(images)
    );
}
void MediaSessionObserverInterceptorForTesting::MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) {
  GetForwardingInterface()->MediaSessionPositionChanged(
    std::move(position)
    );
}
MediaSessionObserverAsyncWaiter::MediaSessionObserverAsyncWaiter(
    MediaSessionObserver* proxy) : proxy_(proxy) {}

MediaSessionObserverAsyncWaiter::~MediaSessionObserverAsyncWaiter() = default;





void MediaSessionInterceptorForTesting::GetMediaSessionInfo(GetMediaSessionInfoCallback callback) {
  GetForwardingInterface()->GetMediaSessionInfo(std::move(callback));
}
void MediaSessionInterceptorForTesting::GetDebugInfo(GetDebugInfoCallback callback) {
  GetForwardingInterface()->GetDebugInfo(std::move(callback));
}
void MediaSessionInterceptorForTesting::StartDucking() {
  GetForwardingInterface()->StartDucking();
}
void MediaSessionInterceptorForTesting::StopDucking() {
  GetForwardingInterface()->StopDucking();
}
void MediaSessionInterceptorForTesting::Suspend(MediaSession::SuspendType suspend_type) {
  GetForwardingInterface()->Suspend(
    std::move(suspend_type)
    );
}
void MediaSessionInterceptorForTesting::Resume(MediaSession::SuspendType suspend_type) {
  GetForwardingInterface()->Resume(
    std::move(suspend_type)
    );
}
void MediaSessionInterceptorForTesting::AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void MediaSessionInterceptorForTesting::PreviousTrack() {
  GetForwardingInterface()->PreviousTrack();
}
void MediaSessionInterceptorForTesting::NextTrack() {
  GetForwardingInterface()->NextTrack();
}
void MediaSessionInterceptorForTesting::Seek(::base::TimeDelta seek_time) {
  GetForwardingInterface()->Seek(
    std::move(seek_time)
    );
}
void MediaSessionInterceptorForTesting::Stop(MediaSession::SuspendType suspend_type) {
  GetForwardingInterface()->Stop(
    std::move(suspend_type)
    );
}
void MediaSessionInterceptorForTesting::SkipAd() {
  GetForwardingInterface()->SkipAd();
}
void MediaSessionInterceptorForTesting::GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) {
  GetForwardingInterface()->GetMediaImageBitmap(
    std::move(image)
    , 
    std::move(minimum_size_px)
    , 
    std::move(desired_size_px)
    , std::move(callback));
}
void MediaSessionInterceptorForTesting::SeekTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->SeekTo(
    std::move(seek_time)
    );
}
void MediaSessionInterceptorForTesting::ScrubTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->ScrubTo(
    std::move(seek_time)
    );
}
void MediaSessionInterceptorForTesting::EnterPictureInPicture() {
  GetForwardingInterface()->EnterPictureInPicture();
}
void MediaSessionInterceptorForTesting::ExitPictureInPicture() {
  GetForwardingInterface()->ExitPictureInPicture();
}
void MediaSessionInterceptorForTesting::SetAudioSinkId(const std::optional<std::string>& id) {
  GetForwardingInterface()->SetAudioSinkId(
    std::move(id)
    );
}
void MediaSessionInterceptorForTesting::ToggleMicrophone() {
  GetForwardingInterface()->ToggleMicrophone();
}
void MediaSessionInterceptorForTesting::ToggleCamera() {
  GetForwardingInterface()->ToggleCamera();
}
void MediaSessionInterceptorForTesting::HangUp() {
  GetForwardingInterface()->HangUp();
}
void MediaSessionInterceptorForTesting::Raise() {
  GetForwardingInterface()->Raise();
}
void MediaSessionInterceptorForTesting::SetMute(bool mute) {
  GetForwardingInterface()->SetMute(
    std::move(mute)
    );
}
void MediaSessionInterceptorForTesting::RequestMediaRemoting() {
  GetForwardingInterface()->RequestMediaRemoting();
}
void MediaSessionInterceptorForTesting::PreviousSlide() {
  GetForwardingInterface()->PreviousSlide();
}
void MediaSessionInterceptorForTesting::NextSlide() {
  GetForwardingInterface()->NextSlide();
}
void MediaSessionInterceptorForTesting::EnterAutoPictureInPicture() {
  GetForwardingInterface()->EnterAutoPictureInPicture();
}
void MediaSessionInterceptorForTesting::GetVisibility(GetVisibilityCallback callback) {
  GetForwardingInterface()->GetVisibility(std::move(callback));
}
MediaSessionAsyncWaiter::MediaSessionAsyncWaiter(
    MediaSession* proxy) : proxy_(proxy) {}

MediaSessionAsyncWaiter::~MediaSessionAsyncWaiter() = default;


void MediaSessionAsyncWaiter::GetMediaSessionInfo(
    MediaSessionInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetMediaSessionInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaSessionInfoPtr* out_info
,
             MediaSessionInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

MediaSessionInfoPtr MediaSessionAsyncWaiter::GetMediaSessionInfo(
    ) {
  MediaSessionInfoPtr async_wait_result;
  GetMediaSessionInfo(&async_wait_result);
  return async_wait_result;
}

void MediaSessionAsyncWaiter::GetDebugInfo(
    MediaSessionDebugInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetDebugInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaSessionDebugInfoPtr* out_info
,
             MediaSessionDebugInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

MediaSessionDebugInfoPtr MediaSessionAsyncWaiter::GetDebugInfo(
    ) {
  MediaSessionDebugInfoPtr async_wait_result;
  GetDebugInfo(&async_wait_result);
  return async_wait_result;
}

void MediaSessionAsyncWaiter::GetMediaImageBitmap(
    const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, ::SkBitmap* out_image) {
  base::RunLoop loop;
  proxy_->GetMediaImageBitmap(
      std::move(image),
      std::move(minimum_size_px),
      std::move(desired_size_px),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_image
,
             const ::SkBitmap& image) {*out_image = std::move(image);
            loop->Quit();
          },
          &loop,
          out_image));
  loop.Run();
}

::SkBitmap MediaSessionAsyncWaiter::GetMediaImageBitmap(
    const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px) {
  ::SkBitmap async_wait_result;
  GetMediaImageBitmap(std::move(image),std::move(minimum_size_px),std::move(desired_size_px),&async_wait_result);
  return async_wait_result;
}

void MediaSessionAsyncWaiter::GetVisibility(
    bool* out_has_sufficiently_visible_video) {
  base::RunLoop loop;
  proxy_->GetVisibility(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_sufficiently_visible_video
,
             bool has_sufficiently_visible_video) {*out_has_sufficiently_visible_video = std::move(has_sufficiently_visible_video);
            loop->Quit();
          },
          &loop,
          out_has_sufficiently_visible_video));
  loop.Run();
}

bool MediaSessionAsyncWaiter::GetVisibility(
    ) {
  bool async_wait_result;
  GetVisibility(&async_wait_result);
  return async_wait_result;
}






}  // media_session::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif