// services/media_session/public/mojom/media_session.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('mediaSession.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaPlaybackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaPlaybackState = {
  
  kPaused: 0,
  kPlaying: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaSessionActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaSessionAction = {
  
  kPlay: 0,
  kPause: 1,
  kPreviousTrack: 2,
  kNextTrack: 3,
  kSeekBackward: 4,
  kSeekForward: 5,
  kSkipAd: 6,
  kStop: 7,
  kSeekTo: 8,
  kScrubTo: 9,
  kEnterPictureInPicture: 10,
  kExitPictureInPicture: 11,
  kSwitchAudioDevice: 12,
  kToggleMicrophone: 13,
  kToggleCamera: 14,
  kHangUp: 15,
  kRaise: 16,
  kSetMute: 17,
  kPreviousSlide: 18,
  kNextSlide: 19,
  kEnterAutoPictureInPicture: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaSessionImageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaSessionImageType = {
  
  kArtwork: 0,
  kSourceIcon: 1,
  kChapter: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaPictureInPictureStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaPictureInPictureState = {
  
  kNotInPictureInPicture: 0,
  kInPictureInPicture: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaAudioVideoStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaAudioVideoState = {
  
  kDeprecatedUnknown: 0,
  kAudioOnly: 1,
  kAudioVideo: 2,
  kVideoOnly: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaImageBitmapColorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaImageBitmapColorType = {
  
  kRGBA_8888: 0,
  kBGRA_8888: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MicrophoneStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MicrophoneState = {
  
  kUnknown: 0,
  kMuted: 1,
  kUnmuted: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.CameraStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.CameraState = {
  
  kUnknown: 0,
  kTurnedOn: 1,
  kTurnedOff: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaSessionObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaSessionObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaSessionObserverInterface }
 */
mediaSession.mojom.MediaSessionObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaSessionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaSessionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaSessionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionInfo } info
   */

  mediaSessionInfoChanged(
      info) {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(
      metadata) {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !Array<!mediaSession.mojom.MediaSessionAction> } action
   */

  mediaSessionActionsChanged(
      action) {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !Object<!mediaSession.mojom.MediaSessionImageType, !Array<!mediaSession.mojom.MediaImage>> } images
   */

  mediaSessionImagesChanged(
      images) {
    this.proxy.sendMessage(
        3,
        mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        [
          images
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaPosition } position
   */

  mediaSessionPositionChanged(
      position) {
    this.proxy.sendMessage(
        4,
        mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaSessionObserverReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaSessionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaSessionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        impl.mediaSessionImagesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaSessionObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaSessionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaSessionObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaSessionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaSessionObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionImagesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        this.mediaSessionImagesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaSessionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaSession.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaSessionInterface }
 */
mediaSession.mojom.MediaSessionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        info: !mediaSession.mojom.MediaSessionInfo,
   *  }>}
   */

  getMediaSessionInfo() {
    return this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        info: !mediaSession.mojom.MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfo() {
    return this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaSession_GetDebugInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  startDucking() {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.MediaSession_StartDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stopDucking() {
    this.proxy.sendMessage(
        3,
        mediaSession.mojom.MediaSession_StopDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSession_SuspendType } suspendType
   */

  suspend(
      suspendType) {
    this.proxy.sendMessage(
        4,
        mediaSession.mojom.MediaSession_Suspend_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSession_SuspendType } suspendType
   */

  resume(
      suspendType) {
    this.proxy.sendMessage(
        5,
        mediaSession.mojom.MediaSession_Resume_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        6,
        mediaSession.mojom.MediaSession_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  previousTrack() {
    this.proxy.sendMessage(
        7,
        mediaSession.mojom.MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextTrack() {
    this.proxy.sendMessage(
        8,
        mediaSession.mojom.MediaSession_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  seek(
      seekTime) {
    this.proxy.sendMessage(
        9,
        mediaSession.mojom.MediaSession_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSession_SuspendType } suspendType
   */

  stop(
      suspendType) {
    this.proxy.sendMessage(
        10,
        mediaSession.mojom.MediaSession_Stop_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   */

  skipAd() {
    this.proxy.sendMessage(
        11,
        mediaSession.mojom.MediaSession_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaImage } image
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @return {!Promise<{
        image: ?mediaSession.mojom.MediaImageBitmap,
   *  }>}
   */

  getMediaImageBitmap(
      image,
      minimumSizePx,
      desiredSizePx) {
    return this.proxy.sendMessage(
        12,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        [
          image,
          minimumSizePx,
          desiredSizePx
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  seekTo(
      seekTime) {
    this.proxy.sendMessage(
        13,
        mediaSession.mojom.MediaSession_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  scrubTo(
      seekTime) {
    this.proxy.sendMessage(
        14,
        mediaSession.mojom.MediaSession_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   */

  enterPictureInPicture() {
    this.proxy.sendMessage(
        15,
        mediaSession.mojom.MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  exitPictureInPicture() {
    this.proxy.sendMessage(
        16,
        mediaSession.mojom.MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(
      id) {
    this.proxy.sendMessage(
        17,
        mediaSession.mojom.MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   */

  toggleMicrophone() {
    this.proxy.sendMessage(
        18,
        mediaSession.mojom.MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleCamera() {
    this.proxy.sendMessage(
        19,
        mediaSession.mojom.MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hangUp() {
    this.proxy.sendMessage(
        20,
        mediaSession.mojom.MediaSession_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  raise() {
    this.proxy.sendMessage(
        21,
        mediaSession.mojom.MediaSession_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } mute
   */

  setMute(
      mute) {
    this.proxy.sendMessage(
        22,
        mediaSession.mojom.MediaSession_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  
  /**
   */

  requestMediaRemoting() {
    this.proxy.sendMessage(
        23,
        mediaSession.mojom.MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  previousSlide() {
    this.proxy.sendMessage(
        24,
        mediaSession.mojom.MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextSlide() {
    this.proxy.sendMessage(
        25,
        mediaSession.mojom.MediaSession_NextSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  enterAutoPictureInPicture() {
    this.proxy.sendMessage(
        26,
        mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        hasSufficientlyVisibleVideo: !boolean,
   *  }>}
   */

  getVisibility() {
    return this.proxy.sendMessage(
        27,
        mediaSession.mojom.MediaSession_GetVisibility_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetVisibility_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaSessionReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        impl.getMediaSessionInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaSession_GetDebugInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        impl.getDebugInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaSession_StartDucking_ParamsSpec.$,
        null,
        impl.startDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaSession_StopDucking_ParamsSpec.$,
        null,
        impl.stopDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaSession_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.MediaSession_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.MediaSession_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.MediaSession_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.MediaSession_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.MediaSession_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.MediaSession_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        impl.getMediaImageBitmap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        mediaSession.mojom.MediaSession_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        mediaSession.mojom.MediaSession_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        mediaSession.mojom.MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        mediaSession.mojom.MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        mediaSession.mojom.MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        mediaSession.mojom.MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        mediaSession.mojom.MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        mediaSession.mojom.MediaSession_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        mediaSession.mojom.MediaSession_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        mediaSession.mojom.MediaSession_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        mediaSession.mojom.MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        mediaSession.mojom.MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        impl.previousSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        mediaSession.mojom.MediaSession_NextSlide_ParamsSpec.$,
        null,
        impl.nextSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        mediaSession.mojom.MediaSession_GetVisibility_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetVisibility_ResponseParamsSpec.$,
        impl.getVisibility.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaSession = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaSessionRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaSession.SuspendTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaSession_SuspendType = {
  
  kSystem: 0,
  kUI: 1,
  kContent: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the MediaSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaSessionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMediaSessionInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        this.getMediaSessionInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDebugInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaSession_GetDebugInfo_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        this.getDebugInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaSession_StartDucking_ParamsSpec.$,
        null,
        this.startDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaSession_StopDucking_ParamsSpec.$,
        null,
        this.stopDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaSession_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.MediaSession_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.MediaSession_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.MediaSession_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.MediaSession_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.MediaSession_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.MediaSession_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMediaImageBitmap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        this.getMediaImageBitmap.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        mediaSession.mojom.MediaSession_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        mediaSession.mojom.MediaSession_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        mediaSession.mojom.MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        mediaSession.mojom.MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        mediaSession.mojom.MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        mediaSession.mojom.MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        mediaSession.mojom.MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        mediaSession.mojom.MediaSession_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        mediaSession.mojom.MediaSession_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        mediaSession.mojom.MediaSession_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        mediaSession.mojom.MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        mediaSession.mojom.MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        this.previousSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        mediaSession.mojom.MediaSession_NextSlide_ParamsSpec.$,
        null,
        this.nextSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        mediaSession.mojom.MediaSession_GetVisibility_ParamsSpec.$,
        mediaSession.mojom.MediaSession_GetVisibility_ResponseParamsSpec.$,
        this.getVisibility.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaImageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.ChapterInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaImageBitmapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaPositionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.RemotePlaybackMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionDebugInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetMediaSessionInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetDebugInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_StartDucking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_StopDucking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_PreviousTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_NextTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_Seek_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_SkipAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetMediaImageBitmap_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_SeekTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_ScrubTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_EnterPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_ExitPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_SetAudioSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_ToggleMicrophone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_ToggleCamera_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_HangUp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_Raise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_SetMute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_RequestMediaRemoting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_PreviousSlide_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_NextSlide_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetVisibility_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaSession_GetVisibility_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mediaSession.mojom.MediaImageSpec.$,
    'MediaImage',
    [
      mojo.internal.StructField(
        'src', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sizes', 16,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
mediaSession.mojom.MediaImage = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.src;
    /** @export { !mojoBase.mojom.String16 } */
    this.type;
    /** @export { !Array<!gfx.mojom.Size> } */
    this.sizes;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.ChapterInformationSpec.$,
    'ChapterInformation',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'artwork', 16,
        0,
        mojo.internal.Array(mediaSession.mojom.MediaImageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
mediaSession.mojom.ChapterInformation = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.startTime;
    /** @export { !Array<!mediaSession.mojom.MediaImage> } */
    this.artwork;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaMetadataSpec.$,
    'MediaMetadata',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'artist', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'album', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceTitle', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'chapters', 32,
        0,
        mojo.internal.Array(mediaSession.mojom.ChapterInformationSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],[21, 48],]);





/** @record */
mediaSession.mojom.MediaMetadata = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
    /** @export { !mojoBase.mojom.String16 } */
    this.artist;
    /** @export { !mojoBase.mojom.String16 } */
    this.album;
    /** @export { !mojoBase.mojom.String16 } */
    this.sourceTitle;
    /** @export { (Array<!mediaSession.mojom.ChapterInformation>|undefined) } */
    this.chapters;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaImageBitmapSpec.$,
    'MediaImageBitmap',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pixelData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'colorType', 16,
        0,
        mediaSession.mojom.MediaImageBitmapColorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[5, 32],]);





/** @record */
mediaSession.mojom.MediaImageBitmap = class {
  constructor() {
    /** @export { !number } */
    this.width;
    /** @export { !number } */
    this.height;
    /** @export { !Array<!number> } */
    this.pixelData;
    /** @export { !mediaSession.mojom.MediaImageBitmapColorType } */
    this.colorType;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaPositionSpec.$,
    'MediaPosition',
    [
      mojo.internal.StructField(
        'playbackRate', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'duration', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'position', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastUpdatedTime', 24,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOfMedia', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],[13, 48],]);





/** @record */
mediaSession.mojom.MediaPosition = class {
  constructor() {
    /** @export { !number } */
    this.playbackRate;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.duration;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.position;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.lastUpdatedTime;
    /** @export { !boolean } */
    this.endOfMedia;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.RemotePlaybackMetadataSpec.$,
    'RemotePlaybackMetadata',
    [
      mojo.internal.StructField(
        'videoCodec', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioCodec', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remotePlaybackDisabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remotePlaybackStarted', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unusedField', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isEncryptedMedia', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[17, 40],[18, 40],]);





/** @record */
mediaSession.mojom.RemotePlaybackMetadata = class {
  constructor() {
    /** @export { !string } */
    this.videoCodec;
    /** @export { !string } */
    this.audioCodec;
    /** @export { !boolean } */
    this.remotePlaybackDisabled;
    /** @export { !boolean } */
    this.remotePlaybackStarted;
    /** @export { (string|undefined) } */
    this.unusedField;
    /** @export { !boolean } */
    this.isEncryptedMedia;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.MediaSessionInfoSpec.SessionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.MediaSessionInfo_SessionState = {
  
  kActive: 0,
  kDucking: 1,
  kSuspended: 2,
  kInactive: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


mojo.internal.Struct(
    mediaSession.mojom.MediaSessionInfoSpec.$,
    'MediaSessionInfo',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.SessionStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceDuck', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'playbackState', 8,
        0,
        mediaSession.mojom.MediaPlaybackStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isControllable', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferStopForGainFocusLoss', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecatedIsSensitive', 4,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pictureInPictureState', 12,
        0,
        mediaSession.mojom.MediaPictureInPictureStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecatedAudioVideoState', 16,
        0,
        mediaSession.mojom.MediaAudioVideoStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioSinkId', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioVideoStates', 32,
        0,
        mojo.internal.Array(mediaSession.mojom.MediaAudioVideoStateSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'microphoneState', 20,
        0,
        mediaSession.mojom.MicrophoneStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cameraState', 40,
        0,
        mediaSession.mojom.CameraStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'muted', 4,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasPresentation', 4,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remotePlaybackMetadata', 48,
        0,
        mediaSession.mojom.RemotePlaybackMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hideMetadata', 4,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignoreForActiveSession', 4,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'meetsVisibilityThreshold', 5,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canEnterBrowserInitiatedAutopip', 5,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[1, 24],[2, 24],[4, 24],[6, 24],[7, 24],[8, 32],[9, 40],[10, 48],[11, 56],[12, 56],[14, 56],[15, 64],[16, 64],[20, 64],[21, 64],[24, 64],]);





/** @record */
mediaSession.mojom.MediaSessionInfo = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo_SessionState } */
    this.state;
    /** @export { !boolean } */
    this.forceDuck;
    /** @export { !mediaSession.mojom.MediaPlaybackState } */
    this.playbackState;
    /** @export { !boolean } */
    this.isControllable;
    /** @export { !boolean } */
    this.preferStopForGainFocusLoss;
    /** @export { !boolean } */
    this.deprecatedIsSensitive;
    /** @export { !mediaSession.mojom.MediaPictureInPictureState } */
    this.pictureInPictureState;
    /** @export { !mediaSession.mojom.MediaAudioVideoState } */
    this.deprecatedAudioVideoState;
    /** @export { (string|undefined) } */
    this.audioSinkId;
    /** @export { (Array<!mediaSession.mojom.MediaAudioVideoState>|undefined) } */
    this.audioVideoStates;
    /** @export { !mediaSession.mojom.MicrophoneState } */
    this.microphoneState;
    /** @export { !mediaSession.mojom.CameraState } */
    this.cameraState;
    /** @export { !boolean } */
    this.muted;
    /** @export { !boolean } */
    this.hasPresentation;
    /** @export { (mediaSession.mojom.RemotePlaybackMetadata|undefined) } */
    this.remotePlaybackMetadata;
    /** @export { !boolean } */
    this.hideMetadata;
    /** @export { !boolean } */
    this.ignoreForActiveSession;
    /** @export { !boolean } */
    this.meetsVisibilityThreshold;
    /** @export { !boolean } */
    this.canEnterBrowserInitiatedAutopip;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionDebugInfoSpec.$,
    'MediaSessionDebugInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'owner', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
mediaSession.mojom.MediaSessionDebugInfo = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.owner;
    /** @export { !string } */
    this.state;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSessionObserver_MediaSessionInfoChanged_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        mediaSession.mojom.MediaMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSessionObserver_MediaSessionMetadataChanged_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaMetadata|undefined) } */
    this.metadata;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mojo.internal.Array(mediaSession.mojom.MediaSessionActionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSessionObserver_MediaSessionActionsChanged_Params = class {
  constructor() {
    /** @export { !Array<!mediaSession.mojom.MediaSessionAction> } */
    this.action;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionImagesChanged_Params',
    [
      mojo.internal.StructField(
        'images', 0,
        0,
        mojo.internal.Map(mediaSession.mojom.MediaSessionImageTypeSpec.$, mojo.internal.Array(mediaSession.mojom.MediaImageSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSessionObserver_MediaSessionImagesChanged_Params = class {
  constructor() {
    /** @export { !Object<!mediaSession.mojom.MediaSessionImageType, !Array<!mediaSession.mojom.MediaImage>> } */
    this.images;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        mediaSession.mojom.MediaPositionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSessionObserver_MediaSessionPositionChanged_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaPosition|undefined) } */
    this.position;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetMediaSessionInfo_ParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_GetMediaSessionInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_GetMediaSessionInfo_ResponseParams = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetDebugInfo_ParamsSpec.$,
    'MediaSession_GetDebugInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_GetDebugInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParamsSpec.$,
    'MediaSession_GetDebugInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mediaSession.mojom.MediaSessionDebugInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_GetDebugInfo_ResponseParams = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionDebugInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_StartDucking_ParamsSpec.$,
    'MediaSession_StartDucking_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_StartDucking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_StopDucking_ParamsSpec.$,
    'MediaSession_StopDucking_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_StopDucking_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_Suspend_ParamsSpec.$,
    'MediaSession_Suspend_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        mediaSession.mojom.MediaSession.SuspendTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_Suspend_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSession_SuspendType } */
    this.suspendType;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_Resume_ParamsSpec.$,
    'MediaSession_Resume_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        mediaSession.mojom.MediaSession.SuspendTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_Resume_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSession_SuspendType } */
    this.suspendType;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_AddObserver_ParamsSpec.$,
    'MediaSession_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.MediaSessionObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_AddObserver_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_PreviousTrack_ParamsSpec.$,
    'MediaSession_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_PreviousTrack_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_NextTrack_ParamsSpec.$,
    'MediaSession_NextTrack_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_NextTrack_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_Seek_ParamsSpec.$,
    'MediaSession_Seek_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_Seek_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_Stop_ParamsSpec.$,
    'MediaSession_Stop_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        mediaSession.mojom.MediaSession.SuspendTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_Stop_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSession_SuspendType } */
    this.suspendType;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_SkipAd_ParamsSpec.$,
    'MediaSession_SkipAd_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_SkipAd_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetMediaImageBitmap_ParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mediaSession.mojom.MediaImageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimumSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'desiredSizePx', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.MediaSession_GetMediaImageBitmap_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaImage } */
    this.image;
    /** @export { !number } */
    this.minimumSizePx;
    /** @export { !number } */
    this.desiredSizePx;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_ResponseParams',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mediaSession.mojom.MediaImageBitmapSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_GetMediaImageBitmap_ResponseParams = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaImageBitmap|undefined) } */
    this.image;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_SeekTo_ParamsSpec.$,
    'MediaSession_SeekTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_SeekTo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_ScrubTo_ParamsSpec.$,
    'MediaSession_ScrubTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_ScrubTo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_EnterPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_EnterPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_ExitPictureInPicture_ParamsSpec.$,
    'MediaSession_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_ExitPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_SetAudioSinkId_ParamsSpec.$,
    'MediaSession_SetAudioSinkId_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_SetAudioSinkId_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.id;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_ToggleMicrophone_ParamsSpec.$,
    'MediaSession_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_ToggleMicrophone_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_ToggleCamera_ParamsSpec.$,
    'MediaSession_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_ToggleCamera_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_HangUp_ParamsSpec.$,
    'MediaSession_HangUp_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_HangUp_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_Raise_ParamsSpec.$,
    'MediaSession_Raise_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_Raise_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_SetMute_ParamsSpec.$,
    'MediaSession_SetMute_Params',
    [
      mojo.internal.StructField(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_SetMute_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.mute;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_RequestMediaRemoting_ParamsSpec.$,
    'MediaSession_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_RequestMediaRemoting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_PreviousSlide_ParamsSpec.$,
    'MediaSession_PreviousSlide_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_PreviousSlide_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_NextSlide_ParamsSpec.$,
    'MediaSession_NextSlide_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_NextSlide_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_EnterAutoPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetVisibility_ParamsSpec.$,
    'MediaSession_GetVisibility_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaSession_GetVisibility_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaSession_GetVisibility_ResponseParamsSpec.$,
    'MediaSession_GetVisibility_ResponseParams',
    [
      mojo.internal.StructField(
        'hasSufficientlyVisibleVideo', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaSession_GetVisibility_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.hasSufficientlyVisibleVideo;
  }
};

