// services/media_session/public/mojom/media_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/media_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/media_controller.mojom-params-data.h"
#include "services/media_session/public/mojom/media_controller.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/media_controller.mojom-import-headers.h"
#include "services/media_session/public/mojom/media_controller.mojom-test-utils.h"


namespace media_session::mojom {
// The declaration includes the definition on other builds.
constexpr base::Token MediaControllerManager::Uuid_;

MediaControllerManager::IPCStableHashFunction MediaControllerManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaControllerManager>(message.name())) {
    case messages::MediaControllerManager::kCreateMediaControllerForSession: {
      return &MediaControllerManager::CreateMediaControllerForSession_Sym::IPCStableHash;
    }
    case messages::MediaControllerManager::kCreateActiveMediaController: {
      return &MediaControllerManager::CreateActiveMediaController_Sym::IPCStableHash;
    }
    case messages::MediaControllerManager::kSuspendAllSessions: {
      return &MediaControllerManager::SuspendAllSessions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaControllerManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaControllerManager>(message.name())) {
      case messages::MediaControllerManager::kCreateMediaControllerForSession:
            return "Receive media_session::mojom::MediaControllerManager::CreateMediaControllerForSession";
      case messages::MediaControllerManager::kCreateActiveMediaController:
            return "Receive media_session::mojom::MediaControllerManager::CreateActiveMediaController";
      case messages::MediaControllerManager::kSuspendAllSessions:
            return "Receive media_session::mojom::MediaControllerManager::SuspendAllSessions";
    }
  } else {
    switch (static_cast<messages::MediaControllerManager>(message.name())) {
      case messages::MediaControllerManager::kCreateMediaControllerForSession:
            return "Receive reply media_session::mojom::MediaControllerManager::CreateMediaControllerForSession";
      case messages::MediaControllerManager::kCreateActiveMediaController:
            return "Receive reply media_session::mojom::MediaControllerManager::CreateActiveMediaController";
      case messages::MediaControllerManager::kSuspendAllSessions:
            return "Receive reply media_session::mojom::MediaControllerManager::SuspendAllSessions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaControllerManager::CreateMediaControllerForSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2debb6e;  // IPCStableHash for media_session::mojom::MediaControllerManager::CreateMediaControllerForSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerManager::CreateActiveMediaController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20b37aa5;  // IPCStableHash for media_session::mojom::MediaControllerManager::CreateActiveMediaController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerManager::SuspendAllSessions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb67f9acd;  // IPCStableHash for media_session::mojom::MediaControllerManager::SuspendAllSessions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaControllerManagerProxy::MediaControllerManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerManagerProxy::CreateMediaControllerForSession(
    ::mojo::PendingReceiver<MediaController> in_receiver, const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerManager::CreateMediaControllerForSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MediaController>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerManager::kCreateMediaControllerForSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in MediaControllerManager.CreateMediaControllerForSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in MediaControllerManager.CreateMediaControllerForSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("CreateMediaControllerForSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerManagerProxy::CreateActiveMediaController(
    ::mojo::PendingReceiver<MediaController> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerManager::CreateActiveMediaController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MediaController>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerManager::kCreateActiveMediaController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_CreateActiveMediaController_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in MediaControllerManager.CreateActiveMediaController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("CreateActiveMediaController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerManagerProxy::SuspendAllSessions(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaControllerManager::SuspendAllSessions");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerManager::kSuspendAllSessions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_SuspendAllSessions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("SuspendAllSessions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaControllerManagerStubDispatch::Accept(
    MediaControllerManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaControllerManager>(message->header()->name)) {
    case messages::MediaControllerManager::kCreateMediaControllerForSession: {
      DCHECK(message->is_serialized());
      internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerManager.0
      bool success = true;
      ::mojo::PendingReceiver<MediaController> p_receiver{};
      ::base::UnguessableToken p_request_id{};
      MediaControllerManager_CreateMediaControllerForSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMediaControllerForSession(        
        std::move(p_receiver), 
        std::move(p_request_id));
      return true;
    }
    case messages::MediaControllerManager::kCreateActiveMediaController: {
      DCHECK(message->is_serialized());
      internal::MediaControllerManager_CreateActiveMediaController_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_CreateActiveMediaController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerManager.1
      bool success = true;
      ::mojo::PendingReceiver<MediaController> p_receiver{};
      MediaControllerManager_CreateActiveMediaController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateActiveMediaController(        
        std::move(p_receiver));
      return true;
    }
    case messages::MediaControllerManager::kSuspendAllSessions: {
      DCHECK(message->is_serialized());
      internal::MediaControllerManager_SuspendAllSessions_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_SuspendAllSessions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerManager.2
      bool success = true;
      MediaControllerManager_SuspendAllSessions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendAllSessions(        );
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerManagerStubDispatch::AcceptWithResponder(
    MediaControllerManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaControllerManager>(message->header()->name)) {
    case messages::MediaControllerManager::kCreateMediaControllerForSession: {
      break;
    }
    case messages::MediaControllerManager::kCreateActiveMediaController: {
      break;
    }
    case messages::MediaControllerManager::kSuspendAllSessions: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaControllerManagerValidationInfo[] = {
    { &internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerManager_CreateActiveMediaController_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerManager_SuspendAllSessions_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaControllerManager::Name_,
    kMediaControllerManagerValidationInfo);
}

// The declaration includes the definition on other builds.

MediaController::IPCStableHashFunction MediaController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaController>(message.name())) {
    case messages::MediaController::kSuspend: {
      return &MediaController::Suspend_Sym::IPCStableHash;
    }
    case messages::MediaController::kResume: {
      return &MediaController::Resume_Sym::IPCStableHash;
    }
    case messages::MediaController::kStop: {
      return &MediaController::Stop_Sym::IPCStableHash;
    }
    case messages::MediaController::kToggleSuspendResume: {
      return &MediaController::ToggleSuspendResume_Sym::IPCStableHash;
    }
    case messages::MediaController::kAddObserver: {
      return &MediaController::AddObserver_Sym::IPCStableHash;
    }
    case messages::MediaController::kPreviousTrack: {
      return &MediaController::PreviousTrack_Sym::IPCStableHash;
    }
    case messages::MediaController::kNextTrack: {
      return &MediaController::NextTrack_Sym::IPCStableHash;
    }
    case messages::MediaController::kSeek: {
      return &MediaController::Seek_Sym::IPCStableHash;
    }
    case messages::MediaController::kObserveImages: {
      return &MediaController::ObserveImages_Sym::IPCStableHash;
    }
    case messages::MediaController::kSeekTo: {
      return &MediaController::SeekTo_Sym::IPCStableHash;
    }
    case messages::MediaController::kScrubTo: {
      return &MediaController::ScrubTo_Sym::IPCStableHash;
    }
    case messages::MediaController::kEnterPictureInPicture: {
      return &MediaController::EnterPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaController::kExitPictureInPicture: {
      return &MediaController::ExitPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaController::kSetAudioSinkId: {
      return &MediaController::SetAudioSinkId_Sym::IPCStableHash;
    }
    case messages::MediaController::kToggleMicrophone: {
      return &MediaController::ToggleMicrophone_Sym::IPCStableHash;
    }
    case messages::MediaController::kToggleCamera: {
      return &MediaController::ToggleCamera_Sym::IPCStableHash;
    }
    case messages::MediaController::kHangUp: {
      return &MediaController::HangUp_Sym::IPCStableHash;
    }
    case messages::MediaController::kRaise: {
      return &MediaController::Raise_Sym::IPCStableHash;
    }
    case messages::MediaController::kSetMute: {
      return &MediaController::SetMute_Sym::IPCStableHash;
    }
    case messages::MediaController::kRequestMediaRemoting: {
      return &MediaController::RequestMediaRemoting_Sym::IPCStableHash;
    }
    case messages::MediaController::kEnterAutoPictureInPicture: {
      return &MediaController::EnterAutoPictureInPicture_Sym::IPCStableHash;
    }
    case messages::MediaController::kSkipAd: {
      return &MediaController::SkipAd_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaController>(message.name())) {
      case messages::MediaController::kSuspend:
            return "Receive media_session::mojom::MediaController::Suspend";
      case messages::MediaController::kResume:
            return "Receive media_session::mojom::MediaController::Resume";
      case messages::MediaController::kStop:
            return "Receive media_session::mojom::MediaController::Stop";
      case messages::MediaController::kToggleSuspendResume:
            return "Receive media_session::mojom::MediaController::ToggleSuspendResume";
      case messages::MediaController::kAddObserver:
            return "Receive media_session::mojom::MediaController::AddObserver";
      case messages::MediaController::kPreviousTrack:
            return "Receive media_session::mojom::MediaController::PreviousTrack";
      case messages::MediaController::kNextTrack:
            return "Receive media_session::mojom::MediaController::NextTrack";
      case messages::MediaController::kSeek:
            return "Receive media_session::mojom::MediaController::Seek";
      case messages::MediaController::kObserveImages:
            return "Receive media_session::mojom::MediaController::ObserveImages";
      case messages::MediaController::kSeekTo:
            return "Receive media_session::mojom::MediaController::SeekTo";
      case messages::MediaController::kScrubTo:
            return "Receive media_session::mojom::MediaController::ScrubTo";
      case messages::MediaController::kEnterPictureInPicture:
            return "Receive media_session::mojom::MediaController::EnterPictureInPicture";
      case messages::MediaController::kExitPictureInPicture:
            return "Receive media_session::mojom::MediaController::ExitPictureInPicture";
      case messages::MediaController::kSetAudioSinkId:
            return "Receive media_session::mojom::MediaController::SetAudioSinkId";
      case messages::MediaController::kToggleMicrophone:
            return "Receive media_session::mojom::MediaController::ToggleMicrophone";
      case messages::MediaController::kToggleCamera:
            return "Receive media_session::mojom::MediaController::ToggleCamera";
      case messages::MediaController::kHangUp:
            return "Receive media_session::mojom::MediaController::HangUp";
      case messages::MediaController::kRaise:
            return "Receive media_session::mojom::MediaController::Raise";
      case messages::MediaController::kSetMute:
            return "Receive media_session::mojom::MediaController::SetMute";
      case messages::MediaController::kRequestMediaRemoting:
            return "Receive media_session::mojom::MediaController::RequestMediaRemoting";
      case messages::MediaController::kEnterAutoPictureInPicture:
            return "Receive media_session::mojom::MediaController::EnterAutoPictureInPicture";
      case messages::MediaController::kSkipAd:
            return "Receive media_session::mojom::MediaController::SkipAd";
    }
  } else {
    switch (static_cast<messages::MediaController>(message.name())) {
      case messages::MediaController::kSuspend:
            return "Receive reply media_session::mojom::MediaController::Suspend";
      case messages::MediaController::kResume:
            return "Receive reply media_session::mojom::MediaController::Resume";
      case messages::MediaController::kStop:
            return "Receive reply media_session::mojom::MediaController::Stop";
      case messages::MediaController::kToggleSuspendResume:
            return "Receive reply media_session::mojom::MediaController::ToggleSuspendResume";
      case messages::MediaController::kAddObserver:
            return "Receive reply media_session::mojom::MediaController::AddObserver";
      case messages::MediaController::kPreviousTrack:
            return "Receive reply media_session::mojom::MediaController::PreviousTrack";
      case messages::MediaController::kNextTrack:
            return "Receive reply media_session::mojom::MediaController::NextTrack";
      case messages::MediaController::kSeek:
            return "Receive reply media_session::mojom::MediaController::Seek";
      case messages::MediaController::kObserveImages:
            return "Receive reply media_session::mojom::MediaController::ObserveImages";
      case messages::MediaController::kSeekTo:
            return "Receive reply media_session::mojom::MediaController::SeekTo";
      case messages::MediaController::kScrubTo:
            return "Receive reply media_session::mojom::MediaController::ScrubTo";
      case messages::MediaController::kEnterPictureInPicture:
            return "Receive reply media_session::mojom::MediaController::EnterPictureInPicture";
      case messages::MediaController::kExitPictureInPicture:
            return "Receive reply media_session::mojom::MediaController::ExitPictureInPicture";
      case messages::MediaController::kSetAudioSinkId:
            return "Receive reply media_session::mojom::MediaController::SetAudioSinkId";
      case messages::MediaController::kToggleMicrophone:
            return "Receive reply media_session::mojom::MediaController::ToggleMicrophone";
      case messages::MediaController::kToggleCamera:
            return "Receive reply media_session::mojom::MediaController::ToggleCamera";
      case messages::MediaController::kHangUp:
            return "Receive reply media_session::mojom::MediaController::HangUp";
      case messages::MediaController::kRaise:
            return "Receive reply media_session::mojom::MediaController::Raise";
      case messages::MediaController::kSetMute:
            return "Receive reply media_session::mojom::MediaController::SetMute";
      case messages::MediaController::kRequestMediaRemoting:
            return "Receive reply media_session::mojom::MediaController::RequestMediaRemoting";
      case messages::MediaController::kEnterAutoPictureInPicture:
            return "Receive reply media_session::mojom::MediaController::EnterAutoPictureInPicture";
      case messages::MediaController::kSkipAd:
            return "Receive reply media_session::mojom::MediaController::SkipAd";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaController::Suspend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3898fc2;  // IPCStableHash for media_session::mojom::MediaController::Suspend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccecdeb2;  // IPCStableHash for media_session::mojom::MediaController::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc30fb662;  // IPCStableHash for media_session::mojom::MediaController::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ToggleSuspendResume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f9891d1;  // IPCStableHash for media_session::mojom::MediaController::ToggleSuspendResume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04581387;  // IPCStableHash for media_session::mojom::MediaController::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::PreviousTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd82bed43;  // IPCStableHash for media_session::mojom::MediaController::PreviousTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::NextTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e3313bd;  // IPCStableHash for media_session::mojom::MediaController::NextTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Seek_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77088059;  // IPCStableHash for media_session::mojom::MediaController::Seek
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ObserveImages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0635b1d6;  // IPCStableHash for media_session::mojom::MediaController::ObserveImages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SeekTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9ca1e08;  // IPCStableHash for media_session::mojom::MediaController::SeekTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ScrubTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61bd76a6;  // IPCStableHash for media_session::mojom::MediaController::ScrubTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::EnterPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e783b43;  // IPCStableHash for media_session::mojom::MediaController::EnterPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ExitPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95a40da2;  // IPCStableHash for media_session::mojom::MediaController::ExitPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SetAudioSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1394cfc;  // IPCStableHash for media_session::mojom::MediaController::SetAudioSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ToggleMicrophone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1023daa4;  // IPCStableHash for media_session::mojom::MediaController::ToggleMicrophone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::ToggleCamera_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedce01a8;  // IPCStableHash for media_session::mojom::MediaController::ToggleCamera
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::HangUp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f4d8b1e;  // IPCStableHash for media_session::mojom::MediaController::HangUp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Raise_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a0b3dc6;  // IPCStableHash for media_session::mojom::MediaController::Raise
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SetMute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf84d9fb4;  // IPCStableHash for media_session::mojom::MediaController::SetMute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::RequestMediaRemoting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04b00384;  // IPCStableHash for media_session::mojom::MediaController::RequestMediaRemoting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::EnterAutoPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98e01d6d;  // IPCStableHash for media_session::mojom::MediaController::EnterAutoPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SkipAd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a49a8e1;  // IPCStableHash for media_session::mojom::MediaController::SkipAd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaControllerProxy::MediaControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerProxy::Suspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::Suspend");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Suspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::Resume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ToggleSuspendResume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::ToggleSuspendResume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kToggleSuspendResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleSuspendResume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleSuspendResume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::AddObserver(
    ::mojo::PendingRemote<MediaControllerObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MediaControllerObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MediaController.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::PreviousTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::PreviousTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kPreviousTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_PreviousTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("PreviousTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::NextTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::NextTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kNextTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_NextTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("NextTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Seek(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::Seek", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSeek), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Seek_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaController.Seek request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Seek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ObserveImages(
    ::media_session::mojom::MediaSessionImageType in_type, int32_t in_minimum_size_px, int32_t in_desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::ObserveImages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media_session::mojom::MediaSessionImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_size_px"), in_minimum_size_px,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_size_px"), in_desired_size_px,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MediaControllerImageObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kObserveImages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ObserveImages_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionImageType>(
    in_type,
    &params->type);

  params->minimum_size_px = in_minimum_size_px;

  params->desired_size_px = in_desired_size_px;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerImageObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in MediaController.ObserveImages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ObserveImages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::SeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSeekTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaController.SeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ScrubTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::ScrubTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kScrubTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ScrubTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in MediaController.ScrubTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ScrubTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::EnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::EnterPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kEnterPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_EnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("EnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ExitPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::ExitPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kExitPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ExitPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ExitPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SetAudioSinkId(
    const std::optional<std::string>& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSetAudioSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ToggleMicrophone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::ToggleMicrophone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kToggleMicrophone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleMicrophone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleMicrophone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::ToggleCamera(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::ToggleCamera");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kToggleCamera), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleCamera_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleCamera");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::HangUp(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::HangUp");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kHangUp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_HangUp_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("HangUp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Raise(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::Raise");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kRaise), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Raise_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Raise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SetMute(
    bool in_mute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaController::SetMute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mute"), in_mute,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSetMute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SetMute_Params_Data> params(
          message);
  params.Allocate();

  params->mute = in_mute;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SetMute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::RequestMediaRemoting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::RequestMediaRemoting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kRequestMediaRemoting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_RequestMediaRemoting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("RequestMediaRemoting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::EnterAutoPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::EnterAutoPictureInPicture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kEnterAutoPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_EnterAutoPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("EnterAutoPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SkipAd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_session::mojom::MediaController::SkipAd");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSkipAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SkipAd_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SkipAd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaControllerStubDispatch::Accept(
    MediaController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaController>(message->header()->name)) {
    case messages::MediaController::kSuspend: {
      DCHECK(message->is_serialized());
      internal::MediaController_Suspend_Params_Data* params =
          reinterpret_cast<internal::MediaController_Suspend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.0
      bool success = true;
      MediaController_Suspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(        );
      return true;
    }
    case messages::MediaController::kResume: {
      DCHECK(message->is_serialized());
      internal::MediaController_Resume_Params_Data* params =
          reinterpret_cast<internal::MediaController_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.1
      bool success = true;
      MediaController_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        );
      return true;
    }
    case messages::MediaController::kStop: {
      DCHECK(message->is_serialized());
      internal::MediaController_Stop_Params_Data* params =
          reinterpret_cast<internal::MediaController_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.2
      bool success = true;
      MediaController_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
    case messages::MediaController::kToggleSuspendResume: {
      DCHECK(message->is_serialized());
      internal::MediaController_ToggleSuspendResume_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleSuspendResume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.3
      bool success = true;
      MediaController_ToggleSuspendResume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleSuspendResume(        );
      return true;
    }
    case messages::MediaController::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::MediaController_AddObserver_Params_Data* params =
          reinterpret_cast<internal::MediaController_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.4
      bool success = true;
      ::mojo::PendingRemote<MediaControllerObserver> p_observer{};
      MediaController_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::MediaController::kPreviousTrack: {
      DCHECK(message->is_serialized());
      internal::MediaController_PreviousTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_PreviousTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.5
      bool success = true;
      MediaController_PreviousTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousTrack(        );
      return true;
    }
    case messages::MediaController::kNextTrack: {
      DCHECK(message->is_serialized());
      internal::MediaController_NextTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_NextTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.6
      bool success = true;
      MediaController_NextTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextTrack(        );
      return true;
    }
    case messages::MediaController::kSeek: {
      DCHECK(message->is_serialized());
      internal::MediaController_Seek_Params_Data* params =
          reinterpret_cast<internal::MediaController_Seek_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.7
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_Seek_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Seek(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaController::kObserveImages: {
      DCHECK(message->is_serialized());
      internal::MediaController_ObserveImages_Params_Data* params =
          reinterpret_cast<internal::MediaController_ObserveImages_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.8
      bool success = true;
      ::media_session::mojom::MediaSessionImageType p_type{};
      int32_t p_minimum_size_px{};
      int32_t p_desired_size_px{};
      ::mojo::PendingRemote<MediaControllerImageObserver> p_observer{};
      MediaController_ObserveImages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_minimum_size_px = input_data_view.minimum_size_px();
      if (success)
        p_desired_size_px = input_data_view.desired_size_px();
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ObserveImages(        
        std::move(p_type), 
        std::move(p_minimum_size_px), 
        std::move(p_desired_size_px), 
        std::move(p_observer));
      return true;
    }
    case messages::MediaController::kSeekTo: {
      DCHECK(message->is_serialized());
      internal::MediaController_SeekTo_Params_Data* params =
          reinterpret_cast<internal::MediaController_SeekTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.9
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_SeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SeekTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaController::kScrubTo: {
      DCHECK(message->is_serialized());
      internal::MediaController_ScrubTo_Params_Data* params =
          reinterpret_cast<internal::MediaController_ScrubTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.10
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_ScrubTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrubTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::MediaController::kEnterPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaController_EnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaController_EnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.11
      bool success = true;
      MediaController_EnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterPictureInPicture(        );
      return true;
    }
    case messages::MediaController::kExitPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaController_ExitPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaController_ExitPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.12
      bool success = true;
      MediaController_ExitPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPictureInPicture(        );
      return true;
    }
    case messages::MediaController::kSetAudioSinkId: {
      DCHECK(message->is_serialized());
      internal::MediaController_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaController_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.13
      bool success = true;
      std::optional<std::string> p_id{};
      MediaController_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(        
        std::move(p_id));
      return true;
    }
    case messages::MediaController::kToggleMicrophone: {
      DCHECK(message->is_serialized());
      internal::MediaController_ToggleMicrophone_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleMicrophone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.14
      bool success = true;
      MediaController_ToggleMicrophone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleMicrophone(        );
      return true;
    }
    case messages::MediaController::kToggleCamera: {
      DCHECK(message->is_serialized());
      internal::MediaController_ToggleCamera_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleCamera_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.15
      bool success = true;
      MediaController_ToggleCamera_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleCamera(        );
      return true;
    }
    case messages::MediaController::kHangUp: {
      DCHECK(message->is_serialized());
      internal::MediaController_HangUp_Params_Data* params =
          reinterpret_cast<internal::MediaController_HangUp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.16
      bool success = true;
      MediaController_HangUp_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HangUp(        );
      return true;
    }
    case messages::MediaController::kRaise: {
      DCHECK(message->is_serialized());
      internal::MediaController_Raise_Params_Data* params =
          reinterpret_cast<internal::MediaController_Raise_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.17
      bool success = true;
      MediaController_Raise_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Raise(        );
      return true;
    }
    case messages::MediaController::kSetMute: {
      DCHECK(message->is_serialized());
      internal::MediaController_SetMute_Params_Data* params =
          reinterpret_cast<internal::MediaController_SetMute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.18
      bool success = true;
      bool p_mute{};
      MediaController_SetMute_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mute = input_data_view.mute();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMute(        
        std::move(p_mute));
      return true;
    }
    case messages::MediaController::kRequestMediaRemoting: {
      DCHECK(message->is_serialized());
      internal::MediaController_RequestMediaRemoting_Params_Data* params =
          reinterpret_cast<internal::MediaController_RequestMediaRemoting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.19
      bool success = true;
      MediaController_RequestMediaRemoting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMediaRemoting(        );
      return true;
    }
    case messages::MediaController::kEnterAutoPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::MediaController_EnterAutoPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaController_EnterAutoPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.20
      bool success = true;
      MediaController_EnterAutoPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterAutoPictureInPicture(        );
      return true;
    }
    case messages::MediaController::kSkipAd: {
      DCHECK(message->is_serialized());
      internal::MediaController_SkipAd_Params_Data* params =
          reinterpret_cast<internal::MediaController_SkipAd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.21
      bool success = true;
      MediaController_SkipAd_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SkipAd(        );
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerStubDispatch::AcceptWithResponder(
    MediaController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaController>(message->header()->name)) {
    case messages::MediaController::kSuspend: {
      break;
    }
    case messages::MediaController::kResume: {
      break;
    }
    case messages::MediaController::kStop: {
      break;
    }
    case messages::MediaController::kToggleSuspendResume: {
      break;
    }
    case messages::MediaController::kAddObserver: {
      break;
    }
    case messages::MediaController::kPreviousTrack: {
      break;
    }
    case messages::MediaController::kNextTrack: {
      break;
    }
    case messages::MediaController::kSeek: {
      break;
    }
    case messages::MediaController::kObserveImages: {
      break;
    }
    case messages::MediaController::kSeekTo: {
      break;
    }
    case messages::MediaController::kScrubTo: {
      break;
    }
    case messages::MediaController::kEnterPictureInPicture: {
      break;
    }
    case messages::MediaController::kExitPictureInPicture: {
      break;
    }
    case messages::MediaController::kSetAudioSinkId: {
      break;
    }
    case messages::MediaController::kToggleMicrophone: {
      break;
    }
    case messages::MediaController::kToggleCamera: {
      break;
    }
    case messages::MediaController::kHangUp: {
      break;
    }
    case messages::MediaController::kRaise: {
      break;
    }
    case messages::MediaController::kSetMute: {
      break;
    }
    case messages::MediaController::kRequestMediaRemoting: {
      break;
    }
    case messages::MediaController::kEnterAutoPictureInPicture: {
      break;
    }
    case messages::MediaController::kSkipAd: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaControllerValidationInfo[] = {
    { &internal::MediaController_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Stop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ToggleSuspendResume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_PreviousTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_NextTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Seek_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ObserveImages_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SeekTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ScrubTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_EnterPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ExitPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SetAudioSinkId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ToggleMicrophone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_ToggleCamera_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_HangUp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Raise_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SetMute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_RequestMediaRemoting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_EnterAutoPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SkipAd_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaController::Name_,
    kMediaControllerValidationInfo);
}

// The declaration includes the definition on other builds.

MediaControllerObserver::IPCStableHashFunction MediaControllerObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaControllerObserver>(message.name())) {
    case messages::MediaControllerObserver::kMediaSessionInfoChanged: {
      return &MediaControllerObserver::MediaSessionInfoChanged_Sym::IPCStableHash;
    }
    case messages::MediaControllerObserver::kMediaSessionMetadataChanged: {
      return &MediaControllerObserver::MediaSessionMetadataChanged_Sym::IPCStableHash;
    }
    case messages::MediaControllerObserver::kMediaSessionActionsChanged: {
      return &MediaControllerObserver::MediaSessionActionsChanged_Sym::IPCStableHash;
    }
    case messages::MediaControllerObserver::kMediaSessionChanged: {
      return &MediaControllerObserver::MediaSessionChanged_Sym::IPCStableHash;
    }
    case messages::MediaControllerObserver::kMediaSessionPositionChanged: {
      return &MediaControllerObserver::MediaSessionPositionChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaControllerObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaControllerObserver>(message.name())) {
      case messages::MediaControllerObserver::kMediaSessionInfoChanged:
            return "Receive media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged";
      case messages::MediaControllerObserver::kMediaSessionMetadataChanged:
            return "Receive media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged";
      case messages::MediaControllerObserver::kMediaSessionActionsChanged:
            return "Receive media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged";
      case messages::MediaControllerObserver::kMediaSessionChanged:
            return "Receive media_session::mojom::MediaControllerObserver::MediaSessionChanged";
      case messages::MediaControllerObserver::kMediaSessionPositionChanged:
            return "Receive media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged";
    }
  } else {
    switch (static_cast<messages::MediaControllerObserver>(message.name())) {
      case messages::MediaControllerObserver::kMediaSessionInfoChanged:
            return "Receive reply media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged";
      case messages::MediaControllerObserver::kMediaSessionMetadataChanged:
            return "Receive reply media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged";
      case messages::MediaControllerObserver::kMediaSessionActionsChanged:
            return "Receive reply media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged";
      case messages::MediaControllerObserver::kMediaSessionChanged:
            return "Receive reply media_session::mojom::MediaControllerObserver::MediaSessionChanged";
      case messages::MediaControllerObserver::kMediaSessionPositionChanged:
            return "Receive reply media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaControllerObserver::MediaSessionInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdae0fa1b;  // IPCStableHash for media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerObserver::MediaSessionMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea171eac;  // IPCStableHash for media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerObserver::MediaSessionActionsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcba2fac;  // IPCStableHash for media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerObserver::MediaSessionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3dc99d00;  // IPCStableHash for media_session::mojom::MediaControllerObserver::MediaSessionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerObserver::MediaSessionPositionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a0d7209;  // IPCStableHash for media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaControllerObserverProxy::MediaControllerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerObserverProxy::MediaSessionInfoChanged(
    ::media_session::mojom::MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerObserver::kMediaSessionInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerObserverProxy::MediaSessionMetadataChanged(
    const std::optional<::media_session::MediaMetadata>& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const std::optional<::media_session::MediaMetadata>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerObserver::kMediaSessionMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerObserverProxy::MediaSessionActionsChanged(
    const std::vector<::media_session::mojom::MediaSessionAction>& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type const std::vector<::media_session::mojom::MediaSessionAction>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerObserver::kMediaSessionActionsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType>
      action_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& action_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaSessionAction_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
    in_action,
    action_fragment,
    &action_validate_params);

  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action in MediaControllerObserver.MediaSessionActionsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionActionsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerObserverProxy::MediaSessionChanged(
    const std::optional<::base::UnguessableToken>& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerObserver::MediaSessionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerObserver::kMediaSessionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerObserverProxy::MediaSessionPositionChanged(
    const std::optional<::media_session::MediaPosition>& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const std::optional<::media_session::MediaPosition>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerObserver::kMediaSessionPositionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionPositionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaControllerObserverStubDispatch::Accept(
    MediaControllerObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaControllerObserver>(message->header()->name)) {
    case messages::MediaControllerObserver::kMediaSessionInfoChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerObserver.0
      bool success = true;
      ::media_session::mojom::MediaSessionInfoPtr p_info{};
      MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(        
        std::move(p_info));
      return true;
    }
    case messages::MediaControllerObserver::kMediaSessionMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerObserver.1
      bool success = true;
      std::optional<::media_session::MediaMetadata> p_metadata{};
      MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionMetadataChanged(        
        std::move(p_metadata));
      return true;
    }
    case messages::MediaControllerObserver::kMediaSessionActionsChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerObserver.2
      bool success = true;
      std::vector<::media_session::mojom::MediaSessionAction> p_action{};
      MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionActionsChanged(        
        std::move(p_action));
      return true;
    }
    case messages::MediaControllerObserver::kMediaSessionChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerObserver.3
      bool success = true;
      std::optional<::base::UnguessableToken> p_request_id{};
      MediaControllerObserver_MediaSessionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionChanged(        
        std::move(p_request_id));
      return true;
    }
    case messages::MediaControllerObserver::kMediaSessionPositionChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerObserver.4
      bool success = true;
      std::optional<::media_session::MediaPosition> p_position{};
      MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionPositionChanged(        
        std::move(p_position));
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerObserverStubDispatch::AcceptWithResponder(
    MediaControllerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaControllerObserver>(message->header()->name)) {
    case messages::MediaControllerObserver::kMediaSessionInfoChanged: {
      break;
    }
    case messages::MediaControllerObserver::kMediaSessionMetadataChanged: {
      break;
    }
    case messages::MediaControllerObserver::kMediaSessionActionsChanged: {
      break;
    }
    case messages::MediaControllerObserver::kMediaSessionChanged: {
      break;
    }
    case messages::MediaControllerObserver::kMediaSessionPositionChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaControllerObserverValidationInfo[] = {
    { &internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerObserver_MediaSessionChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaControllerObserver::Name_,
    kMediaControllerObserverValidationInfo);
}

// The declaration includes the definition on other builds.

MediaControllerImageObserver::IPCStableHashFunction MediaControllerImageObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaControllerImageObserver>(message.name())) {
    case messages::MediaControllerImageObserver::kMediaControllerImageChanged: {
      return &MediaControllerImageObserver::MediaControllerImageChanged_Sym::IPCStableHash;
    }
    case messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged: {
      return &MediaControllerImageObserver::MediaControllerChapterImageChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaControllerImageObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaControllerImageObserver>(message.name())) {
      case messages::MediaControllerImageObserver::kMediaControllerImageChanged:
            return "Receive media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged";
      case messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged:
            return "Receive media_session::mojom::MediaControllerImageObserver::MediaControllerChapterImageChanged";
    }
  } else {
    switch (static_cast<messages::MediaControllerImageObserver>(message.name())) {
      case messages::MediaControllerImageObserver::kMediaControllerImageChanged:
            return "Receive reply media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged";
      case messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged:
            return "Receive reply media_session::mojom::MediaControllerImageObserver::MediaControllerChapterImageChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaControllerImageObserver::MediaControllerImageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64145f53;  // IPCStableHash for media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaControllerImageObserver::MediaControllerChapterImageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdc530948;  // IPCStableHash for media_session::mojom::MediaControllerImageObserver::MediaControllerChapterImageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaControllerImageObserverProxy::MediaControllerImageObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerImageObserverProxy::MediaControllerImageChanged(
    ::media_session::mojom::MediaSessionImageType in_type, const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media_session::mojom::MediaSessionImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerImageObserver::kMediaControllerImageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media_session::mojom::MediaSessionImageType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerImageObserver::Name_);
  message.set_method_name("MediaControllerImageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerImageObserverProxy::MediaControllerChapterImageChanged(
    int32_t in_index, const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_session::mojom::MediaControllerImageObserver::MediaControllerChapterImageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerImageObserver::Name_);
  message.set_method_name("MediaControllerChapterImageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaControllerImageObserverStubDispatch::Accept(
    MediaControllerImageObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaControllerImageObserver>(message->header()->name)) {
    case messages::MediaControllerImageObserver::kMediaControllerImageChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerImageObserver.0
      bool success = true;
      ::media_session::mojom::MediaSessionImageType p_type{};
      ::SkBitmap p_bitmap{};
      MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadBitmap(&p_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerImageObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaControllerImageChanged(        
        std::move(p_type), 
        std::move(p_bitmap));
      return true;
    }
    case messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged: {
      DCHECK(message->is_serialized());
      internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaControllerImageObserver.1
      bool success = true;
      int32_t p_index{};
      ::SkBitmap p_bitmap{};
      MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadBitmap(&p_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerImageObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaControllerChapterImageChanged(        
        std::move(p_index), 
        std::move(p_bitmap));
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerImageObserverStubDispatch::AcceptWithResponder(
    MediaControllerImageObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaControllerImageObserver>(message->header()->name)) {
    case messages::MediaControllerImageObserver::kMediaControllerImageChanged: {
      break;
    }
    case messages::MediaControllerImageObserver::kMediaControllerChapterImageChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaControllerImageObserverValidationInfo[] = {
    { &internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerImageObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_session::mojom::MediaControllerImageObserver::Name_,
    kMediaControllerImageObserverValidationInfo);
}



}  // media_session::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_session::mojom {


void MediaControllerManagerInterceptorForTesting::CreateMediaControllerForSession(::mojo::PendingReceiver<MediaController> receiver, const ::base::UnguessableToken& request_id) {
  GetForwardingInterface()->CreateMediaControllerForSession(
    std::move(receiver)
    , 
    std::move(request_id)
    );
}
void MediaControllerManagerInterceptorForTesting::CreateActiveMediaController(::mojo::PendingReceiver<MediaController> receiver) {
  GetForwardingInterface()->CreateActiveMediaController(
    std::move(receiver)
    );
}
void MediaControllerManagerInterceptorForTesting::SuspendAllSessions() {
  GetForwardingInterface()->SuspendAllSessions();
}
MediaControllerManagerAsyncWaiter::MediaControllerManagerAsyncWaiter(
    MediaControllerManager* proxy) : proxy_(proxy) {}

MediaControllerManagerAsyncWaiter::~MediaControllerManagerAsyncWaiter() = default;





void MediaControllerInterceptorForTesting::Suspend() {
  GetForwardingInterface()->Suspend();
}
void MediaControllerInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void MediaControllerInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
void MediaControllerInterceptorForTesting::ToggleSuspendResume() {
  GetForwardingInterface()->ToggleSuspendResume();
}
void MediaControllerInterceptorForTesting::AddObserver(::mojo::PendingRemote<MediaControllerObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void MediaControllerInterceptorForTesting::PreviousTrack() {
  GetForwardingInterface()->PreviousTrack();
}
void MediaControllerInterceptorForTesting::NextTrack() {
  GetForwardingInterface()->NextTrack();
}
void MediaControllerInterceptorForTesting::Seek(::base::TimeDelta seek_time) {
  GetForwardingInterface()->Seek(
    std::move(seek_time)
    );
}
void MediaControllerInterceptorForTesting::ObserveImages(::media_session::mojom::MediaSessionImageType type, int32_t minimum_size_px, int32_t desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> observer) {
  GetForwardingInterface()->ObserveImages(
    std::move(type)
    , 
    std::move(minimum_size_px)
    , 
    std::move(desired_size_px)
    , 
    std::move(observer)
    );
}
void MediaControllerInterceptorForTesting::SeekTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->SeekTo(
    std::move(seek_time)
    );
}
void MediaControllerInterceptorForTesting::ScrubTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->ScrubTo(
    std::move(seek_time)
    );
}
void MediaControllerInterceptorForTesting::EnterPictureInPicture() {
  GetForwardingInterface()->EnterPictureInPicture();
}
void MediaControllerInterceptorForTesting::ExitPictureInPicture() {
  GetForwardingInterface()->ExitPictureInPicture();
}
void MediaControllerInterceptorForTesting::SetAudioSinkId(const std::optional<std::string>& id) {
  GetForwardingInterface()->SetAudioSinkId(
    std::move(id)
    );
}
void MediaControllerInterceptorForTesting::ToggleMicrophone() {
  GetForwardingInterface()->ToggleMicrophone();
}
void MediaControllerInterceptorForTesting::ToggleCamera() {
  GetForwardingInterface()->ToggleCamera();
}
void MediaControllerInterceptorForTesting::HangUp() {
  GetForwardingInterface()->HangUp();
}
void MediaControllerInterceptorForTesting::Raise() {
  GetForwardingInterface()->Raise();
}
void MediaControllerInterceptorForTesting::SetMute(bool mute) {
  GetForwardingInterface()->SetMute(
    std::move(mute)
    );
}
void MediaControllerInterceptorForTesting::RequestMediaRemoting() {
  GetForwardingInterface()->RequestMediaRemoting();
}
void MediaControllerInterceptorForTesting::EnterAutoPictureInPicture() {
  GetForwardingInterface()->EnterAutoPictureInPicture();
}
void MediaControllerInterceptorForTesting::SkipAd() {
  GetForwardingInterface()->SkipAd();
}
MediaControllerAsyncWaiter::MediaControllerAsyncWaiter(
    MediaController* proxy) : proxy_(proxy) {}

MediaControllerAsyncWaiter::~MediaControllerAsyncWaiter() = default;





void MediaControllerObserverInterceptorForTesting::MediaSessionInfoChanged(::media_session::mojom::MediaSessionInfoPtr info) {
  GetForwardingInterface()->MediaSessionInfoChanged(
    std::move(info)
    );
}
void MediaControllerObserverInterceptorForTesting::MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) {
  GetForwardingInterface()->MediaSessionMetadataChanged(
    std::move(metadata)
    );
}
void MediaControllerObserverInterceptorForTesting::MediaSessionActionsChanged(const std::vector<::media_session::mojom::MediaSessionAction>& action) {
  GetForwardingInterface()->MediaSessionActionsChanged(
    std::move(action)
    );
}
void MediaControllerObserverInterceptorForTesting::MediaSessionChanged(const std::optional<::base::UnguessableToken>& request_id) {
  GetForwardingInterface()->MediaSessionChanged(
    std::move(request_id)
    );
}
void MediaControllerObserverInterceptorForTesting::MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) {
  GetForwardingInterface()->MediaSessionPositionChanged(
    std::move(position)
    );
}
MediaControllerObserverAsyncWaiter::MediaControllerObserverAsyncWaiter(
    MediaControllerObserver* proxy) : proxy_(proxy) {}

MediaControllerObserverAsyncWaiter::~MediaControllerObserverAsyncWaiter() = default;





void MediaControllerImageObserverInterceptorForTesting::MediaControllerImageChanged(::media_session::mojom::MediaSessionImageType type, const ::SkBitmap& bitmap) {
  GetForwardingInterface()->MediaControllerImageChanged(
    std::move(type)
    , 
    std::move(bitmap)
    );
}
void MediaControllerImageObserverInterceptorForTesting::MediaControllerChapterImageChanged(int32_t index, const ::SkBitmap& bitmap) {
  GetForwardingInterface()->MediaControllerChapterImageChanged(
    std::move(index)
    , 
    std::move(bitmap)
    );
}
MediaControllerImageObserverAsyncWaiter::MediaControllerImageObserverAsyncWaiter(
    MediaControllerImageObserver* proxy) : proxy_(proxy) {}

MediaControllerImageObserverAsyncWaiter::~MediaControllerImageObserverAsyncWaiter() = default;







}  // media_session::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif