// services/media_session/public/mojom/audio_focus.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  MediaSessionRemote as mediaSession_mojom_MediaSessionRemote,
  MediaSessionDebugInfoSpec as mediaSession_mojom_MediaSessionDebugInfoSpec,
  MediaSessionDebugInfo as mediaSession_mojom_MediaSessionDebugInfo,
  MediaSessionInfoSpec as mediaSession_mojom_MediaSessionInfoSpec,
  MediaSessionInfo as mediaSession_mojom_MediaSessionInfo
} from './media_session.mojom-webui.js';
import {
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec,
  UnguessableToken as mojoBase_mojom_UnguessableToken
} from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';





export const EnforcementModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum EnforcementMode {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kDefault = 0,
  kNone = 1,
  kSingleGroup = 2,
  kSingleSession = 3,
}

export const AudioFocusTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AudioFocusType {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kGain = 0,
  kGainTransientMayDuck = 1,
  kGainTransient = 2,
  kAmbient = 3,
}



export type AudioFocusObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AudioFocusObserverPendingReceiver>;

export class AudioFocusObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AudioFocusObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<AudioFocusObserverPendingReceiver>;
  constructor(handle: MojoHandle|AudioFocusObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.AudioFocusObserver',
        scope);
  }
}

export interface AudioFocusObserverInterface {
  onFocusGained(state: AudioFocusRequestState): void;
  onFocusLost(state: AudioFocusRequestState): void;
  onRequestIdReleased(requestId: mojoBase_mojom_UnguessableToken): void;
}

export class AudioFocusObserverRemote implements AudioFocusObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AudioFocusObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AudioFocusObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AudioFocusObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onFocusGained(
      state: AudioFocusRequestState): void {
    this.proxy.sendMessage(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  onFocusLost(
      state: AudioFocusRequestState): void {
    this.proxy.sendMessage(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  onRequestIdReleased(
      requestId: mojoBase_mojom_UnguessableToken): void {
    this.proxy.sendMessage(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusObserverRemote, AudioFocusObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusObserverRemote, AudioFocusObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AudioFocusObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        impl.onFocusGained.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        impl.onFocusLost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        impl.onRequestIdReleased.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusObserver {
  static get $interfaceName(): string {
    return "media_session.mojom.AudioFocusObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AudioFocusObserverRemote {
    let remote = new AudioFocusObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusObserverRemote, AudioFocusObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusObserverRemote, AudioFocusObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onFocusGained: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onFocusLost: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onRequestIdReleased: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onFocusGained =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        this.onFocusGained.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onFocusLost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        this.onFocusLost.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onRequestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        this.onRequestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AudioFocusRequestClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AudioFocusRequestClientPendingReceiver>;

export class AudioFocusRequestClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AudioFocusRequestClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<AudioFocusRequestClientPendingReceiver>;
  constructor(handle: MojoHandle|AudioFocusRequestClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.AudioFocusRequestClient',
        scope);
  }
}

export interface AudioFocusRequestClientInterface {
  requestAudioFocus(sessionInfo: mediaSession_mojom_MediaSessionInfo, type: AudioFocusType): Promise<void>;
  abandonAudioFocus(): void;
  mediaSessionInfoChanged(sessionInfo: mediaSession_mojom_MediaSessionInfo): void;
}

export class AudioFocusRequestClientRemote implements AudioFocusRequestClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AudioFocusRequestClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AudioFocusRequestClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AudioFocusRequestClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusRequestClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  requestAudioFocus(
      sessionInfo: mediaSession_mojom_MediaSessionInfo,
      type: AudioFocusType): Promise<void> {
    return this.proxy.sendMessage(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        [
          sessionInfo,
          type
        ],
        false);
  }

  abandonAudioFocus(): void {
    this.proxy.sendMessage(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  mediaSessionInfoChanged(
      sessionInfo: mediaSession_mojom_MediaSessionInfo): void {
    this.proxy.sendMessage(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          sessionInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusRequestClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusRequestClientRemote, AudioFocusRequestClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusRequestClientRemote, AudioFocusRequestClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AudioFocusRequestClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusRequestClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        impl.abandonAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusRequestClient {
  static get $interfaceName(): string {
    return "media_session.mojom.AudioFocusRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AudioFocusRequestClientRemote {
    let remote = new AudioFocusRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusRequestClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusRequestClientRemote, AudioFocusRequestClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusRequestClientRemote, AudioFocusRequestClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  requestAudioFocus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  abandonAudioFocus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionInfoChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusRequestClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    this.abandonAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        this.abandonAudioFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AudioFocusManagerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AudioFocusManagerPendingReceiver>;

export class AudioFocusManagerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AudioFocusManager> {

  handle: mojo.internal.interfaceSupport.Endpoint<AudioFocusManagerPendingReceiver>;
  constructor(handle: MojoHandle|AudioFocusManagerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.AudioFocusManager',
        scope);
  }
}

export interface AudioFocusManagerInterface {
  requestAudioFocus(client: AudioFocusRequestClientPendingReceiver, session: mediaSession_mojom_MediaSessionRemote, sessionInfo: mediaSession_mojom_MediaSessionInfo, type: AudioFocusType): Promise<{
        requestId: mojoBase_mojom_UnguessableToken, }>;
  requestGroupedAudioFocus(requestId: mojoBase_mojom_UnguessableToken, client: AudioFocusRequestClientPendingReceiver, session: mediaSession_mojom_MediaSessionRemote, sessionInfo: mediaSession_mojom_MediaSessionInfo, type: AudioFocusType, groupId: mojoBase_mojom_UnguessableToken): Promise<{
        success: boolean, }>;
  getFocusRequests(): Promise<{
        requests: AudioFocusRequestState[], }>;
  addObserver(observer: AudioFocusObserverRemote): void;
  setSource(identity: mojoBase_mojom_UnguessableToken, name: string): void;
  setEnforcementMode(mode: EnforcementMode): void;
  addSourceObserver(sourceId: mojoBase_mojom_UnguessableToken, observer: AudioFocusObserverRemote): void;
  getSourceFocusRequests(sourceId: mojoBase_mojom_UnguessableToken): Promise<{
        requests: AudioFocusRequestState[], }>;
  requestIdReleased(requestId: mojoBase_mojom_UnguessableToken): void;
  startDuckingAllAudio(exemptedRequestId: (mojoBase_mojom_UnguessableToken | null)): void;
  stopDuckingAllAudio(): void;
  flushForTesting(): Promise<void>;
}

export class AudioFocusManagerRemote implements AudioFocusManagerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AudioFocusManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AudioFocusManagerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AudioFocusManagerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusManagerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  requestAudioFocus(
      client: AudioFocusRequestClientPendingReceiver,
      session: mediaSession_mojom_MediaSessionRemote,
      sessionInfo: mediaSession_mojom_MediaSessionInfo,
      type: AudioFocusType): Promise<{
        requestId: mojoBase_mojom_UnguessableToken, }> {
    return this.proxy.sendMessage(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        [
          client,
          session,
          sessionInfo,
          type
        ],
        false);
  }

  requestGroupedAudioFocus(
      requestId: mojoBase_mojom_UnguessableToken,
      client: AudioFocusRequestClientPendingReceiver,
      session: mediaSession_mojom_MediaSessionRemote,
      sessionInfo: mediaSession_mojom_MediaSessionInfo,
      type: AudioFocusType,
      groupId: mojoBase_mojom_UnguessableToken): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        [
          requestId,
          client,
          session,
          sessionInfo,
          type,
          groupId
        ],
        false);
  }

  getFocusRequests(): Promise<{
        requests: AudioFocusRequestState[], }> {
    return this.proxy.sendMessage(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  addObserver(
      observer: AudioFocusObserverRemote): void {
    this.proxy.sendMessage(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  setSource(
      identity: mojoBase_mojom_UnguessableToken,
      name: string): void {
    this.proxy.sendMessage(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        [
          identity,
          name
        ],
        false);
  }

  setEnforcementMode(
      mode: EnforcementMode): void {
    this.proxy.sendMessage(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  addSourceObserver(
      sourceId: mojoBase_mojom_UnguessableToken,
      observer: AudioFocusObserverRemote): void {
    this.proxy.sendMessage(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        [
          sourceId,
          observer
        ],
        false);
  }

  getSourceFocusRequests(
      sourceId: mojoBase_mojom_UnguessableToken): Promise<{
        requests: AudioFocusRequestState[], }> {
    return this.proxy.sendMessage(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        [
          sourceId
        ],
        false);
  }

  requestIdReleased(
      requestId: mojoBase_mojom_UnguessableToken): void {
    this.proxy.sendMessage(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  startDuckingAllAudio(
      exemptedRequestId: (mojoBase_mojom_UnguessableToken | null)): void {
    this.proxy.sendMessage(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        [
          exemptedRequestId
        ],
        false);
  }

  stopDuckingAllAudio(): void {
    this.proxy.sendMessage(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  flushForTesting(): Promise<void> {
    return this.proxy.sendMessage(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusManagerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusManagerRemote, AudioFocusManagerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusManagerRemote, AudioFocusManagerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AudioFocusManagerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        impl.requestGroupedAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        impl.getFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        impl.setSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        impl.setEnforcementMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        impl.addSourceObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        impl.getSourceFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        impl.requestIdReleased.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        impl.startDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        impl.stopDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        impl.flushForTesting.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusManager {
  static get $interfaceName(): string {
    return "media_session.mojom.AudioFocusManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AudioFocusManagerRemote {
    let remote = new AudioFocusManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusManagerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusManagerRemote, AudioFocusManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusManagerRemote, AudioFocusManagerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  requestAudioFocus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestGroupedAudioFocus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getFocusRequests: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSource: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setEnforcementMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addSourceObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSourceFocusRequests: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestIdReleased: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startDuckingAllAudio: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopDuckingAllAudio: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  flushForTesting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestGroupedAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        this.requestGroupedAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        this.getFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        this.setSource.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setEnforcementMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        this.setEnforcementMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addSourceObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        this.addSourceObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getSourceFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        this.getSourceFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        this.requestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    this.startDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        this.startDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stopDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        this.stopDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    this.flushForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        this.flushForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AudioFocusManagerDebugPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AudioFocusManagerDebugPendingReceiver>;

export class AudioFocusManagerDebugPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AudioFocusManagerDebug> {

  handle: mojo.internal.interfaceSupport.Endpoint<AudioFocusManagerDebugPendingReceiver>;
  constructor(handle: MojoHandle|AudioFocusManagerDebugPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.AudioFocusManagerDebug',
        scope);
  }
}

export interface AudioFocusManagerDebugInterface {
  getDebugInfoForRequest(requestId: mojoBase_mojom_UnguessableToken): Promise<{
        debugInfo: mediaSession_mojom_MediaSessionDebugInfo, }>;
}

export class AudioFocusManagerDebugRemote implements AudioFocusManagerDebugInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AudioFocusManagerDebugPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AudioFocusManagerDebugPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AudioFocusManagerDebugPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusManagerDebugPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDebugInfoForRequest(
      requestId: mojoBase_mojom_UnguessableToken): Promise<{
        debugInfo: mediaSession_mojom_MediaSessionDebugInfo, }> {
    return this.proxy.sendMessage(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        [
          requestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusManagerDebugReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusManagerDebugRemote, AudioFocusManagerDebugPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusManagerDebugRemote, AudioFocusManagerDebugPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AudioFocusManagerDebugInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusManagerDebugRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        impl.getDebugInfoForRequest.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusManagerDebug {
  static get $interfaceName(): string {
    return "media_session.mojom.AudioFocusManagerDebug";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AudioFocusManagerDebugRemote {
    let remote = new AudioFocusManagerDebugRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusManagerDebugCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AudioFocusManagerDebugRemote, AudioFocusManagerDebugPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AudioFocusManagerDebugRemote, AudioFocusManagerDebugPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDebugInfoForRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusManagerDebugRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDebugInfoForRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        this.getDebugInfoForRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AudioFocusRequestStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusObserver_OnFocusGained_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusObserver_OnFocusLost_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusObserver_OnRequestIdReleased_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusRequestClient_RequestAudioFocus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_RequestAudioFocus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_RequestAudioFocus_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_GetFocusRequests_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_GetFocusRequests_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_AddObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_SetSource_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_SetEnforcementMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_AddSourceObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_GetSourceFocusRequests_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_RequestIdReleased_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_StartDuckingAllAudio_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_StopDuckingAllAudio_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_FlushForTesting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManager_FlushForTesting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AudioFocusRequestStateMojoType {
  sessionInfo: mediaSession_mojom_MediaSessionInfo;
  audioFocusType: AudioFocusType;
  sourceName: (string | null);
  requestId: (mojoBase_mojom_UnguessableToken | null);
  sourceId: (mojoBase_mojom_UnguessableToken | null);
}


export type AudioFocusRequestState = AudioFocusRequestStateMojoType;
mojo.internal.Struct<AudioFocusRequestStateMojoType>(
    AudioFocusRequestStateSpec.$,
    'AudioFocusRequestState',
    [
      mojo.internal.StructField<AudioFocusRequestStateMojoType, mediaSession_mojom_MediaSessionInfo>(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusRequestStateMojoType, AudioFocusType>(
        'audioFocusType', 8,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusRequestStateMojoType, string>(
        'sourceName', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        2,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusRequestStateMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        3,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusRequestStateMojoType, mojoBase_mojom_UnguessableToken>(
        'sourceId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        9,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],[2, 32],[3, 40],[9, 48],]);





export interface AudioFocusObserver_OnFocusGained_ParamsMojoType {
  state: AudioFocusRequestState;
}


export type AudioFocusObserver_OnFocusGained_Params = AudioFocusObserver_OnFocusGained_ParamsMojoType;
mojo.internal.Struct<AudioFocusObserver_OnFocusGained_ParamsMojoType>(
    AudioFocusObserver_OnFocusGained_ParamsSpec.$,
    'AudioFocusObserver_OnFocusGained_Params',
    [
      mojo.internal.StructField<AudioFocusObserver_OnFocusGained_ParamsMojoType, AudioFocusRequestState>(
        'state', 0,
        0,
        AudioFocusRequestStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusObserver_OnFocusLost_ParamsMojoType {
  state: AudioFocusRequestState;
}


export type AudioFocusObserver_OnFocusLost_Params = AudioFocusObserver_OnFocusLost_ParamsMojoType;
mojo.internal.Struct<AudioFocusObserver_OnFocusLost_ParamsMojoType>(
    AudioFocusObserver_OnFocusLost_ParamsSpec.$,
    'AudioFocusObserver_OnFocusLost_Params',
    [
      mojo.internal.StructField<AudioFocusObserver_OnFocusLost_ParamsMojoType, AudioFocusRequestState>(
        'state', 0,
        0,
        AudioFocusRequestStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusObserver_OnRequestIdReleased_ParamsMojoType {
  requestId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusObserver_OnRequestIdReleased_Params = AudioFocusObserver_OnRequestIdReleased_ParamsMojoType;
mojo.internal.Struct<AudioFocusObserver_OnRequestIdReleased_ParamsMojoType>(
    AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
    'AudioFocusObserver_OnRequestIdReleased_Params',
    [
      mojo.internal.StructField<AudioFocusObserver_OnRequestIdReleased_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusRequestClient_RequestAudioFocus_ParamsMojoType {
  sessionInfo: mediaSession_mojom_MediaSessionInfo;
  type: AudioFocusType;
}


export type AudioFocusRequestClient_RequestAudioFocus_Params = AudioFocusRequestClient_RequestAudioFocus_ParamsMojoType;
mojo.internal.Struct<AudioFocusRequestClient_RequestAudioFocus_ParamsMojoType>(
    AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_Params',
    [
      mojo.internal.StructField<AudioFocusRequestClient_RequestAudioFocus_ParamsMojoType, mediaSession_mojom_MediaSessionInfo>(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusRequestClient_RequestAudioFocus_ParamsMojoType, AudioFocusType>(
        'type', 8,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AudioFocusRequestClient_RequestAudioFocus_ResponseParamsMojoType {
}


export type AudioFocusRequestClient_RequestAudioFocus_ResponseParams = AudioFocusRequestClient_RequestAudioFocus_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusRequestClient_RequestAudioFocus_ResponseParamsMojoType>(
    AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface AudioFocusRequestClient_AbandonAudioFocus_ParamsMojoType {
}


export type AudioFocusRequestClient_AbandonAudioFocus_Params = AudioFocusRequestClient_AbandonAudioFocus_ParamsMojoType;
mojo.internal.Struct<AudioFocusRequestClient_AbandonAudioFocus_ParamsMojoType>(
    AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_AbandonAudioFocus_Params',
    [
    ],
    [[0, 8],]);





export interface AudioFocusRequestClient_MediaSessionInfoChanged_ParamsMojoType {
  sessionInfo: mediaSession_mojom_MediaSessionInfo;
}


export type AudioFocusRequestClient_MediaSessionInfoChanged_Params = AudioFocusRequestClient_MediaSessionInfoChanged_ParamsMojoType;
mojo.internal.Struct<AudioFocusRequestClient_MediaSessionInfoChanged_ParamsMojoType>(
    AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
    'AudioFocusRequestClient_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField<AudioFocusRequestClient_MediaSessionInfoChanged_ParamsMojoType, mediaSession_mojom_MediaSessionInfo>(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_RequestAudioFocus_ParamsMojoType {
  client: AudioFocusRequestClientPendingReceiver;
  session: mediaSession_mojom_MediaSessionRemote;
  type: AudioFocusType;
  sessionInfo: mediaSession_mojom_MediaSessionInfo;
}


export type AudioFocusManager_RequestAudioFocus_Params = AudioFocusManager_RequestAudioFocus_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_RequestAudioFocus_ParamsMojoType>(
    AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_Params',
    [
      mojo.internal.StructField<AudioFocusManager_RequestAudioFocus_ParamsMojoType, AudioFocusRequestClientPendingReceiver>(
        'client', 0,
        0,
        mojo.internal.InterfaceRequest(AudioFocusRequestClientPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestAudioFocus_ParamsMojoType, mediaSession_mojom_MediaSessionRemote>(
        'session', 4,
        0,
        mojo.internal.InterfaceProxy(mediaSession_mojom_MediaSessionRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestAudioFocus_ParamsMojoType, mediaSession_mojom_MediaSessionInfo>(
        'sessionInfo', 16,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestAudioFocus_ParamsMojoType, AudioFocusType>(
        'type', 12,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface AudioFocusManager_RequestAudioFocus_ResponseParamsMojoType {
  requestId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusManager_RequestAudioFocus_ResponseParams = AudioFocusManager_RequestAudioFocus_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManager_RequestAudioFocus_ResponseParamsMojoType>(
    AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_ResponseParams',
    [
      mojo.internal.StructField<AudioFocusManager_RequestAudioFocus_ResponseParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType {
  requestId: mojoBase_mojom_UnguessableToken;
  client: AudioFocusRequestClientPendingReceiver;
  session: mediaSession_mojom_MediaSessionRemote;
  type: AudioFocusType;
  sessionInfo: mediaSession_mojom_MediaSessionInfo;
  groupId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusManager_RequestGroupedAudioFocus_Params = AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType>(
    AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_Params',
    [
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, AudioFocusRequestClientPendingReceiver>(
        'client', 8,
        0,
        mojo.internal.InterfaceRequest(AudioFocusRequestClientPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, mediaSession_mojom_MediaSessionRemote>(
        'session', 12,
        0,
        mojo.internal.InterfaceProxy(mediaSession_mojom_MediaSessionRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, mediaSession_mojom_MediaSessionInfo>(
        'sessionInfo', 24,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, AudioFocusType>(
        'type', 20,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'groupId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsMojoType {
  success: boolean;
}


export type AudioFocusManager_RequestGroupedAudioFocus_ResponseParams = AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsMojoType>(
    AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_ResponseParams',
    [
      mojo.internal.StructField<AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_GetFocusRequests_ParamsMojoType {
}


export type AudioFocusManager_GetFocusRequests_Params = AudioFocusManager_GetFocusRequests_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_GetFocusRequests_ParamsMojoType>(
    AudioFocusManager_GetFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_Params',
    [
    ],
    [[0, 8],]);





export interface AudioFocusManager_GetFocusRequests_ResponseParamsMojoType {
  requests: AudioFocusRequestState[];
}


export type AudioFocusManager_GetFocusRequests_ResponseParams = AudioFocusManager_GetFocusRequests_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManager_GetFocusRequests_ResponseParamsMojoType>(
    AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_ResponseParams',
    [
      mojo.internal.StructField<AudioFocusManager_GetFocusRequests_ResponseParamsMojoType, AudioFocusRequestState[]>(
        'requests', 0,
        0,
        mojo.internal.Array(AudioFocusRequestStateSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_AddObserver_ParamsMojoType {
  observer: AudioFocusObserverRemote;
}


export type AudioFocusManager_AddObserver_Params = AudioFocusManager_AddObserver_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_AddObserver_ParamsMojoType>(
    AudioFocusManager_AddObserver_ParamsSpec.$,
    'AudioFocusManager_AddObserver_Params',
    [
      mojo.internal.StructField<AudioFocusManager_AddObserver_ParamsMojoType, AudioFocusObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(AudioFocusObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_SetSource_ParamsMojoType {
  identity: mojoBase_mojom_UnguessableToken;
  name: string;
}


export type AudioFocusManager_SetSource_Params = AudioFocusManager_SetSource_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_SetSource_ParamsMojoType>(
    AudioFocusManager_SetSource_ParamsSpec.$,
    'AudioFocusManager_SetSource_Params',
    [
      mojo.internal.StructField<AudioFocusManager_SetSource_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'identity', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_SetSource_ParamsMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AudioFocusManager_SetEnforcementMode_ParamsMojoType {
  mode: EnforcementMode;
}


export type AudioFocusManager_SetEnforcementMode_Params = AudioFocusManager_SetEnforcementMode_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_SetEnforcementMode_ParamsMojoType>(
    AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
    'AudioFocusManager_SetEnforcementMode_Params',
    [
      mojo.internal.StructField<AudioFocusManager_SetEnforcementMode_ParamsMojoType, EnforcementMode>(
        'mode', 0,
        0,
        EnforcementModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_AddSourceObserver_ParamsMojoType {
  sourceId: mojoBase_mojom_UnguessableToken;
  observer: AudioFocusObserverRemote;
}


export type AudioFocusManager_AddSourceObserver_Params = AudioFocusManager_AddSourceObserver_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_AddSourceObserver_ParamsMojoType>(
    AudioFocusManager_AddSourceObserver_ParamsSpec.$,
    'AudioFocusManager_AddSourceObserver_Params',
    [
      mojo.internal.StructField<AudioFocusManager_AddSourceObserver_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'sourceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AudioFocusManager_AddSourceObserver_ParamsMojoType, AudioFocusObserverRemote>(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(AudioFocusObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AudioFocusManager_GetSourceFocusRequests_ParamsMojoType {
  sourceId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusManager_GetSourceFocusRequests_Params = AudioFocusManager_GetSourceFocusRequests_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_GetSourceFocusRequests_ParamsMojoType>(
    AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_Params',
    [
      mojo.internal.StructField<AudioFocusManager_GetSourceFocusRequests_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'sourceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_GetSourceFocusRequests_ResponseParamsMojoType {
  requests: AudioFocusRequestState[];
}


export type AudioFocusManager_GetSourceFocusRequests_ResponseParams = AudioFocusManager_GetSourceFocusRequests_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManager_GetSourceFocusRequests_ResponseParamsMojoType>(
    AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_ResponseParams',
    [
      mojo.internal.StructField<AudioFocusManager_GetSourceFocusRequests_ResponseParamsMojoType, AudioFocusRequestState[]>(
        'requests', 0,
        0,
        mojo.internal.Array(AudioFocusRequestStateSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_RequestIdReleased_ParamsMojoType {
  requestId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusManager_RequestIdReleased_Params = AudioFocusManager_RequestIdReleased_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_RequestIdReleased_ParamsMojoType>(
    AudioFocusManager_RequestIdReleased_ParamsSpec.$,
    'AudioFocusManager_RequestIdReleased_Params',
    [
      mojo.internal.StructField<AudioFocusManager_RequestIdReleased_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_StartDuckingAllAudio_ParamsMojoType {
  exemptedRequestId: (mojoBase_mojom_UnguessableToken | null);
}


export type AudioFocusManager_StartDuckingAllAudio_Params = AudioFocusManager_StartDuckingAllAudio_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_StartDuckingAllAudio_ParamsMojoType>(
    AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StartDuckingAllAudio_Params',
    [
      mojo.internal.StructField<AudioFocusManager_StartDuckingAllAudio_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'exemptedRequestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManager_StopDuckingAllAudio_ParamsMojoType {
}


export type AudioFocusManager_StopDuckingAllAudio_Params = AudioFocusManager_StopDuckingAllAudio_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_StopDuckingAllAudio_ParamsMojoType>(
    AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StopDuckingAllAudio_Params',
    [
    ],
    [[0, 8],]);





export interface AudioFocusManager_FlushForTesting_ParamsMojoType {
}


export type AudioFocusManager_FlushForTesting_Params = AudioFocusManager_FlushForTesting_ParamsMojoType;
mojo.internal.Struct<AudioFocusManager_FlushForTesting_ParamsMojoType>(
    AudioFocusManager_FlushForTesting_ParamsSpec.$,
    'AudioFocusManager_FlushForTesting_Params',
    [
    ],
    [[0, 8],]);





export interface AudioFocusManager_FlushForTesting_ResponseParamsMojoType {
}


export type AudioFocusManager_FlushForTesting_ResponseParams = AudioFocusManager_FlushForTesting_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManager_FlushForTesting_ResponseParamsMojoType>(
    AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
    'AudioFocusManager_FlushForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsMojoType {
  requestId: mojoBase_mojom_UnguessableToken;
}


export type AudioFocusManagerDebug_GetDebugInfoForRequest_Params = AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsMojoType;
mojo.internal.Struct<AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsMojoType>(
    AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_Params',
    [
      mojo.internal.StructField<AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsMojoType {
  debugInfo: mediaSession_mojom_MediaSessionDebugInfo;
}


export type AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams = AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsMojoType;
mojo.internal.Struct<AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsMojoType>(
    AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams',
    [
      mojo.internal.StructField<AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsMojoType, mediaSession_mojom_MediaSessionDebugInfo>(
        'debugInfo', 0,
        0,
        mediaSession_mojom_MediaSessionDebugInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



