// services/device/public/mojom/usb_device.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec,
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer
} from '//resources/mojo/mojo/public/mojom/base/read_only_buffer.mojom-webui.js';
import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const USB_AUDIO_CLASS: number = 0x01;


export const USB_COMM_CLASS: number = 0x02;


export const USB_HID_CLASS: number = 0x03;


export const USB_MASS_STORAGE_CLASS: number = 0x08;


export const USB_SMART_CARD_CLASS: number = 0x0B;


export const USB_VIDEO_CLASS: number = 0x0E;


export const USB_AUDIO_VIDEO_CLASS: number = 0x10;


export const USB_WIRELESS_CLASS: number = 0xE0;


export const UsbOpenDeviceSuccessSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbOpenDeviceSuccess {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  OK = 0,
}

export const UsbOpenDeviceErrorSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbOpenDeviceError {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  ACCESS_DENIED = 0,
  ALREADY_OPEN = 1,
}

export const UsbClaimInterfaceResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbClaimInterfaceResult {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kSuccess = 0,
  kProtectedClass = 1,
  kFailure = 2,
}

export const UsbTransferDirectionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbTransferDirection {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  INBOUND = 0,
  OUTBOUND = 1,
}

export const UsbControlTransferTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbControlTransferType {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  STANDARD = 0,
  CLASS = 1,
  VENDOR = 2,
  RESERVED = 3,
}

export const UsbControlTransferRecipientSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbControlTransferRecipient {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  DEVICE = 0,
  INTERFACE = 1,
  ENDPOINT = 2,
  OTHER = 3,
}

export const UsbTransferTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbTransferType {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  CONTROL = 0,
  ISOCHRONOUS = 1,
  BULK = 2,
  INTERRUPT = 3,
}

export const UsbSynchronizationTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbSynchronizationType {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  NONE = 0,
  ASYNCHRONOUS = 1,
  ADAPTIVE = 2,
  SYNCHRONOUS = 3,
}

export const UsbUsageTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbUsageType {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  DATA = 0,
  FEEDBACK = 1,
  EXPLICIT_FEEDBACK = 2,
  PERIODIC = 3,
  NOTIFICATION = 4,
  RESERVED = 5,
}

export const UsbTransferStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UsbTransferStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 8,
  COMPLETED = 0,
  TRANSFER_ERROR = 1,
  TIMEOUT = 2,
  CANCELLED = 3,
  STALLED = 4,
  DISCONNECT = 5,
  BABBLE = 6,
  SHORT_PACKET = 7,
  PERMISSION_DENIED = 8,
}



export type UsbDevicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UsbDevicePendingReceiver>;

export class UsbDevicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UsbDevice> {

  handle: mojo.internal.interfaceSupport.Endpoint<UsbDevicePendingReceiver>;
  constructor(handle: MojoHandle|UsbDevicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.UsbDevice',
        scope);
  }
}

export interface UsbDeviceInterface {
  open(): Promise<{
        result: UsbOpenDeviceResult, }>;
  close(): Promise<void>;
  setConfiguration(value: number): Promise<{
        success: boolean, }>;
  claimInterface(interfaceNumber: number): Promise<{
        result: UsbClaimInterfaceResult, }>;
  releaseInterface(interfaceNumber: number): Promise<{
        success: boolean, }>;
  setInterfaceAlternateSetting(interfaceNumber: number, alternateSetting: number): Promise<{
        success: boolean, }>;
  reset(): Promise<{
        success: boolean, }>;
  clearHalt(direction: UsbTransferDirection, endpointNumber: number): Promise<{
        success: boolean, }>;
  controlTransferIn(params: UsbControlTransferParams, length: number, timeout: number): Promise<{
        status: UsbTransferStatus,
        data: mojoBase_mojom_ReadOnlyBuffer, }>;
  controlTransferOut(params: UsbControlTransferParams, data: mojoBase_mojom_ReadOnlyBuffer, timeout: number): Promise<{
        status: UsbTransferStatus, }>;
  genericTransferIn(endpointNumber: number, length: number, timeout: number): Promise<{
        status: UsbTransferStatus,
        data: mojoBase_mojom_ReadOnlyBuffer, }>;
  genericTransferOut(endpointNumber: number, data: mojoBase_mojom_ReadOnlyBuffer, timeout: number): Promise<{
        status: UsbTransferStatus, }>;
  isochronousTransferIn(endpointNumber: number, packetLengths: number[], timeout: number): Promise<{
        data: mojoBase_mojom_ReadOnlyBuffer,
        packets: UsbIsochronousPacket[], }>;
  isochronousTransferOut(endpointNumber: number, data: mojoBase_mojom_ReadOnlyBuffer, packetLengths: number[], timeout: number): Promise<{
        packets: UsbIsochronousPacket[], }>;
}

export class UsbDeviceRemote implements UsbDeviceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UsbDevicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDevicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UsbDevicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDevicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  open(): Promise<{
        result: UsbOpenDeviceResult, }> {
    return this.proxy.sendMessage(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  close(): Promise<void> {
    return this.proxy.sendMessage(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setConfiguration(
      value: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  claimInterface(
      interfaceNumber: number): Promise<{
        result: UsbClaimInterfaceResult, }> {
    return this.proxy.sendMessage(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ],
        false);
  }

  releaseInterface(
      interfaceNumber: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ],
        false);
  }

  setInterfaceAlternateSetting(
      interfaceNumber: number,
      alternateSetting: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        [
          interfaceNumber,
          alternateSetting
        ],
        false);
  }

  reset(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  clearHalt(
      direction: UsbTransferDirection,
      endpointNumber: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        [
          direction,
          endpointNumber
        ],
        false);
  }

  controlTransferIn(
      params: UsbControlTransferParams,
      length: number,
      timeout: number): Promise<{
        status: UsbTransferStatus,
        data: mojoBase_mojom_ReadOnlyBuffer, }> {
    return this.proxy.sendMessage(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        [
          params,
          length,
          timeout
        ],
        false);
  }

  controlTransferOut(
      params: UsbControlTransferParams,
      data: mojoBase_mojom_ReadOnlyBuffer,
      timeout: number): Promise<{
        status: UsbTransferStatus, }> {
    return this.proxy.sendMessage(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        [
          params,
          data,
          timeout
        ],
        false);
  }

  genericTransferIn(
      endpointNumber: number,
      length: number,
      timeout: number): Promise<{
        status: UsbTransferStatus,
        data: mojoBase_mojom_ReadOnlyBuffer, }> {
    return this.proxy.sendMessage(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          length,
          timeout
        ],
        false);
  }

  genericTransferOut(
      endpointNumber: number,
      data: mojoBase_mojom_ReadOnlyBuffer,
      timeout: number): Promise<{
        status: UsbTransferStatus, }> {
    return this.proxy.sendMessage(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          timeout
        ],
        false);
  }

  isochronousTransferIn(
      endpointNumber: number,
      packetLengths: number[],
      timeout: number): Promise<{
        data: mojoBase_mojom_ReadOnlyBuffer,
        packets: UsbIsochronousPacket[], }> {
    return this.proxy.sendMessage(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          packetLengths,
          timeout
        ],
        false);
  }

  isochronousTransferOut(
      endpointNumber: number,
      data: mojoBase_mojom_ReadOnlyBuffer,
      packetLengths: number[],
      timeout: number): Promise<{
        packets: UsbIsochronousPacket[], }> {
    return this.proxy.sendMessage(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          packetLengths,
          timeout
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDevice
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceRemote, UsbDevicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceRemote, UsbDevicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UsbDeviceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        impl.setConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        impl.claimInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        impl.releaseInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        impl.setInterfaceAlternateSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        impl.clearHalt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        impl.controlTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        impl.controlTransferOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        impl.genericTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        impl.genericTransferOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        impl.isochronousTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        impl.isochronousTransferOut.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDevice {
  static get $interfaceName(): string {
    return "device.mojom.UsbDevice";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UsbDeviceRemote {
    let remote = new UsbDeviceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UsbDevice
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceRemote, UsbDevicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceRemote, UsbDevicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  open: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  close: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setConfiguration: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  claimInterface: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  releaseInterface: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setInterfaceAlternateSetting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  reset: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearHalt: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  controlTransferIn: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  controlTransferOut: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  genericTransferIn: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  genericTransferOut: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isochronousTransferIn: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isochronousTransferOut: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        false);
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        this.setConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    this.claimInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        this.claimInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    this.releaseInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        this.releaseInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setInterfaceAlternateSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        this.setInterfaceAlternateSetting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearHalt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        this.clearHalt.createReceiverHandler(true /* expectsResponse */),
        false);
    this.controlTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        this.controlTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    this.controlTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        this.controlTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    this.genericTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        this.genericTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    this.genericTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        this.genericTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isochronousTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        this.isochronousTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isochronousTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        this.isochronousTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type UsbDeviceClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UsbDeviceClientPendingReceiver>;

export class UsbDeviceClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UsbDeviceClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<UsbDeviceClientPendingReceiver>;
  constructor(handle: MojoHandle|UsbDeviceClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.UsbDeviceClient',
        scope);
  }
}

export interface UsbDeviceClientInterface {
  onDeviceOpened(): void;
  onDeviceClosed(): void;
}

export class UsbDeviceClientRemote implements UsbDeviceClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UsbDeviceClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDeviceClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UsbDeviceClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onDeviceOpened(): void {
    this.proxy.sendMessage(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onDeviceClosed(): void {
    this.proxy.sendMessage(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceClientRemote, UsbDeviceClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceClientRemote, UsbDeviceClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UsbDeviceClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        impl.onDeviceOpened.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        impl.onDeviceClosed.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceClient {
  static get $interfaceName(): string {
    return "device.mojom.UsbDeviceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UsbDeviceClientRemote {
    let remote = new UsbDeviceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceClientRemote, UsbDeviceClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceClientRemote, UsbDeviceClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onDeviceOpened: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDeviceClosed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onDeviceOpened =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        this.onDeviceOpened.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDeviceClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        this.onDeviceClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const UsbEndpointInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbAlternateInterfaceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbInterfaceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbConfigurationInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbControlTransferParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbIsochronousPacketSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Open_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Open_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Close_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Close_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_SetConfiguration_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_SetConfiguration_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ClaimInterface_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ClaimInterface_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ReleaseInterface_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ReleaseInterface_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_SetInterfaceAlternateSetting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Reset_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_Reset_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ClearHalt_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ClearHalt_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ControlTransferIn_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ControlTransferIn_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ControlTransferOut_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_ControlTransferOut_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_GenericTransferIn_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_GenericTransferIn_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_GenericTransferOut_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_GenericTransferOut_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_IsochronousTransferIn_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_IsochronousTransferIn_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_IsochronousTransferOut_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDevice_IsochronousTransferOut_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceClient_OnDeviceOpened_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceClient_OnDeviceClosed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbOpenDeviceResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface UsbEndpointInfoMojoType {
  endpointNumber: number;
  pollingInterval: number;
  direction: UsbTransferDirection;
  type: UsbTransferType;
  packetSize: number;
  synchronizationType: UsbSynchronizationType;
  usageType: UsbUsageType;
  extraData: number[];
}


export type UsbEndpointInfo = UsbEndpointInfoMojoType;
mojo.internal.Struct<UsbEndpointInfoMojoType>(
    UsbEndpointInfoSpec.$,
    'UsbEndpointInfo',
    [
      mojo.internal.StructField<UsbEndpointInfoMojoType, number>(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, UsbTransferDirection>(
        'direction', 4,
        0,
        UsbTransferDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, UsbTransferType>(
        'type', 8,
        0,
        UsbTransferTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, number>(
        'packetSize', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, UsbSynchronizationType>(
        'synchronizationType', 16,
        0,
        UsbSynchronizationTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, UsbUsageType>(
        'usageType', 20,
        0,
        UsbUsageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, number>(
        'pollingInterval', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbEndpointInfoMojoType, number[]>(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface UsbAlternateInterfaceInfoMojoType {
  alternateSetting: number;
  classCode: number;
  subclassCode: number;
  protocolCode: number;
  interfaceName: (mojoBase_mojom_String16 | null);
  endpoints: UsbEndpointInfo[];
  extraData: number[];
}


export type UsbAlternateInterfaceInfo = UsbAlternateInterfaceInfoMojoType;
mojo.internal.Struct<UsbAlternateInterfaceInfoMojoType>(
    UsbAlternateInterfaceInfoSpec.$,
    'UsbAlternateInterfaceInfo',
    [
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, number>(
        'alternateSetting', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, number>(
        'classCode', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, number>(
        'subclassCode', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, number>(
        'protocolCode', 3,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, mojoBase_mojom_String16>(
        'interfaceName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, UsbEndpointInfo[]>(
        'endpoints', 16,
        0,
        mojo.internal.Array(UsbEndpointInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbAlternateInterfaceInfoMojoType, number[]>(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface UsbInterfaceInfoMojoType {
  interfaceNumber: number;
  firstInterface: number;
  alternates: UsbAlternateInterfaceInfo[];
}


export type UsbInterfaceInfo = UsbInterfaceInfoMojoType;
mojo.internal.Struct<UsbInterfaceInfoMojoType>(
    UsbInterfaceInfoSpec.$,
    'UsbInterfaceInfo',
    [
      mojo.internal.StructField<UsbInterfaceInfoMojoType, number>(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbInterfaceInfoMojoType, number>(
        'firstInterface', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbInterfaceInfoMojoType, UsbAlternateInterfaceInfo[]>(
        'alternates', 8,
        0,
        mojo.internal.Array(UsbAlternateInterfaceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbConfigurationInfoMojoType {
  configurationValue: number;
  selfPowered: boolean;
  remoteWakeup: boolean;
  maximumPower: number;
  configurationName: (mojoBase_mojom_String16 | null);
  interfaces: UsbInterfaceInfo[];
  extraData: number[];
}


export type UsbConfigurationInfo = UsbConfigurationInfoMojoType;
mojo.internal.Struct<UsbConfigurationInfoMojoType>(
    UsbConfigurationInfoSpec.$,
    'UsbConfigurationInfo',
    [
      mojo.internal.StructField<UsbConfigurationInfoMojoType, number>(
        'configurationValue', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, mojoBase_mojom_String16>(
        'configurationName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, boolean>(
        'selfPowered', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, boolean>(
        'remoteWakeup', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, number>(
        'maximumPower', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, UsbInterfaceInfo[]>(
        'interfaces', 16,
        0,
        mojo.internal.Array(UsbInterfaceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbConfigurationInfoMojoType, number[]>(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface UsbDeviceInfoMojoType {
  guid: string;
  usbVersionMajor: number;
  usbVersionMinor: number;
  usbVersionSubminor: number;
  classCode: number;
  subclassCode: number;
  protocolCode: number;
  vendorId: number;
  busNumber: number;
  portNumber: number;
  productId: number;
  deviceVersionMajor: number;
  deviceVersionMinor: number;
  deviceVersionSubminor: number;
  activeConfiguration: number;
  manufacturerName: (mojoBase_mojom_String16 | null);
  productName: (mojoBase_mojom_String16 | null);
  serialNumber: (mojoBase_mojom_String16 | null);
  webusbLandingPage: (url_mojom_Url | null);
  configurations: UsbConfigurationInfo[];
}


export type UsbDeviceInfo = UsbDeviceInfoMojoType;
mojo.internal.Struct<UsbDeviceInfoMojoType>(
    UsbDeviceInfoSpec.$,
    'UsbDeviceInfo',
    [
      mojo.internal.StructField<UsbDeviceInfoMojoType, string>(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'usbVersionMajor', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'usbVersionMinor', 9,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'usbVersionSubminor', 10,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'classCode', 11,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'subclassCode', 12,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'protocolCode', 13,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'busNumber', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'portNumber', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'vendorId', 14,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'productId', 24,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'deviceVersionMajor', 26,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'deviceVersionMinor', 27,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'deviceVersionSubminor', 28,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, mojoBase_mojom_String16>(
        'manufacturerName', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, mojoBase_mojom_String16>(
        'productName', 40,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, mojoBase_mojom_String16>(
        'serialNumber', 48,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, url_mojom_Url>(
        'webusbLandingPage', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, number>(
        'activeConfiguration', 29,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceInfoMojoType, UsbConfigurationInfo[]>(
        'configurations', 64,
        0,
        mojo.internal.Array(UsbConfigurationInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);



export const UsbControlTransferParams_SECURITY_KEY_AOA_MODEL: string =
    "12eba9f901039b36";



export interface UsbControlTransferParamsMojoType {
  type: UsbControlTransferType;
  recipient: UsbControlTransferRecipient;
  request: number;
  value: number;
  index: number;
}


export type UsbControlTransferParams = UsbControlTransferParamsMojoType;
mojo.internal.Struct<UsbControlTransferParamsMojoType>(
    UsbControlTransferParamsSpec.$,
    'UsbControlTransferParams',
    [
      mojo.internal.StructField<UsbControlTransferParamsMojoType, UsbControlTransferType>(
        'type', 0,
        0,
        UsbControlTransferTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbControlTransferParamsMojoType, UsbControlTransferRecipient>(
        'recipient', 4,
        0,
        UsbControlTransferRecipientSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbControlTransferParamsMojoType, number>(
        'request', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbControlTransferParamsMojoType, number>(
        'value', 10,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbControlTransferParamsMojoType, number>(
        'index', 12,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbIsochronousPacketMojoType {
  length: number;
  transferredLength: number;
  status: UsbTransferStatus;
}


export type UsbIsochronousPacket = UsbIsochronousPacketMojoType;
mojo.internal.Struct<UsbIsochronousPacketMojoType>(
    UsbIsochronousPacketSpec.$,
    'UsbIsochronousPacket',
    [
      mojo.internal.StructField<UsbIsochronousPacketMojoType, number>(
        'length', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbIsochronousPacketMojoType, number>(
        'transferredLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbIsochronousPacketMojoType, UsbTransferStatus>(
        'status', 8,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_Open_ParamsMojoType {
}


export type UsbDevice_Open_Params = UsbDevice_Open_ParamsMojoType;
mojo.internal.Struct<UsbDevice_Open_ParamsMojoType>(
    UsbDevice_Open_ParamsSpec.$,
    'UsbDevice_Open_Params',
    [
    ],
    [[0, 8],]);





export interface UsbDevice_Open_ResponseParamsMojoType {
  result: UsbOpenDeviceResult;
}


export type UsbDevice_Open_ResponseParams = UsbDevice_Open_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_Open_ResponseParamsMojoType>(
    UsbDevice_Open_ResponseParamsSpec.$,
    'UsbDevice_Open_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_Open_ResponseParamsMojoType, UsbOpenDeviceResult>(
        'result', 0,
        0,
        UsbOpenDeviceResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_Close_ParamsMojoType {
}


export type UsbDevice_Close_Params = UsbDevice_Close_ParamsMojoType;
mojo.internal.Struct<UsbDevice_Close_ParamsMojoType>(
    UsbDevice_Close_ParamsSpec.$,
    'UsbDevice_Close_Params',
    [
    ],
    [[0, 8],]);





export interface UsbDevice_Close_ResponseParamsMojoType {
}


export type UsbDevice_Close_ResponseParams = UsbDevice_Close_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_Close_ResponseParamsMojoType>(
    UsbDevice_Close_ResponseParamsSpec.$,
    'UsbDevice_Close_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface UsbDevice_SetConfiguration_ParamsMojoType {
  value: number;
}


export type UsbDevice_SetConfiguration_Params = UsbDevice_SetConfiguration_ParamsMojoType;
mojo.internal.Struct<UsbDevice_SetConfiguration_ParamsMojoType>(
    UsbDevice_SetConfiguration_ParamsSpec.$,
    'UsbDevice_SetConfiguration_Params',
    [
      mojo.internal.StructField<UsbDevice_SetConfiguration_ParamsMojoType, number>(
        'value', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_SetConfiguration_ResponseParamsMojoType {
  success: boolean;
}


export type UsbDevice_SetConfiguration_ResponseParams = UsbDevice_SetConfiguration_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_SetConfiguration_ResponseParamsMojoType>(
    UsbDevice_SetConfiguration_ResponseParamsSpec.$,
    'UsbDevice_SetConfiguration_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_SetConfiguration_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ClaimInterface_ParamsMojoType {
  interfaceNumber: number;
}


export type UsbDevice_ClaimInterface_Params = UsbDevice_ClaimInterface_ParamsMojoType;
mojo.internal.Struct<UsbDevice_ClaimInterface_ParamsMojoType>(
    UsbDevice_ClaimInterface_ParamsSpec.$,
    'UsbDevice_ClaimInterface_Params',
    [
      mojo.internal.StructField<UsbDevice_ClaimInterface_ParamsMojoType, number>(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ClaimInterface_ResponseParamsMojoType {
  result: UsbClaimInterfaceResult;
}


export type UsbDevice_ClaimInterface_ResponseParams = UsbDevice_ClaimInterface_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_ClaimInterface_ResponseParamsMojoType>(
    UsbDevice_ClaimInterface_ResponseParamsSpec.$,
    'UsbDevice_ClaimInterface_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_ClaimInterface_ResponseParamsMojoType, UsbClaimInterfaceResult>(
        'result', 0,
        0,
        UsbClaimInterfaceResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ReleaseInterface_ParamsMojoType {
  interfaceNumber: number;
}


export type UsbDevice_ReleaseInterface_Params = UsbDevice_ReleaseInterface_ParamsMojoType;
mojo.internal.Struct<UsbDevice_ReleaseInterface_ParamsMojoType>(
    UsbDevice_ReleaseInterface_ParamsSpec.$,
    'UsbDevice_ReleaseInterface_Params',
    [
      mojo.internal.StructField<UsbDevice_ReleaseInterface_ParamsMojoType, number>(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ReleaseInterface_ResponseParamsMojoType {
  success: boolean;
}


export type UsbDevice_ReleaseInterface_ResponseParams = UsbDevice_ReleaseInterface_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_ReleaseInterface_ResponseParamsMojoType>(
    UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
    'UsbDevice_ReleaseInterface_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_ReleaseInterface_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_SetInterfaceAlternateSetting_ParamsMojoType {
  interfaceNumber: number;
  alternateSetting: number;
}


export type UsbDevice_SetInterfaceAlternateSetting_Params = UsbDevice_SetInterfaceAlternateSetting_ParamsMojoType;
mojo.internal.Struct<UsbDevice_SetInterfaceAlternateSetting_ParamsMojoType>(
    UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_Params',
    [
      mojo.internal.StructField<UsbDevice_SetInterfaceAlternateSetting_ParamsMojoType, number>(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_SetInterfaceAlternateSetting_ParamsMojoType, number>(
        'alternateSetting', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_SetInterfaceAlternateSetting_ResponseParamsMojoType {
  success: boolean;
}


export type UsbDevice_SetInterfaceAlternateSetting_ResponseParams = UsbDevice_SetInterfaceAlternateSetting_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_SetInterfaceAlternateSetting_ResponseParamsMojoType>(
    UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_SetInterfaceAlternateSetting_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_Reset_ParamsMojoType {
}


export type UsbDevice_Reset_Params = UsbDevice_Reset_ParamsMojoType;
mojo.internal.Struct<UsbDevice_Reset_ParamsMojoType>(
    UsbDevice_Reset_ParamsSpec.$,
    'UsbDevice_Reset_Params',
    [
    ],
    [[0, 8],]);





export interface UsbDevice_Reset_ResponseParamsMojoType {
  success: boolean;
}


export type UsbDevice_Reset_ResponseParams = UsbDevice_Reset_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_Reset_ResponseParamsMojoType>(
    UsbDevice_Reset_ResponseParamsSpec.$,
    'UsbDevice_Reset_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_Reset_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ClearHalt_ParamsMojoType {
  direction: UsbTransferDirection;
  endpointNumber: number;
}


export type UsbDevice_ClearHalt_Params = UsbDevice_ClearHalt_ParamsMojoType;
mojo.internal.Struct<UsbDevice_ClearHalt_ParamsMojoType>(
    UsbDevice_ClearHalt_ParamsSpec.$,
    'UsbDevice_ClearHalt_Params',
    [
      mojo.internal.StructField<UsbDevice_ClearHalt_ParamsMojoType, UsbTransferDirection>(
        'direction', 0,
        0,
        UsbTransferDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ClearHalt_ParamsMojoType, number>(
        'endpointNumber', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ClearHalt_ResponseParamsMojoType {
  success: boolean;
}


export type UsbDevice_ClearHalt_ResponseParams = UsbDevice_ClearHalt_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_ClearHalt_ResponseParamsMojoType>(
    UsbDevice_ClearHalt_ResponseParamsSpec.$,
    'UsbDevice_ClearHalt_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_ClearHalt_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_ControlTransferIn_ParamsMojoType {
  params: UsbControlTransferParams;
  length: number;
  timeout: number;
}


export type UsbDevice_ControlTransferIn_Params = UsbDevice_ControlTransferIn_ParamsMojoType;
mojo.internal.Struct<UsbDevice_ControlTransferIn_ParamsMojoType>(
    UsbDevice_ControlTransferIn_ParamsSpec.$,
    'UsbDevice_ControlTransferIn_Params',
    [
      mojo.internal.StructField<UsbDevice_ControlTransferIn_ParamsMojoType, UsbControlTransferParams>(
        'params', 0,
        0,
        UsbControlTransferParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ControlTransferIn_ParamsMojoType, number>(
        'length', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ControlTransferIn_ParamsMojoType, number>(
        'timeout', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_ControlTransferIn_ResponseParamsMojoType {
  status: UsbTransferStatus;
  data: mojoBase_mojom_ReadOnlyBuffer;
}


export type UsbDevice_ControlTransferIn_ResponseParams = UsbDevice_ControlTransferIn_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_ControlTransferIn_ResponseParamsMojoType>(
    UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferIn_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_ControlTransferIn_ResponseParamsMojoType, UsbTransferStatus>(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ControlTransferIn_ResponseParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_ControlTransferOut_ParamsMojoType {
  params: UsbControlTransferParams;
  data: mojoBase_mojom_ReadOnlyBuffer;
  timeout: number;
}


export type UsbDevice_ControlTransferOut_Params = UsbDevice_ControlTransferOut_ParamsMojoType;
mojo.internal.Struct<UsbDevice_ControlTransferOut_ParamsMojoType>(
    UsbDevice_ControlTransferOut_ParamsSpec.$,
    'UsbDevice_ControlTransferOut_Params',
    [
      mojo.internal.StructField<UsbDevice_ControlTransferOut_ParamsMojoType, UsbControlTransferParams>(
        'params', 0,
        0,
        UsbControlTransferParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ControlTransferOut_ParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_ControlTransferOut_ParamsMojoType, number>(
        'timeout', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UsbDevice_ControlTransferOut_ResponseParamsMojoType {
  status: UsbTransferStatus;
}


export type UsbDevice_ControlTransferOut_ResponseParams = UsbDevice_ControlTransferOut_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_ControlTransferOut_ResponseParamsMojoType>(
    UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferOut_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_ControlTransferOut_ResponseParamsMojoType, UsbTransferStatus>(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_GenericTransferIn_ParamsMojoType {
  endpointNumber: number;
  length: number;
  timeout: number;
}


export type UsbDevice_GenericTransferIn_Params = UsbDevice_GenericTransferIn_ParamsMojoType;
mojo.internal.Struct<UsbDevice_GenericTransferIn_ParamsMojoType>(
    UsbDevice_GenericTransferIn_ParamsSpec.$,
    'UsbDevice_GenericTransferIn_Params',
    [
      mojo.internal.StructField<UsbDevice_GenericTransferIn_ParamsMojoType, number>(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_GenericTransferIn_ParamsMojoType, number>(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_GenericTransferIn_ParamsMojoType, number>(
        'timeout', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_GenericTransferIn_ResponseParamsMojoType {
  status: UsbTransferStatus;
  data: mojoBase_mojom_ReadOnlyBuffer;
}


export type UsbDevice_GenericTransferIn_ResponseParams = UsbDevice_GenericTransferIn_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_GenericTransferIn_ResponseParamsMojoType>(
    UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferIn_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_GenericTransferIn_ResponseParamsMojoType, UsbTransferStatus>(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_GenericTransferIn_ResponseParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_GenericTransferOut_ParamsMojoType {
  endpointNumber: number;
  timeout: number;
  data: mojoBase_mojom_ReadOnlyBuffer;
}


export type UsbDevice_GenericTransferOut_Params = UsbDevice_GenericTransferOut_ParamsMojoType;
mojo.internal.Struct<UsbDevice_GenericTransferOut_ParamsMojoType>(
    UsbDevice_GenericTransferOut_ParamsSpec.$,
    'UsbDevice_GenericTransferOut_Params',
    [
      mojo.internal.StructField<UsbDevice_GenericTransferOut_ParamsMojoType, number>(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_GenericTransferOut_ParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_GenericTransferOut_ParamsMojoType, number>(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_GenericTransferOut_ResponseParamsMojoType {
  status: UsbTransferStatus;
}


export type UsbDevice_GenericTransferOut_ResponseParams = UsbDevice_GenericTransferOut_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_GenericTransferOut_ResponseParamsMojoType>(
    UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferOut_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_GenericTransferOut_ResponseParamsMojoType, UsbTransferStatus>(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDevice_IsochronousTransferIn_ParamsMojoType {
  endpointNumber: number;
  timeout: number;
  packetLengths: number[];
}


export type UsbDevice_IsochronousTransferIn_Params = UsbDevice_IsochronousTransferIn_ParamsMojoType;
mojo.internal.Struct<UsbDevice_IsochronousTransferIn_ParamsMojoType>(
    UsbDevice_IsochronousTransferIn_ParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_Params',
    [
      mojo.internal.StructField<UsbDevice_IsochronousTransferIn_ParamsMojoType, number>(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferIn_ParamsMojoType, number[]>(
        'packetLengths', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferIn_ParamsMojoType, number>(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_IsochronousTransferIn_ResponseParamsMojoType {
  data: mojoBase_mojom_ReadOnlyBuffer;
  packets: UsbIsochronousPacket[];
}


export type UsbDevice_IsochronousTransferIn_ResponseParams = UsbDevice_IsochronousTransferIn_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_IsochronousTransferIn_ResponseParamsMojoType>(
    UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_IsochronousTransferIn_ResponseParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferIn_ResponseParamsMojoType, UsbIsochronousPacket[]>(
        'packets', 8,
        0,
        mojo.internal.Array(UsbIsochronousPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDevice_IsochronousTransferOut_ParamsMojoType {
  endpointNumber: number;
  timeout: number;
  data: mojoBase_mojom_ReadOnlyBuffer;
  packetLengths: number[];
}


export type UsbDevice_IsochronousTransferOut_Params = UsbDevice_IsochronousTransferOut_ParamsMojoType;
mojo.internal.Struct<UsbDevice_IsochronousTransferOut_ParamsMojoType>(
    UsbDevice_IsochronousTransferOut_ParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_Params',
    [
      mojo.internal.StructField<UsbDevice_IsochronousTransferOut_ParamsMojoType, number>(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferOut_ParamsMojoType, mojoBase_mojom_ReadOnlyBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferOut_ParamsMojoType, number[]>(
        'packetLengths', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDevice_IsochronousTransferOut_ParamsMojoType, number>(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UsbDevice_IsochronousTransferOut_ResponseParamsMojoType {
  packets: UsbIsochronousPacket[];
}


export type UsbDevice_IsochronousTransferOut_ResponseParams = UsbDevice_IsochronousTransferOut_ResponseParamsMojoType;
mojo.internal.Struct<UsbDevice_IsochronousTransferOut_ResponseParamsMojoType>(
    UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_ResponseParams',
    [
      mojo.internal.StructField<UsbDevice_IsochronousTransferOut_ResponseParamsMojoType, UsbIsochronousPacket[]>(
        'packets', 0,
        0,
        mojo.internal.Array(UsbIsochronousPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceClient_OnDeviceOpened_ParamsMojoType {
}


export type UsbDeviceClient_OnDeviceOpened_Params = UsbDeviceClient_OnDeviceOpened_ParamsMojoType;
mojo.internal.Struct<UsbDeviceClient_OnDeviceOpened_ParamsMojoType>(
    UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceOpened_Params',
    [
    ],
    [[0, 8],]);





export interface UsbDeviceClient_OnDeviceClosed_ParamsMojoType {
}


export type UsbDeviceClient_OnDeviceClosed_Params = UsbDeviceClient_OnDeviceClosed_ParamsMojoType;
mojo.internal.Struct<UsbDeviceClient_OnDeviceClosed_ParamsMojoType>(
    UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceClosed_Params',
    [
    ],
    [[0, 8],]);



mojo.internal.Union(
    UsbOpenDeviceResultSpec.$, 'UsbOpenDeviceResult',
    {
      'success': {
        'ordinal': 0,
        'type': UsbOpenDeviceSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': UsbOpenDeviceErrorSpec.$,
      },
    });

export interface UsbOpenDeviceResult {
  success?: UsbOpenDeviceSuccess,
  error?: UsbOpenDeviceError,
}

export enum UsbOpenDeviceResultFieldTags {
  SUCCESS,
  ERROR,
}

export function whichUsbOpenDeviceResult(u: UsbOpenDeviceResult): UsbOpenDeviceResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return UsbOpenDeviceResultFieldTags.SUCCESS;
  }
  if (u.error !== null && u.error !== undefined) {
    return UsbOpenDeviceResultFieldTags.ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
