// services/device/public/mojom/time_zone_monitor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/time_zone_monitor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/time_zone_monitor.mojom-params-data.h"
#include "services/device/public/mojom/time_zone_monitor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/time_zone_monitor.mojom-blink-import-headers.h"
#include "services/device/public/mojom/time_zone_monitor.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

TimeZoneMonitor::IPCStableHashFunction TimeZoneMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TimeZoneMonitor>(message.name())) {
    case messages::TimeZoneMonitor::kAddClient: {
      return &TimeZoneMonitor::AddClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TimeZoneMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TimeZoneMonitor>(message.name())) {
      case messages::TimeZoneMonitor::kAddClient:
            return "Receive device::mojom::TimeZoneMonitor::AddClient";
    }
  } else {
    switch (static_cast<messages::TimeZoneMonitor>(message.name())) {
      case messages::TimeZoneMonitor::kAddClient:
            return "Receive reply device::mojom::TimeZoneMonitor::AddClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TimeZoneMonitor::AddClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33233691;  // IPCStableHash for device::mojom::TimeZoneMonitor::AddClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TimeZoneMonitorProxy::TimeZoneMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TimeZoneMonitorProxy::AddClient(
    ::mojo::PendingRemote<TimeZoneMonitorClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::TimeZoneMonitor::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<TimeZoneMonitorClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TimeZoneMonitor::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::TimeZoneMonitor_AddClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::TimeZoneMonitorClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in TimeZoneMonitor.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TimeZoneMonitor::Name_);
  message.set_method_name("AddClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TimeZoneMonitorStubDispatch::Accept(
    TimeZoneMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TimeZoneMonitor>(message->header()->name)) {
    case messages::TimeZoneMonitor::kAddClient: {
      DCHECK(message->is_serialized());
      internal::TimeZoneMonitor_AddClient_Params_Data* params =
          reinterpret_cast<internal::TimeZoneMonitor_AddClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TimeZoneMonitor.0
      bool success = true;
      ::mojo::PendingRemote<TimeZoneMonitorClient> p_client{};
      TimeZoneMonitor_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TimeZoneMonitor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool TimeZoneMonitorStubDispatch::AcceptWithResponder(
    TimeZoneMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TimeZoneMonitor>(message->header()->name)) {
    case messages::TimeZoneMonitor::kAddClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTimeZoneMonitorValidationInfo[] = {
    { &internal::TimeZoneMonitor_AddClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool TimeZoneMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::TimeZoneMonitor::Name_,
    kTimeZoneMonitorValidationInfo);
}

// The declaration includes the definition on other builds.

TimeZoneMonitorClient::IPCStableHashFunction TimeZoneMonitorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TimeZoneMonitorClient>(message.name())) {
    case messages::TimeZoneMonitorClient::kOnTimeZoneChange: {
      return &TimeZoneMonitorClient::OnTimeZoneChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TimeZoneMonitorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TimeZoneMonitorClient>(message.name())) {
      case messages::TimeZoneMonitorClient::kOnTimeZoneChange:
            return "Receive device::mojom::TimeZoneMonitorClient::OnTimeZoneChange";
    }
  } else {
    switch (static_cast<messages::TimeZoneMonitorClient>(message.name())) {
      case messages::TimeZoneMonitorClient::kOnTimeZoneChange:
            return "Receive reply device::mojom::TimeZoneMonitorClient::OnTimeZoneChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TimeZoneMonitorClient::OnTimeZoneChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ed776d6;  // IPCStableHash for device::mojom::TimeZoneMonitorClient::OnTimeZoneChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TimeZoneMonitorClientProxy::TimeZoneMonitorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TimeZoneMonitorClientProxy::OnTimeZoneChange(
    const ::blink::String& in_tz_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::TimeZoneMonitorClient::OnTimeZoneChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tz_info"), in_tz_info,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TimeZoneMonitorClient::kOnTimeZoneChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tz_info)::BaseType> tz_info_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tz_info,
    tz_info_fragment);

  params->tz_info.Set(
      tz_info_fragment.is_null() ? nullptr : tz_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tz_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tz_info in TimeZoneMonitorClient.OnTimeZoneChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TimeZoneMonitorClient::Name_);
  message.set_method_name("OnTimeZoneChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TimeZoneMonitorClientStubDispatch::Accept(
    TimeZoneMonitorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TimeZoneMonitorClient>(message->header()->name)) {
    case messages::TimeZoneMonitorClient::kOnTimeZoneChange: {
      DCHECK(message->is_serialized());
      internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data* params =
          reinterpret_cast<internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TimeZoneMonitorClient.0
      bool success = true;
      ::blink::String p_tz_info{};
      TimeZoneMonitorClient_OnTimeZoneChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTzInfo(&p_tz_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TimeZoneMonitorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTimeZoneChange(        
        std::move(p_tz_info));
      return true;
    }
  }
  return false;
}

// static
bool TimeZoneMonitorClientStubDispatch::AcceptWithResponder(
    TimeZoneMonitorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TimeZoneMonitorClient>(message->header()->name)) {
    case messages::TimeZoneMonitorClient::kOnTimeZoneChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTimeZoneMonitorClientValidationInfo[] = {
    { &internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool TimeZoneMonitorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::TimeZoneMonitorClient::Name_,
    kTimeZoneMonitorClientValidationInfo);
}



}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void TimeZoneMonitorInterceptorForTesting::AddClient(::mojo::PendingRemote<TimeZoneMonitorClient> client) {
  GetForwardingInterface()->AddClient(
    std::move(client)
    );
}
TimeZoneMonitorAsyncWaiter::TimeZoneMonitorAsyncWaiter(
    TimeZoneMonitor* proxy) : proxy_(proxy) {}

TimeZoneMonitorAsyncWaiter::~TimeZoneMonitorAsyncWaiter() = default;





void TimeZoneMonitorClientInterceptorForTesting::OnTimeZoneChange(const ::blink::String& tz_info) {
  GetForwardingInterface()->OnTimeZoneChange(
    std::move(tz_info)
    );
}
TimeZoneMonitorClientAsyncWaiter::TimeZoneMonitorClientAsyncWaiter(
    TimeZoneMonitorClient* proxy) : proxy_(proxy) {}

TimeZoneMonitorClientAsyncWaiter::~TimeZoneMonitorClientAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif