// services/device/public/mojom/geoposition.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/geoposition.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/device/public/mojom/geoposition.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GeopositionErrorCode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GeopositionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeopositionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Geoposition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->latitude = Traits::latitude(input);

      fragment->longitude = Traits::longitude(input);

      fragment->altitude = Traits::altitude(input);

      fragment->accuracy = Traits::accuracy(input);

      fragment->altitude_accuracy = Traits::altitude_accuracy(input);

      fragment->heading = Traits::heading(input);

      fragment->speed = Traits::speed(input);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in Geoposition struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GeopositionErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeopositionErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GeopositionError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::GeopositionErrorCode>(
        Traits::error_code(input),
        &fragment->error_code);

      decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error_message)::BaseType> error_message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_error_message,
        error_message_fragment);

      fragment->error_message.Set(
          error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error_message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_message in GeopositionError struct");

      decltype(Traits::error_technical(input)) in_error_technical = Traits::error_technical(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error_technical)::BaseType> error_technical_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_error_technical,
        error_technical_fragment);

      fragment->error_technical.Set(
          error_technical_fragment.is_null() ? nullptr : error_technical_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error_technical.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_technical in GeopositionError struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GeopositionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::GeopositionResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::GeopositionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::GeopositionResultDataView::Tag::kPosition: {
    decltype(Traits::position(input))
    in_position = Traits::position(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_position)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::GeopositionDataView, send_validation>(
  in_position,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null position in GeopositionResult union");
    fragment->data.f_position.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::GeopositionResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::GeopositionErrorDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in GeopositionResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SEND_VALIDATION_H_