// services/device/public/mojom/geolocation_context.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  GeolocationRemote as device_mojom_GeolocationRemote,
  GeolocationPendingReceiver as device_mojom_GeolocationPendingReceiver
} from './geolocation.mojom.m.js';

import {
  GeolocationClientId as device_mojom_GeolocationClientId,
  GeolocationClientIdSpec as device_mojom_GeolocationClientIdSpec
} from './geolocation_client_id.mojom.m.js';

import {
  GeopositionResult as device_mojom_GeopositionResult,
  GeopositionResultSpec as device_mojom_GeopositionResultSpec
} from './geoposition.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GeolocationContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.GeolocationContext', scope);
  }
}

/** @interface */
export class GeolocationContextInterface {
  
  /**
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !url_mojom_Url } requestingUrl
   * @param { !device_mojom_GeolocationClientId } clientId
   */

  bindGeolocation(receiver, requestingUrl, clientId) {}
  
  /**
   * @param { !url_mojom_Origin } origin
   */

  onPermissionRevoked(origin) {}
  
  /**
   * @param { !device_mojom_GeopositionResult } result
   */

  setOverride(result) {}
  
  /**
   */

  clearOverride() {}
}

/**
 * @implements { GeolocationContextInterface }
 */
export class GeolocationContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GeolocationContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GeolocationContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GeolocationContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !url_mojom_Url } requestingUrl
   * @param { !device_mojom_GeolocationClientId } clientId
   */

  bindGeolocation(
      receiver,
      requestingUrl,
      clientId) {
    this.proxy.sendMessage(
        0,
        GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        [
          receiver,
          requestingUrl,
          clientId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   */

  onPermissionRevoked(
      origin) {
    this.proxy.sendMessage(
        1,
        GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        [
          origin
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_GeopositionResult } result
   */

  setOverride(
      result) {
    this.proxy.sendMessage(
        2,
        GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   */

  clearOverride() {
    this.proxy.sendMessage(
        3,
        GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GeolocationContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GeolocationContextReceiver {
  /**
   * @param {!GeolocationContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GeolocationContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GeolocationContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        impl.bindGeolocation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        impl.onPermissionRevoked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        impl.setOverride.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        impl.clearOverride.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GeolocationContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.GeolocationContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GeolocationContextRemote}
   */
  static getRemote() {
    let remote = new GeolocationContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GeolocationContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GeolocationContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GeolocationContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindGeolocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        this.bindGeolocation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPermissionRevoked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        this.onPermissionRevoked.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        this.setOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        this.clearOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationContext_BindGeolocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationContext_OnPermissionRevoked_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationContext_SetOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationContext_ClearOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GeolocationContext_BindGeolocation_ParamsSpec.$,
    'GeolocationContext_BindGeolocation_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(device_mojom_GeolocationPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestingUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientId', 4,
        0,
        device_mojom_GeolocationClientIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GeolocationContext_BindGeolocation_Params {
  constructor() {
    /** @type { !device_mojom_GeolocationPendingReceiver } */
    this.receiver;
    /** @type { !url_mojom_Url } */
    this.requestingUrl;
    /** @type { !device_mojom_GeolocationClientId } */
    this.clientId;
  }
}



mojo.internal.Struct(
    GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
    'GeolocationContext_OnPermissionRevoked_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GeolocationContext_OnPermissionRevoked_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
  }
}



mojo.internal.Struct(
    GeolocationContext_SetOverride_ParamsSpec.$,
    'GeolocationContext_SetOverride_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device_mojom_GeopositionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GeolocationContext_SetOverride_Params {
  constructor() {
    /** @type { !device_mojom_GeopositionResult } */
    this.result;
  }
}



mojo.internal.Struct(
    GeolocationContext_ClearOverride_ParamsSpec.$,
    'GeolocationContext_ClearOverride_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class GeolocationContext_ClearOverride_Params {
  constructor() {
  }
}

