// services/device/public/mojom/geolocation.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.GeopositionResult');






goog.provide('device.mojom.Geolocation');
goog.provide('device.mojom.GeolocationReceiver');
goog.provide('device.mojom.GeolocationCallbackRouter');
goog.provide('device.mojom.GeolocationInterface');
goog.provide('device.mojom.GeolocationRemote');
goog.provide('device.mojom.GeolocationPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.GeolocationPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.Geolocation.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.GeolocationInterface = class {
  
  /**
   * @param { !boolean } highAccuracy
   */

  setHighAccuracyHint(highAccuracy) {}
  
  /**
   * @return {!Promise<{
        result: !device.mojom.GeopositionResult,
   *  }>}
   */

  queryNextPosition() {}
};

/**
 * @export
 * @implements { device.mojom.GeolocationInterface }
 */
device.mojom.GeolocationRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.GeolocationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.GeolocationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.GeolocationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } highAccuracy
   */

  setHighAccuracyHint(
      highAccuracy) {
    this.proxy.sendMessage(
        0,
        device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec.$,
        null,
        [
          highAccuracy
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.GeopositionResult,
   *  }>}
   */

  queryNextPosition() {
    return this.proxy.sendMessage(
        1,
        device.mojom.Geolocation_QueryNextPosition_ParamsSpec.$,
        device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Geolocation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.GeolocationReceiver = class {
  /**
   * @param {!device.mojom.GeolocationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.GeolocationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.GeolocationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.GeolocationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec.$,
        null,
        impl.setHighAccuracyHint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.Geolocation_QueryNextPosition_ParamsSpec.$,
        device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec.$,
        impl.queryNextPosition.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.Geolocation = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.Geolocation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.GeolocationRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.GeolocationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Geolocation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.GeolocationCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.GeolocationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.GeolocationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHighAccuracyHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec.$,
        null,
        this.setHighAccuracyHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryNextPosition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.Geolocation_QueryNextPosition_ParamsSpec.$,
        device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec.$,
        this.queryNextPosition.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Geolocation_QueryNextPosition_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Geolocation_QueryNextPosition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.Geolocation_SetHighAccuracyHint_ParamsSpec.$,
    'Geolocation_SetHighAccuracyHint_Params',
    [
      mojo.internal.StructField(
        'highAccuracy', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Geolocation_SetHighAccuracyHint_Params');

/** @record */
device.mojom.Geolocation_SetHighAccuracyHint_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.highAccuracy;
  }
};



mojo.internal.Struct(
    device.mojom.Geolocation_QueryNextPosition_ParamsSpec.$,
    'Geolocation_QueryNextPosition_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Geolocation_QueryNextPosition_Params');

/** @record */
device.mojom.Geolocation_QueryNextPosition_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Geolocation_QueryNextPosition_ResponseParamsSpec.$,
    'Geolocation_QueryNextPosition_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.GeopositionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.Geolocation_QueryNextPosition_ResponseParams');

/** @record */
device.mojom.Geolocation_QueryNextPosition_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.GeopositionResult } */
    this.result;
  }
};

