// services/data_decoder/public/mojom/xml_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/data_decoder/public/mojom/xml_parser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/xml_parser.mojom-params-data.h"
namespace data_decoder {
namespace mojom {

NOINLINE static const char* XmlParser_WhitespaceBehaviorToStringHelper(XmlParser_WhitespaceBehavior value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XmlParser_WhitespaceBehavior::kIgnore:
      return "kIgnore";
    case XmlParser_WhitespaceBehavior::kPreserveSignificant:
      return "kPreserveSignificant";
    default:
      return nullptr;
  }
}

std::string XmlParser_WhitespaceBehaviorToString(XmlParser_WhitespaceBehavior value) {
  const char *str = XmlParser_WhitespaceBehaviorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XmlParser_WhitespaceBehavior value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XmlParser_WhitespaceBehavior value) {
  return os << XmlParser_WhitespaceBehaviorToString(value);
}

namespace internal {


// static
bool XmlParser_Parse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XmlParser_Parse_Params_Data* object =
      static_cast<const XmlParser_Parse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->xml, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& xml_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->xml, validation_context,
                                         &xml_validate_params)) {
    return false;
  }


  if (!::data_decoder::mojom::internal::XmlParser_WhitespaceBehavior_Data
        ::Validate(object->whitespace_behavior, validation_context))
    return false;

  return true;
}

XmlParser_Parse_Params_Data::XmlParser_Parse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XmlParser_Parse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XmlParser_Parse_ResponseParams_Data* object =
      static_cast<const XmlParser_Parse_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

XmlParser_Parse_ResponseParams_Data::XmlParser_Parse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_decoder

namespace perfetto {

// static
void TraceFormatTraits<::data_decoder::mojom::XmlParser_WhitespaceBehavior>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_decoder::mojom::XmlParser_WhitespaceBehavior value) {
  return std::move(context).WriteString(::data_decoder::mojom::XmlParser_WhitespaceBehaviorToString(value));
}

} // namespace perfetto