// services/data_decoder/public/mojom/image_decoder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/image_decoder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-params-data.h"
#include "services/data_decoder/public/mojom/image_decoder.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-import-headers.h"
#include "services/data_decoder/public/mojom/image_decoder.mojom-test-utils.h"


namespace data_decoder::mojom {
AnimationFrame::AnimationFrame()
    : bitmap(),
      duration() {}

AnimationFrame::AnimationFrame(
    const ::SkBitmap& bitmap_in,
    ::base::TimeDelta duration_in)
    : bitmap(std::move(bitmap_in)),
      duration(std::move(duration_in)) {}

AnimationFrame::~AnimationFrame() = default;

void AnimationFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitmap"), this->bitmap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ImageDecoder::IPCStableHashFunction ImageDecoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageDecoder>(message.name())) {
    case messages::ImageDecoder::kDecodeImage: {
      return &ImageDecoder::DecodeImage_Sym::IPCStableHash;
    }
    case messages::ImageDecoder::kDecodeAnimation: {
      return &ImageDecoder::DecodeAnimation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageDecoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageDecoder>(message.name())) {
      case messages::ImageDecoder::kDecodeImage:
            return "Receive data_decoder::mojom::ImageDecoder::DecodeImage";
      case messages::ImageDecoder::kDecodeAnimation:
            return "Receive data_decoder::mojom::ImageDecoder::DecodeAnimation";
    }
  } else {
    switch (static_cast<messages::ImageDecoder>(message.name())) {
      case messages::ImageDecoder::kDecodeImage:
            return "Receive reply data_decoder::mojom::ImageDecoder::DecodeImage";
      case messages::ImageDecoder::kDecodeAnimation:
            return "Receive reply data_decoder::mojom::ImageDecoder::DecodeAnimation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageDecoder::DecodeImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x577ad00c;  // IPCStableHash for data_decoder::mojom::ImageDecoder::DecodeImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ImageDecoder::DecodeAnimation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd9600a0;  // IPCStableHash for data_decoder::mojom::ImageDecoder::DecodeAnimation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ImageDecoder_DecodeImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDecoder_DecodeImage_ForwardToCallback(
      ImageDecoder::DecodeImageCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageDecoder_DecodeImage_ForwardToCallback(const ImageDecoder_DecodeImage_ForwardToCallback&) = delete;
  ImageDecoder_DecodeImage_ForwardToCallback& operator=(const ImageDecoder_DecodeImage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageDecoder::DecodeImageCallback callback_;
};

class ImageDecoder_DecodeAnimation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDecoder_DecodeAnimation_ForwardToCallback(
      ImageDecoder::DecodeAnimationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageDecoder_DecodeAnimation_ForwardToCallback(const ImageDecoder_DecodeAnimation_ForwardToCallback&) = delete;
  ImageDecoder_DecodeAnimation_ForwardToCallback& operator=(const ImageDecoder_DecodeAnimation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageDecoder::DecodeAnimationCallback callback_;
};

ImageDecoderProxy::ImageDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageDecoderProxy::DecodeImage(
    ::mojo_base::BigBuffer in_encoded_data, ImageCodec in_codec, bool in_shrink_to_fit, int64_t in_max_size_in_bytes, const ::gfx::Size& in_desired_image_frame_size, DecodeImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::ImageDecoder::DecodeImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoded_data"), in_encoded_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ImageCodec>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shrink_to_fit"), in_shrink_to_fit,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size_in_bytes"), in_max_size_in_bytes,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_image_frame_size"), in_desired_image_frame_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDecoder::kDecodeImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encoded_data)>
      encoded_data_fragment(params.message());
  encoded_data_fragment.Claim(&params->encoded_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_encoded_data,
    encoded_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encoded_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encoded_data in ImageDecoder.DecodeImage request");

  
  mojo::internal::Serialize<::data_decoder::mojom::ImageCodec>(
    in_codec,
    &params->codec);

  params->shrink_to_fit = in_shrink_to_fit;

  params->max_size_in_bytes = in_max_size_in_bytes;
  mojo::internal::MessageFragment<
      typename decltype(params->desired_image_frame_size)::BaseType> desired_image_frame_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_desired_image_frame_size,
    desired_image_frame_size_fragment);

  params->desired_image_frame_size.Set(
      desired_image_frame_size_fragment.is_null() ? nullptr : desired_image_frame_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->desired_image_frame_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null desired_image_frame_size in ImageDecoder.DecodeImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDecoder_DecodeImage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ImageDecoderProxy::DecodeAnimation(
    ::mojo_base::BigBuffer in_encoded_data, bool in_shrink_to_fit, int64_t in_max_size_in_bytes, DecodeAnimationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::ImageDecoder::DecodeAnimation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoded_data"), in_encoded_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shrink_to_fit"), in_shrink_to_fit,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size_in_bytes"), in_max_size_in_bytes,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDecoder::kDecodeAnimation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeAnimation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->encoded_data)>
      encoded_data_fragment(params.message());
  encoded_data_fragment.Claim(&params->encoded_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_encoded_data,
    encoded_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encoded_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encoded_data in ImageDecoder.DecodeAnimation request");

  params->shrink_to_fit = in_shrink_to_fit;

  params->max_size_in_bytes = in_max_size_in_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeAnimation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDecoder_DecodeAnimation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ImageDecoder_DecodeImage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageDecoder::DecodeImageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageDecoder_DecodeImage_ProxyToResponder> proxy(
        new ImageDecoder_DecodeImage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageDecoder_DecodeImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDecoder_DecodeImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageDecoder_DecodeImage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageDecoder::DecodeImageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::TimeDelta in_decoding_duration, const ::SkBitmap& in_decoded_image);
};

bool ImageDecoder_DecodeImage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageDecoder_DecodeImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDecoder_DecodeImage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageDecoder.0
  bool success = true;
  ::base::TimeDelta p_decoding_duration{};
  ::SkBitmap p_decoded_image{};
  ImageDecoder_DecodeImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDecodingDuration(&p_decoding_duration))
    success = false;
  if (success && !input_data_view.ReadDecodedImage(&p_decoded_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_decoding_duration), 
std::move(p_decoded_image));
  }
  return true;
}

void ImageDecoder_DecodeImage_ProxyToResponder::Run(
    ::base::TimeDelta in_decoding_duration, const ::SkBitmap& in_decoded_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::ImageDecoder::DecodeImage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoding_duration"), in_decoding_duration,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoded_image"), in_decoded_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDecoder::kDecodeImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decoding_duration)::BaseType> decoding_duration_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_decoding_duration,
    decoding_duration_fragment);

  params->decoding_duration.Set(
      decoding_duration_fragment.is_null() ? nullptr : decoding_duration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->decoding_duration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null decoding_duration in ");
  mojo::internal::MessageFragment<
      typename decltype(params->decoded_image)::BaseType> decoded_image_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_decoded_image,
    decoded_image_fragment);

  params->decoded_image.Set(
      decoded_image_fragment.is_null() ? nullptr : decoded_image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeImage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImageDecoder_DecodeAnimation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageDecoder::DecodeAnimationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageDecoder_DecodeAnimation_ProxyToResponder> proxy(
        new ImageDecoder_DecodeAnimation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageDecoder_DecodeAnimation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDecoder_DecodeAnimation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageDecoder_DecodeAnimation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageDecoder::DecodeAnimationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AnimationFramePtr> in_decoded_image);
};

bool ImageDecoder_DecodeAnimation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDecoder_DecodeAnimation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageDecoder.1
  bool success = true;
  std::vector<AnimationFramePtr> p_decoded_image{};
  ImageDecoder_DecodeAnimation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDecodedImage(&p_decoded_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDecoder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_decoded_image));
  }
  return true;
}

void ImageDecoder_DecodeAnimation_ProxyToResponder::Run(
    std::vector<AnimationFramePtr> in_decoded_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::ImageDecoder::DecodeAnimation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoded_image"), in_decoded_image,
                        "<value of type std::vector<AnimationFramePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDecoder::kDecodeAnimation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ImageDecoder_DecodeAnimation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decoded_image)::BaseType>
      decoded_image_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& decoded_image_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::data_decoder::mojom::AnimationFrameDataView>>(
    in_decoded_image,
    decoded_image_fragment,
    &decoded_image_validate_params);

  params->decoded_image.Set(
      decoded_image_fragment.is_null() ? nullptr : decoded_image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->decoded_image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null decoded_image in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDecoder::Name_);
  message.set_method_name("DecodeAnimation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageDecoderStubDispatch::Accept(
    ImageDecoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageDecoder>(message->header()->name)) {
    case messages::ImageDecoder::kDecodeImage: {
      break;
    }
    case messages::ImageDecoder::kDecodeAnimation: {
      break;
    }
  }
  return false;
}

// static
bool ImageDecoderStubDispatch::AcceptWithResponder(
    ImageDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageDecoder>(message->header()->name)) {
    case messages::ImageDecoder::kDecodeImage: {
      internal::ImageDecoder_DecodeImage_Params_Data* params =
          reinterpret_cast<
              internal::ImageDecoder_DecodeImage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageDecoder.0
      bool success = true;
      ::mojo_base::BigBuffer p_encoded_data{};
      ImageCodec p_codec{};
      bool p_shrink_to_fit{};
      int64_t p_max_size_in_bytes{};
      ::gfx::Size p_desired_image_frame_size{};
      ImageDecoder_DecodeImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodedData(&p_encoded_data))
        success = false;
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (success)
        p_shrink_to_fit = input_data_view.shrink_to_fit();
      if (success)
        p_max_size_in_bytes = input_data_view.max_size_in_bytes();
      if (success && !input_data_view.ReadDesiredImageFrameSize(&p_desired_image_frame_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDecoder::Name_, 0, false);
        return false;
      }
      auto callback =
          ImageDecoder_DecodeImage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeImage(        
        std::move(p_encoded_data), 
        std::move(p_codec), 
        std::move(p_shrink_to_fit), 
        std::move(p_max_size_in_bytes), 
        std::move(p_desired_image_frame_size), std::move(callback));
      return true;
    }
    case messages::ImageDecoder::kDecodeAnimation: {
      internal::ImageDecoder_DecodeAnimation_Params_Data* params =
          reinterpret_cast<
              internal::ImageDecoder_DecodeAnimation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageDecoder.1
      bool success = true;
      ::mojo_base::BigBuffer p_encoded_data{};
      bool p_shrink_to_fit{};
      int64_t p_max_size_in_bytes{};
      ImageDecoder_DecodeAnimation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncodedData(&p_encoded_data))
        success = false;
      if (success)
        p_shrink_to_fit = input_data_view.shrink_to_fit();
      if (success)
        p_max_size_in_bytes = input_data_view.max_size_in_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDecoder::Name_, 1, false);
        return false;
      }
      auto callback =
          ImageDecoder_DecodeAnimation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeAnimation(        
        std::move(p_encoded_data), 
        std::move(p_shrink_to_fit), 
        std::move(p_max_size_in_bytes), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageDecoderValidationInfo[] = {
    { &internal::ImageDecoder_DecodeImage_Params_Data::Validate,
     &internal::ImageDecoder_DecodeImage_ResponseParams_Data::Validate},
    { &internal::ImageDecoder_DecodeAnimation_Params_Data::Validate,
     &internal::ImageDecoder_DecodeAnimation_ResponseParams_Data::Validate},
};

bool ImageDecoderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_decoder::mojom::ImageDecoder::Name_,
    kImageDecoderValidationInfo);
}

bool ImageDecoderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::data_decoder::mojom::ImageDecoder::Name_,
    kImageDecoderValidationInfo);
}


}  // data_decoder::mojom


namespace mojo {


// static
bool StructTraits<::data_decoder::mojom::AnimationFrame::DataView, ::data_decoder::mojom::AnimationFramePtr>::Read(
    ::data_decoder::mojom::AnimationFrame::DataView input,
    ::data_decoder::mojom::AnimationFramePtr* output) {
  bool success = true;
  ::data_decoder::mojom::AnimationFramePtr result(::data_decoder::mojom::AnimationFrame::New());
  
      if (success && !input.ReadBitmap(&result->bitmap))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_decoder::mojom {


void ImageDecoderInterceptorForTesting::DecodeImage(::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, DecodeImageCallback callback) {
  GetForwardingInterface()->DecodeImage(
    std::move(encoded_data)
    , 
    std::move(codec)
    , 
    std::move(shrink_to_fit)
    , 
    std::move(max_size_in_bytes)
    , 
    std::move(desired_image_frame_size)
    , std::move(callback));
}
void ImageDecoderInterceptorForTesting::DecodeAnimation(::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, DecodeAnimationCallback callback) {
  GetForwardingInterface()->DecodeAnimation(
    std::move(encoded_data)
    , 
    std::move(shrink_to_fit)
    , 
    std::move(max_size_in_bytes)
    , std::move(callback));
}
ImageDecoderAsyncWaiter::ImageDecoderAsyncWaiter(
    ImageDecoder* proxy) : proxy_(proxy) {}

ImageDecoderAsyncWaiter::~ImageDecoderAsyncWaiter() = default;


void ImageDecoderAsyncWaiter::DecodeImage(
    ::mojo_base::BigBuffer encoded_data, ImageCodec codec, bool shrink_to_fit, int64_t max_size_in_bytes, const ::gfx::Size& desired_image_frame_size, ::base::TimeDelta* out_decoding_duration, ::SkBitmap* out_decoded_image) {
  base::RunLoop loop;
  proxy_->DecodeImage(
      std::move(encoded_data),
      std::move(codec),
      std::move(shrink_to_fit),
      std::move(max_size_in_bytes),
      std::move(desired_image_frame_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::TimeDelta* out_decoding_duration
,
             ::SkBitmap* out_decoded_image
,
             ::base::TimeDelta decoding_duration,
             const ::SkBitmap& decoded_image) {*out_decoding_duration = std::move(decoding_duration);*out_decoded_image = std::move(decoded_image);
            loop->Quit();
          },
          &loop,
          out_decoding_duration,
          out_decoded_image));
  loop.Run();
}



void ImageDecoderAsyncWaiter::DecodeAnimation(
    ::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes, std::vector<AnimationFramePtr>* out_decoded_image) {
  base::RunLoop loop;
  proxy_->DecodeAnimation(
      std::move(encoded_data),
      std::move(shrink_to_fit),
      std::move(max_size_in_bytes),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AnimationFramePtr>* out_decoded_image
,
             std::vector<AnimationFramePtr> decoded_image) {*out_decoded_image = std::move(decoded_image);
            loop->Quit();
          },
          &loop,
          out_decoded_image));
  loop.Run();
}

std::vector<AnimationFramePtr> ImageDecoderAsyncWaiter::DecodeAnimation(
    ::mojo_base::BigBuffer encoded_data, bool shrink_to_fit, int64_t max_size_in_bytes) {
  std::vector<AnimationFramePtr> async_wait_result;
  DecodeAnimation(std::move(encoded_data),std::move(shrink_to_fit),std::move(max_size_in_bytes),&async_wait_result);
  return async_wait_result;
}






}  // data_decoder::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif