// services/audio/public/mojom/audio_device_description.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/audio_device_description.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/audio_device_description.mojom-params-data.h"
#include "services/audio/public/mojom/audio_device_description.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/audio_device_description.mojom-import-headers.h"
#include "services/audio/public/mojom/audio_device_description.mojom-test-utils.h"


namespace audio::mojom {
AudioDeviceDescription::AudioDeviceDescription()
    : device_name(),
      unique_id(),
      group_id(),
      is_system_default(),
      is_communications_device() {}

AudioDeviceDescription::AudioDeviceDescription(
    const std::string& device_name_in,
    const std::string& unique_id_in,
    const std::string& group_id_in,
    bool is_system_default_in,
    bool is_communications_device_in)
    : device_name(std::move(device_name_in)),
      unique_id(std::move(unique_id_in)),
      group_id(std::move(group_id_in)),
      is_system_default(std::move(is_system_default_in)),
      is_communications_device(std::move(is_communications_device_in)) {}

AudioDeviceDescription::~AudioDeviceDescription() = default;

void AudioDeviceDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_name"), this->device_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_id"), this->unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_system_default"), this->is_system_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_communications_device"), this->is_communications_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioDeviceDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // audio::mojom


namespace mojo {


// static
bool StructTraits<::audio::mojom::AudioDeviceDescription::DataView, ::audio::mojom::AudioDeviceDescriptionPtr>::Read(
    ::audio::mojom::AudioDeviceDescription::DataView input,
    ::audio::mojom::AudioDeviceDescriptionPtr* output) {
  bool success = true;
  ::audio::mojom::AudioDeviceDescriptionPtr result(::audio::mojom::AudioDeviceDescription::New());
  
      if (success && !input.ReadDeviceName(&result->device_name))
        success = false;
      if (success && !input.ReadUniqueId(&result->unique_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success)
        result->is_system_default = input.is_system_default();
      if (success)
        result->is_communications_device = input.is_communications_device();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace audio::mojom {




}  // audio::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif