// services/accessibility/public/mojom/automation_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_CLIENT_MOJOM_H_
#define SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/accessibility/public/mojom/automation_client.mojom-features.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/automation_client.mojom-shared.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/automation_client.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_action_data.mojom.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ax::mojom {

class AutomationClientProxy;

template <typename ImplRefTraits>
class AutomationClientStub;

class AutomationClientRequestValidator;
class AutomationClientResponseValidator;


class AutomationClient
    : public AutomationClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ax.mojom.AutomationClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutomationClientInterfaceBase;
  using Proxy_ = AutomationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutomationClientStub<ImplRefTraits>;

  using RequestValidator_ = AutomationClientRequestValidator;
  using ResponseValidator_ = AutomationClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnableMinVersion = 0,
    kDisableMinVersion = 0,
    kEnableChildTreeMinVersion = 0,
    kPerformActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Enable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Disable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableChildTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutomationClient() = default;

  using EnableCallback = base::OnceCallback<void(const ::ui::AXTreeID&)>;
  using EnableMojoCallback = base::OnceCallback<void(const ::ui::AXTreeID&)>;

  virtual void Enable(EnableCallback callback) = 0;

  virtual void Disable() = 0;

  virtual void EnableChildTree(const ::ui::AXTreeID& tree_id) = 0;

  virtual void PerformAction(const ::ui::AXActionData& action_data) = 0;
};



class  AutomationClientProxy
    : public AutomationClient {
 public:
  using InterfaceType = AutomationClient;

  explicit AutomationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Enable(EnableCallback callback) final;
  
  void Disable() final;
  
  void EnableChildTree(const ::ui::AXTreeID& tree_id) final;
  
  void PerformAction(const ::ui::AXActionData& action_data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutomationClientStubDispatch {
 public:
  static bool Accept(AutomationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutomationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutomationClient>>
class AutomationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutomationClientStub() = default;
  ~AutomationClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutomationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutomationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutomationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutomationClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ax::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_CLIENT_MOJOM_H_