// services/accessibility/public/mojom/automation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/accessibility/public/mojom/automation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/accessibility/public/mojom/automation.mojom-params-data.h"
#include "services/accessibility/public/mojom/automation.mojom-shared-message-ids.h"

#include "services/accessibility/public/mojom/automation.mojom-import-headers.h"
#include "services/accessibility/public/mojom/automation.mojom-test-utils.h"


namespace ax::mojom {
// The declaration includes the definition on other builds.

Automation::IPCStableHashFunction Automation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Automation>(message.name())) {
    case messages::Automation::kDispatchTreeDestroyedEvent: {
      return &Automation::DispatchTreeDestroyedEvent_Sym::IPCStableHash;
    }
    case messages::Automation::kDispatchActionResult: {
      return &Automation::DispatchActionResult_Sym::IPCStableHash;
    }
    case messages::Automation::kDispatchAccessibilityEvents: {
      return &Automation::DispatchAccessibilityEvents_Sym::IPCStableHash;
    }
    case messages::Automation::kDispatchAccessibilityLocationChange: {
      return &Automation::DispatchAccessibilityLocationChange_Sym::IPCStableHash;
    }
    case messages::Automation::kDispatchAccessibilityScrollChange: {
      return &Automation::DispatchAccessibilityScrollChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Automation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Automation>(message.name())) {
      case messages::Automation::kDispatchTreeDestroyedEvent:
            return "Receive ax::mojom::Automation::DispatchTreeDestroyedEvent";
      case messages::Automation::kDispatchActionResult:
            return "Receive ax::mojom::Automation::DispatchActionResult";
      case messages::Automation::kDispatchAccessibilityEvents:
            return "Receive ax::mojom::Automation::DispatchAccessibilityEvents";
      case messages::Automation::kDispatchAccessibilityLocationChange:
            return "Receive ax::mojom::Automation::DispatchAccessibilityLocationChange";
      case messages::Automation::kDispatchAccessibilityScrollChange:
            return "Receive ax::mojom::Automation::DispatchAccessibilityScrollChange";
    }
  } else {
    switch (static_cast<messages::Automation>(message.name())) {
      case messages::Automation::kDispatchTreeDestroyedEvent:
            return "Receive reply ax::mojom::Automation::DispatchTreeDestroyedEvent";
      case messages::Automation::kDispatchActionResult:
            return "Receive reply ax::mojom::Automation::DispatchActionResult";
      case messages::Automation::kDispatchAccessibilityEvents:
            return "Receive reply ax::mojom::Automation::DispatchAccessibilityEvents";
      case messages::Automation::kDispatchAccessibilityLocationChange:
            return "Receive reply ax::mojom::Automation::DispatchAccessibilityLocationChange";
      case messages::Automation::kDispatchAccessibilityScrollChange:
            return "Receive reply ax::mojom::Automation::DispatchAccessibilityScrollChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Automation::DispatchTreeDestroyedEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8948a84;  // IPCStableHash for ax::mojom::Automation::DispatchTreeDestroyedEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Automation::DispatchActionResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd5818e9;  // IPCStableHash for ax::mojom::Automation::DispatchActionResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Automation::DispatchAccessibilityEvents_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbca2b801;  // IPCStableHash for ax::mojom::Automation::DispatchAccessibilityEvents
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Automation::DispatchAccessibilityLocationChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x05f30483;  // IPCStableHash for ax::mojom::Automation::DispatchAccessibilityLocationChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Automation::DispatchAccessibilityScrollChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfdc0eb56;  // IPCStableHash for ax::mojom::Automation::DispatchAccessibilityScrollChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutomationProxy::AutomationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutomationProxy::DispatchTreeDestroyedEvent(
    const ::ui::AXTreeID& in_tree_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::Automation::DispatchTreeDestroyedEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Automation::kDispatchTreeDestroyedEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::Automation_DispatchTreeDestroyedEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in Automation.DispatchTreeDestroyedEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Automation::Name_);
  message.set_method_name("DispatchTreeDestroyedEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutomationProxy::DispatchActionResult(
    const ::ui::AXActionData& in_data, bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::Automation::DispatchActionResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::ui::AXActionData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Automation::kDispatchActionResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::Automation_DispatchActionResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXActionDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Automation.DispatchActionResult request");

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Automation::Name_);
  message.set_method_name("DispatchActionResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutomationProxy::DispatchAccessibilityEvents(
    const ::ui::AXTreeID& in_tree_id, const std::vector<::ui::AXTreeUpdate>& in_updates, const ::gfx::Point& in_mouse_location, const std::vector<::ui::AXEvent>& in_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::Automation::DispatchAccessibilityEvents", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updates"), in_updates,
                        "<value of type const std::vector<::ui::AXTreeUpdate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mouse_location"), in_mouse_location,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events"), in_events,
                        "<value of type const std::vector<::ui::AXEvent>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Automation::kDispatchAccessibilityEvents), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::Automation_DispatchAccessibilityEvents_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in Automation.DispatchAccessibilityEvents request");
  mojo::internal::MessageFragment<
      typename decltype(params->updates)::BaseType>
      updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>>(
    in_updates,
    updates_fragment,
    &updates_validate_params);

  params->updates.Set(
      updates_fragment.is_null() ? nullptr : updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null updates in Automation.DispatchAccessibilityEvents request");
  mojo::internal::MessageFragment<
      typename decltype(params->mouse_location)::BaseType> mouse_location_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_mouse_location,
    mouse_location_fragment);

  params->mouse_location.Set(
      mouse_location_fragment.is_null() ? nullptr : mouse_location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mouse_location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mouse_location in Automation.DispatchAccessibilityEvents request");
  mojo::internal::MessageFragment<
      typename decltype(params->events)::BaseType>
      events_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>>(
    in_events,
    events_fragment,
    &events_validate_params);

  params->events.Set(
      events_fragment.is_null() ? nullptr : events_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->events.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null events in Automation.DispatchAccessibilityEvents request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Automation::Name_);
  message.set_method_name("DispatchAccessibilityEvents");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutomationProxy::DispatchAccessibilityLocationChange(
    const ::ui::AXTreeID& in_tree_id, int32_t in_node_id, const ::ui::AXRelativeBounds& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::Automation::DispatchAccessibilityLocationChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::ui::AXRelativeBounds&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Automation::kDispatchAccessibilityLocationChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::Automation_DispatchAccessibilityLocationChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in Automation.DispatchAccessibilityLocationChange request");

  params->node_id = in_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXRelativeBoundsDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in Automation.DispatchAccessibilityLocationChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Automation::Name_);
  message.set_method_name("DispatchAccessibilityLocationChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutomationProxy::DispatchAccessibilityScrollChange(
    const ::ui::AXTreeID& in_tree_id, int32_t in_node_id, int32_t in_scroll_x, int32_t in_scroll_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::Automation::DispatchAccessibilityScrollChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_id"), in_tree_id,
                        "<value of type const ::ui::AXTreeID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scroll_x"), in_scroll_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scroll_y"), in_scroll_y,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Automation::kDispatchAccessibilityScrollChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::Automation_DispatchAccessibilityScrollChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->tree_id)>
      tree_id_fragment(params.message());
  tree_id_fragment.Claim(&params->tree_id);
  
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
    in_tree_id,
    tree_id_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tree_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tree_id in Automation.DispatchAccessibilityScrollChange request");

  params->node_id = in_node_id;

  params->scroll_x = in_scroll_x;

  params->scroll_y = in_scroll_y;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Automation::Name_);
  message.set_method_name("DispatchAccessibilityScrollChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutomationStubDispatch::Accept(
    Automation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Automation>(message->header()->name)) {
    case messages::Automation::kDispatchTreeDestroyedEvent: {
      DCHECK(message->is_serialized());
      internal::Automation_DispatchTreeDestroyedEvent_Params_Data* params =
          reinterpret_cast<internal::Automation_DispatchTreeDestroyedEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Automation.0
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      Automation_DispatchTreeDestroyedEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Automation::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchTreeDestroyedEvent(        
        std::move(p_tree_id));
      return true;
    }
    case messages::Automation::kDispatchActionResult: {
      DCHECK(message->is_serialized());
      internal::Automation_DispatchActionResult_Params_Data* params =
          reinterpret_cast<internal::Automation_DispatchActionResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Automation.1
      bool success = true;
      ::ui::AXActionData p_data{};
      bool p_result{};
      Automation_DispatchActionResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Automation::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchActionResult(        
        std::move(p_data), 
        std::move(p_result));
      return true;
    }
    case messages::Automation::kDispatchAccessibilityEvents: {
      DCHECK(message->is_serialized());
      internal::Automation_DispatchAccessibilityEvents_Params_Data* params =
          reinterpret_cast<internal::Automation_DispatchAccessibilityEvents_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Automation.2
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      std::vector<::ui::AXTreeUpdate> p_updates{};
      ::gfx::Point p_mouse_location{};
      std::vector<::ui::AXEvent> p_events{};
      Automation_DispatchAccessibilityEvents_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success && !input_data_view.ReadUpdates(&p_updates))
        success = false;
      if (success && !input_data_view.ReadMouseLocation(&p_mouse_location))
        success = false;
      if (success && !input_data_view.ReadEvents(&p_events))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Automation::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchAccessibilityEvents(        
        std::move(p_tree_id), 
        std::move(p_updates), 
        std::move(p_mouse_location), 
        std::move(p_events));
      return true;
    }
    case messages::Automation::kDispatchAccessibilityLocationChange: {
      DCHECK(message->is_serialized());
      internal::Automation_DispatchAccessibilityLocationChange_Params_Data* params =
          reinterpret_cast<internal::Automation_DispatchAccessibilityLocationChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Automation.3
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      int32_t p_node_id{};
      ::ui::AXRelativeBounds p_bounds{};
      Automation_DispatchAccessibilityLocationChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Automation::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchAccessibilityLocationChange(        
        std::move(p_tree_id), 
        std::move(p_node_id), 
        std::move(p_bounds));
      return true;
    }
    case messages::Automation::kDispatchAccessibilityScrollChange: {
      DCHECK(message->is_serialized());
      internal::Automation_DispatchAccessibilityScrollChange_Params_Data* params =
          reinterpret_cast<internal::Automation_DispatchAccessibilityScrollChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Automation.4
      bool success = true;
      ::ui::AXTreeID p_tree_id{};
      int32_t p_node_id{};
      int32_t p_scroll_x{};
      int32_t p_scroll_y{};
      Automation_DispatchAccessibilityScrollChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTreeId(&p_tree_id))
        success = false;
      if (success)
        p_node_id = input_data_view.node_id();
      if (success)
        p_scroll_x = input_data_view.scroll_x();
      if (success)
        p_scroll_y = input_data_view.scroll_y();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Automation::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchAccessibilityScrollChange(        
        std::move(p_tree_id), 
        std::move(p_node_id), 
        std::move(p_scroll_x), 
        std::move(p_scroll_y));
      return true;
    }
  }
  return false;
}

// static
bool AutomationStubDispatch::AcceptWithResponder(
    Automation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Automation>(message->header()->name)) {
    case messages::Automation::kDispatchTreeDestroyedEvent: {
      break;
    }
    case messages::Automation::kDispatchActionResult: {
      break;
    }
    case messages::Automation::kDispatchAccessibilityEvents: {
      break;
    }
    case messages::Automation::kDispatchAccessibilityLocationChange: {
      break;
    }
    case messages::Automation::kDispatchAccessibilityScrollChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutomationValidationInfo[] = {
    { &internal::Automation_DispatchTreeDestroyedEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Automation_DispatchActionResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Automation_DispatchAccessibilityEvents_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Automation_DispatchAccessibilityLocationChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Automation_DispatchAccessibilityScrollChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutomationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ax::mojom::Automation::Name_,
    kAutomationValidationInfo);
}



}  // ax::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {


void AutomationInterceptorForTesting::DispatchTreeDestroyedEvent(const ::ui::AXTreeID& tree_id) {
  GetForwardingInterface()->DispatchTreeDestroyedEvent(
    std::move(tree_id)
    );
}
void AutomationInterceptorForTesting::DispatchActionResult(const ::ui::AXActionData& data, bool result) {
  GetForwardingInterface()->DispatchActionResult(
    std::move(data)
    , 
    std::move(result)
    );
}
void AutomationInterceptorForTesting::DispatchAccessibilityEvents(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const ::gfx::Point& mouse_location, const std::vector<::ui::AXEvent>& events) {
  GetForwardingInterface()->DispatchAccessibilityEvents(
    std::move(tree_id)
    , 
    std::move(updates)
    , 
    std::move(mouse_location)
    , 
    std::move(events)
    );
}
void AutomationInterceptorForTesting::DispatchAccessibilityLocationChange(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::ui::AXRelativeBounds& bounds) {
  GetForwardingInterface()->DispatchAccessibilityLocationChange(
    std::move(tree_id)
    , 
    std::move(node_id)
    , 
    std::move(bounds)
    );
}
void AutomationInterceptorForTesting::DispatchAccessibilityScrollChange(const ::ui::AXTreeID& tree_id, int32_t node_id, int32_t scroll_x, int32_t scroll_y) {
  GetForwardingInterface()->DispatchAccessibilityScrollChange(
    std::move(tree_id)
    , 
    std::move(node_id)
    , 
    std::move(scroll_x)
    , 
    std::move(scroll_y)
    );
}
AutomationAsyncWaiter::AutomationAsyncWaiter(
    Automation* proxy) : proxy_(proxy) {}

AutomationAsyncWaiter::~AutomationAsyncWaiter() = default;







}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif