// services/accessibility/public/mojom/accessibility_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/accessibility/public/mojom/accessibility_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/accessibility/public/mojom/accessibility_service.mojom-params-data.h"
#include "services/accessibility/public/mojom/accessibility_service.mojom-shared-message-ids.h"

#include "services/accessibility/public/mojom/accessibility_service.mojom-import-headers.h"
#include "services/accessibility/public/mojom/accessibility_service.mojom-test-utils.h"


namespace ax::mojom {
// The declaration includes the definition on other builds.

AccessibilityService::IPCStableHashFunction AccessibilityService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AccessibilityService>(message.name())) {
    case messages::AccessibilityService::kBindAccessibilityServiceClient: {
      return &AccessibilityService::BindAccessibilityServiceClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AccessibilityService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AccessibilityService>(message.name())) {
      case messages::AccessibilityService::kBindAccessibilityServiceClient:
            return "Receive ax::mojom::AccessibilityService::BindAccessibilityServiceClient";
    }
  } else {
    switch (static_cast<messages::AccessibilityService>(message.name())) {
      case messages::AccessibilityService::kBindAccessibilityServiceClient:
            return "Receive reply ax::mojom::AccessibilityService::BindAccessibilityServiceClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AccessibilityService::BindAccessibilityServiceClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a847fa9;  // IPCStableHash for ax::mojom::AccessibilityService::BindAccessibilityServiceClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AccessibilityServiceProxy::AccessibilityServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AccessibilityServiceProxy::BindAccessibilityServiceClient(
    ::mojo::PendingRemote<AccessibilityServiceClient> in_accessibility_service_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::AccessibilityService::BindAccessibilityServiceClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessibility_service_client"), in_accessibility_service_client,
                        "<value of type ::mojo::PendingRemote<AccessibilityServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AccessibilityService::kBindAccessibilityServiceClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::AccessibilityService_BindAccessibilityServiceClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::ax::mojom::AccessibilityServiceClientInterfaceBase>>(
    in_accessibility_service_client,
    &params->accessibility_service_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->accessibility_service_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid accessibility_service_client in AccessibilityService.BindAccessibilityServiceClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AccessibilityService::Name_);
  message.set_method_name("BindAccessibilityServiceClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AccessibilityServiceStubDispatch::Accept(
    AccessibilityService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AccessibilityService>(message->header()->name)) {
    case messages::AccessibilityService::kBindAccessibilityServiceClient: {
      DCHECK(message->is_serialized());
      internal::AccessibilityService_BindAccessibilityServiceClient_Params_Data* params =
          reinterpret_cast<internal::AccessibilityService_BindAccessibilityServiceClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AccessibilityService.0
      bool success = true;
      ::mojo::PendingRemote<AccessibilityServiceClient> p_accessibility_service_client{};
      AccessibilityService_BindAccessibilityServiceClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_accessibility_service_client =
            input_data_view.TakeAccessibilityServiceClient<decltype(p_accessibility_service_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AccessibilityService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAccessibilityServiceClient(        
        std::move(p_accessibility_service_client));
      return true;
    }
  }
  return false;
}

// static
bool AccessibilityServiceStubDispatch::AcceptWithResponder(
    AccessibilityService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AccessibilityService>(message->header()->name)) {
    case messages::AccessibilityService::kBindAccessibilityServiceClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAccessibilityServiceValidationInfo[] = {
    { &internal::AccessibilityService_BindAccessibilityServiceClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool AccessibilityServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ax::mojom::AccessibilityService::Name_,
    kAccessibilityServiceValidationInfo);
}

// The declaration includes the definition on other builds.

AccessibilityServiceClient::IPCStableHashFunction AccessibilityServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AccessibilityServiceClient>(message.name())) {
    case messages::AccessibilityServiceClient::kBindAutomation: {
      return &AccessibilityServiceClient::BindAutomation_Sym::IPCStableHash;
    }
    case messages::AccessibilityServiceClient::kBindAutomationClient: {
      return &AccessibilityServiceClient::BindAutomationClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AccessibilityServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AccessibilityServiceClient>(message.name())) {
      case messages::AccessibilityServiceClient::kBindAutomation:
            return "Receive ax::mojom::AccessibilityServiceClient::BindAutomation";
      case messages::AccessibilityServiceClient::kBindAutomationClient:
            return "Receive ax::mojom::AccessibilityServiceClient::BindAutomationClient";
    }
  } else {
    switch (static_cast<messages::AccessibilityServiceClient>(message.name())) {
      case messages::AccessibilityServiceClient::kBindAutomation:
            return "Receive reply ax::mojom::AccessibilityServiceClient::BindAutomation";
      case messages::AccessibilityServiceClient::kBindAutomationClient:
            return "Receive reply ax::mojom::AccessibilityServiceClient::BindAutomationClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AccessibilityServiceClient::BindAutomation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe647d08;  // IPCStableHash for ax::mojom::AccessibilityServiceClient::BindAutomation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AccessibilityServiceClient::BindAutomationClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8bbca3b;  // IPCStableHash for ax::mojom::AccessibilityServiceClient::BindAutomationClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AccessibilityServiceClientProxy::AccessibilityServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AccessibilityServiceClientProxy::BindAutomation(
    ::mojo::PendingAssociatedRemote<::ax::mojom::Automation> in_automation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::AccessibilityServiceClient::BindAutomation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("automation"), in_automation,
                        "<value of type ::mojo::PendingAssociatedRemote<::ax::mojom::Automation>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AccessibilityServiceClient::kBindAutomation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::AccessibilityServiceClient_BindAutomation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ax::mojom::AutomationAssociatedPtrInfoDataView>(
    in_automation,
    &params->automation,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->automation)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid automation in AccessibilityServiceClient.BindAutomation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AccessibilityServiceClient::Name_);
  message.set_method_name("BindAutomation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AccessibilityServiceClientProxy::BindAutomationClient(
    ::mojo::PendingReceiver<::ax::mojom::AutomationClient> in_automation_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ax::mojom::AccessibilityServiceClient::BindAutomationClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("automation_client"), in_automation_client,
                        "<value of type ::mojo::PendingReceiver<::ax::mojom::AutomationClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AccessibilityServiceClient::kBindAutomationClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ax::mojom::internal::AccessibilityServiceClient_BindAutomationClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ax::mojom::AutomationClientInterfaceBase>>(
    in_automation_client,
    &params->automation_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->automation_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid automation_client in AccessibilityServiceClient.BindAutomationClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AccessibilityServiceClient::Name_);
  message.set_method_name("BindAutomationClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AccessibilityServiceClientStubDispatch::Accept(
    AccessibilityServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AccessibilityServiceClient>(message->header()->name)) {
    case messages::AccessibilityServiceClient::kBindAutomation: {
      DCHECK(message->is_serialized());
      internal::AccessibilityServiceClient_BindAutomation_Params_Data* params =
          reinterpret_cast<internal::AccessibilityServiceClient_BindAutomation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AccessibilityServiceClient.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<::ax::mojom::Automation> p_automation{};
      AccessibilityServiceClient_BindAutomation_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_automation =
            input_data_view.TakeAutomation<decltype(p_automation)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AccessibilityServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAutomation(        
        std::move(p_automation));
      return true;
    }
    case messages::AccessibilityServiceClient::kBindAutomationClient: {
      DCHECK(message->is_serialized());
      internal::AccessibilityServiceClient_BindAutomationClient_Params_Data* params =
          reinterpret_cast<internal::AccessibilityServiceClient_BindAutomationClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AccessibilityServiceClient.1
      bool success = true;
      ::mojo::PendingReceiver<::ax::mojom::AutomationClient> p_automation_client{};
      AccessibilityServiceClient_BindAutomationClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_automation_client =
            input_data_view.TakeAutomationClient<decltype(p_automation_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AccessibilityServiceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAutomationClient(        
        std::move(p_automation_client));
      return true;
    }
  }
  return false;
}

// static
bool AccessibilityServiceClientStubDispatch::AcceptWithResponder(
    AccessibilityServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AccessibilityServiceClient>(message->header()->name)) {
    case messages::AccessibilityServiceClient::kBindAutomation: {
      break;
    }
    case messages::AccessibilityServiceClient::kBindAutomationClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAccessibilityServiceClientValidationInfo[] = {
    { &internal::AccessibilityServiceClient_BindAutomation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AccessibilityServiceClient_BindAutomationClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool AccessibilityServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ax::mojom::AccessibilityServiceClient::Name_,
    kAccessibilityServiceClientValidationInfo);
}



}  // ax::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {


void AccessibilityServiceInterceptorForTesting::BindAccessibilityServiceClient(::mojo::PendingRemote<AccessibilityServiceClient> accessibility_service_client) {
  GetForwardingInterface()->BindAccessibilityServiceClient(
    std::move(accessibility_service_client)
    );
}
AccessibilityServiceAsyncWaiter::AccessibilityServiceAsyncWaiter(
    AccessibilityService* proxy) : proxy_(proxy) {}

AccessibilityServiceAsyncWaiter::~AccessibilityServiceAsyncWaiter() = default;





void AccessibilityServiceClientInterceptorForTesting::BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) {
  GetForwardingInterface()->BindAutomation(
    std::move(automation)
    );
}
void AccessibilityServiceClientInterceptorForTesting::BindAutomationClient(::mojo::PendingReceiver<::ax::mojom::AutomationClient> automation_client) {
  GetForwardingInterface()->BindAutomationClient(
    std::move(automation_client)
    );
}
AccessibilityServiceClientAsyncWaiter::AccessibilityServiceClientAsyncWaiter(
    AccessibilityServiceClient* proxy) : proxy_(proxy) {}

AccessibilityServiceClientAsyncWaiter::~AccessibilityServiceClientAsyncWaiter() = default;







}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif