// printing/mojom/printing_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "printing/mojom/printing_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/mojom/printing_context.mojom-params-data.h"
#include "printing/mojom/printing_context.mojom-shared-message-ids.h"

#include "printing/mojom/printing_context.mojom-import-headers.h"
#include "printing/mojom/printing_context.mojom-test-utils.h"


namespace printing::mojom {
PageMargins::PageMargins()
    : header(),
      footer(),
      left(),
      right(),
      top(),
      bottom() {}

PageMargins::PageMargins(
    int32_t header_in,
    int32_t footer_in,
    int32_t left_in,
    int32_t right_in,
    int32_t top_in,
    int32_t bottom_in)
    : header(std::move(header_in)),
      footer(std::move(footer_in)),
      left(std::move(left_in)),
      right(std::move(right_in)),
      top(std::move(top_in)),
      bottom(std::move(bottom_in)) {}

PageMargins::~PageMargins() = default;

void PageMargins::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "footer"), this->footer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left"), this->left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right"), this->right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top"), this->top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom"), this->bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageMargins::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageSetup::PageSetup()
    : physical_size(),
      printable_area(),
      overlay_area(),
      content_area(),
      effective_margins(),
      requested_margins(),
      forced_margins(),
      text_height() {}

PageSetup::PageSetup(
    const ::gfx::Size& physical_size_in,
    const ::gfx::Rect& printable_area_in,
    const ::gfx::Rect& overlay_area_in,
    const ::gfx::Rect& content_area_in,
    const ::printing::PageMargins& effective_margins_in,
    const ::printing::PageMargins& requested_margins_in,
    bool forced_margins_in,
    int32_t text_height_in)
    : physical_size(std::move(physical_size_in)),
      printable_area(std::move(printable_area_in)),
      overlay_area(std::move(overlay_area_in)),
      content_area(std::move(content_area_in)),
      effective_margins(std::move(effective_margins_in)),
      requested_margins(std::move(requested_margins_in)),
      forced_margins(std::move(forced_margins_in)),
      text_height(std::move(text_height_in)) {}

PageSetup::~PageSetup() = default;

void PageSetup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_size"), this->physical_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area"), this->printable_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_area"), this->overlay_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_area"), this->content_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_margins"), this->effective_margins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PageMargins&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_margins"), this->requested_margins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PageMargins&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forced_margins"), this->forced_margins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_height"), this->text_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageSetup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestedMedia::RequestedMedia()
    : size_microns(),
      vendor_id() {}

RequestedMedia::RequestedMedia(
    const ::gfx::Size& size_microns_in,
    const std::string& vendor_id_in)
    : size_microns(std::move(size_microns_in)),
      vendor_id(std::move(vendor_id_in)) {}

RequestedMedia::~RequestedMedia() = default;

void RequestedMedia::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_microns"), this->size_microns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestedMedia::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintSettings::PrintSettings()
    : ranges(),
      selection_only(),
      margin_type(),
      title(),
      url(),
      display_header_footer(),
      should_print_backgrounds(),
      collate(),
      color(),
      copies(),
      duplex_mode(),
      device_name(),
      requested_media(),
      page_setup_device_units(),
      borderless(),
      media_type(),
      dpi(),
      scale_factor(),
      rasterize_pdf(),
      landscape(),
      is_modifiable(),
      requested_custom_margins_in_microns(),
      pages_per_sheet(),
      system_print_dialog_data() {}

PrintSettings::PrintSettings(
    std::vector<::printing::PageRange> ranges_in,
    bool selection_only_in,
    ::printing::mojom::MarginType margin_type_in,
    const ::std::u16string& title_in,
    const ::std::u16string& url_in,
    bool display_header_footer_in,
    bool should_print_backgrounds_in,
    bool collate_in,
    ::printing::mojom::ColorModel color_in,
    int32_t copies_in,
    ::printing::mojom::DuplexMode duplex_mode_in,
    const ::std::u16string& device_name_in,
    const ::printing::PrintSettings::RequestedMedia& requested_media_in,
    const ::printing::PageSetup& page_setup_device_units_in,
    bool borderless_in,
    const std::string& media_type_in,
    const ::gfx::Size& dpi_in,
    double scale_factor_in,
    bool rasterize_pdf_in,
    bool landscape_in,
    bool is_modifiable_in,
    const ::printing::PageMargins& requested_custom_margins_in_microns_in,
    int32_t pages_per_sheet_in,
    ::base::Value::Dict system_print_dialog_data_in)
    : ranges(std::move(ranges_in)),
      selection_only(std::move(selection_only_in)),
      margin_type(std::move(margin_type_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      display_header_footer(std::move(display_header_footer_in)),
      should_print_backgrounds(std::move(should_print_backgrounds_in)),
      collate(std::move(collate_in)),
      color(std::move(color_in)),
      copies(std::move(copies_in)),
      duplex_mode(std::move(duplex_mode_in)),
      device_name(std::move(device_name_in)),
      requested_media(std::move(requested_media_in)),
      page_setup_device_units(std::move(page_setup_device_units_in)),
      borderless(std::move(borderless_in)),
      media_type(std::move(media_type_in)),
      dpi(std::move(dpi_in)),
      scale_factor(std::move(scale_factor_in)),
      rasterize_pdf(std::move(rasterize_pdf_in)),
      landscape(std::move(landscape_in)),
      is_modifiable(std::move(is_modifiable_in)),
      requested_custom_margins_in_microns(std::move(requested_custom_margins_in_microns_in)),
      pages_per_sheet(std::move(pages_per_sheet_in)),
      system_print_dialog_data(std::move(system_print_dialog_data_in)) {}

PrintSettings::~PrintSettings() = default;

void PrintSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ranges"), this->ranges,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::printing::PageRange>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_only"), this->selection_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_type"), this->margin_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::MarginType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_header_footer"), this->display_header_footer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_print_backgrounds"), this->should_print_backgrounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collate"), this->collate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::ColorModel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies"), this->copies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex_mode"), this->duplex_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::DuplexMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_name"), this->device_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_media"), this->requested_media,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PrintSettings::RequestedMedia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_setup_device_units"), this->page_setup_device_units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PageSetup&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "borderless"), this->borderless,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_type"), this->media_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dpi"), this->dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_pdf"), this->rasterize_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "landscape"), this->landscape,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_modifiable"), this->is_modifiable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_custom_margins_in_microns"), this->requested_custom_margins_in_microns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PageMargins&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_per_sheet"), this->pages_per_sheet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_print_dialog_data"), this->system_print_dialog_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::Dict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // printing::mojom


namespace mojo {


// static
bool StructTraits<::printing::mojom::PageMargins::DataView, ::printing::mojom::PageMarginsPtr>::Read(
    ::printing::mojom::PageMargins::DataView input,
    ::printing::mojom::PageMarginsPtr* output) {
  bool success = true;
  ::printing::mojom::PageMarginsPtr result(::printing::mojom::PageMargins::New());
  
      if (success)
        result->header = input.header();
      if (success)
        result->footer = input.footer();
      if (success)
        result->left = input.left();
      if (success)
        result->right = input.right();
      if (success)
        result->top = input.top();
      if (success)
        result->bottom = input.bottom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PageSetup::DataView, ::printing::mojom::PageSetupPtr>::Read(
    ::printing::mojom::PageSetup::DataView input,
    ::printing::mojom::PageSetupPtr* output) {
  bool success = true;
  ::printing::mojom::PageSetupPtr result(::printing::mojom::PageSetup::New());
  
      if (success && !input.ReadPhysicalSize(&result->physical_size))
        success = false;
      if (success && !input.ReadPrintableArea(&result->printable_area))
        success = false;
      if (success && !input.ReadOverlayArea(&result->overlay_area))
        success = false;
      if (success && !input.ReadContentArea(&result->content_area))
        success = false;
      if (success && !input.ReadEffectiveMargins(&result->effective_margins))
        success = false;
      if (success && !input.ReadRequestedMargins(&result->requested_margins))
        success = false;
      if (success)
        result->forced_margins = input.forced_margins();
      if (success)
        result->text_height = input.text_height();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::RequestedMedia::DataView, ::printing::mojom::RequestedMediaPtr>::Read(
    ::printing::mojom::RequestedMedia::DataView input,
    ::printing::mojom::RequestedMediaPtr* output) {
  bool success = true;
  ::printing::mojom::RequestedMediaPtr result(::printing::mojom::RequestedMedia::New());
  
      if (success && !input.ReadSizeMicrons(&result->size_microns))
        success = false;
      if (success && !input.ReadVendorId(&result->vendor_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintSettings::DataView, ::printing::mojom::PrintSettingsPtr>::Read(
    ::printing::mojom::PrintSettings::DataView input,
    ::printing::mojom::PrintSettingsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintSettingsPtr result(::printing::mojom::PrintSettings::New());
  
      if (success && !input.ReadRanges(&result->ranges))
        success = false;
      if (success)
        result->selection_only = input.selection_only();
      if (success && !input.ReadMarginType(&result->margin_type))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->display_header_footer = input.display_header_footer();
      if (success)
        result->should_print_backgrounds = input.should_print_backgrounds();
      if (success)
        result->collate = input.collate();
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success)
        result->copies = input.copies();
      if (success && !input.ReadDuplexMode(&result->duplex_mode))
        success = false;
      if (success && !input.ReadDeviceName(&result->device_name))
        success = false;
      if (success && !input.ReadRequestedMedia(&result->requested_media))
        success = false;
      if (success && !input.ReadPageSetupDeviceUnits(&result->page_setup_device_units))
        success = false;
      if (success)
        result->borderless = input.borderless();
      if (success && !input.ReadMediaType(&result->media_type))
        success = false;
      if (success && !input.ReadDpi(&result->dpi))
        success = false;
      if (success)
        result->scale_factor = input.scale_factor();
      if (success)
        result->rasterize_pdf = input.rasterize_pdf();
      if (success)
        result->landscape = input.landscape();
      if (success)
        result->is_modifiable = input.is_modifiable();
      if (success && !input.ReadRequestedCustomMarginsInMicrons(&result->requested_custom_margins_in_microns))
        success = false;
      if (success)
        result->pages_per_sheet = input.pages_per_sheet();
      if (success && !input.ReadSystemPrintDialogData(&result->system_print_dialog_data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {




}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif