// printing/mojom/print.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINT_MOJOM_DATA_VIEW_H_
#define PRINTING_MOJOM_PRINT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "printing/mojom/print.mojom-shared-internal.h"


namespace printing::mojom {
class PageSizeMarginsDataView;

class PageRangeDataView;



}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PageSizeMarginsDataView> {
  using Data = ::printing::mojom::internal::PageSizeMargins_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PageRangeDataView> {
  using Data = ::printing::mojom::internal::PageRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class ColorModel : int32_t {
  
  kUnknownColorModel = 0,
  
  kGray = 1,
  
  kColor = 2,
  
  kCMYK = 3,
  
  kCMY = 4,
  
  kKCMY = 5,
  
  kCMYPlusK = 6,
  
  kBlack = 7,
  
  kGrayscale = 8,
  
  kRGB = 9,
  
  kRGB16 = 10,
  
  kRGBA = 11,
  
  kColorModeColor = 12,
  
  kColorModeMonochrome = 13,
  
  kHPColorColor = 14,
  
  kHPColorBlack = 15,
  
  kPrintoutModeNormal = 16,
  
  kPrintoutModeNormalGray = 17,
  
  kProcessColorModelCMYK = 18,
  
  kProcessColorModelGreyscale = 19,
  
  kProcessColorModelRGB = 20,
  
  kBrotherCUPSColor = 21,
  
  kBrotherCUPSMono = 22,
  
  kBrotherBRScript3Color = 23,
  
  kBrotherBRScript3Black = 24,
  
  kEpsonInkColor = 25,
  
  kEpsonInkMono = 26,
  
  kSharpARCModeCMColor = 27,
  
  kSharpARCModeCMBW = 28,
  
  kXeroxXRXColorAutomatic = 29,
  
  kXeroxXRXColorBW = 30,
  
  kCanonCNColorModeColor = 31,
  
  kCanonCNColorModeMono = 32,
  
  kCanonCNIJGrayScaleOne = 33,
  
  kCanonCNIJGrayScaleZero = 34,
  
  kKonicaMinoltaSelectColorColor = 35,
  
  kKonicaMinoltaSelectColorGrayscale = 36,
  
  kOkiOKControlColor = 37,
  
  kOkiOKControlGray = 38,
  
  kXeroxXROutputColorPrintAsColor = 39,
  
  kXeroxXROutputColorPrintAsGrayscale = 40,
  
  kHpPjlColorAsGrayNo = 41,
  
  kHpPjlColorAsGrayYes = 42,
  kMinValue = 0,
  kMaxValue = 42,
};

 std::ostream& operator<<(std::ostream& os, ColorModel value);
inline bool IsKnownEnumValue(ColorModel value) {
  return internal::ColorModel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DuplexMode : int32_t {
  
  kUnknownDuplexMode = -1,
  
  kSimplex = 0,
  
  kLongEdge = 1,
  
  kShortEdge = 2,
  kMinValue = -1,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DuplexMode value);
inline bool IsKnownEnumValue(DuplexMode value) {
  return internal::DuplexMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PageOrientation : int32_t {
  
  kUpright = 0,
  
  kRotateLeft = 1,
  
  kRotateRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PageOrientation value);
inline bool IsKnownEnumValue(PageOrientation value) {
  return internal::PageOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrintScalingOption : int32_t {
  
  kNone = 0,
  
  kFitToPrintableArea = 1,
  
  kSourceSize = 2,
  
  kFitToPaper = 3,
  
  kCenterShrinkToFitPaper = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PrintScalingOption value);
inline bool IsKnownEnumValue(PrintScalingOption value) {
  return internal::PrintScalingOption_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SkiaDocumentType : int32_t {
  
  kPDF = 0,
  
  kMSKP = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SkiaDocumentType value);
inline bool IsKnownEnumValue(SkiaDocumentType value) {
  return internal::SkiaDocumentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MetafileDataType : int32_t {
  
  kPDF = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, MetafileDataType value);
inline bool IsKnownEnumValue(MetafileDataType value) {
  return internal::MetafileDataType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GenerateDocumentOutline : int32_t {
  
  kNone = 0,
  
  kFromAccessibilityTreeHeaders = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GenerateDocumentOutline value);
inline bool IsKnownEnumValue(GenerateDocumentOutline value) {
  return internal::GenerateDocumentOutline_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MarginType : int32_t {
  
  kDefaultMargins = 0,
  
  kNoMargins = 1,
  
  kPrintableAreaMargins = 2,
  
  kCustomMargins = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MarginType value);
inline bool IsKnownEnumValue(MarginType value) {
  return internal::MarginType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResultCode : int32_t {
  
  kSuccess = 0,
  
  kFailed = 1,
  
  kAccessDenied = 2,
  
  kCanceled = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ResultCode value);
inline bool IsKnownEnumValue(ResultCode value) {
  return internal::ResultCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrinterType : int32_t {
  
  kExtension = 0,
  
  kPdf = 1,
  
  kLocal = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PrinterType value);
inline bool IsKnownEnumValue(PrinterType value) {
  return internal::PrinterType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PageSizeMarginsDataView {
 public:
  PageSizeMarginsDataView() = default;

  PageSizeMarginsDataView(
      internal::PageSizeMargins_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double content_width() const {
    return data_->content_width;
  }
  double content_height() const {
    return data_->content_height;
  }
  double margin_top() const {
    return data_->margin_top;
  }
  double margin_right() const {
    return data_->margin_right;
  }
  double margin_bottom() const {
    return data_->margin_bottom;
  }
  double margin_left() const {
    return data_->margin_left;
  }
 private:
  internal::PageSizeMargins_Data* data_ = nullptr;
};


class PageRangeDataView {
 public:
  PageRangeDataView() = default;

  PageRangeDataView(
      internal::PageRange_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t from() const {
    return data_->from;
  }
  uint32_t to() const {
    return data_->to;
  }
 private:
  internal::PageRange_Data* data_ = nullptr;
};


}  // printing::mojom

#endif  // PRINTING_MOJOM_PRINT_MOJOM_DATA_VIEW_H_