// pdf/mojom/pdf.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PDF_MOJOM_PDF_MOJOM_H_
#define PDF_MOJOM_PDF_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "pdf/mojom/pdf.mojom-features.h"  // IWYU pragma: export
#include "pdf/mojom/pdf.mojom-shared.h"  // IWYU pragma: export
#include "pdf/mojom/pdf.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace pdf::mojom {

class SaveDataBufferHandlerProxy;

template <typename ImplRefTraits>
class SaveDataBufferHandlerStub;

class SaveDataBufferHandlerRequestValidator;
class SaveDataBufferHandlerResponseValidator;


class SaveDataBufferHandler
    : public SaveDataBufferHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "pdf.mojom.SaveDataBufferHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SaveDataBufferHandlerInterfaceBase;
  using Proxy_ = SaveDataBufferHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SaveDataBufferHandlerStub<ImplRefTraits>;

  using RequestValidator_ = SaveDataBufferHandlerRequestValidator;
  using ResponseValidator_ = SaveDataBufferHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SaveDataBufferHandler() = default;

  using ReadCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;
  using ReadMojoCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;

  virtual void Read(uint32_t offset, uint32_t block_size, ReadCallback callback) = 0;
};

class PdfListenerProxy;

template <typename ImplRefTraits>
class PdfListenerStub;

class PdfListenerRequestValidator;
class PdfListenerResponseValidator;


class PdfListener
    : public PdfListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "pdf.mojom.PdfListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfListenerInterfaceBase;
  using Proxy_ = PdfListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfListenerStub<ImplRefTraits>;

  using RequestValidator_ = PdfListenerRequestValidator;
  using ResponseValidator_ = PdfListenerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetCaretPositionMinVersion = 0,
    kMoveRangeSelectionExtentMinVersion = 0,
    kSetSelectionBoundsMinVersion = 0,
    kGetPdfBytesMinVersion = 0,
    kGetPageTextMinVersion = 0,
    kGetMostVisiblePageIndexMinVersion = 0,
    kGetSaveDataBufferHandlerForDriveMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCaretPosition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveRangeSelectionExtent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSelectionBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPdfBytes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPageText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMostVisiblePageIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSaveDataBufferHandlerForDrive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using GetPdfBytesStatus = PdfListener_GetPdfBytesStatus;
  virtual ~PdfListener() = default;

  virtual void SetCaretPosition(const ::gfx::PointF& position) = 0;

  virtual void MoveRangeSelectionExtent(const ::gfx::PointF& extent) = 0;

  virtual void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) = 0;

  using GetPdfBytesCallback = base::OnceCallback<void(PdfListener::GetPdfBytesStatus, const std::vector<uint8_t>&, uint32_t)>;
  using GetPdfBytesMojoCallback = base::OnceCallback<void(PdfListener::GetPdfBytesStatus, const std::vector<uint8_t>&, uint32_t)>;

  virtual void GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) = 0;

  using GetPageTextCallback = base::OnceCallback<void(const ::std::u16string&)>;
  using GetPageTextMojoCallback = base::OnceCallback<void(const ::std::u16string&)>;

  virtual void GetPageText(int32_t page_index, GetPageTextCallback callback) = 0;

  using GetMostVisiblePageIndexCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using GetMostVisiblePageIndexMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) = 0;

  using GetSaveDataBufferHandlerForDriveCallback = base::OnceCallback<void(SaveDataBufferHandlerGetResultPtr)>;
  using GetSaveDataBufferHandlerForDriveMojoCallback = base::OnceCallback<void(SaveDataBufferHandlerGetResultPtr)>;

  virtual void GetSaveDataBufferHandlerForDrive(SaveRequestType request_type, GetSaveDataBufferHandlerForDriveCallback callback) = 0;
};

class PdfHostProxy;

template <typename ImplRefTraits>
class PdfHostStub;

class PdfHostRequestValidator;


class PdfHost
    : public PdfHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "pdf.mojom.PdfHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfHostInterfaceBase;
  using Proxy_ = PdfHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfHostStub<ImplRefTraits>;

  using RequestValidator_ = PdfHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetListenerMinVersion = 0,
    kOnDocumentLoadCompleteMinVersion = 0,
    kUpdateContentRestrictionsMinVersion = 0,
    kSaveUrlAsMinVersion = 0,
    kSelectionChangedMinVersion = 0,
    kSetPluginCanSaveMinVersion = 0,
    kOnSearchifyStartedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDocumentLoadComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateContentRestrictions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveUrlAs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPluginCanSave_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSearchifyStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PdfHost() = default;

  virtual void SetListener(::mojo::PendingRemote<PdfListener> client) = 0;

  virtual void OnDocumentLoadComplete() = 0;

  virtual void UpdateContentRestrictions(int32_t restrictions) = 0;

  virtual void SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) = 0;

  virtual void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) = 0;

  virtual void SetPluginCanSave(bool can_save) = 0;

  virtual void OnSearchifyStarted() = 0;
};



class  SaveDataBufferHandlerProxy
    : public SaveDataBufferHandler {
 public:
  using InterfaceType = SaveDataBufferHandler;

  explicit SaveDataBufferHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(uint32_t offset, uint32_t block_size, ReadCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PdfListenerProxy
    : public PdfListener {
 public:
  using InterfaceType = PdfListener;

  explicit PdfListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCaretPosition(const ::gfx::PointF& position) final;
  
  void MoveRangeSelectionExtent(const ::gfx::PointF& extent) final;
  
  void SetSelectionBounds(const ::gfx::PointF& base, const ::gfx::PointF& extent) final;
  
  void GetPdfBytes(uint32_t size_limit, GetPdfBytesCallback callback) final;
  
  void GetPageText(int32_t page_index, GetPageTextCallback callback) final;
  
  void GetMostVisiblePageIndex(GetMostVisiblePageIndexCallback callback) final;
  
  void GetSaveDataBufferHandlerForDrive(SaveRequestType request_type, GetSaveDataBufferHandlerForDriveCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PdfHostProxy
    : public PdfHost {
 public:
  using InterfaceType = PdfHost;

  explicit PdfHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetListener(::mojo::PendingRemote<PdfListener> client) final;
  
  void OnDocumentLoadComplete() final;
  
  void UpdateContentRestrictions(int32_t restrictions) final;
  
  void SaveUrlAs(const ::GURL& url, ::network::mojom::ReferrerPolicy policy) final;
  
  void SelectionChanged(const ::gfx::PointF& left, int32_t left_height, const ::gfx::PointF& right, int32_t right_height) final;
  
  void SetPluginCanSave(bool can_save) final;
  
  void OnSearchifyStarted() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SaveDataBufferHandlerStubDispatch {
 public:
  static bool Accept(SaveDataBufferHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SaveDataBufferHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SaveDataBufferHandler>>
class SaveDataBufferHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SaveDataBufferHandlerStub() = default;
  ~SaveDataBufferHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveDataBufferHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SaveDataBufferHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfListenerStubDispatch {
 public:
  static bool Accept(PdfListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfListener>>
class PdfListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfListenerStub() = default;
  ~PdfListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfHostStubDispatch {
 public:
  static bool Accept(PdfHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfHost>>
class PdfHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfHostStub() = default;
  ~PdfHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SaveDataBufferHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SaveDataBufferHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfListenerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SaveDataBufferHandlerGetResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SaveDataBufferHandlerGetResult, T>::value>;
  using DataView = SaveDataBufferHandlerGetResultDataView;
  using Data_ = internal::SaveDataBufferHandlerGetResult_Data;

  template <typename... Args>
  static SaveDataBufferHandlerGetResultPtr New(Args&&... args) {
    return SaveDataBufferHandlerGetResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SaveDataBufferHandlerGetResultPtr From(const U& u) {
    return mojo::TypeConverter<SaveDataBufferHandlerGetResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SaveDataBufferHandlerGetResult>::Convert(*this);
  }


  SaveDataBufferHandlerGetResult();

  SaveDataBufferHandlerGetResult(
      ::mojo::PendingRemote<SaveDataBufferHandler> handler,
      uint32_t total_file_size);

SaveDataBufferHandlerGetResult(const SaveDataBufferHandlerGetResult&) = delete;
SaveDataBufferHandlerGetResult& operator=(const SaveDataBufferHandlerGetResult&) = delete;

  ~SaveDataBufferHandlerGetResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SaveDataBufferHandlerGetResultPtr>
  SaveDataBufferHandlerGetResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SaveDataBufferHandlerGetResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SaveDataBufferHandlerGetResult_UnserializedMessageContext<
            UserType, SaveDataBufferHandlerGetResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SaveDataBufferHandlerGetResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SaveDataBufferHandlerGetResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SaveDataBufferHandlerGetResult_UnserializedMessageContext<
            UserType, SaveDataBufferHandlerGetResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SaveDataBufferHandlerGetResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<SaveDataBufferHandler> handler;
  
  uint32_t total_file_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SaveDataBufferHandlerGetResultPtr SaveDataBufferHandlerGetResult::Clone() const {
  return New(
      mojo::Clone(handler),
      mojo::Clone(total_file_size)
  );
}

template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>*>
bool SaveDataBufferHandlerGetResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->handler, other_struct.handler))
    return false;
  if (!mojo::Equals(this->total_file_size, other_struct.total_file_size))
    return false;
  return true;
}

template <typename T, SaveDataBufferHandlerGetResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.handler < rhs.handler)
    return true;
  if (rhs.handler < lhs.handler)
    return false;
  if (lhs.total_file_size < rhs.total_file_size)
    return true;
  if (rhs.total_file_size < lhs.total_file_size)
    return false;
  return false;
}


}  // pdf::mojom

namespace mojo {


template <>
struct  StructTraits<::pdf::mojom::SaveDataBufferHandlerGetResult::DataView,
                                         ::pdf::mojom::SaveDataBufferHandlerGetResultPtr> {
  static bool IsNull(const ::pdf::mojom::SaveDataBufferHandlerGetResultPtr& input) { return !input; }
  static void SetToNull(::pdf::mojom::SaveDataBufferHandlerGetResultPtr* output) { output->reset(); }

  static  decltype(::pdf::mojom::SaveDataBufferHandlerGetResult::handler)& handler(
       ::pdf::mojom::SaveDataBufferHandlerGetResultPtr& input) {
    return input->handler;
  }

  static decltype(::pdf::mojom::SaveDataBufferHandlerGetResult::total_file_size) total_file_size(
      const ::pdf::mojom::SaveDataBufferHandlerGetResultPtr& input) {
    return input->total_file_size;
  }

  static bool Read(::pdf::mojom::SaveDataBufferHandlerGetResult::DataView input, ::pdf::mojom::SaveDataBufferHandlerGetResultPtr* output);
};

}  // namespace mojo

#endif  // PDF_MOJOM_PDF_MOJOM_H_