// owl/mojom/web_view_group.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_SHARED_H_
#define OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view_group.mojom-shared-internal.h"
#include "owl/mojom/web_view.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/web_view_group.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::GroupScopedWebViewSource>
    : public mojo::internal::EnumHashImpl<::owl::mojom::GroupScopedWebViewSource> {};

template <>
struct hash<::owl::mojom::NavigationValidationResult>
    : public mojo::internal::EnumHashImpl<::owl::mojom::NavigationValidationResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::GroupScopedWebViewSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::GroupScopedWebViewSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::GroupScopedWebViewSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NavigationValidationResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::NavigationValidationResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::NavigationValidationResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateWebViewInitializationData_InitialDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreateWebViewInitializationData_InitialDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreateWebViewInitializationData_InitialData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CreateWebViewInitializationData_InitialData struct");

    
    mojo::internal::Serialize<::owl::mojom::NavigationType>(
      Traits::navigation_type(input),
      &fragment->navigation_type);

    decltype(Traits::additional_headers(input)) in_additional_headers = Traits::additional_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_headers)::BaseType> additional_headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_additional_headers,
      additional_headers_fragment);

    fragment->additional_headers.Set(
        additional_headers_fragment.is_null() ? nullptr : additional_headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->additional_headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_headers in CreateWebViewInitializationData_InitialData struct");
  }

  static bool Deserialize(::owl::mojom::internal::CreateWebViewInitializationData_InitialData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateWebViewInitializationData_InitialDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreateWebViewInitializationData_RestoreData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::session_data(input)) in_session_data = Traits::session_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_data)::BaseType>
        session_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_session_data,
      session_data_fragment,
      &session_data_validate_params);

    fragment->session_data.Set(
        session_data_fragment.is_null() ? nullptr : session_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_data in CreateWebViewInitializationData_RestoreData struct");
    fragment->navigation_index_override_$flag = Traits::navigation_index_override(input).has_value();
    if (Traits::navigation_index_override(input).has_value()) {
      fragment->navigation_index_override_$value = Traits::navigation_index_override(input).value();
    }
  }

  static bool Deserialize(::owl::mojom::internal::CreateWebViewInitializationData_RestoreData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateWebViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreateWebViewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreateWebViewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->foreground = Traits::foreground(input);

    decltype(Traits::initialization_data(input)) in_initialization_data = Traits::initialization_data(input);
    mojo::internal::MessageFragment<decltype(fragment->initialization_data)>
        initialization_data_fragment(fragment.message());
    initialization_data_fragment.Claim(&fragment->initialization_data);
    
    mojo::internal::Serialize<::owl::mojom::CreateWebViewInitializationDataDataView>(
      in_initialization_data,
      initialization_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initialization_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initialization_data in CreateWebViewParams struct");

    decltype(Traits::initial_storage_partition(input)) in_initial_storage_partition = Traits::initial_storage_partition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_storage_partition)::BaseType> initial_storage_partition_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::StoragePartitionDescriptorDataView>(
      in_initial_storage_partition,
      initial_storage_partition_fragment);

    fragment->initial_storage_partition.Set(
        initial_storage_partition_fragment.is_null() ? nullptr : initial_storage_partition_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::CreateWebViewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateWebViewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreatedWebViewDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CreatedWebViewDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CreatedWebViewDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->web_content_id = Traits::web_content_id(input);
  }

  static bool Deserialize(::owl::mojom::internal::CreatedWebViewDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreatedWebViewDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateWebViewInitializationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::CreateWebViewInitializationDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::CreateWebViewInitializationData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::CreateWebViewInitializationDataDataView::Tag::kInitialData: {
    decltype(Traits::initial_data(input))
    in_initial_data = Traits::initial_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_initial_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::CreateWebViewInitializationData_InitialDataDataView>(
  in_initial_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null initial_data in CreateWebViewInitializationData union");
    fragment->data.f_initial_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::CreateWebViewInitializationDataDataView::Tag::kRestoreData: {
    decltype(Traits::restore_data(input))
    in_restore_data = Traits::restore_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_restore_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::CreateWebViewInitializationData_RestoreDataDataView>(
  in_restore_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null restore_data in CreateWebViewInitializationData union");
    fragment->data.f_restore_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::CreateWebViewInitializationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateWebViewInitializationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CreateWebViewResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::CreateWebViewResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::CreateWebViewResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::CreateWebViewResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in CreateWebViewResult union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::CreateWebViewResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::CreatedWebViewDetailsDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in CreateWebViewResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::owl::mojom::internal::CreateWebViewResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CreateWebViewResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void CreateWebViewInitializationData_InitialDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CreateWebViewInitializationData_InitialDataDataView::GetAdditionalHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->additional_headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CreateWebViewInitializationData_RestoreDataDataView::GetSessionDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->session_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void CreateWebViewParamsDataView::GetInitializationDataDataView(
    CreateWebViewInitializationDataDataView* output) {
  auto pointer = &data_->initialization_data;
  *output = CreateWebViewInitializationDataDataView(pointer, message_);
}
inline void CreateWebViewParamsDataView::GetInitialStoragePartitionDataView(
    ::owl::mojom::StoragePartitionDescriptorDataView* output) {
  auto pointer = data_->initial_storage_partition.Get();
  *output = ::owl::mojom::StoragePartitionDescriptorDataView(pointer, message_);
}




inline void CreateWebViewInitializationDataDataView::GetInitialDataDataView(
    CreateWebViewInitializationData_InitialDataDataView* output) const {
  CHECK(is_initial_data());
  *output = CreateWebViewInitializationData_InitialDataDataView(data_->data.f_initial_data.Get(), message_);
}
inline void CreateWebViewInitializationDataDataView::GetRestoreDataDataView(
    CreateWebViewInitializationData_RestoreDataDataView* output) const {
  CHECK(is_restore_data());
  *output = CreateWebViewInitializationData_RestoreDataDataView(data_->data.f_restore_data.Get(), message_);
}

inline void CreateWebViewResultDataView::GetFailureDataView(
    mojo::StringDataView* output) const {
  CHECK(is_failure());
  *output = mojo::StringDataView(data_->data.f_failure.Get(), message_);
}
inline void CreateWebViewResultDataView::GetSuccessDataView(
    CreatedWebViewDetailsDataView* output) const {
  CHECK(is_success());
  *output = CreatedWebViewDetailsDataView(data_->data.f_success.Get(), message_);
}


}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::GroupScopedWebViewSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::GroupScopedWebViewSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::NavigationValidationResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::NavigationValidationResult value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_SHARED_H_