// owl/mojom/web_view_group.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/web_view_group.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view_group.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* GroupScopedWebViewSourceToStringHelper(GroupScopedWebViewSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GroupScopedWebViewSource::kNewTab:
      return "kNewTab";
    default:
      return nullptr;
  }
}

std::string GroupScopedWebViewSourceToString(GroupScopedWebViewSource value) {
  const char *str = GroupScopedWebViewSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GroupScopedWebViewSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GroupScopedWebViewSource value) {
  return os << GroupScopedWebViewSourceToString(value);
}

NOINLINE static const char* NavigationValidationResultToStringHelper(NavigationValidationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationValidationResult::kAllow:
      return "kAllow";
    case NavigationValidationResult::kDeny:
      return "kDeny";
    default:
      return nullptr;
  }
}

std::string NavigationValidationResultToString(NavigationValidationResult value) {
  const char *str = NavigationValidationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationValidationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationValidationResult value) {
  return os << NavigationValidationResultToString(value);
}

namespace internal {
// static
bool CreateWebViewInitializationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateWebViewInitializationData_Data* object = static_cast<const CreateWebViewInitializationData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateWebViewInitializationData_Tag::kInitialData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_initial_data, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_initial_data, validation_context))
        return false;
      return true;
    }
    case CreateWebViewInitializationData_Tag::kRestoreData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_restore_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_restore_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateWebViewInitializationData");
      return false;
    }
  }
}
// static
bool CreateWebViewResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateWebViewResult_Data* object = static_cast<const CreateWebViewResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateWebViewResult_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& failure_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_failure, validation_context,
                                             &failure_validate_params)) {
        return false;
      }
      return true;
    }
    case CreateWebViewResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateWebViewResult");
      return false;
    }
  }
}


// static
bool CreateWebViewInitializationData_InitialData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateWebViewInitializationData_InitialData_Data* object =
      static_cast<const CreateWebViewInitializationData_InitialData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::owl::mojom::internal::NavigationType_Data
        ::Validate(object->navigation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_headers, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& additional_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->additional_headers, validation_context,
                                         &additional_headers_validate_params)) {
    return false;
  }

  return true;
}

CreateWebViewInitializationData_InitialData_Data::CreateWebViewInitializationData_InitialData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateWebViewInitializationData_RestoreData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateWebViewInitializationData_RestoreData_Data* object =
      static_cast<const CreateWebViewInitializationData_RestoreData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_data, validation_context,
                                         &session_data_validate_params)) {
    return false;
  }

  return true;
}

CreateWebViewInitializationData_RestoreData_Data::CreateWebViewInitializationData_RestoreData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateWebViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateWebViewParams_Data* object =
      static_cast<const CreateWebViewParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->initialization_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->initialization_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initial_storage_partition, validation_context))
    return false;

  return true;
}

CreateWebViewParams_Data::CreateWebViewParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreatedWebViewDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreatedWebViewDetails_Data* object =
      static_cast<const CreatedWebViewDetails_Data*>(data);

  return true;
}

CreatedWebViewDetails_Data::CreatedWebViewDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroup_CreateWebView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroup_CreateWebView_Params_Data* object =
      static_cast<const WebViewGroup_CreateWebView_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewGroup_CreateWebView_Params_Data::WebViewGroup_CreateWebView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroup_CreateWebView_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroup_CreateWebView_ResponseParams_Data* object =
      static_cast<const WebViewGroup_CreateWebView_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebViewGroup_CreateWebView_ResponseParams_Data::WebViewGroup_CreateWebView_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroup_TabStripDidBecomeActive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroup_TabStripDidBecomeActive_Params_Data* object =
      static_cast<const WebViewGroup_TabStripDidBecomeActive_Params_Data*>(data);

  return true;
}

WebViewGroup_TabStripDidBecomeActive_Params_Data::WebViewGroup_TabStripDidBecomeActive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroup_EnableNavigationValidation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroup_EnableNavigationValidation_Params_Data* object =
      static_cast<const WebViewGroup_EnableNavigationValidation_Params_Data*>(data);

  return true;
}

WebViewGroup_EnableNavigationValidation_Params_Data::WebViewGroup_EnableNavigationValidation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroup_EnableAgentModeRestrictions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroup_EnableAgentModeRestrictions_Params_Data* object =
      static_cast<const WebViewGroup_EnableAgentModeRestrictions_Params_Data*>(data);

  return true;
}

WebViewGroup_EnableAgentModeRestrictions_Params_Data::WebViewGroup_EnableAgentModeRestrictions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroupClient_OpenChromeURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroupClient_OpenChromeURL_Params_Data* object =
      static_cast<const WebViewGroupClient_OpenChromeURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebViewGroupClient_OpenChromeURL_Params_Data::WebViewGroupClient_OpenChromeURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroupClient_CreatedNewWebView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroupClient_CreatedNewWebView_Params_Data* object =
      static_cast<const WebViewGroupClient_CreatedNewWebView_Params_Data*>(data);


  if (!::owl::mojom::internal::GroupScopedWebViewSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_view, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_view,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_view_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_view_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewGroupClient_CreatedNewWebView_Params_Data::WebViewGroupClient_CreatedNewWebView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroupClient_ValidateNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroupClient_ValidateNavigation_Params_Data* object =
      static_cast<const WebViewGroupClient_ValidateNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebViewGroupClient_ValidateNavigation_Params_Data::WebViewGroupClient_ValidateNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewGroupClient_ValidateNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewGroupClient_ValidateNavigation_ResponseParams_Data* object =
      static_cast<const WebViewGroupClient_ValidateNavigation_ResponseParams_Data*>(data);


  if (!::owl::mojom::internal::NavigationValidationResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebViewGroupClient_ValidateNavigation_ResponseParams_Data::WebViewGroupClient_ValidateNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::GroupScopedWebViewSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::GroupScopedWebViewSource value) {
  return std::move(context).WriteString(::owl::mojom::GroupScopedWebViewSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::NavigationValidationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::NavigationValidationResult value) {
  return std::move(context).WriteString(::owl::mojom::NavigationValidationResultToString(value));
}

} // namespace perfetto