// owl/mojom/web_view_container_view.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_CONTAINER_VIEW_MOJOM_H_
#define OWL_MOJOM_WEB_VIEW_CONTAINER_VIEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view_container_view.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_view_container_view.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_view_container_view.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/ca_layer_params.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class LayerHostProxy;

template <typename ImplRefTraits>
class LayerHostStub;

class LayerHostRequestValidator;


class LayerHost
    : public LayerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.LayerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerHostInterfaceBase;
  using Proxy_ = LayerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerHostStub<ImplRefTraits>;

  using RequestValidator_ = LayerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetGeometryMinVersion = 0,
    kSetDisplayIdMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetGeometry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDisplayId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerHost() = default;

  virtual void SetGeometry(const std::optional<::gfx::Rect>& window_frame_in_screen_dip, const ::gfx::Rect& view_bounds_in_window_dip) = 0;

  virtual void SetDisplayId(int64_t id) = 0;
};

class WebViewContainerViewProxy;

template <typename ImplRefTraits>
class WebViewContainerViewStub;

class WebViewContainerViewRequestValidator;


class WebViewContainerView
    : public WebViewContainerViewInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebViewContainerView";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewContainerViewInterfaceBase;
  using Proxy_ = WebViewContainerViewProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewContainerViewStub<ImplRefTraits>;

  using RequestValidator_ = WebViewContainerViewRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetWebViewMinVersion = 0,
    kSetVisibleMinVersion = 0,
    kDestroyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetWebView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebViewContainerView() = default;

  virtual void SetWebView(std::optional<uint64_t> web_content_id) = 0;

  virtual void SetVisible(bool value) = 0;

  virtual void Destroy() = 0;
};

class LayerHostClientProxy;

template <typename ImplRefTraits>
class LayerHostClientStub;

class LayerHostClientRequestValidator;


class LayerHostClient
    : public LayerHostClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.LayerHostClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerHostClientInterfaceBase;
  using Proxy_ = LayerHostClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerHostClientStub<ImplRefTraits>;

  using RequestValidator_ = LayerHostClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCALayerParamsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCALayerParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerHostClient() = default;

  virtual void SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) = 0;
};



class  LayerHostProxy
    : public LayerHost {
 public:
  using InterfaceType = LayerHost;

  explicit LayerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetGeometry(const std::optional<::gfx::Rect>& window_frame_in_screen_dip, const ::gfx::Rect& view_bounds_in_window_dip) final;
  
  void SetDisplayId(int64_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebViewContainerViewProxy
    : public WebViewContainerView {
 public:
  using InterfaceType = WebViewContainerView;

  explicit WebViewContainerViewProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetWebView(std::optional<uint64_t> web_content_id) final;
  
  void SetVisible(bool value) final;
  
  void Destroy() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LayerHostClientProxy
    : public LayerHostClient {
 public:
  using InterfaceType = LayerHostClient;

  explicit LayerHostClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LayerHostStubDispatch {
 public:
  static bool Accept(LayerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerHost>>
class LayerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerHostStub() = default;
  ~LayerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewContainerViewStubDispatch {
 public:
  static bool Accept(WebViewContainerView* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebViewContainerView* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebViewContainerView>>
class WebViewContainerViewStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewContainerViewStub() = default;
  ~WebViewContainerViewStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewContainerViewStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewContainerViewStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LayerHostClientStubDispatch {
 public:
  static bool Accept(LayerHostClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerHostClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerHostClient>>
class LayerHostClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerHostClientStub() = default;
  ~LayerHostClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerHostClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerHostClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LayerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewContainerViewRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LayerHostClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // owl::mojom

namespace mojo {

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_VIEW_CONTAINER_VIEW_MOJOM_H_