// owl/mojom/web_content_renderer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/web_content_renderer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_content_renderer.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* OverscrollTypeToStringHelper(OverscrollType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OverscrollType::kNone:
      return "kNone";
    case OverscrollType::kAuto:
      return "kAuto";
    case OverscrollType::kContain:
      return "kContain";
    default:
      return nullptr;
  }
}

std::string OverscrollTypeToString(OverscrollType value) {
  const char *str = OverscrollTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OverscrollType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OverscrollType value) {
  return os << OverscrollTypeToString(value);
}

namespace internal {


// static
bool RectWithRange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RectWithRange_Data* object =
      static_cast<const RectWithRange_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

RectWithRange_Data::RectWithRange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenu_Data* object =
      static_cast<const PopupMenu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PopupMenu_Data::PopupMenu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_IsWidgetForMainFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_IsWidgetForMainFrame_Params_Data* object =
      static_cast<const WebContentRenderer_IsWidgetForMainFrame_Params_Data*>(data);

  return true;
}

WebContentRenderer_IsWidgetForMainFrame_Params_Data::WebContentRenderer_IsWidgetForMainFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data*>(data);

  return true;
}

WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_RequestShutdown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_RequestShutdown_Params_Data* object =
      static_cast<const WebContentRenderer_RequestShutdown_Params_Data*>(data);

  return true;
}

WebContentRenderer_RequestShutdown_Params_Data::WebContentRenderer_RequestShutdown_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_SetFocusLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_SetFocusLock_Params_Data* object =
      static_cast<const WebContentRenderer_SetFocusLock_Params_Data*>(data);

  return true;
}

WebContentRenderer_SetFocusLock_Params_Data::WebContentRenderer_SetFocusLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_OnFirstResponderChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_OnFirstResponderChanged_Params_Data* object =
      static_cast<const WebContentRenderer_OnFirstResponderChanged_Params_Data*>(data);

  return true;
}

WebContentRenderer_OnFirstResponderChanged_Params_Data::WebContentRenderer_OnFirstResponderChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_OnWindowIsKeyChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_OnWindowIsKeyChanged_Params_Data* object =
      static_cast<const WebContentRenderer_OnWindowIsKeyChanged_Params_Data*>(data);

  return true;
}

WebContentRenderer_OnWindowIsKeyChanged_Params_Data::WebContentRenderer_OnWindowIsKeyChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_BeginKeyboardEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_BeginKeyboardEvent_Params_Data* object =
      static_cast<const WebContentRenderer_BeginKeyboardEvent_Params_Data*>(data);

  return true;
}

WebContentRenderer_BeginKeyboardEvent_Params_Data::WebContentRenderer_BeginKeyboardEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_EndKeyboardEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_EndKeyboardEvent_Params_Data* object =
      static_cast<const WebContentRenderer_EndKeyboardEvent_Params_Data*>(data);

  return true;
}

WebContentRenderer_EndKeyboardEvent_Params_Data::WebContentRenderer_EndKeyboardEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data* object =
      static_cast<const WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_event_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_event_data, validation_context,
                                         &native_event_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->commands, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->commands, validation_context,
                                         &commands_validate_params)) {
    return false;
  }

  return true;
}

WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data::WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data* object =
      static_cast<const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_event_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_event_data, validation_context,
                                         &native_event_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->commands, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->commands, validation_context,
                                         &commands_validate_params)) {
    return false;
  }

  return true;
}

WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data*>(data);

  return true;
}

WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_RouteOrProcessMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_RouteOrProcessMouseEvent_Params_Data* object =
      static_cast<const WebContentRenderer_RouteOrProcessMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_RouteOrProcessMouseEvent_Params_Data::WebContentRenderer_RouteOrProcessMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_RouteOrProcessTouchEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_RouteOrProcessTouchEvent_Params_Data* object =
      static_cast<const WebContentRenderer_RouteOrProcessTouchEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_RouteOrProcessTouchEvent_Params_Data::WebContentRenderer_RouteOrProcessTouchEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_RouteOrProcessWheelEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_RouteOrProcessWheelEvent_Params_Data* object =
      static_cast<const WebContentRenderer_RouteOrProcessWheelEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_RouteOrProcessWheelEvent_Params_Data::WebContentRenderer_RouteOrProcessWheelEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GestureBegin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GestureBegin_Params_Data* object =
      static_cast<const WebContentRenderer_GestureBegin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_GestureBegin_Params_Data::WebContentRenderer_GestureBegin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GestureUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GestureUpdate_Params_Data* object =
      static_cast<const WebContentRenderer_GestureUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_GestureUpdate_Params_Data::WebContentRenderer_GestureUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GestureEnd_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GestureEnd_Params_Data* object =
      static_cast<const WebContentRenderer_GestureEnd_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_GestureEnd_Params_Data::WebContentRenderer_GestureEnd_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_SmartMagnify_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_SmartMagnify_Params_Data* object =
      static_cast<const WebContentRenderer_SmartMagnify_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRenderer_SmartMagnify_Params_Data::WebContentRenderer_SmartMagnify_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ImeSetComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ImeSetComposition_Params_Data* object =
      static_cast<const WebContentRenderer_ImeSetComposition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement_range, validation_context))
    return false;

  return true;
}

WebContentRenderer_ImeSetComposition_Params_Data::WebContentRenderer_ImeSetComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ImeCommitText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ImeCommitText_Params_Data* object =
      static_cast<const WebContentRenderer_ImeCommitText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_range, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement_range, validation_context))
    return false;

  return true;
}

WebContentRenderer_ImeCommitText_Params_Data::WebContentRenderer_ImeCommitText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ImeFinishComposingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ImeFinishComposingText_Params_Data* object =
      static_cast<const WebContentRenderer_ImeFinishComposingText_Params_Data*>(data);

  return true;
}

WebContentRenderer_ImeFinishComposingText_Params_Data::WebContentRenderer_ImeFinishComposingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ImeCancelCompositionFromClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ImeCancelCompositionFromClient_Params_Data* object =
      static_cast<const WebContentRenderer_ImeCancelCompositionFromClient_Params_Data*>(data);

  return true;
}

WebContentRenderer_ImeCancelCompositionFromClient_Params_Data::WebContentRenderer_ImeCancelCompositionFromClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data* object =
      static_cast<const WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_point, validation_context))
    return false;

  return true;
}

WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data::WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data* object =
      static_cast<const WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data::WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetCharacterIndexAtPoint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetCharacterIndexAtPoint_Params_Data* object =
      static_cast<const WebContentRenderer_GetCharacterIndexAtPoint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_point, validation_context))
    return false;

  return true;
}

WebContentRenderer_GetCharacterIndexAtPoint_Params_Data::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data*>(data);

  return true;
}

WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetFirstRectForRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetFirstRectForRange_Params_Data* object =
      static_cast<const WebContentRenderer_GetFirstRectForRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_range, validation_context))
    return false;

  return true;
}

WebContentRenderer_GetFirstRectForRange_Params_Data::WebContentRenderer_GetFirstRectForRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetFirstRectForRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetFirstRectForRange_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_GetFirstRectForRange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

WebContentRenderer_GetFirstRectForRange_ResponseParams_Data::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_ExecuteEditCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_ExecuteEditCommand_Params_Data* object =
      static_cast<const WebContentRenderer_ExecuteEditCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->command, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& command_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->command, validation_context,
                                         &command_validate_params)) {
    return false;
  }

  return true;
}

WebContentRenderer_ExecuteEditCommand_Params_Data::WebContentRenderer_ExecuteEditCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_Undo_Params_Data* object =
      static_cast<const WebContentRenderer_Undo_Params_Data*>(data);

  return true;
}

WebContentRenderer_Undo_Params_Data::WebContentRenderer_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_Redo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_Redo_Params_Data* object =
      static_cast<const WebContentRenderer_Redo_Params_Data*>(data);

  return true;
}

WebContentRenderer_Redo_Params_Data::WebContentRenderer_Redo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_Cut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_Cut_Params_Data* object =
      static_cast<const WebContentRenderer_Cut_Params_Data*>(data);

  return true;
}

WebContentRenderer_Cut_Params_Data::WebContentRenderer_Cut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_Copy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_Copy_Params_Data* object =
      static_cast<const WebContentRenderer_Copy_Params_Data*>(data);

  return true;
}

WebContentRenderer_Copy_Params_Data::WebContentRenderer_Copy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_CopyToFindPboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_CopyToFindPboard_Params_Data* object =
      static_cast<const WebContentRenderer_CopyToFindPboard_Params_Data*>(data);

  return true;
}

WebContentRenderer_CopyToFindPboard_Params_Data::WebContentRenderer_CopyToFindPboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_CenterSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_CenterSelection_Params_Data* object =
      static_cast<const WebContentRenderer_CenterSelection_Params_Data*>(data);

  return true;
}

WebContentRenderer_CenterSelection_Params_Data::WebContentRenderer_CenterSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_Paste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_Paste_Params_Data* object =
      static_cast<const WebContentRenderer_Paste_Params_Data*>(data);

  return true;
}

WebContentRenderer_Paste_Params_Data::WebContentRenderer_Paste_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_PasteAndMatchStyle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_PasteAndMatchStyle_Params_Data* object =
      static_cast<const WebContentRenderer_PasteAndMatchStyle_Params_Data*>(data);

  return true;
}

WebContentRenderer_PasteAndMatchStyle_Params_Data::WebContentRenderer_PasteAndMatchStyle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_SelectAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_SelectAll_Params_Data* object =
      static_cast<const WebContentRenderer_SelectAll_Params_Data*>(data);

  return true;
}

WebContentRenderer_SelectAll_Params_Data::WebContentRenderer_SelectAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_StartSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_StartSpeaking_Params_Data* object =
      static_cast<const WebContentRenderer_StartSpeaking_Params_Data*>(data);

  return true;
}

WebContentRenderer_StartSpeaking_Params_Data::WebContentRenderer_StartSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_StopSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_StopSpeaking_Params_Data* object =
      static_cast<const WebContentRenderer_StopSpeaking_Params_Data*>(data);

  return true;
}

WebContentRenderer_StopSpeaking_Params_Data::WebContentRenderer_StopSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_IsSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_IsSpeaking_Params_Data* object =
      static_cast<const WebContentRenderer_IsSpeaking_Params_Data*>(data);

  return true;
}

WebContentRenderer_IsSpeaking_Params_Data::WebContentRenderer_IsSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_IsSpeaking_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_IsSpeaking_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_IsSpeaking_ResponseParams_Data*>(data);

  return true;
}

WebContentRenderer_IsSpeaking_ResponseParams_Data::WebContentRenderer_IsSpeaking_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data* object =
      static_cast<const WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data*>(data);

  return true;
}

WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data::WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_pid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& element_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->element_token, validation_context,
                                         &element_token_validate_params)) {
    return false;
  }

  return true;
}

WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data::WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data* object =
      static_cast<const WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_token, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& window_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->window_token, validation_context,
                                         &window_token_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& view_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->view_token, validation_context,
                                         &view_token_validate_params)) {
    return false;
  }

  return true;
}

WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data::WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_PingHostView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_PingHostView_Params_Data* object =
      static_cast<const WebContentRenderer_PingHostView_Params_Data*>(data);

  return true;
}

WebContentRenderer_PingHostView_Params_Data::WebContentRenderer_PingHostView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRenderer_PingHostView_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRenderer_PingHostView_ResponseParams_Data* object =
      static_cast<const WebContentRenderer_PingHostView_ResponseParams_Data*>(data);

  return true;
}

WebContentRenderer_PingHostView_ResponseParams_Data::WebContentRenderer_PingHostView_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuRunner_Hide_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenuRunner_Hide_Params_Data* object =
      static_cast<const PopupMenuRunner_Hide_Params_Data*>(data);

  return true;
}

PopupMenuRunner_Hide_Params_Data::PopupMenuRunner_Hide_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_InitAsPopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_InitAsPopup_Params_Data* object =
      static_cast<const WebContentRendererClient_InitAsPopup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->layer_host_remote, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->layer_host_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->layer_host_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->layer_host_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebContentRendererClient_InitAsPopup_Params_Data::WebContentRendererClient_InitAsPopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetPopupBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetPopupBounds_Params_Data* object =
      static_cast<const WebContentRendererClient_SetPopupBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

WebContentRendererClient_SetPopupBounds_Params_Data::WebContentRendererClient_SetPopupBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_TakeFocus_Params_Data* object =
      static_cast<const WebContentRendererClient_TakeFocus_Params_Data*>(data);

  return true;
}

WebContentRendererClient_TakeFocus_Params_Data::WebContentRendererClient_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetVisible_Params_Data* object =
      static_cast<const WebContentRendererClient_SetVisible_Params_Data*>(data);

  return true;
}

WebContentRendererClient_SetVisible_Params_Data::WebContentRendererClient_SetVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetTooltipText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetTooltipText_Params_Data* object =
      static_cast<const WebContentRendererClient_SetTooltipText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_text, validation_context))
    return false;

  return true;
}

WebContentRendererClient_SetTooltipText_Params_Data::WebContentRendererClient_SetTooltipText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetTextInputState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetTextInputState_Params_Data* object =
      static_cast<const WebContentRendererClient_SetTextInputState_Params_Data*>(data);


  if (!::ui::mojom::internal::TextInputType_Data
        ::Validate(object->text_input_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->edit_context_selection_bounds, validation_context))
    return false;

  return true;
}

WebContentRendererClient_SetTextInputState_Params_Data::WebContentRendererClient_SetTextInputState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetTextSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetTextSelection_Params_Data* object =
      static_cast<const WebContentRendererClient_SetTextSelection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

WebContentRendererClient_SetTextSelection_Params_Data::WebContentRendererClient_SetTextSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetCompositionRangeInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetCompositionRangeInfo_Params_Data* object =
      static_cast<const WebContentRendererClient_SetCompositionRangeInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

WebContentRendererClient_SetCompositionRangeInfo_Params_Data::WebContentRendererClient_SetCompositionRangeInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_CancelComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_CancelComposition_Params_Data* object =
      static_cast<const WebContentRendererClient_CancelComposition_Params_Data*>(data);

  return true;
}

WebContentRendererClient_CancelComposition_Params_Data::WebContentRendererClient_CancelComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_OnSelectionBoundsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_OnSelectionBoundsChanged_Params_Data* object =
      static_cast<const WebContentRendererClient_OnSelectionBoundsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->focus_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->focus_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->anchor_rect, validation_context))
    return false;

  return true;
}

WebContentRendererClient_OnSelectionBoundsChanged_Params_Data::WebContentRendererClient_OnSelectionBoundsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetShowingContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetShowingContextMenu_Params_Data* object =
      static_cast<const WebContentRendererClient_SetShowingContextMenu_Params_Data*>(data);

  return true;
}

WebContentRendererClient_SetShowingContextMenu_Params_Data::WebContentRendererClient_SetShowingContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_DisplayCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_DisplayCursor_Params_Data* object =
      static_cast<const WebContentRendererClient_DisplayCursor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cursor, validation_context))
    return false;

  return true;
}

WebContentRendererClient_DisplayCursor_Params_Data::WebContentRendererClient_DisplayCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetCursorLocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetCursorLocked_Params_Data* object =
      static_cast<const WebContentRendererClient_SetCursorLocked_Params_Data*>(data);

  return true;
}

WebContentRendererClient_SetCursorLocked_Params_Data::WebContentRendererClient_SetCursorLocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data* object =
      static_cast<const WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data*>(data);

  return true;
}

WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data::WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data* object =
      static_cast<const WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data*>(data);

  return true;
}

WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data::WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_ShowDictionaryOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_ShowDictionaryOverlay_Params_Data* object =
      static_cast<const WebContentRendererClient_ShowDictionaryOverlay_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributed_string, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attributed_string, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->baseline_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->baseline_point, validation_context))
    return false;

  return true;
}

WebContentRendererClient_ShowDictionaryOverlay_Params_Data::WebContentRendererClient_ShowDictionaryOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_LockKeyboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_LockKeyboard_Params_Data* object =
      static_cast<const WebContentRendererClient_LockKeyboard_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& dom_codes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dom_codes, validation_context,
                                         &dom_codes_validate_params)) {
    return false;
  }

  return true;
}

WebContentRendererClient_LockKeyboard_Params_Data::WebContentRendererClient_LockKeyboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_UnlockKeyboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_UnlockKeyboard_Params_Data* object =
      static_cast<const WebContentRendererClient_UnlockKeyboard_Params_Data*>(data);

  return true;
}

WebContentRendererClient_UnlockKeyboard_Params_Data::WebContentRendererClient_UnlockKeyboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_ShowSharingServicePicker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_ShowSharingServicePicker_Params_Data* object =
      static_cast<const WebContentRendererClient_ShowSharingServicePicker_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->file_paths, validation_context,
                                         &file_paths_validate_params)) {
    return false;
  }

  return true;
}

WebContentRendererClient_ShowSharingServicePicker_Params_Data::WebContentRendererClient_ShowSharingServicePicker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data* object =
      static_cast<const WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ShareError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data::WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_Destroy_Params_Data* object =
      static_cast<const WebContentRendererClient_Destroy_Params_Data*>(data);

  return true;
}

WebContentRendererClient_Destroy_Params_Data::WebContentRendererClient_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_GestureScrollEventAck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_GestureScrollEventAck_Params_Data* object =
      static_cast<const WebContentRendererClient_GestureScrollEventAck_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContentRendererClient_GestureScrollEventAck_Params_Data::WebContentRendererClient_GestureScrollEventAck_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_DidOverscroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_DidOverscroll_Params_Data* object =
      static_cast<const WebContentRendererClient_DidOverscroll_Params_Data*>(data);


  if (!::owl::mojom::internal::OverscrollType_Data
        ::Validate(object->x, validation_context))
    return false;


  if (!::owl::mojom::internal::OverscrollType_Data
        ::Validate(object->y, validation_context))
    return false;

  return true;
}

WebContentRendererClient_DidOverscroll_Params_Data::WebContentRendererClient_DidOverscroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_DisplayPopupMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_DisplayPopupMenu_Params_Data* object =
      static_cast<const WebContentRendererClient_DisplayPopupMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->menu, validation_context))
    return false;

  return true;
}

WebContentRendererClient_DisplayPopupMenu_Params_Data::WebContentRendererClient_DisplayPopupMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data* object =
      static_cast<const WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data*>(data);

  return true;
}

WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data::WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::OverscrollType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::OverscrollType value) {
  return std::move(context).WriteString(::owl::mojom::OverscrollTypeToString(value));
}

} // namespace perfetto