// owl/mojom/web_content.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_content.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_content.mojom-params-data.h"
#include "owl/mojom/web_content.mojom-shared-message-ids.h"

#include "owl/mojom/web_content.mojom-import-headers.h"
#include "owl/mojom/web_content.mojom-test-utils.h"
#include "ui/events/mojom/event_mojom_traits.h"


namespace owl::mojom {
FileSystemFileInfo::FileSystemFileInfo()
    : url(),
      size(),
      filesystem_id() {}

FileSystemFileInfo::FileSystemFileInfo(
    const ::GURL& url_in,
    int64_t size_in,
    const std::string& filesystem_id_in)
    : url(std::move(url_in)),
      size(std::move(size_in)),
      filesystem_id(std::move(filesystem_id_in)) {}

FileSystemFileInfo::~FileSystemFileInfo() = default;

void FileSystemFileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filesystem_id"), this->filesystem_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DropData::DropData()
    : url(),
      url_title(),
      download_metadata(),
      referrer_policy(),
      filenames(),
      file_mime_types(),
      filesystem_id(),
      file_system_files(),
      text(),
      html(),
      html_base_url(),
      file_contents(),
      file_contents_image_accessible(),
      file_contents_source_url(),
      file_contents_filename_extension(),
      file_contents_content_disposition(),
      custom_data(),
      operation(),
      document_is_handling_drag() {}

DropData::DropData(
    const std::optional<::GURL>& url_in,
    const std::optional<std::string>& url_title_in,
    const std::optional<std::string>& download_metadata_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    std::vector<::base::FilePath> filenames_in,
    std::vector<std::string> file_mime_types_in,
    const std::optional<std::string>& filesystem_id_in,
    std::vector<FileSystemFileInfoPtr> file_system_files_in,
    const std::optional<std::string>& text_in,
    const std::optional<std::string>& html_in,
    const std::optional<::GURL>& html_base_url_in,
    std::optional<std::vector<uint8_t>> file_contents_in,
    bool file_contents_image_accessible_in,
    const std::optional<::GURL>& file_contents_source_url_in,
    const std::string& file_contents_filename_extension_in,
    const std::string& file_contents_content_disposition_in,
    const base::flat_map<std::string, std::string>& custom_data_in,
    ::ui::mojom::DragOperation operation_in,
    bool document_is_handling_drag_in)
    : url(std::move(url_in)),
      url_title(std::move(url_title_in)),
      download_metadata(std::move(download_metadata_in)),
      referrer_policy(std::move(referrer_policy_in)),
      filenames(std::move(filenames_in)),
      file_mime_types(std::move(file_mime_types_in)),
      filesystem_id(std::move(filesystem_id_in)),
      file_system_files(std::move(file_system_files_in)),
      text(std::move(text_in)),
      html(std::move(html_in)),
      html_base_url(std::move(html_base_url_in)),
      file_contents(std::move(file_contents_in)),
      file_contents_image_accessible(std::move(file_contents_image_accessible_in)),
      file_contents_source_url(std::move(file_contents_source_url_in)),
      file_contents_filename_extension(std::move(file_contents_filename_extension_in)),
      file_contents_content_disposition(std::move(file_contents_content_disposition_in)),
      custom_data(std::move(custom_data_in)),
      operation(std::move(operation_in)),
      document_is_handling_drag(std::move(document_is_handling_drag_in)) {}

DropData::~DropData() = default;

void DropData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_title"), this->url_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_metadata"), this->download_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filenames"), this->filenames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_mime_types"), this->file_mime_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filesystem_id"), this->filesystem_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_files"), this->file_system_files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FileSystemFileInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html"), this->html,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html_base_url"), this->html_base_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_contents"), this->file_contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_contents_image_accessible"), this->file_contents_image_accessible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_contents_source_url"), this->file_contents_source_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_contents_filename_extension"), this->file_contents_filename_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_contents_content_disposition"), this->file_contents_content_disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_data"), this->custom_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::DragOperation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_is_handling_drag"), this->document_is_handling_drag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DropData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DraggingInfo::DraggingInfo()
    : location_in_view(),
      location_in_screen(),
      url(),
      operation_mask() {}

DraggingInfo::DraggingInfo(
    const ::gfx::PointF& location_in_view_in,
    const ::gfx::PointF& location_in_screen_in,
    const std::optional<::GURL>& url_in,
    uint64_t operation_mask_in)
    : location_in_view(std::move(location_in_view_in)),
      location_in_screen(std::move(location_in_screen_in)),
      url(std::move(url_in)),
      operation_mask(std::move(operation_mask_in)) {}

DraggingInfo::~DraggingInfo() = default;

void DraggingInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_in_view"), this->location_in_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_in_screen"), this->location_in_screen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation_mask"), this->operation_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DraggingInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebContent::IPCStableHashFunction WebContent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContent>(message.name())) {
    case messages::WebContent::kSetInputMode: {
      return &WebContent::SetInputMode_Sym::IPCStableHash;
    }
    case messages::WebContent::kOnMouseEvent: {
      return &WebContent::OnMouseEvent_Sym::IPCStableHash;
    }
    case messages::WebContent::kOnBecameFirstResponder: {
      return &WebContent::OnBecameFirstResponder_Sym::IPCStableHash;
    }
    case messages::WebContent::kOnWindowVisibilityChanged: {
      return &WebContent::OnWindowVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::WebContent::kDraggingEntered: {
      return &WebContent::DraggingEntered_Sym::IPCStableHash;
    }
    case messages::WebContent::kDraggingExited: {
      return &WebContent::DraggingExited_Sym::IPCStableHash;
    }
    case messages::WebContent::kDraggingUpdated: {
      return &WebContent::DraggingUpdated_Sym::IPCStableHash;
    }
    case messages::WebContent::kPerformDragOperation: {
      return &WebContent::PerformDragOperation_Sym::IPCStableHash;
    }
    case messages::WebContent::kEndDrag: {
      return &WebContent::EndDrag_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContent>(message.name())) {
      case messages::WebContent::kSetInputMode:
            return "Receive owl::mojom::WebContent::SetInputMode";
      case messages::WebContent::kOnMouseEvent:
            return "Receive owl::mojom::WebContent::OnMouseEvent";
      case messages::WebContent::kOnBecameFirstResponder:
            return "Receive owl::mojom::WebContent::OnBecameFirstResponder";
      case messages::WebContent::kOnWindowVisibilityChanged:
            return "Receive owl::mojom::WebContent::OnWindowVisibilityChanged";
      case messages::WebContent::kDraggingEntered:
            return "Receive owl::mojom::WebContent::DraggingEntered";
      case messages::WebContent::kDraggingExited:
            return "Receive owl::mojom::WebContent::DraggingExited";
      case messages::WebContent::kDraggingUpdated:
            return "Receive owl::mojom::WebContent::DraggingUpdated";
      case messages::WebContent::kPerformDragOperation:
            return "Receive owl::mojom::WebContent::PerformDragOperation";
      case messages::WebContent::kEndDrag:
            return "Receive owl::mojom::WebContent::EndDrag";
    }
  } else {
    switch (static_cast<messages::WebContent>(message.name())) {
      case messages::WebContent::kSetInputMode:
            return "Receive reply owl::mojom::WebContent::SetInputMode";
      case messages::WebContent::kOnMouseEvent:
            return "Receive reply owl::mojom::WebContent::OnMouseEvent";
      case messages::WebContent::kOnBecameFirstResponder:
            return "Receive reply owl::mojom::WebContent::OnBecameFirstResponder";
      case messages::WebContent::kOnWindowVisibilityChanged:
            return "Receive reply owl::mojom::WebContent::OnWindowVisibilityChanged";
      case messages::WebContent::kDraggingEntered:
            return "Receive reply owl::mojom::WebContent::DraggingEntered";
      case messages::WebContent::kDraggingExited:
            return "Receive reply owl::mojom::WebContent::DraggingExited";
      case messages::WebContent::kDraggingUpdated:
            return "Receive reply owl::mojom::WebContent::DraggingUpdated";
      case messages::WebContent::kPerformDragOperation:
            return "Receive reply owl::mojom::WebContent::PerformDragOperation";
      case messages::WebContent::kEndDrag:
            return "Receive reply owl::mojom::WebContent::EndDrag";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContent::SetInputMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2c04f32;  // IPCStableHash for owl::mojom::WebContent::SetInputMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::OnMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2943424b;  // IPCStableHash for owl::mojom::WebContent::OnMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::OnBecameFirstResponder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc535f61c;  // IPCStableHash for owl::mojom::WebContent::OnBecameFirstResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::OnWindowVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1018c860;  // IPCStableHash for owl::mojom::WebContent::OnWindowVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::DraggingEntered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53630db8;  // IPCStableHash for owl::mojom::WebContent::DraggingEntered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::DraggingExited_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf258d5c3;  // IPCStableHash for owl::mojom::WebContent::DraggingExited
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::DraggingUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f613992;  // IPCStableHash for owl::mojom::WebContent::DraggingUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::PerformDragOperation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2dcad165;  // IPCStableHash for owl::mojom::WebContent::PerformDragOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContent::EndDrag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84190ebf;  // IPCStableHash for owl::mojom::WebContent::EndDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebContentProxy::WebContentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebContentProxy::SetInputMode(
    InputMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::SetInputMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type InputMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kSetInputMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_SetInputMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::InputMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("SetInputMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::OnMouseEvent(
    ::std::unique_ptr<::ui::Event> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::OnMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::ui::Event>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kOnMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_OnMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContent.OnMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("OnMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::OnBecameFirstResponder(
    WindowSelectionMethod in_method) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::OnBecameFirstResponder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method"), in_method,
                        "<value of type WindowSelectionMethod>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kOnBecameFirstResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_OnBecameFirstResponder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::WindowSelectionMethod>(
    in_method,
    &params->method);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("OnBecameFirstResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::OnWindowVisibilityChanged(
    WindowVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::OnWindowVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type WindowVisibility>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kOnWindowVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_OnWindowVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::WindowVisibility>(
    in_visibility,
    &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("OnWindowVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::DraggingEntered(
    DropDataPtr in_drop_data, DraggingInfoPtr in_dragging_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::DraggingEntered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), in_drop_data,
                        "<value of type DropDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kDraggingEntered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_DraggingEntered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DropDataDataView>(
    in_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContent.DraggingEntered request");
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContent.DraggingEntered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("DraggingEntered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::DraggingExited(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContent::DraggingExited");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kDraggingExited), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_DraggingExited_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("DraggingExited");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::DraggingUpdated(
    DraggingInfoPtr in_dragging_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::DraggingUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kDraggingUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_DraggingUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContent.DraggingUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("DraggingUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::PerformDragOperation(
    DraggingInfoPtr in_dragging_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::PerformDragOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kPerformDragOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_PerformDragOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContent.PerformDragOperation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("PerformDragOperation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentProxy::EndDrag(
    uint64_t in_drag_operation, const ::gfx::PointF& in_local_point, const ::gfx::PointF& in_screen_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContent::EndDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_operation"), in_drag_operation,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_point"), in_local_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContent::kEndDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContent_EndDrag_Params_Data> params(
          message);
  params.Allocate();

  params->drag_operation = in_drag_operation;
  mojo::internal::MessageFragment<
      typename decltype(params->local_point)::BaseType> local_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_local_point,
    local_point_fragment);

  params->local_point.Set(
      local_point_fragment.is_null() ? nullptr : local_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_point in WebContent.EndDrag request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in WebContent.EndDrag request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContent::Name_);
  message.set_method_name("EndDrag");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebContentStubDispatch::Accept(
    WebContent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContent>(message->header()->name)) {
    case messages::WebContent::kSetInputMode: {
      DCHECK(message->is_serialized());
      internal::WebContent_SetInputMode_Params_Data* params =
          reinterpret_cast<internal::WebContent_SetInputMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.0
      bool success = true;
      InputMode p_mode{};
      WebContent_SetInputMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInputMode(        
        std::move(p_mode));
      return true;
    }
    case messages::WebContent::kOnMouseEvent: {
      DCHECK(message->is_serialized());
      internal::WebContent_OnMouseEvent_Params_Data* params =
          reinterpret_cast<internal::WebContent_OnMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.1
      bool success = true;
      ::std::unique_ptr<::ui::Event> p_event{};
      WebContent_OnMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WebContent::kOnBecameFirstResponder: {
      DCHECK(message->is_serialized());
      internal::WebContent_OnBecameFirstResponder_Params_Data* params =
          reinterpret_cast<internal::WebContent_OnBecameFirstResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.2
      bool success = true;
      WindowSelectionMethod p_method{};
      WebContent_OnBecameFirstResponder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethod(&p_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBecameFirstResponder(        
        std::move(p_method));
      return true;
    }
    case messages::WebContent::kOnWindowVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::WebContent_OnWindowVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::WebContent_OnWindowVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.3
      bool success = true;
      WindowVisibility p_visibility{};
      WebContent_OnWindowVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowVisibilityChanged(        
        std::move(p_visibility));
      return true;
    }
    case messages::WebContent::kDraggingEntered: {
      DCHECK(message->is_serialized());
      internal::WebContent_DraggingEntered_Params_Data* params =
          reinterpret_cast<internal::WebContent_DraggingEntered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.4
      bool success = true;
      DropDataPtr p_drop_data{};
      DraggingInfoPtr p_dragging_info{};
      WebContent_DraggingEntered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDropData(&p_drop_data))
        success = false;
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingEntered(        
        std::move(p_drop_data), 
        std::move(p_dragging_info));
      return true;
    }
    case messages::WebContent::kDraggingExited: {
      DCHECK(message->is_serialized());
      internal::WebContent_DraggingExited_Params_Data* params =
          reinterpret_cast<internal::WebContent_DraggingExited_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.5
      bool success = true;
      WebContent_DraggingExited_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingExited(        );
      return true;
    }
    case messages::WebContent::kDraggingUpdated: {
      DCHECK(message->is_serialized());
      internal::WebContent_DraggingUpdated_Params_Data* params =
          reinterpret_cast<internal::WebContent_DraggingUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.6
      bool success = true;
      DraggingInfoPtr p_dragging_info{};
      WebContent_DraggingUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingUpdated(        
        std::move(p_dragging_info));
      return true;
    }
    case messages::WebContent::kPerformDragOperation: {
      DCHECK(message->is_serialized());
      internal::WebContent_PerformDragOperation_Params_Data* params =
          reinterpret_cast<internal::WebContent_PerformDragOperation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.7
      bool success = true;
      DraggingInfoPtr p_dragging_info{};
      WebContent_PerformDragOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformDragOperation(        
        std::move(p_dragging_info));
      return true;
    }
    case messages::WebContent::kEndDrag: {
      DCHECK(message->is_serialized());
      internal::WebContent_EndDrag_Params_Data* params =
          reinterpret_cast<internal::WebContent_EndDrag_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContent.8
      bool success = true;
      uint64_t p_drag_operation{};
      ::gfx::PointF p_local_point{};
      ::gfx::PointF p_screen_point{};
      WebContent_EndDrag_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_drag_operation = input_data_view.drag_operation();
      if (success && !input_data_view.ReadLocalPoint(&p_local_point))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContent::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndDrag(        
        std::move(p_drag_operation), 
        std::move(p_local_point), 
        std::move(p_screen_point));
      return true;
    }
  }
  return false;
}

// static
bool WebContentStubDispatch::AcceptWithResponder(
    WebContent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContent>(message->header()->name)) {
    case messages::WebContent::kSetInputMode: {
      break;
    }
    case messages::WebContent::kOnMouseEvent: {
      break;
    }
    case messages::WebContent::kOnBecameFirstResponder: {
      break;
    }
    case messages::WebContent::kOnWindowVisibilityChanged: {
      break;
    }
    case messages::WebContent::kDraggingEntered: {
      break;
    }
    case messages::WebContent::kDraggingExited: {
      break;
    }
    case messages::WebContent::kDraggingUpdated: {
      break;
    }
    case messages::WebContent::kPerformDragOperation: {
      break;
    }
    case messages::WebContent::kEndDrag: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentValidationInfo[] = {
    { &internal::WebContent_SetInputMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_OnMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_OnBecameFirstResponder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_OnWindowVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_DraggingEntered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_DraggingExited_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_DraggingUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_PerformDragOperation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContent_EndDrag_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebContentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebContent::Name_,
    kWebContentValidationInfo);
}

// The declaration includes the definition on other builds.

WebContentClient::IPCStableHashFunction WebContentClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContentClient>(message.name())) {
    case messages::WebContentClient::kCreateRendererClient: {
      return &WebContentClient::CreateRendererClient_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kTakeFocus: {
      return &WebContentClient::TakeFocus_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kDestroy: {
      return &WebContentClient::Destroy_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kShowContextMenu: {
      return &WebContentClient::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kStartDrag: {
      return &WebContentClient::StartDrag_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kStartNativeDrag: {
      return &WebContentClient::StartNativeDrag_Sym::IPCStableHash;
    }
    case messages::WebContentClient::kUpdateDragOperation: {
      return &WebContentClient::UpdateDragOperation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContentClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContentClient>(message.name())) {
      case messages::WebContentClient::kCreateRendererClient:
            return "Receive owl::mojom::WebContentClient::CreateRendererClient";
      case messages::WebContentClient::kTakeFocus:
            return "Receive owl::mojom::WebContentClient::TakeFocus";
      case messages::WebContentClient::kDestroy:
            return "Receive owl::mojom::WebContentClient::Destroy";
      case messages::WebContentClient::kShowContextMenu:
            return "Receive owl::mojom::WebContentClient::ShowContextMenu";
      case messages::WebContentClient::kStartDrag:
            return "Receive owl::mojom::WebContentClient::StartDrag";
      case messages::WebContentClient::kStartNativeDrag:
            return "Receive owl::mojom::WebContentClient::StartNativeDrag";
      case messages::WebContentClient::kUpdateDragOperation:
            return "Receive owl::mojom::WebContentClient::UpdateDragOperation";
    }
  } else {
    switch (static_cast<messages::WebContentClient>(message.name())) {
      case messages::WebContentClient::kCreateRendererClient:
            return "Receive reply owl::mojom::WebContentClient::CreateRendererClient";
      case messages::WebContentClient::kTakeFocus:
            return "Receive reply owl::mojom::WebContentClient::TakeFocus";
      case messages::WebContentClient::kDestroy:
            return "Receive reply owl::mojom::WebContentClient::Destroy";
      case messages::WebContentClient::kShowContextMenu:
            return "Receive reply owl::mojom::WebContentClient::ShowContextMenu";
      case messages::WebContentClient::kStartDrag:
            return "Receive reply owl::mojom::WebContentClient::StartDrag";
      case messages::WebContentClient::kStartNativeDrag:
            return "Receive reply owl::mojom::WebContentClient::StartNativeDrag";
      case messages::WebContentClient::kUpdateDragOperation:
            return "Receive reply owl::mojom::WebContentClient::UpdateDragOperation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContentClient::CreateRendererClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb44d8e84;  // IPCStableHash for owl::mojom::WebContentClient::CreateRendererClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::TakeFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x865c2b89;  // IPCStableHash for owl::mojom::WebContentClient::TakeFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa082fd5;  // IPCStableHash for owl::mojom::WebContentClient::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaeb53846;  // IPCStableHash for owl::mojom::WebContentClient::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::StartDrag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34b63d91;  // IPCStableHash for owl::mojom::WebContentClient::StartDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::StartNativeDrag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ae2ac4e;  // IPCStableHash for owl::mojom::WebContentClient::StartNativeDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentClient::UpdateDragOperation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec9fb20f;  // IPCStableHash for owl::mojom::WebContentClient::UpdateDragOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebContentClient_StartNativeDrag_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentClient_StartNativeDrag_ForwardToCallback(
      WebContentClient::StartNativeDragCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentClient_StartNativeDrag_ForwardToCallback(const WebContentClient_StartNativeDrag_ForwardToCallback&) = delete;
  WebContentClient_StartNativeDrag_ForwardToCallback& operator=(const WebContentClient_StartNativeDrag_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentClient::StartNativeDragCallback callback_;
};

WebContentClientProxy::WebContentClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebContentClientProxy::CreateRendererClient(
    uint64_t in_id, WebContentRendererType in_type, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> in_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::CreateRendererClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebContentRendererType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer"), in_renderer,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kCreateRendererClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_CreateRendererClient_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

  
  mojo::internal::Serialize<::owl::mojom::WebContentRendererType>(
    in_type,
    &params->type);

  
  mojo::internal::Serialize<::owl::mojom::WebContentRendererClientAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in WebContentClient.CreateRendererClient request");

  
  mojo::internal::Serialize<::owl::mojom::WebContentRendererAssociatedPtrInfoDataView>(
    in_renderer,
    &params->renderer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->renderer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid renderer in WebContentClient.CreateRendererClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("CreateRendererClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentClientProxy::TakeFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::TakeFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kTakeFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_TakeFocus_Params_Data> params(
          message);
  params.Allocate();

  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentClientProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentClient::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentClientProxy::ShowContextMenu(
    ::owl::mojom::ContextMenuParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebContentClient.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentClientProxy::StartDrag(
    DropDataPtr in_drop_data, const ::url::Origin& in_source_origin, uint32_t in_operation_mask, const ::gfx::ImageSkia& in_image, const ::gfx::Vector2d& in_image_offset, bool in_is_privileged) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::StartDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), in_drop_data,
                        "<value of type DropDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation_mask"), in_operation_mask,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_offset"), in_image_offset,
                        "<value of type const ::gfx::Vector2d&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged"), in_is_privileged,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kStartDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_StartDrag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DropDataDataView>(
    in_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContentClient.StartDrag request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in WebContentClient.StartDrag request");

  params->operation_mask = in_operation_mask;
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->image_offset)::BaseType> image_offset_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
    in_image_offset,
    image_offset_fragment);

  params->image_offset.Set(
      image_offset_fragment.is_null() ? nullptr : image_offset_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_offset.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_offset in WebContentClient.StartDrag request");

  params->is_privileged = in_is_privileged;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("StartDrag");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentClientProxy::StartNativeDrag(
    const std::string& in_pasteboard_name, const ::gfx::ImageSkia& in_image, uint32_t in_operation, StartNativeDragCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::StartNativeDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pasteboard_name"), in_pasteboard_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kStartNativeDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_StartNativeDrag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pasteboard_name)::BaseType> pasteboard_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_pasteboard_name,
    pasteboard_name_fragment);

  params->pasteboard_name.Set(
      pasteboard_name_fragment.is_null() ? nullptr : pasteboard_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pasteboard_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pasteboard_name in WebContentClient.StartNativeDrag request");
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  params->operation = in_operation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("StartNativeDrag");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentClient_StartNativeDrag_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentClientProxy::UpdateDragOperation(
    ::ui::mojom::DragOperation in_operation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentClient::UpdateDragOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::ui::mojom::DragOperation>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kUpdateDragOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_UpdateDragOperation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::DragOperation>(
    in_operation,
    &params->operation);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("UpdateDragOperation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebContentClient_StartNativeDrag_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentClient::StartNativeDragCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentClient_StartNativeDrag_ProxyToResponder> proxy(
        new WebContentClient_StartNativeDrag_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentClient_StartNativeDrag_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentClient_StartNativeDrag_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentClient_StartNativeDrag_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentClient::StartNativeDragCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebContentClient_StartNativeDrag_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentClient_StartNativeDrag_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentClient_StartNativeDrag_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentClient.5
  bool success = true;
  WebContentClient_StartNativeDrag_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentClient::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebContentClient_StartNativeDrag_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::WebContentClient::StartNativeDrag");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentClient::kStartNativeDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentClient_StartNativeDrag_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentClient::Name_);
  message.set_method_name("StartNativeDrag");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebContentClientStubDispatch::Accept(
    WebContentClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContentClient>(message->header()->name)) {
    case messages::WebContentClient::kCreateRendererClient: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_CreateRendererClient_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_CreateRendererClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.0
      bool success = true;
      uint64_t p_id{};
      WebContentRendererType p_type{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> p_renderer{};
      WebContentClient_CreateRendererClient_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_renderer =
            input_data_view.TakeRenderer<decltype(p_renderer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRendererClient(        
        std::move(p_id), 
        std::move(p_type), 
        std::move(p_receiver), 
        std::move(p_renderer));
      return true;
    }
    case messages::WebContentClient::kTakeFocus: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_TakeFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.1
      bool success = true;
      bool p_reverse{};
      WebContentClient_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(        
        std::move(p_reverse));
      return true;
    }
    case messages::WebContentClient::kDestroy: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_Destroy_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.2
      bool success = true;
      WebContentClient_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
    case messages::WebContentClient::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.3
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      WebContentClient_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_params));
      return true;
    }
    case messages::WebContentClient::kStartDrag: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_StartDrag_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_StartDrag_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.4
      bool success = true;
      DropDataPtr p_drop_data{};
      ::url::Origin p_source_origin{};
      uint32_t p_operation_mask{};
      ::gfx::ImageSkia p_image{};
      ::gfx::Vector2d p_image_offset{};
      bool p_is_privileged{};
      WebContentClient_StartDrag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDropData(&p_drop_data))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success)
        p_operation_mask = input_data_view.operation_mask();
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadImageOffset(&p_image_offset))
        success = false;
      if (success)
        p_is_privileged = input_data_view.is_privileged();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDrag(        
        std::move(p_drop_data), 
        std::move(p_source_origin), 
        std::move(p_operation_mask), 
        std::move(p_image), 
        std::move(p_image_offset), 
        std::move(p_is_privileged));
      return true;
    }
    case messages::WebContentClient::kStartNativeDrag: {
      break;
    }
    case messages::WebContentClient::kUpdateDragOperation: {
      DCHECK(message->is_serialized());
      internal::WebContentClient_UpdateDragOperation_Params_Data* params =
          reinterpret_cast<internal::WebContentClient_UpdateDragOperation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentClient.6
      bool success = true;
      ::ui::mojom::DragOperation p_operation{};
      WebContentClient_UpdateDragOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOperation(&p_operation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDragOperation(        
        std::move(p_operation));
      return true;
    }
  }
  return false;
}

// static
bool WebContentClientStubDispatch::AcceptWithResponder(
    WebContentClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContentClient>(message->header()->name)) {
    case messages::WebContentClient::kCreateRendererClient: {
      break;
    }
    case messages::WebContentClient::kTakeFocus: {
      break;
    }
    case messages::WebContentClient::kDestroy: {
      break;
    }
    case messages::WebContentClient::kShowContextMenu: {
      break;
    }
    case messages::WebContentClient::kStartDrag: {
      break;
    }
    case messages::WebContentClient::kStartNativeDrag: {
      internal::WebContentClient_StartNativeDrag_Params_Data* params =
          reinterpret_cast<
              internal::WebContentClient_StartNativeDrag_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentClient.5
      bool success = true;
      std::string p_pasteboard_name{};
      ::gfx::ImageSkia p_image{};
      uint32_t p_operation{};
      WebContentClient_StartNativeDrag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPasteboardName(&p_pasteboard_name))
        success = false;
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success)
        p_operation = input_data_view.operation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentClient::Name_, 5, false);
        return false;
      }
      auto callback =
          WebContentClient_StartNativeDrag_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNativeDrag(        
        std::move(p_pasteboard_name), 
        std::move(p_image), 
        std::move(p_operation), std::move(callback));
      return true;
    }
    case messages::WebContentClient::kUpdateDragOperation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentClientValidationInfo[] = {
    { &internal::WebContentClient_CreateRendererClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentClient_TakeFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentClient_Destroy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentClient_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentClient_StartDrag_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentClient_StartNativeDrag_Params_Data::Validate,
     &internal::WebContentClient_StartNativeDrag_ResponseParams_Data::Validate},
    { &internal::WebContentClient_UpdateDragOperation_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebContentClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebContentClient::Name_,
    kWebContentClientValidationInfo);
}

bool WebContentClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebContentClient::Name_,
    kWebContentClientValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::FileSystemFileInfo::DataView, ::owl::mojom::FileSystemFileInfoPtr>::Read(
    ::owl::mojom::FileSystemFileInfo::DataView input,
    ::owl::mojom::FileSystemFileInfoPtr* output) {
  bool success = true;
  ::owl::mojom::FileSystemFileInfoPtr result(::owl::mojom::FileSystemFileInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFilesystemId(&result->filesystem_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::DropData::DataView, ::owl::mojom::DropDataPtr>::Read(
    ::owl::mojom::DropData::DataView input,
    ::owl::mojom::DropDataPtr* output) {
  bool success = true;
  ::owl::mojom::DropDataPtr result(::owl::mojom::DropData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadUrlTitle(&result->url_title))
        success = false;
      if (success && !input.ReadDownloadMetadata(&result->download_metadata))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadFilenames(&result->filenames))
        success = false;
      if (success && !input.ReadFileMimeTypes(&result->file_mime_types))
        success = false;
      if (success && !input.ReadFilesystemId(&result->filesystem_id))
        success = false;
      if (success && !input.ReadFileSystemFiles(&result->file_system_files))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadHtml(&result->html))
        success = false;
      if (success && !input.ReadHtmlBaseUrl(&result->html_base_url))
        success = false;
      if (success && !input.ReadFileContents(&result->file_contents))
        success = false;
      if (success)
        result->file_contents_image_accessible = input.file_contents_image_accessible();
      if (success && !input.ReadFileContentsSourceUrl(&result->file_contents_source_url))
        success = false;
      if (success && !input.ReadFileContentsFilenameExtension(&result->file_contents_filename_extension))
        success = false;
      if (success && !input.ReadFileContentsContentDisposition(&result->file_contents_content_disposition))
        success = false;
      if (success && !input.ReadCustomData(&result->custom_data))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success)
        result->document_is_handling_drag = input.document_is_handling_drag();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::DraggingInfo::DataView, ::owl::mojom::DraggingInfoPtr>::Read(
    ::owl::mojom::DraggingInfo::DataView input,
    ::owl::mojom::DraggingInfoPtr* output) {
  bool success = true;
  ::owl::mojom::DraggingInfoPtr result(::owl::mojom::DraggingInfo::New());
  
      if (success && !input.ReadLocationInView(&result->location_in_view))
        success = false;
      if (success && !input.ReadLocationInScreen(&result->location_in_screen))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->operation_mask = input.operation_mask();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WebContentInterceptorForTesting::SetInputMode(InputMode mode) {
  GetForwardingInterface()->SetInputMode(
    std::move(mode)
    );
}
void WebContentInterceptorForTesting::OnMouseEvent(::std::unique_ptr<::ui::Event> event) {
  GetForwardingInterface()->OnMouseEvent(
    std::move(event)
    );
}
void WebContentInterceptorForTesting::OnBecameFirstResponder(WindowSelectionMethod method) {
  GetForwardingInterface()->OnBecameFirstResponder(
    std::move(method)
    );
}
void WebContentInterceptorForTesting::OnWindowVisibilityChanged(WindowVisibility visibility) {
  GetForwardingInterface()->OnWindowVisibilityChanged(
    std::move(visibility)
    );
}
void WebContentInterceptorForTesting::DraggingEntered(DropDataPtr drop_data, DraggingInfoPtr dragging_info) {
  GetForwardingInterface()->DraggingEntered(
    std::move(drop_data)
    , 
    std::move(dragging_info)
    );
}
void WebContentInterceptorForTesting::DraggingExited() {
  GetForwardingInterface()->DraggingExited();
}
void WebContentInterceptorForTesting::DraggingUpdated(DraggingInfoPtr dragging_info) {
  GetForwardingInterface()->DraggingUpdated(
    std::move(dragging_info)
    );
}
void WebContentInterceptorForTesting::PerformDragOperation(DraggingInfoPtr dragging_info) {
  GetForwardingInterface()->PerformDragOperation(
    std::move(dragging_info)
    );
}
void WebContentInterceptorForTesting::EndDrag(uint64_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) {
  GetForwardingInterface()->EndDrag(
    std::move(drag_operation)
    , 
    std::move(local_point)
    , 
    std::move(screen_point)
    );
}
WebContentAsyncWaiter::WebContentAsyncWaiter(
    WebContent* proxy) : proxy_(proxy) {}

WebContentAsyncWaiter::~WebContentAsyncWaiter() = default;





void WebContentClientInterceptorForTesting::CreateRendererClient(uint64_t id, WebContentRendererType type, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentRendererClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContentRenderer> renderer) {
  GetForwardingInterface()->CreateRendererClient(
    std::move(id)
    , 
    std::move(type)
    , 
    std::move(receiver)
    , 
    std::move(renderer)
    );
}
void WebContentClientInterceptorForTesting::TakeFocus(bool reverse) {
  GetForwardingInterface()->TakeFocus(
    std::move(reverse)
    );
}
void WebContentClientInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
void WebContentClientInterceptorForTesting::ShowContextMenu(::owl::mojom::ContextMenuParamsPtr params) {
  GetForwardingInterface()->ShowContextMenu(
    std::move(params)
    );
}
void WebContentClientInterceptorForTesting::StartDrag(DropDataPtr drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) {
  GetForwardingInterface()->StartDrag(
    std::move(drop_data)
    , 
    std::move(source_origin)
    , 
    std::move(operation_mask)
    , 
    std::move(image)
    , 
    std::move(image_offset)
    , 
    std::move(is_privileged)
    );
}
void WebContentClientInterceptorForTesting::StartNativeDrag(const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation, StartNativeDragCallback callback) {
  GetForwardingInterface()->StartNativeDrag(
    std::move(pasteboard_name)
    , 
    std::move(image)
    , 
    std::move(operation)
    , std::move(callback));
}
void WebContentClientInterceptorForTesting::UpdateDragOperation(::ui::mojom::DragOperation operation) {
  GetForwardingInterface()->UpdateDragOperation(
    std::move(operation)
    );
}
WebContentClientAsyncWaiter::WebContentClientAsyncWaiter(
    WebContentClient* proxy) : proxy_(proxy) {}

WebContentClientAsyncWaiter::~WebContentClientAsyncWaiter() = default;


void WebContentClientAsyncWaiter::StartNativeDrag(
    const std::string& pasteboard_name, const ::gfx::ImageSkia& image, uint32_t operation) {
  base::RunLoop loop;
  proxy_->StartNativeDrag(
      std::move(pasteboard_name),
      std::move(image),
      std::move(operation),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif