// owl/mojom/web_content.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_WEB_CONTENT_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/web_content.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/web_content_renderer.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "owl/mojom/web_content.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::WindowSelectionMethod, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::WindowVisibility, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::InputMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::WebContentRendererType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FileSystemFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FileSystemFileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FileSystemFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in FileSystemFileInfo struct");

      fragment->size = Traits::size(input);

      decltype(Traits::filesystem_id(input)) in_filesystem_id = Traits::filesystem_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filesystem_id)::BaseType> filesystem_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_filesystem_id,
        filesystem_id_fragment);

      fragment->filesystem_id.Set(
          filesystem_id_fragment.is_null() ? nullptr : filesystem_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filesystem_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filesystem_id in FileSystemFileInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::DropDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DropDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DropData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::url_title(input)) in_url_title = Traits::url_title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url_title)::BaseType> url_title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_url_title,
        url_title_fragment);

      fragment->url_title.Set(
          url_title_fragment.is_null() ? nullptr : url_title_fragment.data());

      decltype(Traits::download_metadata(input)) in_download_metadata = Traits::download_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->download_metadata)::BaseType> download_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_download_metadata,
        download_metadata_fragment);

      fragment->download_metadata.Set(
          download_metadata_fragment.is_null() ? nullptr : download_metadata_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input),
        &fragment->referrer_policy);

      decltype(Traits::filenames(input)) in_filenames = Traits::filenames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filenames)::BaseType>
          filenames_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& filenames_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>, send_validation>(
        in_filenames,
        filenames_fragment,
        &filenames_validate_params);

      fragment->filenames.Set(
          filenames_fragment.is_null() ? nullptr : filenames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filenames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filenames in DropData struct");

      decltype(Traits::file_mime_types(input)) in_file_mime_types = Traits::file_mime_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_mime_types)::BaseType>
          file_mime_types_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_mime_types_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_file_mime_types,
        file_mime_types_fragment,
        &file_mime_types_validate_params);

      fragment->file_mime_types.Set(
          file_mime_types_fragment.is_null() ? nullptr : file_mime_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_mime_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_mime_types in DropData struct");

      decltype(Traits::filesystem_id(input)) in_filesystem_id = Traits::filesystem_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filesystem_id)::BaseType> filesystem_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_filesystem_id,
        filesystem_id_fragment);

      fragment->filesystem_id.Set(
          filesystem_id_fragment.is_null() ? nullptr : filesystem_id_fragment.data());

      decltype(Traits::file_system_files(input)) in_file_system_files = Traits::file_system_files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_system_files)::BaseType>
          file_system_files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_system_files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::FileSystemFileInfoDataView>, send_validation>(
        in_file_system_files,
        file_system_files_fragment,
        &file_system_files_validate_params);

      fragment->file_system_files.Set(
          file_system_files_fragment.is_null() ? nullptr : file_system_files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_system_files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_system_files in DropData struct");

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      decltype(Traits::html(input)) in_html = Traits::html(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->html)::BaseType> html_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_html,
        html_fragment);

      fragment->html.Set(
          html_fragment.is_null() ? nullptr : html_fragment.data());

      decltype(Traits::html_base_url(input)) in_html_base_url = Traits::html_base_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->html_base_url)::BaseType> html_base_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_html_base_url,
        html_base_url_fragment);

      fragment->html_base_url.Set(
          html_base_url_fragment.is_null() ? nullptr : html_base_url_fragment.data());

      decltype(Traits::file_contents(input)) in_file_contents = Traits::file_contents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_contents)::BaseType>
          file_contents_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& file_contents_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_file_contents,
        file_contents_fragment,
        &file_contents_validate_params);

      fragment->file_contents.Set(
          file_contents_fragment.is_null() ? nullptr : file_contents_fragment.data());

      fragment->file_contents_image_accessible = Traits::file_contents_image_accessible(input);

      decltype(Traits::file_contents_source_url(input)) in_file_contents_source_url = Traits::file_contents_source_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_contents_source_url)::BaseType> file_contents_source_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_file_contents_source_url,
        file_contents_source_url_fragment);

      fragment->file_contents_source_url.Set(
          file_contents_source_url_fragment.is_null() ? nullptr : file_contents_source_url_fragment.data());

      decltype(Traits::file_contents_filename_extension(input)) in_file_contents_filename_extension = Traits::file_contents_filename_extension(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_contents_filename_extension)::BaseType> file_contents_filename_extension_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_file_contents_filename_extension,
        file_contents_filename_extension_fragment);

      fragment->file_contents_filename_extension.Set(
          file_contents_filename_extension_fragment.is_null() ? nullptr : file_contents_filename_extension_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_contents_filename_extension.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_contents_filename_extension in DropData struct");

      decltype(Traits::file_contents_content_disposition(input)) in_file_contents_content_disposition = Traits::file_contents_content_disposition(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_contents_content_disposition)::BaseType> file_contents_content_disposition_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_file_contents_content_disposition,
        file_contents_content_disposition_fragment);

      fragment->file_contents_content_disposition.Set(
          file_contents_content_disposition_fragment.is_null() ? nullptr : file_contents_content_disposition_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_contents_content_disposition.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_contents_content_disposition in DropData struct");

      decltype(Traits::custom_data(input)) in_custom_data = Traits::custom_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->custom_data)::BaseType>
          custom_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& custom_data_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_custom_data,
        custom_data_fragment,
        &custom_data_validate_params);

      fragment->custom_data.Set(
          custom_data_fragment.is_null() ? nullptr : custom_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->custom_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null custom_data in DropData struct");

      
      mojo::internal::Serialize<::ui::mojom::DragOperation>(
        Traits::operation(input),
        &fragment->operation);

      fragment->document_is_handling_drag = Traits::document_is_handling_drag(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::DraggingInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::DraggingInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::DraggingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::location_in_view(input)) in_location_in_view = Traits::location_in_view(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location_in_view)::BaseType> location_in_view_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_location_in_view,
        location_in_view_fragment);

      fragment->location_in_view.Set(
          location_in_view_fragment.is_null() ? nullptr : location_in_view_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location_in_view.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location_in_view in DraggingInfo struct");

      decltype(Traits::location_in_screen(input)) in_location_in_screen = Traits::location_in_screen(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location_in_screen)::BaseType> location_in_screen_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_location_in_screen,
        location_in_screen_fragment);

      fragment->location_in_screen.Set(
          location_in_screen_fragment.is_null() ? nullptr : location_in_screen_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location_in_screen.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location_in_screen in DraggingInfo struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      fragment->operation_mask = Traits::operation_mask(input);
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_WEB_CONTENT_MOJOM_SEND_VALIDATION_H_