// owl/mojom/web_content.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_WEB_CONTENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/web_content.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/web_content_renderer.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class FileSystemFileInfoDataView;

class DropDataDataView;

class DraggingInfoDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::FileSystemFileInfoDataView> {
  using Data = ::owl::mojom::internal::FileSystemFileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::DropDataDataView> {
  using Data = ::owl::mojom::internal::DropData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::DraggingInfoDataView> {
  using Data = ::owl::mojom::internal::DraggingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class WindowSelectionMethod : int32_t {
  
  kDirect = 0,
  
  kForwardIteration = 1,
  
  kReverseIteration = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WindowSelectionMethod value);
inline bool IsKnownEnumValue(WindowSelectionMethod value) {
  return internal::WindowSelectionMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowVisibility : int32_t {
  
  kVisible = 0,
  
  kOccluded = 1,
  
  kHidden = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WindowVisibility value);
inline bool IsKnownEnumValue(WindowVisibility value) {
  return internal::WindowVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InputMode : int32_t {
  
  kUser = 0,
  
  kAgent = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, InputMode value);
inline bool IsKnownEnumValue(InputMode value) {
  return internal::InputMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebContentRendererType : int32_t {
  
  kMain = 0,
  
  kChild = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, WebContentRendererType value);
inline bool IsKnownEnumValue(WebContentRendererType value) {
  return internal::WebContentRendererType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebContentInterfaceBase {};

using WebContentPtrDataView =
    mojo::InterfacePtrDataView<WebContentInterfaceBase>;
using WebContentRequestDataView =
    mojo::InterfaceRequestDataView<WebContentInterfaceBase>;
using WebContentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentInterfaceBase>;
using WebContentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentInterfaceBase>;
class WebContentClientInterfaceBase {};

using WebContentClientPtrDataView =
    mojo::InterfacePtrDataView<WebContentClientInterfaceBase>;
using WebContentClientRequestDataView =
    mojo::InterfaceRequestDataView<WebContentClientInterfaceBase>;
using WebContentClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebContentClientInterfaceBase>;
using WebContentClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebContentClientInterfaceBase>;


class FileSystemFileInfoDataView {
 public:
  FileSystemFileInfoDataView() = default;

  FileSystemFileInfoDataView(
      internal::FileSystemFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetFilesystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilesystemId(UserType* output) {
    
    auto* pointer = data_->filesystem_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DropDataDataView {
 public:
  DropDataDataView() = default;

  DropDataDataView(
      internal::DropData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUrlTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url_title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlTitle` instead "
    "of `ReadUrlTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDownloadMetadataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `download_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDownloadMetadata` instead "
    "of `ReadDownloadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->download_metadata.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetFilenamesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilenames(UserType* output) {
    
    auto* pointer = data_->filenames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
  inline void GetFileMimeTypesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileMimeTypes(UserType* output) {
    
    auto* pointer = data_->file_mime_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetFilesystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilesystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `filesystem_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilesystemId` instead "
    "of `ReadFilesystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filesystem_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFileSystemFilesDataView(
      mojo::ArrayDataView<FileSystemFileInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemFiles(UserType* output) {
    
    auto* pointer = data_->file_system_files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::FileSystemFileInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadText` instead "
    "of `ReadText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHtmlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtml(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `html` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHtml` instead "
    "of `ReadHtml if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->html.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHtmlBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtmlBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `html_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHtmlBaseUrl` instead "
    "of `ReadHtmlBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->html_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFileContentsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileContents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `file_contents` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileContents` instead "
    "of `ReadFileContents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_contents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool file_contents_image_accessible() const {
    return data_->file_contents_image_accessible;
  }
  inline void GetFileContentsSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileContentsSourceUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `file_contents_source_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileContentsSourceUrl` instead "
    "of `ReadFileContentsSourceUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_contents_source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFileContentsFilenameExtensionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileContentsFilenameExtension(UserType* output) {
    
    auto* pointer = data_->file_contents_filename_extension.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFileContentsContentDispositionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileContentsContentDisposition(UserType* output) {
    
    auto* pointer = data_->file_contents_content_disposition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCustomDataDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomData(UserType* output) {
    
    auto* pointer = data_->custom_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::ui::mojom::DragOperation>(
        data_value, output);
  }
  ::ui::mojom::DragOperation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::DragOperation>(data_->operation));
  }
  bool document_is_handling_drag() const {
    return data_->document_is_handling_drag;
  }
 private:
  internal::DropData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DraggingInfoDataView {
 public:
  DraggingInfoDataView() = default;

  DraggingInfoDataView(
      internal::DraggingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationInViewDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationInView(UserType* output) {
    
    auto* pointer = data_->location_in_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetLocationInScreenDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationInScreen(UserType* output) {
    
    auto* pointer = data_->location_in_screen.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint64_t operation_mask() const {
    return data_->operation_mask;
  }
 private:
  internal::DraggingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_WEB_CONTENT_MOJOM_DATA_VIEW_H_