// owl/mojom/session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/session.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* NetworkStatusToStringHelper(NetworkStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkStatus::kConnected:
      return "kConnected";
    case NetworkStatus::kOffline:
      return "kOffline";
    default:
      return nullptr;
  }
}

std::string NetworkStatusToString(NetworkStatus value) {
  const char *str = NetworkStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkStatus value) {
  return os << NetworkStatusToString(value);
}

namespace internal {


// static
bool InternalURLPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InternalURLPattern_Data* object =
      static_cast<const InternalURLPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefix, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prefix_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefix, validation_context,
                                         &prefix_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

InternalURLPattern_Data::InternalURLPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetClient_Params_Data* object =
      static_cast<const Session_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_SetClient_Params_Data::Session_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_ShowChrome_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_ShowChrome_Params_Data* object =
      static_cast<const Session_ShowChrome_Params_Data*>(data);

  return true;
}

Session_ShowChrome_Params_Data::Session_ShowChrome_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_OpenProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_OpenProfile_Params_Data* object =
      static_cast<const Session_OpenProfile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_OpenProfile_Params_Data::Session_OpenProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_OpenGuestProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_OpenGuestProfile_Params_Data* object =
      static_cast<const Session_OpenGuestProfile_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_OpenGuestProfile_Params_Data::Session_OpenGuestProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetAllowedWebUIPrefixes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetAllowedWebUIPrefixes_Params_Data* object =
      static_cast<const Session_SetAllowedWebUIPrefixes_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefixes, validation_context,
                                         &prefixes_validate_params)) {
    return false;
  }

  return true;
}

Session_SetAllowedWebUIPrefixes_Params_Data::Session_SetAllowedWebUIPrefixes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetInternalURLs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetInternalURLs_Params_Data* object =
      static_cast<const Session_SetInternalURLs_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->patterns, validation_context,
                                         &patterns_validate_params)) {
    return false;
  }

  return true;
}

Session_SetInternalURLs_Params_Data::Session_SetInternalURLs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_CreateWebViewSessionDataDecoder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_CreateWebViewSessionDataDecoder_Params_Data* object =
      static_cast<const Session_CreateWebViewSessionDataDecoder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_CreateWebViewSessionDataDecoder_Params_Data::Session_CreateWebViewSessionDataDecoder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnNetworkStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnNetworkStatusChanged_Params_Data* object =
      static_cast<const SessionClient_OnNetworkStatusChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::NetworkStatus_Data
        ::Validate(object->network_status, validation_context))
    return false;

  return true;
}

SessionClient_OnNetworkStatusChanged_Params_Data::SessionClient_OnNetworkStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionClient_OnCaptivePortalStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionClient_OnCaptivePortalStatusChanged_Params_Data* object =
      static_cast<const SessionClient_OnCaptivePortalStatusChanged_Params_Data*>(data);

  return true;
}

SessionClient_OnCaptivePortalStatusChanged_Params_Data::SessionClient_OnCaptivePortalStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::NetworkStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::NetworkStatus value) {
  return std::move(context).WriteString(::owl::mojom::NetworkStatusToString(value));
}

} // namespace perfetto