// owl/mojom/search_keyword.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SEARCH_KEYWORD_MOJOM_H_
#define OWL_MOJOM_SEARCH_KEYWORD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/search_keyword.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/search_keyword.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/search_keyword.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class SearchKeywordsClientProxy;

template <typename ImplRefTraits>
class SearchKeywordsClientStub;

class SearchKeywordsClientRequestValidator;


class SearchKeywordsClient
    : public SearchKeywordsClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.SearchKeywordsClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SearchKeywordsClientInterfaceBase;
  using Proxy_ = SearchKeywordsClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SearchKeywordsClientStub<ImplRefTraits>;

  using RequestValidator_ = SearchKeywordsClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSearchKeywordsChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSearchKeywordsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SearchKeywordsClient() = default;

  virtual void OnSearchKeywordsChanged(std::vector<SearchKeywordPtr> search_keywords) = 0;
};



class  SearchKeywordsClientProxy
    : public SearchKeywordsClient {
 public:
  using InterfaceType = SearchKeywordsClient;

  explicit SearchKeywordsClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSearchKeywordsChanged(std::vector<SearchKeywordPtr> search_keywords) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SearchKeywordsClientStubDispatch {
 public:
  static bool Accept(SearchKeywordsClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SearchKeywordsClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SearchKeywordsClient>>
class SearchKeywordsClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SearchKeywordsClientStub() = default;
  ~SearchKeywordsClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SearchKeywordsClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SearchKeywordsClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SearchKeywordsClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SearchKeyword {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchKeyword, T>::value>;
  using DataView = SearchKeywordDataView;
  using Data_ = internal::SearchKeyword_Data;

  template <typename... Args>
  static SearchKeywordPtr New(Args&&... args) {
    return SearchKeywordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchKeywordPtr From(const U& u) {
    return mojo::TypeConverter<SearchKeywordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchKeyword>::Convert(*this);
  }


  SearchKeyword();

  SearchKeyword(
      const std::string& id,
      const ::std::u16string& name,
      const ::std::u16string& keyword,
      const ::std::u16string& url,
      uint32_t replacement_offset,
      const ::GURL& favicon_url,
      SearchKeywordType type,
      bool is_default,
      const ::std::u16string& suggestions_url,
      uint32_t suggestions_url_replacement_offset);


  ~SearchKeyword();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchKeywordPtr>
  SearchKeywordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchKeyword::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchKeyword::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchKeyword::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchKeyword_UnserializedMessageContext<
            UserType, SearchKeyword::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchKeyword::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchKeyword::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchKeyword_UnserializedMessageContext<
            UserType, SearchKeyword::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchKeyword::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::std::u16string name;
  
  ::std::u16string keyword;
  
  ::std::u16string url;
  
  uint32_t replacement_offset;
  
  ::GURL favicon_url;
  
  SearchKeywordType type;
  
  bool is_default;
  
  ::std::u16string suggestions_url;
  
  uint32_t suggestions_url_replacement_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchKeyword::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SearchKeywordPtr SearchKeyword::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(keyword),
      mojo::Clone(url),
      mojo::Clone(replacement_offset),
      mojo::Clone(favicon_url),
      mojo::Clone(type),
      mojo::Clone(is_default),
      mojo::Clone(suggestions_url),
      mojo::Clone(suggestions_url_replacement_offset)
  );
}

template <typename T, SearchKeyword::EnableIfSame<T>*>
bool SearchKeyword::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->keyword, other_struct.keyword))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->replacement_offset, other_struct.replacement_offset))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->is_default, other_struct.is_default))
    return false;
  if (!mojo::Equals(this->suggestions_url, other_struct.suggestions_url))
    return false;
  if (!mojo::Equals(this->suggestions_url_replacement_offset, other_struct.suggestions_url_replacement_offset))
    return false;
  return true;
}

template <typename T, SearchKeyword::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.keyword < rhs.keyword)
    return true;
  if (rhs.keyword < lhs.keyword)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.replacement_offset < rhs.replacement_offset)
    return true;
  if (rhs.replacement_offset < lhs.replacement_offset)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.is_default < rhs.is_default)
    return true;
  if (rhs.is_default < lhs.is_default)
    return false;
  if (lhs.suggestions_url < rhs.suggestions_url)
    return true;
  if (rhs.suggestions_url < lhs.suggestions_url)
    return false;
  if (lhs.suggestions_url_replacement_offset < rhs.suggestions_url_replacement_offset)
    return true;
  if (rhs.suggestions_url_replacement_offset < lhs.suggestions_url_replacement_offset)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::SearchKeyword::DataView,
                                         ::owl::mojom::SearchKeywordPtr> {
  static bool IsNull(const ::owl::mojom::SearchKeywordPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::SearchKeywordPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::SearchKeyword::id)& id(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::SearchKeyword::name)& name(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->name;
  }

  static const decltype(::owl::mojom::SearchKeyword::keyword)& keyword(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->keyword;
  }

  static const decltype(::owl::mojom::SearchKeyword::url)& url(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->url;
  }

  static decltype(::owl::mojom::SearchKeyword::replacement_offset) replacement_offset(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->replacement_offset;
  }

  static const decltype(::owl::mojom::SearchKeyword::favicon_url)& favicon_url(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->favicon_url;
  }

  static decltype(::owl::mojom::SearchKeyword::type) type(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->type;
  }

  static decltype(::owl::mojom::SearchKeyword::is_default) is_default(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->is_default;
  }

  static const decltype(::owl::mojom::SearchKeyword::suggestions_url)& suggestions_url(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->suggestions_url;
  }

  static decltype(::owl::mojom::SearchKeyword::suggestions_url_replacement_offset) suggestions_url_replacement_offset(
      const ::owl::mojom::SearchKeywordPtr& input) {
    return input->suggestions_url_replacement_offset;
  }

  static bool Read(::owl::mojom::SearchKeyword::DataView input, ::owl::mojom::SearchKeywordPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_SEARCH_KEYWORD_MOJOM_H_