// owl/mojom/profile.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/profile.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/profile.mojom-params-data.h"
#include "owl/mojom/profile.mojom-shared-message-ids.h"

#include "owl/mojom/profile.mojom-import-headers.h"
#include "owl/mojom/profile.mojom-test-utils.h"


namespace owl::mojom {
TypedUrl::TypedUrl()
    : unique_id(),
      url_as_string(),
      title(),
      visit_count(),
      typed_count(),
      last_visit_time() {}

TypedUrl::TypedUrl(
    int64_t unique_id_in,
    const std::string& url_as_string_in,
    const ::std::u16string& title_in,
    int32_t visit_count_in,
    int32_t typed_count_in,
    ::base::Time last_visit_time_in)
    : unique_id(std::move(unique_id_in)),
      url_as_string(std::move(url_as_string_in)),
      title(std::move(title_in)),
      visit_count(std::move(visit_count_in)),
      typed_count(std::move(typed_count_in)),
      last_visit_time(std::move(last_visit_time_in)) {}

TypedUrl::~TypedUrl() = default;

void TypedUrl::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_id"), this->unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_as_string"), this->url_as_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_count"), this->visit_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typed_count"), this->typed_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_visit_time"), this->last_visit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TypedUrl::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QueryHistoryItem::QueryHistoryItem()
    : url(),
      title(),
      visit_time() {}

QueryHistoryItem::QueryHistoryItem(
    const ::GURL& url_in,
    const ::std::u16string& title_in,
    ::base::Time visit_time_in)
    : url(std::move(url_in)),
      title(std::move(title_in)),
      visit_time(std::move(visit_time_in)) {}

QueryHistoryItem::~QueryHistoryItem() = default;

void QueryHistoryItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_time"), this->visit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryHistoryItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QueryHistoryResponse::QueryHistoryResponse()
    : items() {}

QueryHistoryResponse::QueryHistoryResponse(
    std::vector<QueryHistoryItemPtr> items_in)
    : items(std::move(items_in)) {}

QueryHistoryResponse::~QueryHistoryResponse() = default;

void QueryHistoryResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<QueryHistoryItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryHistoryResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QueryHistoryOptions::QueryHistoryOptions()
    : limit(),
      start(),
      end() {}

QueryHistoryOptions::QueryHistoryOptions(
    uint32_t limit_in,
    std::optional<::base::Time> start_in,
    std::optional<::base::Time> end_in)
    : limit(std::move(limit_in)),
      start(std::move(start_in)),
      end(std::move(end_in)) {}

QueryHistoryOptions::~QueryHistoryOptions() = default;

void QueryHistoryOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "limit"), this->limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start"), this->start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end"), this->end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryHistoryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieData::CookieData()
    : name(),
      value(),
      domain(),
      path(),
      http_only(),
      secure(),
      same_site(),
      expiration_time() {}

CookieData::CookieData(
    const std::string& name_in,
    const std::string& value_in,
    const std::string& domain_in,
    const std::string& path_in,
    bool http_only_in,
    bool secure_in,
    CookieSameSite same_site_in,
    ::base::Time expiration_time_in)
    : name(std::move(name_in)),
      value(std::move(value_in)),
      domain(std::move(domain_in)),
      path(std::move(path_in)),
      http_only(std::move(http_only_in)),
      secure(std::move(secure_in)),
      same_site(std::move(same_site_in)),
      expiration_time(std::move(expiration_time_in)) {}

CookieData::~CookieData() = default;

void CookieData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_only"), this->http_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure"), this->secure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_site"), this->same_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieSameSite>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration_time"), this->expiration_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HistoryVisit::HistoryVisit()
    : id(),
      url(),
      title(),
      time(),
      referring_visit_id(),
      external_referrer_url(),
      hidden(),
      transition(),
      should_increment_typed_count(),
      opener_visit_id(),
      consider_for_ntp_most_visited(),
      visit_duration(),
      redirect_source_visit_id(),
      redirect_destination_visit_id() {}

HistoryVisit::HistoryVisit(
    int64_t id_in,
    const std::string& url_in,
    const std::string& title_in,
    ::base::Time time_in,
    std::optional<int64_t> referring_visit_id_in,
    const std::optional<std::string>& external_referrer_url_in,
    std::optional<bool> hidden_in,
    std::optional<int32_t> transition_in,
    std::optional<bool> should_increment_typed_count_in,
    std::optional<int64_t> opener_visit_id_in,
    std::optional<bool> consider_for_ntp_most_visited_in,
    std::optional<int64_t> visit_duration_in,
    std::optional<int64_t> redirect_source_visit_id_in,
    std::optional<int64_t> redirect_destination_visit_id_in)
    : id(std::move(id_in)),
      url(std::move(url_in)),
      title(std::move(title_in)),
      time(std::move(time_in)),
      referring_visit_id(std::move(referring_visit_id_in)),
      external_referrer_url(std::move(external_referrer_url_in)),
      hidden(std::move(hidden_in)),
      transition(std::move(transition_in)),
      should_increment_typed_count(std::move(should_increment_typed_count_in)),
      opener_visit_id(std::move(opener_visit_id_in)),
      consider_for_ntp_most_visited(std::move(consider_for_ntp_most_visited_in)),
      visit_duration(std::move(visit_duration_in)),
      redirect_source_visit_id(std::move(redirect_source_visit_id_in)),
      redirect_destination_visit_id(std::move(redirect_destination_visit_id_in)) {}

HistoryVisit::~HistoryVisit() = default;

void HistoryVisit::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referring_visit_id"), this->referring_visit_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_referrer_url"), this->external_referrer_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden"), this->hidden,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition"), this->transition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_increment_typed_count"), this->should_increment_typed_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_visit_id"), this->opener_visit_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "consider_for_ntp_most_visited"), this->consider_for_ntp_most_visited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_duration"), this->visit_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_source_visit_id"), this->redirect_source_visit_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_destination_visit_id"), this->redirect_destination_visit_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HistoryVisit::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateBookmarkModelResult::CreateBookmarkModelResult()
    : model(),
      client() {}

CreateBookmarkModelResult::CreateBookmarkModelResult(
    ::mojo::PendingAssociatedRemote<::owl::mojom::BookmarkModel> model_in,
    ::mojo::PendingAssociatedReceiver<::owl::mojom::BookmarkModelClient> client_in)
    : model(std::move(model_in)),
      client(std::move(client_in)) {}

CreateBookmarkModelResult::~CreateBookmarkModelResult() = default;

void CreateBookmarkModelResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model"), this->model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::BookmarkModel>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client"), this->client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::BookmarkModelClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateBookmarkModelResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DownloadURLToFileClient::IPCStableHashFunction DownloadURLToFileClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DownloadURLToFileClient>(message.name())) {
    case messages::DownloadURLToFileClient::kOnDoneOrErrored: {
      return &DownloadURLToFileClient::OnDoneOrErrored_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DownloadURLToFileClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DownloadURLToFileClient>(message.name())) {
      case messages::DownloadURLToFileClient::kOnDoneOrErrored:
            return "Receive owl::mojom::DownloadURLToFileClient::OnDoneOrErrored";
    }
  } else {
    switch (static_cast<messages::DownloadURLToFileClient>(message.name())) {
      case messages::DownloadURLToFileClient::kOnDoneOrErrored:
            return "Receive reply owl::mojom::DownloadURLToFileClient::OnDoneOrErrored";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DownloadURLToFileClient::OnDoneOrErrored_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x86062bdd;  // IPCStableHash for owl::mojom::DownloadURLToFileClient::OnDoneOrErrored
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DownloadURLToFileClientProxy::DownloadURLToFileClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DownloadURLToFileClientProxy::OnDoneOrErrored(
    const ::base::FilePath& in_path, const std::optional<std::string>& in_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadURLToFileClient::OnDoneOrErrored", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadURLToFileClient::kOnDoneOrErrored), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadURLToFileClient_OnDoneOrErrored_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in DownloadURLToFileClient.OnDoneOrErrored request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadURLToFileClient::Name_);
  message.set_method_name("OnDoneOrErrored");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DownloadURLToFileClientStubDispatch::Accept(
    DownloadURLToFileClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DownloadURLToFileClient>(message->header()->name)) {
    case messages::DownloadURLToFileClient::kOnDoneOrErrored: {
      DCHECK(message->is_serialized());
      internal::DownloadURLToFileClient_OnDoneOrErrored_Params_Data* params =
          reinterpret_cast<internal::DownloadURLToFileClient_OnDoneOrErrored_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadURLToFileClient.0
      bool success = true;
      ::base::FilePath p_path{};
      std::optional<std::string> p_mime_type{};
      DownloadURLToFileClient_OnDoneOrErrored_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadURLToFileClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDoneOrErrored(        
        std::move(p_path), 
        std::move(p_mime_type));
      return true;
    }
  }
  return false;
}

// static
bool DownloadURLToFileClientStubDispatch::AcceptWithResponder(
    DownloadURLToFileClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DownloadURLToFileClient>(message->header()->name)) {
    case messages::DownloadURLToFileClient::kOnDoneOrErrored: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDownloadURLToFileClientValidationInfo[] = {
    { &internal::DownloadURLToFileClient_OnDoneOrErrored_Params_Data::Validate,
     nullptr /* no response */},
};

bool DownloadURLToFileClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::DownloadURLToFileClient::Name_,
    kDownloadURLToFileClientValidationInfo);
}

// The declaration includes the definition on other builds.

DeferredLoadBlocker::IPCStableHashFunction DeferredLoadBlocker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeferredLoadBlocker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

DeferredLoadBlockerProxy::DeferredLoadBlockerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool DeferredLoadBlockerStubDispatch::Accept(
    DeferredLoadBlocker* impl,
    mojo::Message* message) {
  return false;
}

// static
bool DeferredLoadBlockerStubDispatch::AcceptWithResponder(
    DeferredLoadBlocker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool DeferredLoadBlockerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::owl::mojom::DeferredLoadBlocker::Name_,
    {});
}

// The declaration includes the definition on other builds.

ProfileCloseListener::IPCStableHashFunction ProfileCloseListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfileCloseListener>(message.name())) {
    case messages::ProfileCloseListener::kOnClosed: {
      return &ProfileCloseListener::OnClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfileCloseListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfileCloseListener>(message.name())) {
      case messages::ProfileCloseListener::kOnClosed:
            return "Receive owl::mojom::ProfileCloseListener::OnClosed";
    }
  } else {
    switch (static_cast<messages::ProfileCloseListener>(message.name())) {
      case messages::ProfileCloseListener::kOnClosed:
            return "Receive reply owl::mojom::ProfileCloseListener::OnClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfileCloseListener::OnClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbee0d642;  // IPCStableHash for owl::mojom::ProfileCloseListener::OnClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProfileCloseListenerProxy::ProfileCloseListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfileCloseListenerProxy::OnClosed(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileCloseListener::OnClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileCloseListener::kOnClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileCloseListener_OnClosed_Params_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileCloseListener::Name_);
  message.set_method_name("OnClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProfileCloseListenerStubDispatch::Accept(
    ProfileCloseListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfileCloseListener>(message->header()->name)) {
    case messages::ProfileCloseListener::kOnClosed: {
      DCHECK(message->is_serialized());
      internal::ProfileCloseListener_OnClosed_Params_Data* params =
          reinterpret_cast<internal::ProfileCloseListener_OnClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileCloseListener.0
      bool success = true;
      bool p_success{};
      ProfileCloseListener_OnClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileCloseListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosed(        
        std::move(p_success));
      return true;
    }
  }
  return false;
}

// static
bool ProfileCloseListenerStubDispatch::AcceptWithResponder(
    ProfileCloseListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfileCloseListener>(message->header()->name)) {
    case messages::ProfileCloseListener::kOnClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfileCloseListenerValidationInfo[] = {
    { &internal::ProfileCloseListener_OnClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProfileCloseListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ProfileCloseListener::Name_,
    kProfileCloseListenerValidationInfo);
}

// The declaration includes the definition on other builds.

Profile::IPCStableHashFunction Profile::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Profile>(message.name())) {
    case messages::Profile::kSetClient: {
      return &Profile::SetClient_Sym::IPCStableHash;
    }
    case messages::Profile::kGetIncognitoVariant: {
      return &Profile::GetIncognitoVariant_Sym::IPCStableHash;
    }
    case messages::Profile::kUpdateAppearanceName: {
      return &Profile::UpdateAppearanceName_Sym::IPCStableHash;
    }
    case messages::Profile::kSetOverrideColors: {
      return &Profile::SetOverrideColors_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateWebViewGroup: {
      return &Profile::CreateWebViewGroup_Sym::IPCStableHash;
    }
    case messages::Profile::kRemoveWebViewGroup: {
      return &Profile::RemoveWebViewGroup_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateDownloadManager: {
      return &Profile::CreateDownloadManager_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateBookmarkModel: {
      return &Profile::CreateBookmarkModel_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateExtensionService: {
      return &Profile::CreateExtensionService_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateAutofillController: {
      return &Profile::CreateAutofillController_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateMetricsService: {
      return &Profile::CreateMetricsService_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateNotificationService: {
      return &Profile::CreateNotificationService_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateWebViewContainerView: {
      return &Profile::CreateWebViewContainerView_Sym::IPCStableHash;
    }
    case messages::Profile::kGetTypedUrls: {
      return &Profile::GetTypedUrls_Sym::IPCStableHash;
    }
    case messages::Profile::kGetAddressList: {
      return &Profile::GetAddressList_Sym::IPCStableHash;
    }
    case messages::Profile::kGetCreditCardList: {
      return &Profile::GetCreditCardList_Sym::IPCStableHash;
    }
    case messages::Profile::kSetCookie: {
      return &Profile::SetCookie_Sym::IPCStableHash;
    }
    case messages::Profile::kDeleteCookie: {
      return &Profile::DeleteCookie_Sym::IPCStableHash;
    }
    case messages::Profile::kGetAllCookies: {
      return &Profile::GetAllCookies_Sym::IPCStableHash;
    }
    case messages::Profile::kGetCookies: {
      return &Profile::GetCookies_Sym::IPCStableHash;
    }
    case messages::Profile::kGetFaviconFromFaviconUrl: {
      return &Profile::GetFaviconFromFaviconUrl_Sym::IPCStableHash;
    }
    case messages::Profile::kGetFaviconForPageUrl: {
      return &Profile::GetFaviconForPageUrl_Sym::IPCStableHash;
    }
    case messages::Profile::kCreateAutocompleteController: {
      return &Profile::CreateAutocompleteController_Sym::IPCStableHash;
    }
    case messages::Profile::kGetDefaultDownloadsLocation: {
      return &Profile::GetDefaultDownloadsLocation_Sym::IPCStableHash;
    }
    case messages::Profile::kSetDefaultDownloadsLocation: {
      return &Profile::SetDefaultDownloadsLocation_Sym::IPCStableHash;
    }
    case messages::Profile::kRegisterSearchKeywordsClient: {
      return &Profile::RegisterSearchKeywordsClient_Sym::IPCStableHash;
    }
    case messages::Profile::kAddSearchKeyword: {
      return &Profile::AddSearchKeyword_Sym::IPCStableHash;
    }
    case messages::Profile::kRemoveSearchKeyword: {
      return &Profile::RemoveSearchKeyword_Sym::IPCStableHash;
    }
    case messages::Profile::kUpdateSearchKeyword: {
      return &Profile::UpdateSearchKeyword_Sym::IPCStableHash;
    }
    case messages::Profile::kDownloadURLToFile: {
      return &Profile::DownloadURLToFile_Sym::IPCStableHash;
    }
    case messages::Profile::kFlushCookies: {
      return &Profile::FlushCookies_Sym::IPCStableHash;
    }
    case messages::Profile::kCloseProfile: {
      return &Profile::CloseProfile_Sym::IPCStableHash;
    }
    case messages::Profile::kImportHistory: {
      return &Profile::ImportHistory_Sym::IPCStableHash;
    }
    case messages::Profile::kImportChromePasswords: {
      return &Profile::ImportChromePasswords_Sym::IPCStableHash;
    }
    case messages::Profile::kClearBrowsingData: {
      return &Profile::ClearBrowsingData_Sym::IPCStableHash;
    }
    case messages::Profile::kDeferLoadsForOrigin: {
      return &Profile::DeferLoadsForOrigin_Sym::IPCStableHash;
    }
    case messages::Profile::kSetCustomHeaderForHosts: {
      return &Profile::SetCustomHeaderForHosts_Sym::IPCStableHash;
    }
    case messages::Profile::kResetProfileSettings: {
      return &Profile::ResetProfileSettings_Sym::IPCStableHash;
    }
    case messages::Profile::kSetWebPreferences: {
      return &Profile::SetWebPreferences_Sym::IPCStableHash;
    }
    case messages::Profile::kGetWebPreferences: {
      return &Profile::GetWebPreferences_Sym::IPCStableHash;
    }
    case messages::Profile::kQueryHistory: {
      return &Profile::QueryHistory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Profile::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Profile>(message.name())) {
      case messages::Profile::kSetClient:
            return "Receive owl::mojom::Profile::SetClient";
      case messages::Profile::kGetIncognitoVariant:
            return "Receive owl::mojom::Profile::GetIncognitoVariant";
      case messages::Profile::kUpdateAppearanceName:
            return "Receive owl::mojom::Profile::UpdateAppearanceName";
      case messages::Profile::kSetOverrideColors:
            return "Receive owl::mojom::Profile::SetOverrideColors";
      case messages::Profile::kCreateWebViewGroup:
            return "Receive owl::mojom::Profile::CreateWebViewGroup";
      case messages::Profile::kRemoveWebViewGroup:
            return "Receive owl::mojom::Profile::RemoveWebViewGroup";
      case messages::Profile::kCreateDownloadManager:
            return "Receive owl::mojom::Profile::CreateDownloadManager";
      case messages::Profile::kCreateBookmarkModel:
            return "Receive owl::mojom::Profile::CreateBookmarkModel";
      case messages::Profile::kCreateExtensionService:
            return "Receive owl::mojom::Profile::CreateExtensionService";
      case messages::Profile::kCreateAutofillController:
            return "Receive owl::mojom::Profile::CreateAutofillController";
      case messages::Profile::kCreateMetricsService:
            return "Receive owl::mojom::Profile::CreateMetricsService";
      case messages::Profile::kCreateNotificationService:
            return "Receive owl::mojom::Profile::CreateNotificationService";
      case messages::Profile::kCreateWebViewContainerView:
            return "Receive owl::mojom::Profile::CreateWebViewContainerView";
      case messages::Profile::kGetTypedUrls:
            return "Receive owl::mojom::Profile::GetTypedUrls";
      case messages::Profile::kGetAddressList:
            return "Receive owl::mojom::Profile::GetAddressList";
      case messages::Profile::kGetCreditCardList:
            return "Receive owl::mojom::Profile::GetCreditCardList";
      case messages::Profile::kSetCookie:
            return "Receive owl::mojom::Profile::SetCookie";
      case messages::Profile::kDeleteCookie:
            return "Receive owl::mojom::Profile::DeleteCookie";
      case messages::Profile::kGetAllCookies:
            return "Receive owl::mojom::Profile::GetAllCookies";
      case messages::Profile::kGetCookies:
            return "Receive owl::mojom::Profile::GetCookies";
      case messages::Profile::kGetFaviconFromFaviconUrl:
            return "Receive owl::mojom::Profile::GetFaviconFromFaviconUrl";
      case messages::Profile::kGetFaviconForPageUrl:
            return "Receive owl::mojom::Profile::GetFaviconForPageUrl";
      case messages::Profile::kCreateAutocompleteController:
            return "Receive owl::mojom::Profile::CreateAutocompleteController";
      case messages::Profile::kGetDefaultDownloadsLocation:
            return "Receive owl::mojom::Profile::GetDefaultDownloadsLocation";
      case messages::Profile::kSetDefaultDownloadsLocation:
            return "Receive owl::mojom::Profile::SetDefaultDownloadsLocation";
      case messages::Profile::kRegisterSearchKeywordsClient:
            return "Receive owl::mojom::Profile::RegisterSearchKeywordsClient";
      case messages::Profile::kAddSearchKeyword:
            return "Receive owl::mojom::Profile::AddSearchKeyword";
      case messages::Profile::kRemoveSearchKeyword:
            return "Receive owl::mojom::Profile::RemoveSearchKeyword";
      case messages::Profile::kUpdateSearchKeyword:
            return "Receive owl::mojom::Profile::UpdateSearchKeyword";
      case messages::Profile::kDownloadURLToFile:
            return "Receive owl::mojom::Profile::DownloadURLToFile";
      case messages::Profile::kFlushCookies:
            return "Receive owl::mojom::Profile::FlushCookies";
      case messages::Profile::kCloseProfile:
            return "Receive owl::mojom::Profile::CloseProfile";
      case messages::Profile::kImportHistory:
            return "Receive owl::mojom::Profile::ImportHistory";
      case messages::Profile::kImportChromePasswords:
            return "Receive owl::mojom::Profile::ImportChromePasswords";
      case messages::Profile::kClearBrowsingData:
            return "Receive owl::mojom::Profile::ClearBrowsingData";
      case messages::Profile::kDeferLoadsForOrigin:
            return "Receive owl::mojom::Profile::DeferLoadsForOrigin";
      case messages::Profile::kSetCustomHeaderForHosts:
            return "Receive owl::mojom::Profile::SetCustomHeaderForHosts";
      case messages::Profile::kResetProfileSettings:
            return "Receive owl::mojom::Profile::ResetProfileSettings";
      case messages::Profile::kSetWebPreferences:
            return "Receive owl::mojom::Profile::SetWebPreferences";
      case messages::Profile::kGetWebPreferences:
            return "Receive owl::mojom::Profile::GetWebPreferences";
      case messages::Profile::kQueryHistory:
            return "Receive owl::mojom::Profile::QueryHistory";
    }
  } else {
    switch (static_cast<messages::Profile>(message.name())) {
      case messages::Profile::kSetClient:
            return "Receive reply owl::mojom::Profile::SetClient";
      case messages::Profile::kGetIncognitoVariant:
            return "Receive reply owl::mojom::Profile::GetIncognitoVariant";
      case messages::Profile::kUpdateAppearanceName:
            return "Receive reply owl::mojom::Profile::UpdateAppearanceName";
      case messages::Profile::kSetOverrideColors:
            return "Receive reply owl::mojom::Profile::SetOverrideColors";
      case messages::Profile::kCreateWebViewGroup:
            return "Receive reply owl::mojom::Profile::CreateWebViewGroup";
      case messages::Profile::kRemoveWebViewGroup:
            return "Receive reply owl::mojom::Profile::RemoveWebViewGroup";
      case messages::Profile::kCreateDownloadManager:
            return "Receive reply owl::mojom::Profile::CreateDownloadManager";
      case messages::Profile::kCreateBookmarkModel:
            return "Receive reply owl::mojom::Profile::CreateBookmarkModel";
      case messages::Profile::kCreateExtensionService:
            return "Receive reply owl::mojom::Profile::CreateExtensionService";
      case messages::Profile::kCreateAutofillController:
            return "Receive reply owl::mojom::Profile::CreateAutofillController";
      case messages::Profile::kCreateMetricsService:
            return "Receive reply owl::mojom::Profile::CreateMetricsService";
      case messages::Profile::kCreateNotificationService:
            return "Receive reply owl::mojom::Profile::CreateNotificationService";
      case messages::Profile::kCreateWebViewContainerView:
            return "Receive reply owl::mojom::Profile::CreateWebViewContainerView";
      case messages::Profile::kGetTypedUrls:
            return "Receive reply owl::mojom::Profile::GetTypedUrls";
      case messages::Profile::kGetAddressList:
            return "Receive reply owl::mojom::Profile::GetAddressList";
      case messages::Profile::kGetCreditCardList:
            return "Receive reply owl::mojom::Profile::GetCreditCardList";
      case messages::Profile::kSetCookie:
            return "Receive reply owl::mojom::Profile::SetCookie";
      case messages::Profile::kDeleteCookie:
            return "Receive reply owl::mojom::Profile::DeleteCookie";
      case messages::Profile::kGetAllCookies:
            return "Receive reply owl::mojom::Profile::GetAllCookies";
      case messages::Profile::kGetCookies:
            return "Receive reply owl::mojom::Profile::GetCookies";
      case messages::Profile::kGetFaviconFromFaviconUrl:
            return "Receive reply owl::mojom::Profile::GetFaviconFromFaviconUrl";
      case messages::Profile::kGetFaviconForPageUrl:
            return "Receive reply owl::mojom::Profile::GetFaviconForPageUrl";
      case messages::Profile::kCreateAutocompleteController:
            return "Receive reply owl::mojom::Profile::CreateAutocompleteController";
      case messages::Profile::kGetDefaultDownloadsLocation:
            return "Receive reply owl::mojom::Profile::GetDefaultDownloadsLocation";
      case messages::Profile::kSetDefaultDownloadsLocation:
            return "Receive reply owl::mojom::Profile::SetDefaultDownloadsLocation";
      case messages::Profile::kRegisterSearchKeywordsClient:
            return "Receive reply owl::mojom::Profile::RegisterSearchKeywordsClient";
      case messages::Profile::kAddSearchKeyword:
            return "Receive reply owl::mojom::Profile::AddSearchKeyword";
      case messages::Profile::kRemoveSearchKeyword:
            return "Receive reply owl::mojom::Profile::RemoveSearchKeyword";
      case messages::Profile::kUpdateSearchKeyword:
            return "Receive reply owl::mojom::Profile::UpdateSearchKeyword";
      case messages::Profile::kDownloadURLToFile:
            return "Receive reply owl::mojom::Profile::DownloadURLToFile";
      case messages::Profile::kFlushCookies:
            return "Receive reply owl::mojom::Profile::FlushCookies";
      case messages::Profile::kCloseProfile:
            return "Receive reply owl::mojom::Profile::CloseProfile";
      case messages::Profile::kImportHistory:
            return "Receive reply owl::mojom::Profile::ImportHistory";
      case messages::Profile::kImportChromePasswords:
            return "Receive reply owl::mojom::Profile::ImportChromePasswords";
      case messages::Profile::kClearBrowsingData:
            return "Receive reply owl::mojom::Profile::ClearBrowsingData";
      case messages::Profile::kDeferLoadsForOrigin:
            return "Receive reply owl::mojom::Profile::DeferLoadsForOrigin";
      case messages::Profile::kSetCustomHeaderForHosts:
            return "Receive reply owl::mojom::Profile::SetCustomHeaderForHosts";
      case messages::Profile::kResetProfileSettings:
            return "Receive reply owl::mojom::Profile::ResetProfileSettings";
      case messages::Profile::kSetWebPreferences:
            return "Receive reply owl::mojom::Profile::SetWebPreferences";
      case messages::Profile::kGetWebPreferences:
            return "Receive reply owl::mojom::Profile::GetWebPreferences";
      case messages::Profile::kQueryHistory:
            return "Receive reply owl::mojom::Profile::QueryHistory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Profile::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9112ddc;  // IPCStableHash for owl::mojom::Profile::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetIncognitoVariant_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb7d2e08;  // IPCStableHash for owl::mojom::Profile::GetIncognitoVariant
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::UpdateAppearanceName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ebf5f77;  // IPCStableHash for owl::mojom::Profile::UpdateAppearanceName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::SetOverrideColors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad2a0f16;  // IPCStableHash for owl::mojom::Profile::SetOverrideColors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateWebViewGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ccab983;  // IPCStableHash for owl::mojom::Profile::CreateWebViewGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::RemoveWebViewGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x996d8063;  // IPCStableHash for owl::mojom::Profile::RemoveWebViewGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateDownloadManager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49461549;  // IPCStableHash for owl::mojom::Profile::CreateDownloadManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateBookmarkModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49873a51;  // IPCStableHash for owl::mojom::Profile::CreateBookmarkModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateExtensionService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb207a395;  // IPCStableHash for owl::mojom::Profile::CreateExtensionService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateAutofillController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37193114;  // IPCStableHash for owl::mojom::Profile::CreateAutofillController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateMetricsService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7723d45;  // IPCStableHash for owl::mojom::Profile::CreateMetricsService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateNotificationService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ec70039;  // IPCStableHash for owl::mojom::Profile::CreateNotificationService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateWebViewContainerView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x169f0a14;  // IPCStableHash for owl::mojom::Profile::CreateWebViewContainerView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetTypedUrls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19a13c90;  // IPCStableHash for owl::mojom::Profile::GetTypedUrls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetAddressList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x097ce49c;  // IPCStableHash for owl::mojom::Profile::GetAddressList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetCreditCardList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfebb76d5;  // IPCStableHash for owl::mojom::Profile::GetCreditCardList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::SetCookie_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x034d0a6a;  // IPCStableHash for owl::mojom::Profile::SetCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::DeleteCookie_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdecbf906;  // IPCStableHash for owl::mojom::Profile::DeleteCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetAllCookies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc99cd6c4;  // IPCStableHash for owl::mojom::Profile::GetAllCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetCookies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60cf16bc;  // IPCStableHash for owl::mojom::Profile::GetCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetFaviconFromFaviconUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc943c5b9;  // IPCStableHash for owl::mojom::Profile::GetFaviconFromFaviconUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetFaviconForPageUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62239bb2;  // IPCStableHash for owl::mojom::Profile::GetFaviconForPageUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CreateAutocompleteController_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xacb059f9;  // IPCStableHash for owl::mojom::Profile::CreateAutocompleteController
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetDefaultDownloadsLocation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf3d9365;  // IPCStableHash for owl::mojom::Profile::GetDefaultDownloadsLocation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::SetDefaultDownloadsLocation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb96e3099;  // IPCStableHash for owl::mojom::Profile::SetDefaultDownloadsLocation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::RegisterSearchKeywordsClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77aa564e;  // IPCStableHash for owl::mojom::Profile::RegisterSearchKeywordsClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::AddSearchKeyword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5570659d;  // IPCStableHash for owl::mojom::Profile::AddSearchKeyword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::RemoveSearchKeyword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71303689;  // IPCStableHash for owl::mojom::Profile::RemoveSearchKeyword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::UpdateSearchKeyword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcfd3e1f;  // IPCStableHash for owl::mojom::Profile::UpdateSearchKeyword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::DownloadURLToFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6dc156d3;  // IPCStableHash for owl::mojom::Profile::DownloadURLToFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::FlushCookies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7f01d7f;  // IPCStableHash for owl::mojom::Profile::FlushCookies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::CloseProfile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1fb5bef;  // IPCStableHash for owl::mojom::Profile::CloseProfile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::ImportHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82d2ce4a;  // IPCStableHash for owl::mojom::Profile::ImportHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::ImportChromePasswords_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe303442e;  // IPCStableHash for owl::mojom::Profile::ImportChromePasswords
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::ClearBrowsingData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87a9cd6d;  // IPCStableHash for owl::mojom::Profile::ClearBrowsingData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::DeferLoadsForOrigin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8bfbaf1;  // IPCStableHash for owl::mojom::Profile::DeferLoadsForOrigin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::SetCustomHeaderForHosts_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d924f8a;  // IPCStableHash for owl::mojom::Profile::SetCustomHeaderForHosts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::ResetProfileSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81c75e93;  // IPCStableHash for owl::mojom::Profile::ResetProfileSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::SetWebPreferences_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f924dc0;  // IPCStableHash for owl::mojom::Profile::SetWebPreferences
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::GetWebPreferences_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a944437;  // IPCStableHash for owl::mojom::Profile::GetWebPreferences
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Profile::QueryHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9c48a86;  // IPCStableHash for owl::mojom::Profile::QueryHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Profile_CreateBookmarkModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_CreateBookmarkModel_ForwardToCallback(
      Profile::CreateBookmarkModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_CreateBookmarkModel_ForwardToCallback(const Profile_CreateBookmarkModel_ForwardToCallback&) = delete;
  Profile_CreateBookmarkModel_ForwardToCallback& operator=(const Profile_CreateBookmarkModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::CreateBookmarkModelCallback callback_;
};

class Profile_GetTypedUrls_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetTypedUrls_ForwardToCallback(
      Profile::GetTypedUrlsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetTypedUrls_ForwardToCallback(const Profile_GetTypedUrls_ForwardToCallback&) = delete;
  Profile_GetTypedUrls_ForwardToCallback& operator=(const Profile_GetTypedUrls_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetTypedUrlsCallback callback_;
};

class Profile_GetAddressList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetAddressList_ForwardToCallback(
      Profile::GetAddressListCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetAddressList_ForwardToCallback(const Profile_GetAddressList_ForwardToCallback&) = delete;
  Profile_GetAddressList_ForwardToCallback& operator=(const Profile_GetAddressList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetAddressListCallback callback_;
};

class Profile_GetCreditCardList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetCreditCardList_ForwardToCallback(
      Profile::GetCreditCardListCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetCreditCardList_ForwardToCallback(const Profile_GetCreditCardList_ForwardToCallback&) = delete;
  Profile_GetCreditCardList_ForwardToCallback& operator=(const Profile_GetCreditCardList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetCreditCardListCallback callback_;
};

class Profile_SetCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_SetCookie_ForwardToCallback(
      Profile::SetCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_SetCookie_ForwardToCallback(const Profile_SetCookie_ForwardToCallback&) = delete;
  Profile_SetCookie_ForwardToCallback& operator=(const Profile_SetCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::SetCookieCallback callback_;
};

class Profile_DeleteCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_DeleteCookie_ForwardToCallback(
      Profile::DeleteCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_DeleteCookie_ForwardToCallback(const Profile_DeleteCookie_ForwardToCallback&) = delete;
  Profile_DeleteCookie_ForwardToCallback& operator=(const Profile_DeleteCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::DeleteCookieCallback callback_;
};

class Profile_GetAllCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetAllCookies_ForwardToCallback(
      Profile::GetAllCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetAllCookies_ForwardToCallback(const Profile_GetAllCookies_ForwardToCallback&) = delete;
  Profile_GetAllCookies_ForwardToCallback& operator=(const Profile_GetAllCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetAllCookiesCallback callback_;
};

class Profile_GetCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetCookies_ForwardToCallback(
      Profile::GetCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetCookies_ForwardToCallback(const Profile_GetCookies_ForwardToCallback&) = delete;
  Profile_GetCookies_ForwardToCallback& operator=(const Profile_GetCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetCookiesCallback callback_;
};

class Profile_GetFaviconFromFaviconUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetFaviconFromFaviconUrl_ForwardToCallback(
      Profile::GetFaviconFromFaviconUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetFaviconFromFaviconUrl_ForwardToCallback(const Profile_GetFaviconFromFaviconUrl_ForwardToCallback&) = delete;
  Profile_GetFaviconFromFaviconUrl_ForwardToCallback& operator=(const Profile_GetFaviconFromFaviconUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetFaviconFromFaviconUrlCallback callback_;
};

class Profile_GetFaviconForPageUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetFaviconForPageUrl_ForwardToCallback(
      Profile::GetFaviconForPageUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetFaviconForPageUrl_ForwardToCallback(const Profile_GetFaviconForPageUrl_ForwardToCallback&) = delete;
  Profile_GetFaviconForPageUrl_ForwardToCallback& operator=(const Profile_GetFaviconForPageUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetFaviconForPageUrlCallback callback_;
};

class Profile_GetDefaultDownloadsLocation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetDefaultDownloadsLocation_ForwardToCallback(
      Profile::GetDefaultDownloadsLocationCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetDefaultDownloadsLocation_ForwardToCallback(const Profile_GetDefaultDownloadsLocation_ForwardToCallback&) = delete;
  Profile_GetDefaultDownloadsLocation_ForwardToCallback& operator=(const Profile_GetDefaultDownloadsLocation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetDefaultDownloadsLocationCallback callback_;
};

class Profile_AddSearchKeyword_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_AddSearchKeyword_ForwardToCallback(
      Profile::AddSearchKeywordCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_AddSearchKeyword_ForwardToCallback(const Profile_AddSearchKeyword_ForwardToCallback&) = delete;
  Profile_AddSearchKeyword_ForwardToCallback& operator=(const Profile_AddSearchKeyword_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::AddSearchKeywordCallback callback_;
};

class Profile_FlushCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_FlushCookies_ForwardToCallback(
      Profile::FlushCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_FlushCookies_ForwardToCallback(const Profile_FlushCookies_ForwardToCallback&) = delete;
  Profile_FlushCookies_ForwardToCallback& operator=(const Profile_FlushCookies_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::FlushCookiesCallback callback_;
};

class Profile_ImportHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_ImportHistory_ForwardToCallback(
      Profile::ImportHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_ImportHistory_ForwardToCallback(const Profile_ImportHistory_ForwardToCallback&) = delete;
  Profile_ImportHistory_ForwardToCallback& operator=(const Profile_ImportHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::ImportHistoryCallback callback_;
};

class Profile_ImportChromePasswords_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_ImportChromePasswords_ForwardToCallback(
      Profile::ImportChromePasswordsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_ImportChromePasswords_ForwardToCallback(const Profile_ImportChromePasswords_ForwardToCallback&) = delete;
  Profile_ImportChromePasswords_ForwardToCallback& operator=(const Profile_ImportChromePasswords_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::ImportChromePasswordsCallback callback_;
};

class Profile_ClearBrowsingData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_ClearBrowsingData_ForwardToCallback(
      Profile::ClearBrowsingDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_ClearBrowsingData_ForwardToCallback(const Profile_ClearBrowsingData_ForwardToCallback&) = delete;
  Profile_ClearBrowsingData_ForwardToCallback& operator=(const Profile_ClearBrowsingData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::ClearBrowsingDataCallback callback_;
};

class Profile_ResetProfileSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_ResetProfileSettings_ForwardToCallback(
      Profile::ResetProfileSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_ResetProfileSettings_ForwardToCallback(const Profile_ResetProfileSettings_ForwardToCallback&) = delete;
  Profile_ResetProfileSettings_ForwardToCallback& operator=(const Profile_ResetProfileSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::ResetProfileSettingsCallback callback_;
};

class Profile_GetWebPreferences_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_GetWebPreferences_ForwardToCallback(
      Profile::GetWebPreferencesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_GetWebPreferences_ForwardToCallback(const Profile_GetWebPreferences_ForwardToCallback&) = delete;
  Profile_GetWebPreferences_ForwardToCallback& operator=(const Profile_GetWebPreferences_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::GetWebPreferencesCallback callback_;
};

class Profile_QueryHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Profile_QueryHistory_ForwardToCallback(
      Profile::QueryHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  Profile_QueryHistory_ForwardToCallback(const Profile_QueryHistory_ForwardToCallback&) = delete;
  Profile_QueryHistory_ForwardToCallback& operator=(const Profile_QueryHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Profile::QueryHistoryCallback callback_;
};

ProfileProxy::ProfileProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfileProxy::SetClient(
    ::mojo::PendingAssociatedRemote<ProfileClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<ProfileClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::ProfileClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::GetIncognitoVariant(
    ::mojo::PendingReceiver<Profile> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::GetIncognitoVariant", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Profile>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetIncognitoVariant), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetIncognitoVariant_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::ProfileInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Profile.GetIncognitoVariant request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetIncognitoVariant");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::UpdateAppearanceName(
    const std::optional<std::string>& in_appearance_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::UpdateAppearanceName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("appearance_name"), in_appearance_name,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kUpdateAppearanceName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_UpdateAppearanceName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->appearance_name)::BaseType> appearance_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_appearance_name,
    appearance_name_fragment);

  params->appearance_name.Set(
      appearance_name_fragment.is_null() ? nullptr : appearance_name_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("UpdateAppearanceName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::SetOverrideColors(
    bool in_is_custom_theme, std::optional<::SkColor> in_control_accent_color, std::optional<::SkColor> in_selected_text_background_color, std::optional<::SkColor> in_insertion_point_color, std::optional<::SkColor> in_control_accent_background_color, std::optional<::SkColor> in_control_accent_background_hover_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetOverrideColors", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_custom_theme"), in_is_custom_theme,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("control_accent_color"), in_control_accent_color,
                        "<value of type std::optional<::SkColor>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_text_background_color"), in_selected_text_background_color,
                        "<value of type std::optional<::SkColor>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("insertion_point_color"), in_insertion_point_color,
                        "<value of type std::optional<::SkColor>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("control_accent_background_color"), in_control_accent_background_color,
                        "<value of type std::optional<::SkColor>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("control_accent_background_hover_color"), in_control_accent_background_hover_color,
                        "<value of type std::optional<::SkColor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetOverrideColors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetOverrideColors_Params_Data> params(
          message);
  params.Allocate();

  params->is_custom_theme = in_is_custom_theme;
  mojo::internal::MessageFragment<
      typename decltype(params->control_accent_color)::BaseType> control_accent_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_control_accent_color,
    control_accent_color_fragment);

  params->control_accent_color.Set(
      control_accent_color_fragment.is_null() ? nullptr : control_accent_color_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->selected_text_background_color)::BaseType> selected_text_background_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_selected_text_background_color,
    selected_text_background_color_fragment);

  params->selected_text_background_color.Set(
      selected_text_background_color_fragment.is_null() ? nullptr : selected_text_background_color_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->insertion_point_color)::BaseType> insertion_point_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_insertion_point_color,
    insertion_point_color_fragment);

  params->insertion_point_color.Set(
      insertion_point_color_fragment.is_null() ? nullptr : insertion_point_color_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->control_accent_background_color)::BaseType> control_accent_background_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_control_accent_background_color,
    control_accent_background_color_fragment);

  params->control_accent_background_color.Set(
      control_accent_background_color_fragment.is_null() ? nullptr : control_accent_background_color_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->control_accent_background_hover_color)::BaseType> control_accent_background_hover_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_control_accent_background_hover_color,
    control_accent_background_hover_color_fragment);

  params->control_accent_background_hover_color.Set(
      control_accent_background_hover_color_fragment.is_null() ? nullptr : control_accent_background_hover_color_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetOverrideColors");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateWebViewGroup(
    const std::string& in_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateWebViewGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateWebViewGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateWebViewGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in Profile.CreateWebViewGroup request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateWebViewGroup request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateWebViewGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateWebViewGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::RemoveWebViewGroup(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::RemoveWebViewGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kRemoveWebViewGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_RemoveWebViewGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in Profile.RemoveWebViewGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("RemoveWebViewGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateDownloadManager(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateDownloadManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateDownloadManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateDownloadManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::DownloadManagerAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateDownloadManager request");

  
  mojo::internal::Serialize<::owl::mojom::DownloadManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateDownloadManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateDownloadManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateBookmarkModel(
    CreateBookmarkModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::CreateBookmarkModel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateBookmarkModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateBookmarkModel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateBookmarkModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_CreateBookmarkModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::CreateExtensionService(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateExtensionService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateExtensionService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateExtensionService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::ExtensionServiceAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateExtensionService request");

  
  mojo::internal::Serialize<::owl::mojom::ExtensionServiceClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateExtensionService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateExtensionService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateAutofillController(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateAutofillController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateAutofillController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateAutofillController_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::AutofillControllerHostAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateAutofillController request");

  
  mojo::internal::Serialize<::owl::mojom::AutofillControllerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateAutofillController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateAutofillController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateMetricsService(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateMetricsService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateMetricsService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateMetricsService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::MetricsServiceAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateMetricsService request");

  
  mojo::internal::Serialize<::owl::mojom::MetricsServiceClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateMetricsService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateMetricsService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateNotificationService(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateNotificationService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateNotificationService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateNotificationService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::NotificationServiceAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateNotificationService request");

  
  mojo::internal::Serialize<::owl::mojom::NotificationServiceClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.CreateNotificationService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateNotificationService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::CreateWebViewContainerView(
    ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> in_receiver, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> in_layer_host_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> in_layer_host_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateWebViewContainerView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_host_receiver"), in_layer_host_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_host_client"), in_layer_host_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateWebViewContainerView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateWebViewContainerView_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::WebViewContainerViewAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateWebViewContainerView request");

  
  mojo::internal::Serialize<::owl::mojom::LayerHostAssociatedRequestDataView>(
    in_layer_host_receiver,
    &params->layer_host_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->layer_host_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid layer_host_receiver in Profile.CreateWebViewContainerView request");

  
  mojo::internal::Serialize<::owl::mojom::LayerHostClientAssociatedPtrInfoDataView>(
    in_layer_host_client,
    &params->layer_host_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->layer_host_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid layer_host_client in Profile.CreateWebViewContainerView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateWebViewContainerView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::GetTypedUrls(
    GetTypedUrlsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::GetTypedUrls");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetTypedUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetTypedUrls_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetTypedUrls");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetTypedUrls_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetAddressList(
    GetAddressListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::GetAddressList");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetAddressList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetAddressList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetAddressList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetAddressList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetCreditCardList(
    GetCreditCardListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::GetCreditCardList");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetCreditCardList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetCreditCardList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetCreditCardList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetCreditCardList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::SetCookie(
    const ::GURL& in_url, CookieDataPtr in_cookie, SetCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type CookieDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.SetCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CookieDataDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in Profile.SetCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_SetCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::DeleteCookie(
    const ::GURL& in_url, CookieDataPtr in_cookie, DeleteCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::DeleteCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type CookieDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kDeleteCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_DeleteCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.DeleteCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CookieDataDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in Profile.DeleteCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("DeleteCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_DeleteCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetAllCookies(
    const ::GURL& in_url, GetAllCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::GetAllCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetAllCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetAllCookies_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.GetAllCookies request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetAllCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetAllCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetCookies(
    const ::GURL& in_url, const std::string& in_name, GetCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::GetCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetCookies_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.GetCookies request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Profile.GetCookies request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetFaviconFromFaviconUrl(
    const ::GURL& in_url, GetFaviconFromFaviconUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::GetFaviconFromFaviconUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetFaviconFromFaviconUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetFaviconFromFaviconUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.GetFaviconFromFaviconUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetFaviconFromFaviconUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetFaviconFromFaviconUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::GetFaviconForPageUrl(
    const ::GURL& in_url, GetFaviconForPageUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::GetFaviconForPageUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetFaviconForPageUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetFaviconForPageUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.GetFaviconForPageUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetFaviconForPageUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetFaviconForPageUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::CreateAutocompleteController(
    ::owl::mojom::AutocompleteConfiguration in_configuration, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CreateAutocompleteController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type ::owl::mojom::AutocompleteConfiguration>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateAutocompleteController), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateAutocompleteController_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::AutocompleteConfiguration>(
    in_configuration,
    &params->configuration);

  
  mojo::internal::Serialize<::owl::mojom::AutocompleteControllerAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in Profile.CreateAutocompleteController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateAutocompleteController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::GetDefaultDownloadsLocation(
    GetDefaultDownloadsLocationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::GetDefaultDownloadsLocation");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetDefaultDownloadsLocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetDefaultDownloadsLocation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetDefaultDownloadsLocation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetDefaultDownloadsLocation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::SetDefaultDownloadsLocation(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetDefaultDownloadsLocation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetDefaultDownloadsLocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetDefaultDownloadsLocation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Profile.SetDefaultDownloadsLocation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetDefaultDownloadsLocation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::RegisterSearchKeywordsClient(
    ::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::RegisterSearchKeywordsClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kRegisterSearchKeywordsClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_RegisterSearchKeywordsClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::SearchKeywordsClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.RegisterSearchKeywordsClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("RegisterSearchKeywordsClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::AddSearchKeyword(
    const ::std::u16string& in_name, const ::std::u16string& in_keyword, const ::std::u16string& in_url, AddSearchKeywordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::AddSearchKeyword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keyword"), in_keyword,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kAddSearchKeyword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_AddSearchKeyword_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Profile.AddSearchKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->keyword)::BaseType> keyword_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_keyword,
    keyword_fragment);

  params->keyword.Set(
      keyword_fragment.is_null() ? nullptr : keyword_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keyword.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keyword in Profile.AddSearchKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.AddSearchKeyword request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("AddSearchKeyword");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_AddSearchKeyword_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::RemoveSearchKeyword(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::RemoveSearchKeyword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kRemoveSearchKeyword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_RemoveSearchKeyword_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in Profile.RemoveSearchKeyword request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("RemoveSearchKeyword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::UpdateSearchKeyword(
    const std::string& in_id, const ::std::u16string& in_name, const ::std::u16string& in_keyword, const ::std::u16string& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::UpdateSearchKeyword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keyword"), in_keyword,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kUpdateSearchKeyword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_UpdateSearchKeyword_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in Profile.UpdateSearchKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in Profile.UpdateSearchKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->keyword)::BaseType> keyword_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_keyword,
    keyword_fragment);

  params->keyword.Set(
      keyword_fragment.is_null() ? nullptr : keyword_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keyword.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keyword in Profile.UpdateSearchKeyword request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.UpdateSearchKeyword request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("UpdateSearchKeyword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::DownloadURLToFile(
    const ::GURL& in_url, ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::DownloadURLToFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<DownloadURLToFileClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kDownloadURLToFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_DownloadURLToFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in Profile.DownloadURLToFile request");

  
  mojo::internal::Serialize<::owl::mojom::DownloadURLToFileClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Profile.DownloadURLToFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("DownloadURLToFile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::FlushCookies(
    FlushCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::FlushCookies");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kFlushCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_FlushCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("FlushCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_FlushCookies_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::CloseProfile(
    ::mojo::PendingRemote<ProfileCloseListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::CloseProfile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<ProfileCloseListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCloseProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CloseProfile_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::owl::mojom::ProfileCloseListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in Profile.CloseProfile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CloseProfile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::ImportHistory(
    std::vector<HistoryVisitPtr> in_visits, ImportHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::ImportHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visits"), in_visits,
                        "<value of type std::vector<HistoryVisitPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kImportHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ImportHistory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visits)::BaseType>
      visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::HistoryVisitDataView>>(
    in_visits,
    visits_fragment,
    &visits_validate_params);

  params->visits.Set(
      visits_fragment.is_null() ? nullptr : visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visits in Profile.ImportHistory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ImportHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_ImportHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::ImportChromePasswords(
    const ::base::FilePath& in_profile_path, const std::vector<uint8_t>& in_decryption_key, ImportChromePasswordsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::ImportChromePasswords", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_path"), in_profile_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decryption_key"), in_decryption_key,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kImportChromePasswords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ImportChromePasswords_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_path)::BaseType> profile_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_profile_path,
    profile_path_fragment);

  params->profile_path.Set(
      profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_path in Profile.ImportChromePasswords request");
  mojo::internal::MessageFragment<
      typename decltype(params->decryption_key)::BaseType>
      decryption_key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& decryption_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_decryption_key,
    decryption_key_fragment,
    &decryption_key_validate_params);

  params->decryption_key.Set(
      decryption_key_fragment.is_null() ? nullptr : decryption_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->decryption_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null decryption_key in Profile.ImportChromePasswords request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ImportChromePasswords");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_ImportChromePasswords_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::ClearBrowsingData(
    const std::vector<ClearBrowsingDataType>& in_types, std::optional<::base::Time> in_delete_begin, std::optional<::base::Time> in_delete_end, ClearBrowsingDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::ClearBrowsingData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("types"), in_types,
                        "<value of type const std::vector<ClearBrowsingDataType>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_begin"), in_delete_begin,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_end"), in_delete_end,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kClearBrowsingData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ClearBrowsingData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->types)::BaseType>
      types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::owl::mojom::internal::ClearBrowsingDataType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ClearBrowsingDataType>>(
    in_types,
    types_fragment,
    &types_validate_params);

  params->types.Set(
      types_fragment.is_null() ? nullptr : types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null types in Profile.ClearBrowsingData request");
  mojo::internal::MessageFragment<
      typename decltype(params->delete_begin)::BaseType> delete_begin_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_delete_begin,
    delete_begin_fragment);

  params->delete_begin.Set(
      delete_begin_fragment.is_null() ? nullptr : delete_begin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->delete_end)::BaseType> delete_end_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_delete_end,
    delete_end_fragment);

  params->delete_end.Set(
      delete_end_fragment.is_null() ? nullptr : delete_end_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ClearBrowsingData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_ClearBrowsingData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::DeferLoadsForOrigin(
    const ::GURL& in_origin, ::mojo::PendingReceiver<DeferredLoadBlocker> in_blocker_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::DeferLoadsForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocker_receiver"), in_blocker_receiver,
                        "<value of type ::mojo::PendingReceiver<DeferredLoadBlocker>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kDeferLoadsForOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_DeferLoadsForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in Profile.DeferLoadsForOrigin request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::DeferredLoadBlockerInterfaceBase>>(
    in_blocker_receiver,
    &params->blocker_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blocker_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blocker_receiver in Profile.DeferLoadsForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("DeferLoadsForOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::SetCustomHeaderForHosts(
    const std::string& in_header_name, const std::string& in_header_value, const std::vector<std::string>& in_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetCustomHeaderForHosts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_name"), in_header_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_value"), in_header_value,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hosts"), in_hosts,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetCustomHeaderForHosts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetCustomHeaderForHosts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->header_name)::BaseType> header_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header_name,
    header_name_fragment);

  params->header_name.Set(
      header_name_fragment.is_null() ? nullptr : header_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header_name in Profile.SetCustomHeaderForHosts request");
  mojo::internal::MessageFragment<
      typename decltype(params->header_value)::BaseType> header_value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_header_value,
    header_value_fragment);

  params->header_value.Set(
      header_value_fragment.is_null() ? nullptr : header_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->header_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null header_value in Profile.SetCustomHeaderForHosts request");
  mojo::internal::MessageFragment<
      typename decltype(params->hosts)::BaseType>
      hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_hosts,
    hosts_fragment,
    &hosts_validate_params);

  params->hosts.Set(
      hosts_fragment.is_null() ? nullptr : hosts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hosts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hosts in Profile.SetCustomHeaderForHosts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetCustomHeaderForHosts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::ResetProfileSettings(
    ResetProfileSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::ResetProfileSettings");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kResetProfileSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ResetProfileSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ResetProfileSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_ResetProfileSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::SetWebPreferences(
    ::owl::mojom::WebPreferencesPtr in_prefs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::SetWebPreferences", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefs"), in_prefs,
                        "<value of type ::owl::mojom::WebPreferencesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetWebPreferences), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetWebPreferences_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prefs)::BaseType> prefs_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::WebPreferencesDataView>(
    in_prefs,
    prefs_fragment);

  params->prefs.Set(
      prefs_fragment.is_null() ? nullptr : prefs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prefs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prefs in Profile.SetWebPreferences request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetWebPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileProxy::GetWebPreferences(
    GetWebPreferencesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::Profile::GetWebPreferences");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetWebPreferences), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetWebPreferences_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetWebPreferences");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_GetWebPreferences_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfileProxy::QueryHistory(
    const ::std::u16string& in_query, QueryHistoryOptionsPtr in_options, QueryHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::Profile::QueryHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type QueryHistoryOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kQueryHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_QueryHistory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in Profile.QueryHistory request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::QueryHistoryOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("QueryHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Profile_QueryHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Profile_CreateBookmarkModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::CreateBookmarkModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_CreateBookmarkModel_ProxyToResponder> proxy(
        new Profile_CreateBookmarkModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_CreateBookmarkModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_CreateBookmarkModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_CreateBookmarkModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::CreateBookmarkModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateBookmarkModelResultPtr in_result);
};

bool Profile_CreateBookmarkModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_CreateBookmarkModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_CreateBookmarkModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.7
  bool success = true;
  CreateBookmarkModelResultPtr p_result{};
  Profile_CreateBookmarkModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Profile_CreateBookmarkModel_ProxyToResponder::Run(
    CreateBookmarkModelResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::CreateBookmarkModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateBookmarkModelResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kCreateBookmarkModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_CreateBookmarkModel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CreateBookmarkModelResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("CreateBookmarkModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetTypedUrls_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetTypedUrlsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetTypedUrls_ProxyToResponder> proxy(
        new Profile_GetTypedUrls_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetTypedUrls_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetTypedUrls_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetTypedUrls_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetTypedUrlsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TypedUrlPtr> in_typed_urls);
};

bool Profile_GetTypedUrls_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetTypedUrls_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetTypedUrls_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.13
  bool success = true;
  std::vector<TypedUrlPtr> p_typed_urls{};
  Profile_GetTypedUrls_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTypedUrls(&p_typed_urls))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_typed_urls));
  }
  return true;
}

void Profile_GetTypedUrls_ProxyToResponder::Run(
    std::vector<TypedUrlPtr> in_typed_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetTypedUrls", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("typed_urls"), in_typed_urls,
                        "<value of type std::vector<TypedUrlPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetTypedUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetTypedUrls_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->typed_urls)::BaseType>
      typed_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& typed_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::TypedUrlDataView>>(
    in_typed_urls,
    typed_urls_fragment,
    &typed_urls_validate_params);

  params->typed_urls.Set(
      typed_urls_fragment.is_null() ? nullptr : typed_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->typed_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null typed_urls in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetTypedUrls");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetAddressList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetAddressListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetAddressList_ProxyToResponder> proxy(
        new Profile_GetAddressList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetAddressList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetAddressList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetAddressList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetAddressListCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::owl::mojom::AutofillAddressEntryPtr> in_addresses);
};

bool Profile_GetAddressList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetAddressList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetAddressList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.14
  bool success = true;
  std::vector<::owl::mojom::AutofillAddressEntryPtr> p_addresses{};
  Profile_GetAddressList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAddresses(&p_addresses))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_addresses));
  }
  return true;
}

void Profile_GetAddressList_ProxyToResponder::Run(
    std::vector<::owl::mojom::AutofillAddressEntryPtr> in_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetAddressList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addresses"), in_addresses,
                        "<value of type std::vector<::owl::mojom::AutofillAddressEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetAddressList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetAddressList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addresses)::BaseType>
      addresses_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::AutofillAddressEntryDataView>>(
    in_addresses,
    addresses_fragment,
    &addresses_validate_params);

  params->addresses.Set(
      addresses_fragment.is_null() ? nullptr : addresses_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addresses.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addresses in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetAddressList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetCreditCardList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetCreditCardListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetCreditCardList_ProxyToResponder> proxy(
        new Profile_GetCreditCardList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetCreditCardList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetCreditCardList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetCreditCardList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetCreditCardListCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::owl::mojom::AutofillCreditCardEntryPtr> in_credit_cards);
};

bool Profile_GetCreditCardList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetCreditCardList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetCreditCardList_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.15
  bool success = true;
  std::vector<::owl::mojom::AutofillCreditCardEntryPtr> p_credit_cards{};
  Profile_GetCreditCardList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCreditCards(&p_credit_cards))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_credit_cards));
  }
  return true;
}

void Profile_GetCreditCardList_ProxyToResponder::Run(
    std::vector<::owl::mojom::AutofillCreditCardEntryPtr> in_credit_cards) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetCreditCardList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credit_cards"), in_credit_cards,
                        "<value of type std::vector<::owl::mojom::AutofillCreditCardEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetCreditCardList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetCreditCardList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credit_cards)::BaseType>
      credit_cards_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& credit_cards_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::AutofillCreditCardEntryDataView>>(
    in_credit_cards,
    credit_cards_fragment,
    &credit_cards_validate_params);

  params->credit_cards.Set(
      credit_cards_fragment.is_null() ? nullptr : credit_cards_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->credit_cards.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null credit_cards in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetCreditCardList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_SetCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::SetCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_SetCookie_ProxyToResponder> proxy(
        new Profile_SetCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_SetCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_SetCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_SetCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::SetCookieCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SetCookieResult in_result);
};

bool Profile_SetCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_SetCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_SetCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.16
  bool success = true;
  SetCookieResult p_result{};
  Profile_SetCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Profile_SetCookie_ProxyToResponder::Run(
    SetCookieResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::SetCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SetCookieResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kSetCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_SetCookie_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::SetCookieResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("SetCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_DeleteCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::DeleteCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_DeleteCookie_ProxyToResponder> proxy(
        new Profile_DeleteCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_DeleteCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_DeleteCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_DeleteCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::DeleteCookieCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeleteCookieResult in_result);
};

bool Profile_DeleteCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_DeleteCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_DeleteCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.17
  bool success = true;
  DeleteCookieResult p_result{};
  Profile_DeleteCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Profile_DeleteCookie_ProxyToResponder::Run(
    DeleteCookieResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::DeleteCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeleteCookieResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kDeleteCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_DeleteCookie_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::DeleteCookieResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("DeleteCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetAllCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetAllCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetAllCookies_ProxyToResponder> proxy(
        new Profile_GetAllCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetAllCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetAllCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetAllCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetAllCookiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CookieDataPtr> in_cookies);
};

bool Profile_GetAllCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetAllCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetAllCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.18
  bool success = true;
  std::vector<CookieDataPtr> p_cookies{};
  Profile_GetAllCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies));
  }
  return true;
}

void Profile_GetAllCookies_ProxyToResponder::Run(
    std::vector<CookieDataPtr> in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetAllCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type std::vector<CookieDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetAllCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetAllCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::CookieDataDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetAllCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetCookies_ProxyToResponder> proxy(
        new Profile_GetCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetCookiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CookieDataPtr> in_cookies);
};

bool Profile_GetCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.19
  bool success = true;
  std::vector<CookieDataPtr> p_cookies{};
  Profile_GetCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies));
  }
  return true;
}

void Profile_GetCookies_ProxyToResponder::Run(
    std::vector<CookieDataPtr> in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetCookies", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type std::vector<CookieDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::CookieDataDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetFaviconFromFaviconUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetFaviconFromFaviconUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetFaviconFromFaviconUrl_ProxyToResponder> proxy(
        new Profile_GetFaviconFromFaviconUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetFaviconFromFaviconUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetFaviconFromFaviconUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetFaviconFromFaviconUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetFaviconFromFaviconUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::ImageSkia& in_image);
};

bool Profile_GetFaviconFromFaviconUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetFaviconFromFaviconUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetFaviconFromFaviconUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.20
  bool success = true;
  ::gfx::ImageSkia p_image{};
  Profile_GetFaviconFromFaviconUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_image));
  }
  return true;
}

void Profile_GetFaviconFromFaviconUrl_ProxyToResponder::Run(
    const ::gfx::ImageSkia& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetFaviconFromFaviconUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetFaviconFromFaviconUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetFaviconFromFaviconUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetFaviconFromFaviconUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetFaviconForPageUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetFaviconForPageUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetFaviconForPageUrl_ProxyToResponder> proxy(
        new Profile_GetFaviconForPageUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetFaviconForPageUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetFaviconForPageUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetFaviconForPageUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetFaviconForPageUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::ImageSkia& in_image);
};

bool Profile_GetFaviconForPageUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetFaviconForPageUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetFaviconForPageUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.21
  bool success = true;
  ::gfx::ImageSkia p_image{};
  Profile_GetFaviconForPageUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_image));
  }
  return true;
}

void Profile_GetFaviconForPageUrl_ProxyToResponder::Run(
    const ::gfx::ImageSkia& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetFaviconForPageUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetFaviconForPageUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetFaviconForPageUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetFaviconForPageUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetDefaultDownloadsLocation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetDefaultDownloadsLocationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetDefaultDownloadsLocation_ProxyToResponder> proxy(
        new Profile_GetDefaultDownloadsLocation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetDefaultDownloadsLocation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetDefaultDownloadsLocation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetDefaultDownloadsLocation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetDefaultDownloadsLocationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_path);
};

bool Profile_GetDefaultDownloadsLocation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetDefaultDownloadsLocation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetDefaultDownloadsLocation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.23
  bool success = true;
  ::base::FilePath p_path{};
  Profile_GetDefaultDownloadsLocation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_path));
  }
  return true;
}

void Profile_GetDefaultDownloadsLocation_ProxyToResponder::Run(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetDefaultDownloadsLocation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetDefaultDownloadsLocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetDefaultDownloadsLocation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetDefaultDownloadsLocation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_AddSearchKeyword_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::AddSearchKeywordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_AddSearchKeyword_ProxyToResponder> proxy(
        new Profile_AddSearchKeyword_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_AddSearchKeyword_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_AddSearchKeyword_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_AddSearchKeyword_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::AddSearchKeywordCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_id);
};

bool Profile_AddSearchKeyword_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_AddSearchKeyword_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_AddSearchKeyword_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.26
  bool success = true;
  std::optional<std::string> p_id{};
  Profile_AddSearchKeyword_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_id));
  }
  return true;
}

void Profile_AddSearchKeyword_ProxyToResponder::Run(
    const std::optional<std::string>& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::AddSearchKeyword", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kAddSearchKeyword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_AddSearchKeyword_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("AddSearchKeyword");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_FlushCookies_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::FlushCookiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_FlushCookies_ProxyToResponder> proxy(
        new Profile_FlushCookies_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_FlushCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_FlushCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_FlushCookies_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::FlushCookiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Profile_FlushCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_FlushCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_FlushCookies_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.30
  bool success = true;
  Profile_FlushCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Profile_FlushCookies_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::Profile::FlushCookies");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kFlushCookies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_FlushCookies_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("FlushCookies");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_ImportHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::ImportHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_ImportHistory_ProxyToResponder> proxy(
        new Profile_ImportHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_ImportHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_ImportHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_ImportHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::ImportHistoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_imported_visits_count);
};

bool Profile_ImportHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_ImportHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_ImportHistory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.32
  bool success = true;
  int64_t p_imported_visits_count{};
  Profile_ImportHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_imported_visits_count = input_data_view.imported_visits_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_imported_visits_count));
  }
  return true;
}

void Profile_ImportHistory_ProxyToResponder::Run(
    int64_t in_imported_visits_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::ImportHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("imported_visits_count"), in_imported_visits_count,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kImportHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ImportHistory_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->imported_visits_count = in_imported_visits_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ImportHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_ImportChromePasswords_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::ImportChromePasswordsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_ImportChromePasswords_ProxyToResponder> proxy(
        new Profile_ImportChromePasswords_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_ImportChromePasswords_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_ImportChromePasswords_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_ImportChromePasswords_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::ImportChromePasswordsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Profile_ImportChromePasswords_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_ImportChromePasswords_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_ImportChromePasswords_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.33
  bool success = true;
  bool p_success{};
  Profile_ImportChromePasswords_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Profile_ImportChromePasswords_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::ImportChromePasswords", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kImportChromePasswords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ImportChromePasswords_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ImportChromePasswords");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_ClearBrowsingData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::ClearBrowsingDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_ClearBrowsingData_ProxyToResponder> proxy(
        new Profile_ClearBrowsingData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_ClearBrowsingData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_ClearBrowsingData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_ClearBrowsingData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::ClearBrowsingDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Profile_ClearBrowsingData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_ClearBrowsingData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_ClearBrowsingData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.34
  bool success = true;
  bool p_success{};
  Profile_ClearBrowsingData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Profile_ClearBrowsingData_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::ClearBrowsingData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kClearBrowsingData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ClearBrowsingData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ClearBrowsingData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_ResetProfileSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::ResetProfileSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_ResetProfileSettings_ProxyToResponder> proxy(
        new Profile_ResetProfileSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_ResetProfileSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_ResetProfileSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_ResetProfileSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::ResetProfileSettingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Profile_ResetProfileSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_ResetProfileSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_ResetProfileSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.37
  bool success = true;
  Profile_ResetProfileSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Profile_ResetProfileSettings_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::Profile::ResetProfileSettings");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kResetProfileSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_ResetProfileSettings_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("ResetProfileSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_GetWebPreferences_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::GetWebPreferencesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_GetWebPreferences_ProxyToResponder> proxy(
        new Profile_GetWebPreferences_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_GetWebPreferences_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_GetWebPreferences_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_GetWebPreferences_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::GetWebPreferencesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::owl::mojom::WebPreferencesPtr in_prefs);
};

bool Profile_GetWebPreferences_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_GetWebPreferences_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_GetWebPreferences_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.39
  bool success = true;
  ::owl::mojom::WebPreferencesPtr p_prefs{};
  Profile_GetWebPreferences_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPrefs(&p_prefs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_prefs));
  }
  return true;
}

void Profile_GetWebPreferences_ProxyToResponder::Run(
    ::owl::mojom::WebPreferencesPtr in_prefs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::GetWebPreferences", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefs"), in_prefs,
                        "<value of type ::owl::mojom::WebPreferencesPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kGetWebPreferences), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_GetWebPreferences_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prefs)::BaseType> prefs_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::WebPreferencesDataView>(
    in_prefs,
    prefs_fragment);

  params->prefs.Set(
      prefs_fragment.is_null() ? nullptr : prefs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prefs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prefs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("GetWebPreferences");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Profile_QueryHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Profile::QueryHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Profile_QueryHistory_ProxyToResponder> proxy(
        new Profile_QueryHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Profile_QueryHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Profile_QueryHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Profile_QueryHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Profile::QueryHistoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      QueryHistoryResponsePtr in_response);
};

bool Profile_QueryHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Profile_QueryHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Profile_QueryHistory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Profile.40
  bool success = true;
  QueryHistoryResponsePtr p_response{};
  Profile_QueryHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Profile::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void Profile_QueryHistory_ProxyToResponder::Run(
    QueryHistoryResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::Profile::QueryHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type QueryHistoryResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Profile::kQueryHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::Profile_QueryHistory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::QueryHistoryResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Profile::Name_);
  message.set_method_name("QueryHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProfileStubDispatch::Accept(
    Profile* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Profile>(message->header()->name)) {
    case messages::Profile::kSetClient: {
      DCHECK(message->is_serialized());
      internal::Profile_SetClient_Params_Data* params =
          reinterpret_cast<internal::Profile_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<ProfileClient> p_client{};
      Profile_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::Profile::kGetIncognitoVariant: {
      DCHECK(message->is_serialized());
      internal::Profile_GetIncognitoVariant_Params_Data* params =
          reinterpret_cast<internal::Profile_GetIncognitoVariant_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.1
      bool success = true;
      ::mojo::PendingReceiver<Profile> p_receiver{};
      Profile_GetIncognitoVariant_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIncognitoVariant(        
        std::move(p_receiver));
      return true;
    }
    case messages::Profile::kUpdateAppearanceName: {
      DCHECK(message->is_serialized());
      internal::Profile_UpdateAppearanceName_Params_Data* params =
          reinterpret_cast<internal::Profile_UpdateAppearanceName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.2
      bool success = true;
      std::optional<std::string> p_appearance_name{};
      Profile_UpdateAppearanceName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppearanceName(&p_appearance_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAppearanceName(        
        std::move(p_appearance_name));
      return true;
    }
    case messages::Profile::kSetOverrideColors: {
      DCHECK(message->is_serialized());
      internal::Profile_SetOverrideColors_Params_Data* params =
          reinterpret_cast<internal::Profile_SetOverrideColors_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.3
      bool success = true;
      bool p_is_custom_theme{};
      std::optional<::SkColor> p_control_accent_color{};
      std::optional<::SkColor> p_selected_text_background_color{};
      std::optional<::SkColor> p_insertion_point_color{};
      std::optional<::SkColor> p_control_accent_background_color{};
      std::optional<::SkColor> p_control_accent_background_hover_color{};
      Profile_SetOverrideColors_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_custom_theme = input_data_view.is_custom_theme();
      if (success && !input_data_view.ReadControlAccentColor(&p_control_accent_color))
        success = false;
      if (success && !input_data_view.ReadSelectedTextBackgroundColor(&p_selected_text_background_color))
        success = false;
      if (success && !input_data_view.ReadInsertionPointColor(&p_insertion_point_color))
        success = false;
      if (success && !input_data_view.ReadControlAccentBackgroundColor(&p_control_accent_background_color))
        success = false;
      if (success && !input_data_view.ReadControlAccentBackgroundHoverColor(&p_control_accent_background_hover_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOverrideColors(        
        std::move(p_is_custom_theme), 
        std::move(p_control_accent_color), 
        std::move(p_selected_text_background_color), 
        std::move(p_insertion_point_color), 
        std::move(p_control_accent_background_color), 
        std::move(p_control_accent_background_hover_color));
      return true;
    }
    case messages::Profile::kCreateWebViewGroup: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateWebViewGroup_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateWebViewGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.4
      bool success = true;
      std::string p_id{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> p_client{};
      Profile_CreateWebViewGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebViewGroup(        
        std::move(p_id), 
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kRemoveWebViewGroup: {
      DCHECK(message->is_serialized());
      internal::Profile_RemoveWebViewGroup_Params_Data* params =
          reinterpret_cast<internal::Profile_RemoveWebViewGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.5
      bool success = true;
      std::string p_id{};
      Profile_RemoveWebViewGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveWebViewGroup(        
        std::move(p_id));
      return true;
    }
    case messages::Profile::kCreateDownloadManager: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateDownloadManager_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateDownloadManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.6
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> p_client{};
      Profile_CreateDownloadManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDownloadManager(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kCreateBookmarkModel: {
      break;
    }
    case messages::Profile::kCreateExtensionService: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateExtensionService_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateExtensionService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.8
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> p_client{};
      Profile_CreateExtensionService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateExtensionService(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kCreateAutofillController: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateAutofillController_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateAutofillController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.9
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> p_client{};
      Profile_CreateAutofillController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAutofillController(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kCreateMetricsService: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateMetricsService_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateMetricsService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.10
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> p_client{};
      Profile_CreateMetricsService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMetricsService(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kCreateNotificationService: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateNotificationService_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateNotificationService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.11
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> p_client{};
      Profile_CreateNotificationService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNotificationService(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kCreateWebViewContainerView: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateWebViewContainerView_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateWebViewContainerView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.12
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> p_receiver{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> p_layer_host_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> p_layer_host_client{};
      Profile_CreateWebViewContainerView_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_layer_host_receiver =
            input_data_view.TakeLayerHostReceiver<decltype(p_layer_host_receiver)>();
      }
      if (success) {
        p_layer_host_client =
            input_data_view.TakeLayerHostClient<decltype(p_layer_host_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebViewContainerView(        
        std::move(p_receiver), 
        std::move(p_layer_host_receiver), 
        std::move(p_layer_host_client));
      return true;
    }
    case messages::Profile::kGetTypedUrls: {
      break;
    }
    case messages::Profile::kGetAddressList: {
      break;
    }
    case messages::Profile::kGetCreditCardList: {
      break;
    }
    case messages::Profile::kSetCookie: {
      break;
    }
    case messages::Profile::kDeleteCookie: {
      break;
    }
    case messages::Profile::kGetAllCookies: {
      break;
    }
    case messages::Profile::kGetCookies: {
      break;
    }
    case messages::Profile::kGetFaviconFromFaviconUrl: {
      break;
    }
    case messages::Profile::kGetFaviconForPageUrl: {
      break;
    }
    case messages::Profile::kCreateAutocompleteController: {
      DCHECK(message->is_serialized());
      internal::Profile_CreateAutocompleteController_Params_Data* params =
          reinterpret_cast<internal::Profile_CreateAutocompleteController_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.22
      bool success = true;
      ::owl::mojom::AutocompleteConfiguration p_configuration{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> p_receiver{};
      Profile_CreateAutocompleteController_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfiguration(&p_configuration))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAutocompleteController(        
        std::move(p_configuration), 
        std::move(p_receiver));
      return true;
    }
    case messages::Profile::kGetDefaultDownloadsLocation: {
      break;
    }
    case messages::Profile::kSetDefaultDownloadsLocation: {
      DCHECK(message->is_serialized());
      internal::Profile_SetDefaultDownloadsLocation_Params_Data* params =
          reinterpret_cast<internal::Profile_SetDefaultDownloadsLocation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.24
      bool success = true;
      ::base::FilePath p_path{};
      Profile_SetDefaultDownloadsLocation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultDownloadsLocation(        
        std::move(p_path));
      return true;
    }
    case messages::Profile::kRegisterSearchKeywordsClient: {
      DCHECK(message->is_serialized());
      internal::Profile_RegisterSearchKeywordsClient_Params_Data* params =
          reinterpret_cast<internal::Profile_RegisterSearchKeywordsClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.25
      bool success = true;
      ::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> p_client{};
      Profile_RegisterSearchKeywordsClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterSearchKeywordsClient(        
        std::move(p_client));
      return true;
    }
    case messages::Profile::kAddSearchKeyword: {
      break;
    }
    case messages::Profile::kRemoveSearchKeyword: {
      DCHECK(message->is_serialized());
      internal::Profile_RemoveSearchKeyword_Params_Data* params =
          reinterpret_cast<internal::Profile_RemoveSearchKeyword_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.27
      bool success = true;
      std::string p_id{};
      Profile_RemoveSearchKeyword_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSearchKeyword(        
        std::move(p_id));
      return true;
    }
    case messages::Profile::kUpdateSearchKeyword: {
      DCHECK(message->is_serialized());
      internal::Profile_UpdateSearchKeyword_Params_Data* params =
          reinterpret_cast<internal::Profile_UpdateSearchKeyword_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.28
      bool success = true;
      std::string p_id{};
      ::std::u16string p_name{};
      ::std::u16string p_keyword{};
      ::std::u16string p_url{};
      Profile_UpdateSearchKeyword_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadKeyword(&p_keyword))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSearchKeyword(        
        std::move(p_id), 
        std::move(p_name), 
        std::move(p_keyword), 
        std::move(p_url));
      return true;
    }
    case messages::Profile::kDownloadURLToFile: {
      DCHECK(message->is_serialized());
      internal::Profile_DownloadURLToFile_Params_Data* params =
          reinterpret_cast<internal::Profile_DownloadURLToFile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.29
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> p_client{};
      Profile_DownloadURLToFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadURLToFile(        
        std::move(p_url), 
        std::move(p_client));
      return true;
    }
    case messages::Profile::kFlushCookies: {
      break;
    }
    case messages::Profile::kCloseProfile: {
      DCHECK(message->is_serialized());
      internal::Profile_CloseProfile_Params_Data* params =
          reinterpret_cast<internal::Profile_CloseProfile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.31
      bool success = true;
      ::mojo::PendingRemote<ProfileCloseListener> p_listener{};
      Profile_CloseProfile_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseProfile(        
        std::move(p_listener));
      return true;
    }
    case messages::Profile::kImportHistory: {
      break;
    }
    case messages::Profile::kImportChromePasswords: {
      break;
    }
    case messages::Profile::kClearBrowsingData: {
      break;
    }
    case messages::Profile::kDeferLoadsForOrigin: {
      DCHECK(message->is_serialized());
      internal::Profile_DeferLoadsForOrigin_Params_Data* params =
          reinterpret_cast<internal::Profile_DeferLoadsForOrigin_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.35
      bool success = true;
      ::GURL p_origin{};
      ::mojo::PendingReceiver<DeferredLoadBlocker> p_blocker_receiver{};
      Profile_DeferLoadsForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_blocker_receiver =
            input_data_view.TakeBlockerReceiver<decltype(p_blocker_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeferLoadsForOrigin(        
        std::move(p_origin), 
        std::move(p_blocker_receiver));
      return true;
    }
    case messages::Profile::kSetCustomHeaderForHosts: {
      DCHECK(message->is_serialized());
      internal::Profile_SetCustomHeaderForHosts_Params_Data* params =
          reinterpret_cast<internal::Profile_SetCustomHeaderForHosts_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.36
      bool success = true;
      std::string p_header_name{};
      std::string p_header_value{};
      std::vector<std::string> p_hosts{};
      Profile_SetCustomHeaderForHosts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeaderName(&p_header_name))
        success = false;
      if (success && !input_data_view.ReadHeaderValue(&p_header_value))
        success = false;
      if (success && !input_data_view.ReadHosts(&p_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCustomHeaderForHosts(        
        std::move(p_header_name), 
        std::move(p_header_value), 
        std::move(p_hosts));
      return true;
    }
    case messages::Profile::kResetProfileSettings: {
      break;
    }
    case messages::Profile::kSetWebPreferences: {
      DCHECK(message->is_serialized());
      internal::Profile_SetWebPreferences_Params_Data* params =
          reinterpret_cast<internal::Profile_SetWebPreferences_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Profile.38
      bool success = true;
      ::owl::mojom::WebPreferencesPtr p_prefs{};
      Profile_SetWebPreferences_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefs(&p_prefs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebPreferences(        
        std::move(p_prefs));
      return true;
    }
    case messages::Profile::kGetWebPreferences: {
      break;
    }
    case messages::Profile::kQueryHistory: {
      break;
    }
  }
  return false;
}

// static
bool ProfileStubDispatch::AcceptWithResponder(
    Profile* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Profile>(message->header()->name)) {
    case messages::Profile::kSetClient: {
      break;
    }
    case messages::Profile::kGetIncognitoVariant: {
      break;
    }
    case messages::Profile::kUpdateAppearanceName: {
      break;
    }
    case messages::Profile::kSetOverrideColors: {
      break;
    }
    case messages::Profile::kCreateWebViewGroup: {
      break;
    }
    case messages::Profile::kRemoveWebViewGroup: {
      break;
    }
    case messages::Profile::kCreateDownloadManager: {
      break;
    }
    case messages::Profile::kCreateBookmarkModel: {
      internal::Profile_CreateBookmarkModel_Params_Data* params =
          reinterpret_cast<
              internal::Profile_CreateBookmarkModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.7
      bool success = true;
      Profile_CreateBookmarkModel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 7, false);
        return false;
      }
      auto callback =
          Profile_CreateBookmarkModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBookmarkModel(std::move(callback));
      return true;
    }
    case messages::Profile::kCreateExtensionService: {
      break;
    }
    case messages::Profile::kCreateAutofillController: {
      break;
    }
    case messages::Profile::kCreateMetricsService: {
      break;
    }
    case messages::Profile::kCreateNotificationService: {
      break;
    }
    case messages::Profile::kCreateWebViewContainerView: {
      break;
    }
    case messages::Profile::kGetTypedUrls: {
      internal::Profile_GetTypedUrls_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetTypedUrls_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.13
      bool success = true;
      Profile_GetTypedUrls_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 13, false);
        return false;
      }
      auto callback =
          Profile_GetTypedUrls_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTypedUrls(std::move(callback));
      return true;
    }
    case messages::Profile::kGetAddressList: {
      internal::Profile_GetAddressList_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetAddressList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.14
      bool success = true;
      Profile_GetAddressList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 14, false);
        return false;
      }
      auto callback =
          Profile_GetAddressList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAddressList(std::move(callback));
      return true;
    }
    case messages::Profile::kGetCreditCardList: {
      internal::Profile_GetCreditCardList_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetCreditCardList_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.15
      bool success = true;
      Profile_GetCreditCardList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 15, false);
        return false;
      }
      auto callback =
          Profile_GetCreditCardList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCreditCardList(std::move(callback));
      return true;
    }
    case messages::Profile::kSetCookie: {
      internal::Profile_SetCookie_Params_Data* params =
          reinterpret_cast<
              internal::Profile_SetCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.16
      bool success = true;
      ::GURL p_url{};
      CookieDataPtr p_cookie{};
      Profile_SetCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 16, false);
        return false;
      }
      auto callback =
          Profile_SetCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCookie(        
        std::move(p_url), 
        std::move(p_cookie), std::move(callback));
      return true;
    }
    case messages::Profile::kDeleteCookie: {
      internal::Profile_DeleteCookie_Params_Data* params =
          reinterpret_cast<
              internal::Profile_DeleteCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.17
      bool success = true;
      ::GURL p_url{};
      CookieDataPtr p_cookie{};
      Profile_DeleteCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 17, false);
        return false;
      }
      auto callback =
          Profile_DeleteCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCookie(        
        std::move(p_url), 
        std::move(p_cookie), std::move(callback));
      return true;
    }
    case messages::Profile::kGetAllCookies: {
      internal::Profile_GetAllCookies_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetAllCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.18
      bool success = true;
      ::GURL p_url{};
      Profile_GetAllCookies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 18, false);
        return false;
      }
      auto callback =
          Profile_GetAllCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookies(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::Profile::kGetCookies: {
      internal::Profile_GetCookies_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.19
      bool success = true;
      ::GURL p_url{};
      std::string p_name{};
      Profile_GetCookies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 19, false);
        return false;
      }
      auto callback =
          Profile_GetCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookies(        
        std::move(p_url), 
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::Profile::kGetFaviconFromFaviconUrl: {
      internal::Profile_GetFaviconFromFaviconUrl_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetFaviconFromFaviconUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.20
      bool success = true;
      ::GURL p_url{};
      Profile_GetFaviconFromFaviconUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 20, false);
        return false;
      }
      auto callback =
          Profile_GetFaviconFromFaviconUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFaviconFromFaviconUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::Profile::kGetFaviconForPageUrl: {
      internal::Profile_GetFaviconForPageUrl_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetFaviconForPageUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.21
      bool success = true;
      ::GURL p_url{};
      Profile_GetFaviconForPageUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 21, false);
        return false;
      }
      auto callback =
          Profile_GetFaviconForPageUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFaviconForPageUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::Profile::kCreateAutocompleteController: {
      break;
    }
    case messages::Profile::kGetDefaultDownloadsLocation: {
      internal::Profile_GetDefaultDownloadsLocation_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetDefaultDownloadsLocation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.23
      bool success = true;
      Profile_GetDefaultDownloadsLocation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 23, false);
        return false;
      }
      auto callback =
          Profile_GetDefaultDownloadsLocation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultDownloadsLocation(std::move(callback));
      return true;
    }
    case messages::Profile::kSetDefaultDownloadsLocation: {
      break;
    }
    case messages::Profile::kRegisterSearchKeywordsClient: {
      break;
    }
    case messages::Profile::kAddSearchKeyword: {
      internal::Profile_AddSearchKeyword_Params_Data* params =
          reinterpret_cast<
              internal::Profile_AddSearchKeyword_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.26
      bool success = true;
      ::std::u16string p_name{};
      ::std::u16string p_keyword{};
      ::std::u16string p_url{};
      Profile_AddSearchKeyword_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadKeyword(&p_keyword))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 26, false);
        return false;
      }
      auto callback =
          Profile_AddSearchKeyword_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSearchKeyword(        
        std::move(p_name), 
        std::move(p_keyword), 
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::Profile::kRemoveSearchKeyword: {
      break;
    }
    case messages::Profile::kUpdateSearchKeyword: {
      break;
    }
    case messages::Profile::kDownloadURLToFile: {
      break;
    }
    case messages::Profile::kFlushCookies: {
      internal::Profile_FlushCookies_Params_Data* params =
          reinterpret_cast<
              internal::Profile_FlushCookies_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.30
      bool success = true;
      Profile_FlushCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 30, false);
        return false;
      }
      auto callback =
          Profile_FlushCookies_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushCookies(std::move(callback));
      return true;
    }
    case messages::Profile::kCloseProfile: {
      break;
    }
    case messages::Profile::kImportHistory: {
      internal::Profile_ImportHistory_Params_Data* params =
          reinterpret_cast<
              internal::Profile_ImportHistory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.32
      bool success = true;
      std::vector<HistoryVisitPtr> p_visits{};
      Profile_ImportHistory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisits(&p_visits))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 32, false);
        return false;
      }
      auto callback =
          Profile_ImportHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportHistory(        
        std::move(p_visits), std::move(callback));
      return true;
    }
    case messages::Profile::kImportChromePasswords: {
      internal::Profile_ImportChromePasswords_Params_Data* params =
          reinterpret_cast<
              internal::Profile_ImportChromePasswords_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.33
      bool success = true;
      ::base::FilePath p_profile_path{};
      std::vector<uint8_t> p_decryption_key{};
      Profile_ImportChromePasswords_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfilePath(&p_profile_path))
        success = false;
      if (success && !input_data_view.ReadDecryptionKey(&p_decryption_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 33, false);
        return false;
      }
      auto callback =
          Profile_ImportChromePasswords_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportChromePasswords(        
        std::move(p_profile_path), 
        std::move(p_decryption_key), std::move(callback));
      return true;
    }
    case messages::Profile::kClearBrowsingData: {
      internal::Profile_ClearBrowsingData_Params_Data* params =
          reinterpret_cast<
              internal::Profile_ClearBrowsingData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.34
      bool success = true;
      std::vector<ClearBrowsingDataType> p_types{};
      std::optional<::base::Time> p_delete_begin{};
      std::optional<::base::Time> p_delete_end{};
      Profile_ClearBrowsingData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTypes(&p_types))
        success = false;
      if (success && !input_data_view.ReadDeleteBegin(&p_delete_begin))
        success = false;
      if (success && !input_data_view.ReadDeleteEnd(&p_delete_end))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 34, false);
        return false;
      }
      auto callback =
          Profile_ClearBrowsingData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBrowsingData(        
        std::move(p_types), 
        std::move(p_delete_begin), 
        std::move(p_delete_end), std::move(callback));
      return true;
    }
    case messages::Profile::kDeferLoadsForOrigin: {
      break;
    }
    case messages::Profile::kSetCustomHeaderForHosts: {
      break;
    }
    case messages::Profile::kResetProfileSettings: {
      internal::Profile_ResetProfileSettings_Params_Data* params =
          reinterpret_cast<
              internal::Profile_ResetProfileSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.37
      bool success = true;
      Profile_ResetProfileSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 37, false);
        return false;
      }
      auto callback =
          Profile_ResetProfileSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetProfileSettings(std::move(callback));
      return true;
    }
    case messages::Profile::kSetWebPreferences: {
      break;
    }
    case messages::Profile::kGetWebPreferences: {
      internal::Profile_GetWebPreferences_Params_Data* params =
          reinterpret_cast<
              internal::Profile_GetWebPreferences_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.39
      bool success = true;
      Profile_GetWebPreferences_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 39, false);
        return false;
      }
      auto callback =
          Profile_GetWebPreferences_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWebPreferences(std::move(callback));
      return true;
    }
    case messages::Profile::kQueryHistory: {
      internal::Profile_QueryHistory_Params_Data* params =
          reinterpret_cast<
              internal::Profile_QueryHistory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Profile.40
      bool success = true;
      ::std::u16string p_query{};
      QueryHistoryOptionsPtr p_options{};
      Profile_QueryHistory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Profile::Name_, 40, false);
        return false;
      }
      auto callback =
          Profile_QueryHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryHistory(        
        std::move(p_query), 
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfileValidationInfo[] = {
    { &internal::Profile_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_GetIncognitoVariant_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_UpdateAppearanceName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_SetOverrideColors_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateWebViewGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_RemoveWebViewGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateDownloadManager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateBookmarkModel_Params_Data::Validate,
     &internal::Profile_CreateBookmarkModel_ResponseParams_Data::Validate},
    { &internal::Profile_CreateExtensionService_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateAutofillController_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateMetricsService_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateNotificationService_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_CreateWebViewContainerView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_GetTypedUrls_Params_Data::Validate,
     &internal::Profile_GetTypedUrls_ResponseParams_Data::Validate},
    { &internal::Profile_GetAddressList_Params_Data::Validate,
     &internal::Profile_GetAddressList_ResponseParams_Data::Validate},
    { &internal::Profile_GetCreditCardList_Params_Data::Validate,
     &internal::Profile_GetCreditCardList_ResponseParams_Data::Validate},
    { &internal::Profile_SetCookie_Params_Data::Validate,
     &internal::Profile_SetCookie_ResponseParams_Data::Validate},
    { &internal::Profile_DeleteCookie_Params_Data::Validate,
     &internal::Profile_DeleteCookie_ResponseParams_Data::Validate},
    { &internal::Profile_GetAllCookies_Params_Data::Validate,
     &internal::Profile_GetAllCookies_ResponseParams_Data::Validate},
    { &internal::Profile_GetCookies_Params_Data::Validate,
     &internal::Profile_GetCookies_ResponseParams_Data::Validate},
    { &internal::Profile_GetFaviconFromFaviconUrl_Params_Data::Validate,
     &internal::Profile_GetFaviconFromFaviconUrl_ResponseParams_Data::Validate},
    { &internal::Profile_GetFaviconForPageUrl_Params_Data::Validate,
     &internal::Profile_GetFaviconForPageUrl_ResponseParams_Data::Validate},
    { &internal::Profile_CreateAutocompleteController_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_GetDefaultDownloadsLocation_Params_Data::Validate,
     &internal::Profile_GetDefaultDownloadsLocation_ResponseParams_Data::Validate},
    { &internal::Profile_SetDefaultDownloadsLocation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_RegisterSearchKeywordsClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_AddSearchKeyword_Params_Data::Validate,
     &internal::Profile_AddSearchKeyword_ResponseParams_Data::Validate},
    { &internal::Profile_RemoveSearchKeyword_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_UpdateSearchKeyword_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_DownloadURLToFile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_FlushCookies_Params_Data::Validate,
     &internal::Profile_FlushCookies_ResponseParams_Data::Validate},
    { &internal::Profile_CloseProfile_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_ImportHistory_Params_Data::Validate,
     &internal::Profile_ImportHistory_ResponseParams_Data::Validate},
    { &internal::Profile_ImportChromePasswords_Params_Data::Validate,
     &internal::Profile_ImportChromePasswords_ResponseParams_Data::Validate},
    { &internal::Profile_ClearBrowsingData_Params_Data::Validate,
     &internal::Profile_ClearBrowsingData_ResponseParams_Data::Validate},
    { &internal::Profile_DeferLoadsForOrigin_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_SetCustomHeaderForHosts_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_ResetProfileSettings_Params_Data::Validate,
     &internal::Profile_ResetProfileSettings_ResponseParams_Data::Validate},
    { &internal::Profile_SetWebPreferences_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Profile_GetWebPreferences_Params_Data::Validate,
     &internal::Profile_GetWebPreferences_ResponseParams_Data::Validate},
    { &internal::Profile_QueryHistory_Params_Data::Validate,
     &internal::Profile_QueryHistory_ResponseParams_Data::Validate},
};

bool ProfileRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::Profile::Name_,
    kProfileValidationInfo);
}

bool ProfileResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::Profile::Name_,
    kProfileValidationInfo);
}
// The declaration includes the definition on other builds.

ProfileClient::IPCStableHashFunction ProfileClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfileClient>(message.name())) {
    case messages::ProfileClient::kUpdateDisplays: {
      return &ProfileClient::UpdateDisplays_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kCreateWebContentClient: {
      return &ProfileClient::CreateWebContentClient_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kCreatedWebViewGroup: {
      return &ProfileClient::CreatedWebViewGroup_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kCreatedIsolatedWebView: {
      return &ProfileClient::CreatedIsolatedWebView_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kCreateWindowBridge: {
      return &ProfileClient::CreateWindowBridge_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kOnMainFrameTypedNavigation: {
      return &ProfileClient::OnMainFrameTypedNavigation_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kOnHistoryDeletions: {
      return &ProfileClient::OnHistoryDeletions_Sym::IPCStableHash;
    }
    case messages::ProfileClient::kOnFaviconsChanged: {
      return &ProfileClient::OnFaviconsChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfileClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfileClient>(message.name())) {
      case messages::ProfileClient::kUpdateDisplays:
            return "Receive owl::mojom::ProfileClient::UpdateDisplays";
      case messages::ProfileClient::kCreateWebContentClient:
            return "Receive owl::mojom::ProfileClient::CreateWebContentClient";
      case messages::ProfileClient::kCreatedWebViewGroup:
            return "Receive owl::mojom::ProfileClient::CreatedWebViewGroup";
      case messages::ProfileClient::kCreatedIsolatedWebView:
            return "Receive owl::mojom::ProfileClient::CreatedIsolatedWebView";
      case messages::ProfileClient::kCreateWindowBridge:
            return "Receive owl::mojom::ProfileClient::CreateWindowBridge";
      case messages::ProfileClient::kOnMainFrameTypedNavigation:
            return "Receive owl::mojom::ProfileClient::OnMainFrameTypedNavigation";
      case messages::ProfileClient::kOnHistoryDeletions:
            return "Receive owl::mojom::ProfileClient::OnHistoryDeletions";
      case messages::ProfileClient::kOnFaviconsChanged:
            return "Receive owl::mojom::ProfileClient::OnFaviconsChanged";
    }
  } else {
    switch (static_cast<messages::ProfileClient>(message.name())) {
      case messages::ProfileClient::kUpdateDisplays:
            return "Receive reply owl::mojom::ProfileClient::UpdateDisplays";
      case messages::ProfileClient::kCreateWebContentClient:
            return "Receive reply owl::mojom::ProfileClient::CreateWebContentClient";
      case messages::ProfileClient::kCreatedWebViewGroup:
            return "Receive reply owl::mojom::ProfileClient::CreatedWebViewGroup";
      case messages::ProfileClient::kCreatedIsolatedWebView:
            return "Receive reply owl::mojom::ProfileClient::CreatedIsolatedWebView";
      case messages::ProfileClient::kCreateWindowBridge:
            return "Receive reply owl::mojom::ProfileClient::CreateWindowBridge";
      case messages::ProfileClient::kOnMainFrameTypedNavigation:
            return "Receive reply owl::mojom::ProfileClient::OnMainFrameTypedNavigation";
      case messages::ProfileClient::kOnHistoryDeletions:
            return "Receive reply owl::mojom::ProfileClient::OnHistoryDeletions";
      case messages::ProfileClient::kOnFaviconsChanged:
            return "Receive reply owl::mojom::ProfileClient::OnFaviconsChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfileClient::UpdateDisplays_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x216d2589;  // IPCStableHash for owl::mojom::ProfileClient::UpdateDisplays
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::CreateWebContentClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x489d615a;  // IPCStableHash for owl::mojom::ProfileClient::CreateWebContentClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::CreatedWebViewGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e40b189;  // IPCStableHash for owl::mojom::ProfileClient::CreatedWebViewGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::CreatedIsolatedWebView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f646005;  // IPCStableHash for owl::mojom::ProfileClient::CreatedIsolatedWebView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::CreateWindowBridge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd761e268;  // IPCStableHash for owl::mojom::ProfileClient::CreateWindowBridge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::OnMainFrameTypedNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb67102b7;  // IPCStableHash for owl::mojom::ProfileClient::OnMainFrameTypedNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::OnHistoryDeletions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd31af947;  // IPCStableHash for owl::mojom::ProfileClient::OnHistoryDeletions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfileClient::OnFaviconsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10a108f5;  // IPCStableHash for owl::mojom::ProfileClient::OnFaviconsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProfileClientProxy::ProfileClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfileClientProxy::UpdateDisplays(
    const std::vector<::display::Display>& in_displays) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::UpdateDisplays", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("displays"), in_displays,
                        "<value of type const std::vector<::display::Display>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kUpdateDisplays), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_UpdateDisplays_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->displays)::BaseType>
      displays_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& displays_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayDataView>>(
    in_displays,
    displays_fragment,
    &displays_validate_params);

  params->displays.Set(
      displays_fragment.is_null() ? nullptr : displays_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->displays.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null displays in ProfileClient.UpdateDisplays request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("UpdateDisplays");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::CreateWebContentClient(
    uint64_t in_web_content_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> in_content) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::CreateWebContentClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_content_id"), in_web_content_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content"), in_content,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kCreateWebContentClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_CreateWebContentClient_Params_Data> params(
          message);
  params.Allocate();

  params->web_content_id = in_web_content_id;

  
  mojo::internal::Serialize<::owl::mojom::WebContentClientAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in ProfileClient.CreateWebContentClient request");

  
  mojo::internal::Serialize<::owl::mojom::WebContentAssociatedPtrInfoDataView>(
    in_content,
    &params->content,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->content)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid content in ProfileClient.CreateWebContentClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("CreateWebContentClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::CreatedWebViewGroup(
    const std::string& in_id, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> in_group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> in_client_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::CreatedWebViewGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_receiver"), in_client_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kCreatedWebViewGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_CreatedWebViewGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ProfileClient.CreatedWebViewGroup request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupAssociatedPtrInfoDataView>(
    in_group,
    &params->group,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->group)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid group in ProfileClient.CreatedWebViewGroup request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupClientAssociatedRequestDataView>(
    in_client_receiver,
    &params->client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client_receiver in ProfileClient.CreatedWebViewGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("CreatedWebViewGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::CreatedIsolatedWebView(
    uint64_t in_web_content_id, const std::string& in_group_id, IsolatedWebViewSource in_source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> in_group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> in_group_client_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> in_view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> in_view_client_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::CreatedIsolatedWebView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_content_id"), in_web_content_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type IsolatedWebViewSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_client_receiver"), in_group_client_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view"), in_view,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebView>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_client_receiver"), in_view_client_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kCreatedIsolatedWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_CreatedIsolatedWebView_Params_Data> params(
          message);
  params.Allocate();

  params->web_content_id = in_web_content_id;
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in ProfileClient.CreatedIsolatedWebView request");

  
  mojo::internal::Serialize<::owl::mojom::IsolatedWebViewSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupAssociatedPtrInfoDataView>(
    in_group,
    &params->group,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->group)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid group in ProfileClient.CreatedIsolatedWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewGroupClientAssociatedRequestDataView>(
    in_group_client_receiver,
    &params->group_client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->group_client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid group_client_receiver in ProfileClient.CreatedIsolatedWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewAssociatedPtrInfoDataView>(
    in_view,
    &params->view,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->view)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid view in ProfileClient.CreatedIsolatedWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewClientAssociatedRequestDataView>(
    in_view_client_receiver,
    &params->view_client_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->view_client_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid view_client_receiver in ProfileClient.CreatedIsolatedWebView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("CreatedIsolatedWebView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::CreateWindowBridge(
    ::owl::mojom::WindowBridgeSource in_source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::CreateWindowBridge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::owl::mojom::WindowBridgeSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kCreateWindowBridge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_CreateWindowBridge_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::WindowBridgeSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::remote_cocoa::mojom::ApplicationAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in ProfileClient.CreateWindowBridge request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("CreateWindowBridge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::OnMainFrameTypedNavigation(
    const std::string& in_url_as_string, const ::std::u16string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::OnMainFrameTypedNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_as_string"), in_url_as_string,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kOnMainFrameTypedNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_OnMainFrameTypedNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url_as_string)::BaseType> url_as_string_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_url_as_string,
    url_as_string_fragment);

  params->url_as_string.Set(
      url_as_string_fragment.is_null() ? nullptr : url_as_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url_as_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url_as_string in ProfileClient.OnMainFrameTypedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in ProfileClient.OnMainFrameTypedNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("OnMainFrameTypedNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::OnHistoryDeletions(
    bool in_is_all_history, bool in_is_from_expiration, std::optional<::base::Time> in_delete_begin, std::optional<::base::Time> in_delete_end, const std::optional<std::vector<::GURL>>& in_restrict_urls, const std::vector<::GURL>& in_deleted_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::OnHistoryDeletions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_all_history"), in_is_all_history,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_from_expiration"), in_is_from_expiration,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_begin"), in_delete_begin,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_end"), in_delete_end,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restrict_urls"), in_restrict_urls,
                        "<value of type const std::optional<std::vector<::GURL>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deleted_urls"), in_deleted_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kOnHistoryDeletions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_OnHistoryDeletions_Params_Data> params(
          message);
  params.Allocate();

  params->is_all_history = in_is_all_history;

  params->is_from_expiration = in_is_from_expiration;
  mojo::internal::MessageFragment<
      typename decltype(params->delete_begin)::BaseType> delete_begin_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_delete_begin,
    delete_begin_fragment);

  params->delete_begin.Set(
      delete_begin_fragment.is_null() ? nullptr : delete_begin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->delete_end)::BaseType> delete_end_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_delete_end,
    delete_end_fragment);

  params->delete_end.Set(
      delete_end_fragment.is_null() ? nullptr : delete_end_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->restrict_urls)::BaseType>
      restrict_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& restrict_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_restrict_urls,
    restrict_urls_fragment,
    &restrict_urls_validate_params);

  params->restrict_urls.Set(
      restrict_urls_fragment.is_null() ? nullptr : restrict_urls_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->deleted_urls)::BaseType>
      deleted_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& deleted_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_deleted_urls,
    deleted_urls_fragment,
    &deleted_urls_validate_params);

  params->deleted_urls.Set(
      deleted_urls_fragment.is_null() ? nullptr : deleted_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->deleted_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null deleted_urls in ProfileClient.OnHistoryDeletions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("OnHistoryDeletions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProfileClientProxy::OnFaviconsChanged(
    const std::vector<::GURL>& in_page_urls, const std::optional<::GURL>& in_icon_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ProfileClient::OnFaviconsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_urls"), in_page_urls,
                        "<value of type const std::vector<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon_url"), in_icon_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfileClient::kOnFaviconsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ProfileClient_OnFaviconsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_urls)::BaseType>
      page_urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& page_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_page_urls,
    page_urls_fragment,
    &page_urls_validate_params);

  params->page_urls.Set(
      page_urls_fragment.is_null() ? nullptr : page_urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_urls in ProfileClient.OnFaviconsChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon_url)::BaseType> icon_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_icon_url,
    icon_url_fragment);

  params->icon_url.Set(
      icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfileClient::Name_);
  message.set_method_name("OnFaviconsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProfileClientStubDispatch::Accept(
    ProfileClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfileClient>(message->header()->name)) {
    case messages::ProfileClient::kUpdateDisplays: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_UpdateDisplays_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_UpdateDisplays_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.0
      bool success = true;
      std::vector<::display::Display> p_displays{};
      ProfileClient_UpdateDisplays_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplays(&p_displays))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDisplays(        
        std::move(p_displays));
      return true;
    }
    case messages::ProfileClient::kCreateWebContentClient: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_CreateWebContentClient_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_CreateWebContentClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.1
      bool success = true;
      uint64_t p_web_content_id{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> p_content{};
      ProfileClient_CreateWebContentClient_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_web_content_id = input_data_view.web_content_id();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_content =
            input_data_view.TakeContent<decltype(p_content)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebContentClient(        
        std::move(p_web_content_id), 
        std::move(p_receiver), 
        std::move(p_content));
      return true;
    }
    case messages::ProfileClient::kCreatedWebViewGroup: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_CreatedWebViewGroup_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_CreatedWebViewGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.2
      bool success = true;
      std::string p_id{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> p_group{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> p_client_receiver{};
      ProfileClient_CreatedWebViewGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success) {
        p_group =
            input_data_view.TakeGroup<decltype(p_group)>();
      }
      if (success) {
        p_client_receiver =
            input_data_view.TakeClientReceiver<decltype(p_client_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatedWebViewGroup(        
        std::move(p_id), 
        std::move(p_group), 
        std::move(p_client_receiver));
      return true;
    }
    case messages::ProfileClient::kCreatedIsolatedWebView: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_CreatedIsolatedWebView_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_CreatedIsolatedWebView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.3
      bool success = true;
      uint64_t p_web_content_id{};
      std::string p_group_id{};
      IsolatedWebViewSource p_source{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> p_group{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> p_group_client_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> p_view{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> p_view_client_receiver{};
      ProfileClient_CreatedIsolatedWebView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_web_content_id = input_data_view.web_content_id();
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_group =
            input_data_view.TakeGroup<decltype(p_group)>();
      }
      if (success) {
        p_group_client_receiver =
            input_data_view.TakeGroupClientReceiver<decltype(p_group_client_receiver)>();
      }
      if (success) {
        p_view =
            input_data_view.TakeView<decltype(p_view)>();
      }
      if (success) {
        p_view_client_receiver =
            input_data_view.TakeViewClientReceiver<decltype(p_view_client_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatedIsolatedWebView(        
        std::move(p_web_content_id), 
        std::move(p_group_id), 
        std::move(p_source), 
        std::move(p_group), 
        std::move(p_group_client_receiver), 
        std::move(p_view), 
        std::move(p_view_client_receiver));
      return true;
    }
    case messages::ProfileClient::kCreateWindowBridge: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_CreateWindowBridge_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_CreateWindowBridge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.4
      bool success = true;
      ::owl::mojom::WindowBridgeSource p_source{};
      ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> p_receiver{};
      ProfileClient_CreateWindowBridge_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWindowBridge(        
        std::move(p_source), 
        std::move(p_receiver));
      return true;
    }
    case messages::ProfileClient::kOnMainFrameTypedNavigation: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_OnMainFrameTypedNavigation_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_OnMainFrameTypedNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.5
      bool success = true;
      std::string p_url_as_string{};
      ::std::u16string p_title{};
      ProfileClient_OnMainFrameTypedNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrlAsString(&p_url_as_string))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMainFrameTypedNavigation(        
        std::move(p_url_as_string), 
        std::move(p_title));
      return true;
    }
    case messages::ProfileClient::kOnHistoryDeletions: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_OnHistoryDeletions_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_OnHistoryDeletions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.6
      bool success = true;
      bool p_is_all_history{};
      bool p_is_from_expiration{};
      std::optional<::base::Time> p_delete_begin{};
      std::optional<::base::Time> p_delete_end{};
      std::optional<std::vector<::GURL>> p_restrict_urls{};
      std::vector<::GURL> p_deleted_urls{};
      ProfileClient_OnHistoryDeletions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_all_history = input_data_view.is_all_history();
      if (success)
        p_is_from_expiration = input_data_view.is_from_expiration();
      if (success && !input_data_view.ReadDeleteBegin(&p_delete_begin))
        success = false;
      if (success && !input_data_view.ReadDeleteEnd(&p_delete_end))
        success = false;
      if (success && !input_data_view.ReadRestrictUrls(&p_restrict_urls))
        success = false;
      if (success && !input_data_view.ReadDeletedUrls(&p_deleted_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistoryDeletions(        
        std::move(p_is_all_history), 
        std::move(p_is_from_expiration), 
        std::move(p_delete_begin), 
        std::move(p_delete_end), 
        std::move(p_restrict_urls), 
        std::move(p_deleted_urls));
      return true;
    }
    case messages::ProfileClient::kOnFaviconsChanged: {
      DCHECK(message->is_serialized());
      internal::ProfileClient_OnFaviconsChanged_Params_Data* params =
          reinterpret_cast<internal::ProfileClient_OnFaviconsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProfileClient.7
      bool success = true;
      std::vector<::GURL> p_page_urls{};
      std::optional<::GURL> p_icon_url{};
      ProfileClient_OnFaviconsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageUrls(&p_page_urls))
        success = false;
      if (success && !input_data_view.ReadIconUrl(&p_icon_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfileClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFaviconsChanged(        
        std::move(p_page_urls), 
        std::move(p_icon_url));
      return true;
    }
  }
  return false;
}

// static
bool ProfileClientStubDispatch::AcceptWithResponder(
    ProfileClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfileClient>(message->header()->name)) {
    case messages::ProfileClient::kUpdateDisplays: {
      break;
    }
    case messages::ProfileClient::kCreateWebContentClient: {
      break;
    }
    case messages::ProfileClient::kCreatedWebViewGroup: {
      break;
    }
    case messages::ProfileClient::kCreatedIsolatedWebView: {
      break;
    }
    case messages::ProfileClient::kCreateWindowBridge: {
      break;
    }
    case messages::ProfileClient::kOnMainFrameTypedNavigation: {
      break;
    }
    case messages::ProfileClient::kOnHistoryDeletions: {
      break;
    }
    case messages::ProfileClient::kOnFaviconsChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfileClientValidationInfo[] = {
    { &internal::ProfileClient_UpdateDisplays_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_CreateWebContentClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_CreatedWebViewGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_CreatedIsolatedWebView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_CreateWindowBridge_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_OnMainFrameTypedNavigation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_OnHistoryDeletions_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProfileClient_OnFaviconsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProfileClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ProfileClient::Name_,
    kProfileClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::TypedUrl::DataView, ::owl::mojom::TypedUrlPtr>::Read(
    ::owl::mojom::TypedUrl::DataView input,
    ::owl::mojom::TypedUrlPtr* output) {
  bool success = true;
  ::owl::mojom::TypedUrlPtr result(::owl::mojom::TypedUrl::New());
  
      if (success)
        result->unique_id = input.unique_id();
      if (success && !input.ReadUrlAsString(&result->url_as_string))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success)
        result->visit_count = input.visit_count();
      if (success)
        result->typed_count = input.typed_count();
      if (success && !input.ReadLastVisitTime(&result->last_visit_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::QueryHistoryItem::DataView, ::owl::mojom::QueryHistoryItemPtr>::Read(
    ::owl::mojom::QueryHistoryItem::DataView input,
    ::owl::mojom::QueryHistoryItemPtr* output) {
  bool success = true;
  ::owl::mojom::QueryHistoryItemPtr result(::owl::mojom::QueryHistoryItem::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadVisitTime(&result->visit_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::QueryHistoryResponse::DataView, ::owl::mojom::QueryHistoryResponsePtr>::Read(
    ::owl::mojom::QueryHistoryResponse::DataView input,
    ::owl::mojom::QueryHistoryResponsePtr* output) {
  bool success = true;
  ::owl::mojom::QueryHistoryResponsePtr result(::owl::mojom::QueryHistoryResponse::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::QueryHistoryOptions::DataView, ::owl::mojom::QueryHistoryOptionsPtr>::Read(
    ::owl::mojom::QueryHistoryOptions::DataView input,
    ::owl::mojom::QueryHistoryOptionsPtr* output) {
  bool success = true;
  ::owl::mojom::QueryHistoryOptionsPtr result(::owl::mojom::QueryHistoryOptions::New());
  
      if (success)
        result->limit = input.limit();
      if (success && !input.ReadStart(&result->start))
        success = false;
      if (success && !input.ReadEnd(&result->end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CookieData::DataView, ::owl::mojom::CookieDataPtr>::Read(
    ::owl::mojom::CookieData::DataView input,
    ::owl::mojom::CookieDataPtr* output) {
  bool success = true;
  ::owl::mojom::CookieDataPtr result(::owl::mojom::CookieData::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->http_only = input.http_only();
      if (success)
        result->secure = input.secure();
      if (success && !input.ReadSameSite(&result->same_site))
        success = false;
      if (success && !input.ReadExpirationTime(&result->expiration_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::HistoryVisit::DataView, ::owl::mojom::HistoryVisitPtr>::Read(
    ::owl::mojom::HistoryVisit::DataView input,
    ::owl::mojom::HistoryVisitPtr* output) {
  bool success = true;
  ::owl::mojom::HistoryVisitPtr result(::owl::mojom::HistoryVisit::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadTime(&result->time))
        success = false;
      if (success) {
        result->referring_visit_id = input.referring_visit_id();
      }
      if (success && !input.ReadExternalReferrerUrl(&result->external_referrer_url))
        success = false;
      if (success) {
        result->hidden = input.hidden();
      }
      if (success) {
        result->transition = input.transition();
      }
      if (success) {
        result->should_increment_typed_count = input.should_increment_typed_count();
      }
      if (success) {
        result->opener_visit_id = input.opener_visit_id();
      }
      if (success) {
        result->consider_for_ntp_most_visited = input.consider_for_ntp_most_visited();
      }
      if (success) {
        result->visit_duration = input.visit_duration();
      }
      if (success) {
        result->redirect_source_visit_id = input.redirect_source_visit_id();
      }
      if (success) {
        result->redirect_destination_visit_id = input.redirect_destination_visit_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CreateBookmarkModelResult::DataView, ::owl::mojom::CreateBookmarkModelResultPtr>::Read(
    ::owl::mojom::CreateBookmarkModelResult::DataView input,
    ::owl::mojom::CreateBookmarkModelResultPtr* output) {
  bool success = true;
  ::owl::mojom::CreateBookmarkModelResultPtr result(::owl::mojom::CreateBookmarkModelResult::New());
  
      if (success) {
        result->model =
            input.TakeModel<decltype(result->model)>();
      }
      if (success) {
        result->client =
            input.TakeClient<decltype(result->client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void DownloadURLToFileClientInterceptorForTesting::OnDoneOrErrored(const ::base::FilePath& path, const std::optional<std::string>& mime_type) {
  GetForwardingInterface()->OnDoneOrErrored(
    std::move(path)
    , 
    std::move(mime_type)
    );
}
DownloadURLToFileClientAsyncWaiter::DownloadURLToFileClientAsyncWaiter(
    DownloadURLToFileClient* proxy) : proxy_(proxy) {}

DownloadURLToFileClientAsyncWaiter::~DownloadURLToFileClientAsyncWaiter() = default;





DeferredLoadBlockerAsyncWaiter::DeferredLoadBlockerAsyncWaiter(
    DeferredLoadBlocker* proxy) : proxy_(proxy) {}

DeferredLoadBlockerAsyncWaiter::~DeferredLoadBlockerAsyncWaiter() = default;





void ProfileCloseListenerInterceptorForTesting::OnClosed(bool success) {
  GetForwardingInterface()->OnClosed(
    std::move(success)
    );
}
ProfileCloseListenerAsyncWaiter::ProfileCloseListenerAsyncWaiter(
    ProfileCloseListener* proxy) : proxy_(proxy) {}

ProfileCloseListenerAsyncWaiter::~ProfileCloseListenerAsyncWaiter() = default;





void ProfileInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<ProfileClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void ProfileInterceptorForTesting::GetIncognitoVariant(::mojo::PendingReceiver<Profile> receiver) {
  GetForwardingInterface()->GetIncognitoVariant(
    std::move(receiver)
    );
}
void ProfileInterceptorForTesting::UpdateAppearanceName(const std::optional<std::string>& appearance_name) {
  GetForwardingInterface()->UpdateAppearanceName(
    std::move(appearance_name)
    );
}
void ProfileInterceptorForTesting::SetOverrideColors(bool is_custom_theme, std::optional<::SkColor> control_accent_color, std::optional<::SkColor> selected_text_background_color, std::optional<::SkColor> insertion_point_color, std::optional<::SkColor> control_accent_background_color, std::optional<::SkColor> control_accent_background_hover_color) {
  GetForwardingInterface()->SetOverrideColors(
    std::move(is_custom_theme)
    , 
    std::move(control_accent_color)
    , 
    std::move(selected_text_background_color)
    , 
    std::move(insertion_point_color)
    , 
    std::move(control_accent_background_color)
    , 
    std::move(control_accent_background_hover_color)
    );
}
void ProfileInterceptorForTesting::CreateWebViewGroup(const std::string& id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> client) {
  GetForwardingInterface()->CreateWebViewGroup(
    std::move(id)
    , 
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::RemoveWebViewGroup(const std::string& id) {
  GetForwardingInterface()->RemoveWebViewGroup(
    std::move(id)
    );
}
void ProfileInterceptorForTesting::CreateDownloadManager(::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> client) {
  GetForwardingInterface()->CreateDownloadManager(
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::CreateBookmarkModel(CreateBookmarkModelCallback callback) {
  GetForwardingInterface()->CreateBookmarkModel(std::move(callback));
}
void ProfileInterceptorForTesting::CreateExtensionService(::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> client) {
  GetForwardingInterface()->CreateExtensionService(
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::CreateAutofillController(::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> client) {
  GetForwardingInterface()->CreateAutofillController(
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::CreateMetricsService(::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> client) {
  GetForwardingInterface()->CreateMetricsService(
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::CreateNotificationService(::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> client) {
  GetForwardingInterface()->CreateNotificationService(
    std::move(receiver)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::CreateWebViewContainerView(::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> receiver, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> layer_host_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> layer_host_client) {
  GetForwardingInterface()->CreateWebViewContainerView(
    std::move(receiver)
    , 
    std::move(layer_host_receiver)
    , 
    std::move(layer_host_client)
    );
}
void ProfileInterceptorForTesting::GetTypedUrls(GetTypedUrlsCallback callback) {
  GetForwardingInterface()->GetTypedUrls(std::move(callback));
}
void ProfileInterceptorForTesting::GetAddressList(GetAddressListCallback callback) {
  GetForwardingInterface()->GetAddressList(std::move(callback));
}
void ProfileInterceptorForTesting::GetCreditCardList(GetCreditCardListCallback callback) {
  GetForwardingInterface()->GetCreditCardList(std::move(callback));
}
void ProfileInterceptorForTesting::SetCookie(const ::GURL& url, CookieDataPtr cookie, SetCookieCallback callback) {
  GetForwardingInterface()->SetCookie(
    std::move(url)
    , 
    std::move(cookie)
    , std::move(callback));
}
void ProfileInterceptorForTesting::DeleteCookie(const ::GURL& url, CookieDataPtr cookie, DeleteCookieCallback callback) {
  GetForwardingInterface()->DeleteCookie(
    std::move(url)
    , 
    std::move(cookie)
    , std::move(callback));
}
void ProfileInterceptorForTesting::GetAllCookies(const ::GURL& url, GetAllCookiesCallback callback) {
  GetForwardingInterface()->GetAllCookies(
    std::move(url)
    , std::move(callback));
}
void ProfileInterceptorForTesting::GetCookies(const ::GURL& url, const std::string& name, GetCookiesCallback callback) {
  GetForwardingInterface()->GetCookies(
    std::move(url)
    , 
    std::move(name)
    , std::move(callback));
}
void ProfileInterceptorForTesting::GetFaviconFromFaviconUrl(const ::GURL& url, GetFaviconFromFaviconUrlCallback callback) {
  GetForwardingInterface()->GetFaviconFromFaviconUrl(
    std::move(url)
    , std::move(callback));
}
void ProfileInterceptorForTesting::GetFaviconForPageUrl(const ::GURL& url, GetFaviconForPageUrlCallback callback) {
  GetForwardingInterface()->GetFaviconForPageUrl(
    std::move(url)
    , std::move(callback));
}
void ProfileInterceptorForTesting::CreateAutocompleteController(::owl::mojom::AutocompleteConfiguration configuration, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> receiver) {
  GetForwardingInterface()->CreateAutocompleteController(
    std::move(configuration)
    , 
    std::move(receiver)
    );
}
void ProfileInterceptorForTesting::GetDefaultDownloadsLocation(GetDefaultDownloadsLocationCallback callback) {
  GetForwardingInterface()->GetDefaultDownloadsLocation(std::move(callback));
}
void ProfileInterceptorForTesting::SetDefaultDownloadsLocation(const ::base::FilePath& path) {
  GetForwardingInterface()->SetDefaultDownloadsLocation(
    std::move(path)
    );
}
void ProfileInterceptorForTesting::RegisterSearchKeywordsClient(::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> client) {
  GetForwardingInterface()->RegisterSearchKeywordsClient(
    std::move(client)
    );
}
void ProfileInterceptorForTesting::AddSearchKeyword(const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, AddSearchKeywordCallback callback) {
  GetForwardingInterface()->AddSearchKeyword(
    std::move(name)
    , 
    std::move(keyword)
    , 
    std::move(url)
    , std::move(callback));
}
void ProfileInterceptorForTesting::RemoveSearchKeyword(const std::string& id) {
  GetForwardingInterface()->RemoveSearchKeyword(
    std::move(id)
    );
}
void ProfileInterceptorForTesting::UpdateSearchKeyword(const std::string& id, const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url) {
  GetForwardingInterface()->UpdateSearchKeyword(
    std::move(id)
    , 
    std::move(name)
    , 
    std::move(keyword)
    , 
    std::move(url)
    );
}
void ProfileInterceptorForTesting::DownloadURLToFile(const ::GURL& url, ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> client) {
  GetForwardingInterface()->DownloadURLToFile(
    std::move(url)
    , 
    std::move(client)
    );
}
void ProfileInterceptorForTesting::FlushCookies(FlushCookiesCallback callback) {
  GetForwardingInterface()->FlushCookies(std::move(callback));
}
void ProfileInterceptorForTesting::CloseProfile(::mojo::PendingRemote<ProfileCloseListener> listener) {
  GetForwardingInterface()->CloseProfile(
    std::move(listener)
    );
}
void ProfileInterceptorForTesting::ImportHistory(std::vector<HistoryVisitPtr> visits, ImportHistoryCallback callback) {
  GetForwardingInterface()->ImportHistory(
    std::move(visits)
    , std::move(callback));
}
void ProfileInterceptorForTesting::ImportChromePasswords(const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, ImportChromePasswordsCallback callback) {
  GetForwardingInterface()->ImportChromePasswords(
    std::move(profile_path)
    , 
    std::move(decryption_key)
    , std::move(callback));
}
void ProfileInterceptorForTesting::ClearBrowsingData(const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, ClearBrowsingDataCallback callback) {
  GetForwardingInterface()->ClearBrowsingData(
    std::move(types)
    , 
    std::move(delete_begin)
    , 
    std::move(delete_end)
    , std::move(callback));
}
void ProfileInterceptorForTesting::DeferLoadsForOrigin(const ::GURL& origin, ::mojo::PendingReceiver<DeferredLoadBlocker> blocker_receiver) {
  GetForwardingInterface()->DeferLoadsForOrigin(
    std::move(origin)
    , 
    std::move(blocker_receiver)
    );
}
void ProfileInterceptorForTesting::SetCustomHeaderForHosts(const std::string& header_name, const std::string& header_value, const std::vector<std::string>& hosts) {
  GetForwardingInterface()->SetCustomHeaderForHosts(
    std::move(header_name)
    , 
    std::move(header_value)
    , 
    std::move(hosts)
    );
}
void ProfileInterceptorForTesting::ResetProfileSettings(ResetProfileSettingsCallback callback) {
  GetForwardingInterface()->ResetProfileSettings(std::move(callback));
}
void ProfileInterceptorForTesting::SetWebPreferences(::owl::mojom::WebPreferencesPtr prefs) {
  GetForwardingInterface()->SetWebPreferences(
    std::move(prefs)
    );
}
void ProfileInterceptorForTesting::GetWebPreferences(GetWebPreferencesCallback callback) {
  GetForwardingInterface()->GetWebPreferences(std::move(callback));
}
void ProfileInterceptorForTesting::QueryHistory(const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryCallback callback) {
  GetForwardingInterface()->QueryHistory(
    std::move(query)
    , 
    std::move(options)
    , std::move(callback));
}
ProfileAsyncWaiter::ProfileAsyncWaiter(
    Profile* proxy) : proxy_(proxy) {}

ProfileAsyncWaiter::~ProfileAsyncWaiter() = default;


void ProfileAsyncWaiter::CreateBookmarkModel(
    CreateBookmarkModelResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateBookmarkModel(
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateBookmarkModelResultPtr* out_result
,
             CreateBookmarkModelResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateBookmarkModelResultPtr ProfileAsyncWaiter::CreateBookmarkModel(
    ) {
  CreateBookmarkModelResultPtr async_wait_result;
  CreateBookmarkModel(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetTypedUrls(
    std::vector<TypedUrlPtr>* out_typed_urls) {
  base::RunLoop loop;
  proxy_->GetTypedUrls(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TypedUrlPtr>* out_typed_urls
,
             std::vector<TypedUrlPtr> typed_urls) {*out_typed_urls = std::move(typed_urls);
            loop->Quit();
          },
          &loop,
          out_typed_urls));
  loop.Run();
}

std::vector<TypedUrlPtr> ProfileAsyncWaiter::GetTypedUrls(
    ) {
  std::vector<TypedUrlPtr> async_wait_result;
  GetTypedUrls(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetAddressList(
    std::vector<::owl::mojom::AutofillAddressEntryPtr>* out_addresses) {
  base::RunLoop loop;
  proxy_->GetAddressList(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::owl::mojom::AutofillAddressEntryPtr>* out_addresses
,
             std::vector<::owl::mojom::AutofillAddressEntryPtr> addresses) {*out_addresses = std::move(addresses);
            loop->Quit();
          },
          &loop,
          out_addresses));
  loop.Run();
}

std::vector<::owl::mojom::AutofillAddressEntryPtr> ProfileAsyncWaiter::GetAddressList(
    ) {
  std::vector<::owl::mojom::AutofillAddressEntryPtr> async_wait_result;
  GetAddressList(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetCreditCardList(
    std::vector<::owl::mojom::AutofillCreditCardEntryPtr>* out_credit_cards) {
  base::RunLoop loop;
  proxy_->GetCreditCardList(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::owl::mojom::AutofillCreditCardEntryPtr>* out_credit_cards
,
             std::vector<::owl::mojom::AutofillCreditCardEntryPtr> credit_cards) {*out_credit_cards = std::move(credit_cards);
            loop->Quit();
          },
          &loop,
          out_credit_cards));
  loop.Run();
}

std::vector<::owl::mojom::AutofillCreditCardEntryPtr> ProfileAsyncWaiter::GetCreditCardList(
    ) {
  std::vector<::owl::mojom::AutofillCreditCardEntryPtr> async_wait_result;
  GetCreditCardList(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::SetCookie(
    const ::GURL& url, CookieDataPtr cookie, SetCookieResult* out_result) {
  base::RunLoop loop;
  proxy_->SetCookie(
      std::move(url),
      std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             SetCookieResult* out_result
,
             SetCookieResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SetCookieResult ProfileAsyncWaiter::SetCookie(
    const ::GURL& url, CookieDataPtr cookie) {
  SetCookieResult async_wait_result;
  SetCookie(std::move(url),std::move(cookie),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::DeleteCookie(
    const ::GURL& url, CookieDataPtr cookie, DeleteCookieResult* out_result) {
  base::RunLoop loop;
  proxy_->DeleteCookie(
      std::move(url),
      std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             DeleteCookieResult* out_result
,
             DeleteCookieResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

DeleteCookieResult ProfileAsyncWaiter::DeleteCookie(
    const ::GURL& url, CookieDataPtr cookie) {
  DeleteCookieResult async_wait_result;
  DeleteCookie(std::move(url),std::move(cookie),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetAllCookies(
    const ::GURL& url, std::vector<CookieDataPtr>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetAllCookies(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<CookieDataPtr>* out_cookies
,
             std::vector<CookieDataPtr> cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}

std::vector<CookieDataPtr> ProfileAsyncWaiter::GetAllCookies(
    const ::GURL& url) {
  std::vector<CookieDataPtr> async_wait_result;
  GetAllCookies(std::move(url),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetCookies(
    const ::GURL& url, const std::string& name, std::vector<CookieDataPtr>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetCookies(
      std::move(url),
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<CookieDataPtr>* out_cookies
,
             std::vector<CookieDataPtr> cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}

std::vector<CookieDataPtr> ProfileAsyncWaiter::GetCookies(
    const ::GURL& url, const std::string& name) {
  std::vector<CookieDataPtr> async_wait_result;
  GetCookies(std::move(url),std::move(name),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetFaviconFromFaviconUrl(
    const ::GURL& url, ::gfx::ImageSkia* out_image) {
  base::RunLoop loop;
  proxy_->GetFaviconFromFaviconUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::ImageSkia* out_image
,
             const ::gfx::ImageSkia& image) {*out_image = std::move(image);
            loop->Quit();
          },
          &loop,
          out_image));
  loop.Run();
}

::gfx::ImageSkia ProfileAsyncWaiter::GetFaviconFromFaviconUrl(
    const ::GURL& url) {
  ::gfx::ImageSkia async_wait_result;
  GetFaviconFromFaviconUrl(std::move(url),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetFaviconForPageUrl(
    const ::GURL& url, ::gfx::ImageSkia* out_image) {
  base::RunLoop loop;
  proxy_->GetFaviconForPageUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::ImageSkia* out_image
,
             const ::gfx::ImageSkia& image) {*out_image = std::move(image);
            loop->Quit();
          },
          &loop,
          out_image));
  loop.Run();
}

::gfx::ImageSkia ProfileAsyncWaiter::GetFaviconForPageUrl(
    const ::GURL& url) {
  ::gfx::ImageSkia async_wait_result;
  GetFaviconForPageUrl(std::move(url),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::GetDefaultDownloadsLocation(
    ::base::FilePath* out_path) {
  base::RunLoop loop;
  proxy_->GetDefaultDownloadsLocation(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_path
,
             const ::base::FilePath& path) {*out_path = std::move(path);
            loop->Quit();
          },
          &loop,
          out_path));
  loop.Run();
}

::base::FilePath ProfileAsyncWaiter::GetDefaultDownloadsLocation(
    ) {
  ::base::FilePath async_wait_result;
  GetDefaultDownloadsLocation(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::AddSearchKeyword(
    const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, std::optional<std::string>* out_id) {
  base::RunLoop loop;
  proxy_->AddSearchKeyword(
      std::move(name),
      std::move(keyword),
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_id
,
             const std::optional<std::string>& id) {*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_id));
  loop.Run();
}

std::optional<std::string> ProfileAsyncWaiter::AddSearchKeyword(
    const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url) {
  std::optional<std::string> async_wait_result;
  AddSearchKeyword(std::move(name),std::move(keyword),std::move(url),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::FlushCookies(
    ) {
  base::RunLoop loop;
  proxy_->FlushCookies(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ProfileAsyncWaiter::ImportHistory(
    std::vector<HistoryVisitPtr> visits, int64_t* out_imported_visits_count) {
  base::RunLoop loop;
  proxy_->ImportHistory(
      std::move(visits),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_imported_visits_count
,
             int64_t imported_visits_count) {*out_imported_visits_count = std::move(imported_visits_count);
            loop->Quit();
          },
          &loop,
          out_imported_visits_count));
  loop.Run();
}

int64_t ProfileAsyncWaiter::ImportHistory(
    std::vector<HistoryVisitPtr> visits) {
  int64_t async_wait_result;
  ImportHistory(std::move(visits),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::ImportChromePasswords(
    const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, bool* out_success) {
  base::RunLoop loop;
  proxy_->ImportChromePasswords(
      std::move(profile_path),
      std::move(decryption_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ProfileAsyncWaiter::ImportChromePasswords(
    const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key) {
  bool async_wait_result;
  ImportChromePasswords(std::move(profile_path),std::move(decryption_key),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::ClearBrowsingData(
    const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, bool* out_success) {
  base::RunLoop loop;
  proxy_->ClearBrowsingData(
      std::move(types),
      std::move(delete_begin),
      std::move(delete_end),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ProfileAsyncWaiter::ClearBrowsingData(
    const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end) {
  bool async_wait_result;
  ClearBrowsingData(std::move(types),std::move(delete_begin),std::move(delete_end),&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::ResetProfileSettings(
    ) {
  base::RunLoop loop;
  proxy_->ResetProfileSettings(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ProfileAsyncWaiter::GetWebPreferences(
    ::owl::mojom::WebPreferencesPtr* out_prefs) {
  base::RunLoop loop;
  proxy_->GetWebPreferences(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::owl::mojom::WebPreferencesPtr* out_prefs
,
             ::owl::mojom::WebPreferencesPtr prefs) {*out_prefs = std::move(prefs);
            loop->Quit();
          },
          &loop,
          out_prefs));
  loop.Run();
}

::owl::mojom::WebPreferencesPtr ProfileAsyncWaiter::GetWebPreferences(
    ) {
  ::owl::mojom::WebPreferencesPtr async_wait_result;
  GetWebPreferences(&async_wait_result);
  return async_wait_result;
}

void ProfileAsyncWaiter::QueryHistory(
    const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->QueryHistory(
      std::move(query),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             QueryHistoryResponsePtr* out_response
,
             QueryHistoryResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

QueryHistoryResponsePtr ProfileAsyncWaiter::QueryHistory(
    const ::std::u16string& query, QueryHistoryOptionsPtr options) {
  QueryHistoryResponsePtr async_wait_result;
  QueryHistory(std::move(query),std::move(options),&async_wait_result);
  return async_wait_result;
}




void ProfileClientInterceptorForTesting::UpdateDisplays(const std::vector<::display::Display>& displays) {
  GetForwardingInterface()->UpdateDisplays(
    std::move(displays)
    );
}
void ProfileClientInterceptorForTesting::CreateWebContentClient(uint64_t web_content_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> content) {
  GetForwardingInterface()->CreateWebContentClient(
    std::move(web_content_id)
    , 
    std::move(receiver)
    , 
    std::move(content)
    );
}
void ProfileClientInterceptorForTesting::CreatedWebViewGroup(const std::string& id, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> client_receiver) {
  GetForwardingInterface()->CreatedWebViewGroup(
    std::move(id)
    , 
    std::move(group)
    , 
    std::move(client_receiver)
    );
}
void ProfileClientInterceptorForTesting::CreatedIsolatedWebView(uint64_t web_content_id, const std::string& group_id, IsolatedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> group_client_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> view_client_receiver) {
  GetForwardingInterface()->CreatedIsolatedWebView(
    std::move(web_content_id)
    , 
    std::move(group_id)
    , 
    std::move(source)
    , 
    std::move(group)
    , 
    std::move(group_client_receiver)
    , 
    std::move(view)
    , 
    std::move(view_client_receiver)
    );
}
void ProfileClientInterceptorForTesting::CreateWindowBridge(::owl::mojom::WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) {
  GetForwardingInterface()->CreateWindowBridge(
    std::move(source)
    , 
    std::move(receiver)
    );
}
void ProfileClientInterceptorForTesting::OnMainFrameTypedNavigation(const std::string& url_as_string, const ::std::u16string& title) {
  GetForwardingInterface()->OnMainFrameTypedNavigation(
    std::move(url_as_string)
    , 
    std::move(title)
    );
}
void ProfileClientInterceptorForTesting::OnHistoryDeletions(bool is_all_history, bool is_from_expiration, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, const std::optional<std::vector<::GURL>>& restrict_urls, const std::vector<::GURL>& deleted_urls) {
  GetForwardingInterface()->OnHistoryDeletions(
    std::move(is_all_history)
    , 
    std::move(is_from_expiration)
    , 
    std::move(delete_begin)
    , 
    std::move(delete_end)
    , 
    std::move(restrict_urls)
    , 
    std::move(deleted_urls)
    );
}
void ProfileClientInterceptorForTesting::OnFaviconsChanged(const std::vector<::GURL>& page_urls, const std::optional<::GURL>& icon_url) {
  GetForwardingInterface()->OnFaviconsChanged(
    std::move(page_urls)
    , 
    std::move(icon_url)
    );
}
ProfileClientAsyncWaiter::ProfileClientAsyncWaiter(
    ProfileClient* proxy) : proxy_(proxy) {}

ProfileClientAsyncWaiter::~ProfileClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif