// owl/mojom/profile.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PROFILE_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_PROFILE_MOJOM_TEST_UTILS_H_

#include "owl/mojom/profile.mojom.h"


namespace owl::mojom {


class  DownloadURLToFileClientInterceptorForTesting : public DownloadURLToFileClient {
  virtual DownloadURLToFileClient* GetForwardingInterface() = 0;
  void OnDoneOrErrored(const ::base::FilePath& path, const std::optional<std::string>& mime_type) override;
};
class  DownloadURLToFileClientAsyncWaiter {
 public:
  explicit DownloadURLToFileClientAsyncWaiter(DownloadURLToFileClient* proxy);

  DownloadURLToFileClientAsyncWaiter(const DownloadURLToFileClientAsyncWaiter&) = delete;
  DownloadURLToFileClientAsyncWaiter& operator=(const DownloadURLToFileClientAsyncWaiter&) = delete;

  ~DownloadURLToFileClientAsyncWaiter();

 private:
  DownloadURLToFileClient* const proxy_;
};


class  DeferredLoadBlockerInterceptorForTesting : public DeferredLoadBlocker {
  virtual DeferredLoadBlocker* GetForwardingInterface() = 0;
};
class  DeferredLoadBlockerAsyncWaiter {
 public:
  explicit DeferredLoadBlockerAsyncWaiter(DeferredLoadBlocker* proxy);

  DeferredLoadBlockerAsyncWaiter(const DeferredLoadBlockerAsyncWaiter&) = delete;
  DeferredLoadBlockerAsyncWaiter& operator=(const DeferredLoadBlockerAsyncWaiter&) = delete;

  ~DeferredLoadBlockerAsyncWaiter();

 private:
  DeferredLoadBlocker* const proxy_;
};


class  ProfileCloseListenerInterceptorForTesting : public ProfileCloseListener {
  virtual ProfileCloseListener* GetForwardingInterface() = 0;
  void OnClosed(bool success) override;
};
class  ProfileCloseListenerAsyncWaiter {
 public:
  explicit ProfileCloseListenerAsyncWaiter(ProfileCloseListener* proxy);

  ProfileCloseListenerAsyncWaiter(const ProfileCloseListenerAsyncWaiter&) = delete;
  ProfileCloseListenerAsyncWaiter& operator=(const ProfileCloseListenerAsyncWaiter&) = delete;

  ~ProfileCloseListenerAsyncWaiter();

 private:
  ProfileCloseListener* const proxy_;
};


class  ProfileInterceptorForTesting : public Profile {
  virtual Profile* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingAssociatedRemote<ProfileClient> client) override;
  void GetIncognitoVariant(::mojo::PendingReceiver<Profile> receiver) override;
  void UpdateAppearanceName(const std::optional<std::string>& appearance_name) override;
  void SetOverrideColors(bool is_custom_theme, std::optional<::SkColor> control_accent_color, std::optional<::SkColor> selected_text_background_color, std::optional<::SkColor> insertion_point_color, std::optional<::SkColor> control_accent_background_color, std::optional<::SkColor> control_accent_background_hover_color) override;
  void CreateWebViewGroup(const std::string& id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroup> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroupClient> client) override;
  void RemoveWebViewGroup(const std::string& id) override;
  void CreateDownloadManager(::mojo::PendingAssociatedReceiver<::owl::mojom::DownloadManager> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::DownloadManagerClient> client) override;
  void CreateBookmarkModel(CreateBookmarkModelCallback callback) override;
  void CreateExtensionService(::mojo::PendingAssociatedReceiver<::owl::mojom::ExtensionService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::ExtensionServiceClient> client) override;
  void CreateAutofillController(::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillControllerHost> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillControllerClient> client) override;
  void CreateMetricsService(::mojo::PendingAssociatedReceiver<::owl::mojom::MetricsService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::MetricsServiceClient> client) override;
  void CreateNotificationService(::mojo::PendingAssociatedReceiver<::owl::mojom::NotificationService> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::NotificationServiceClient> client) override;
  void CreateWebViewContainerView(::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewContainerView> receiver, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHost> layer_host_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHostClient> layer_host_client) override;
  void GetTypedUrls(GetTypedUrlsCallback callback) override;
  void GetAddressList(GetAddressListCallback callback) override;
  void GetCreditCardList(GetCreditCardListCallback callback) override;
  void SetCookie(const ::GURL& url, CookieDataPtr cookie, SetCookieCallback callback) override;
  void DeleteCookie(const ::GURL& url, CookieDataPtr cookie, DeleteCookieCallback callback) override;
  void GetAllCookies(const ::GURL& url, GetAllCookiesCallback callback) override;
  void GetCookies(const ::GURL& url, const std::string& name, GetCookiesCallback callback) override;
  void GetFaviconFromFaviconUrl(const ::GURL& url, GetFaviconFromFaviconUrlCallback callback) override;
  void GetFaviconForPageUrl(const ::GURL& url, GetFaviconForPageUrlCallback callback) override;
  void CreateAutocompleteController(::owl::mojom::AutocompleteConfiguration configuration, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutocompleteController> receiver) override;
  void GetDefaultDownloadsLocation(GetDefaultDownloadsLocationCallback callback) override;
  void SetDefaultDownloadsLocation(const ::base::FilePath& path) override;
  void RegisterSearchKeywordsClient(::mojo::PendingAssociatedRemote<::owl::mojom::SearchKeywordsClient> client) override;
  void AddSearchKeyword(const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, AddSearchKeywordCallback callback) override;
  void RemoveSearchKeyword(const std::string& id) override;
  void UpdateSearchKeyword(const std::string& id, const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url) override;
  void DownloadURLToFile(const ::GURL& url, ::mojo::PendingAssociatedRemote<DownloadURLToFileClient> client) override;
  void FlushCookies(FlushCookiesCallback callback) override;
  void CloseProfile(::mojo::PendingRemote<ProfileCloseListener> listener) override;
  void ImportHistory(std::vector<HistoryVisitPtr> visits, ImportHistoryCallback callback) override;
  void ImportChromePasswords(const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, ImportChromePasswordsCallback callback) override;
  void ClearBrowsingData(const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, ClearBrowsingDataCallback callback) override;
  void DeferLoadsForOrigin(const ::GURL& origin, ::mojo::PendingReceiver<DeferredLoadBlocker> blocker_receiver) override;
  void SetCustomHeaderForHosts(const std::string& header_name, const std::string& header_value, const std::vector<std::string>& hosts) override;
  void ResetProfileSettings(ResetProfileSettingsCallback callback) override;
  void SetWebPreferences(::owl::mojom::WebPreferencesPtr prefs) override;
  void GetWebPreferences(GetWebPreferencesCallback callback) override;
  void QueryHistory(const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryCallback callback) override;
};
class  ProfileAsyncWaiter {
 public:
  explicit ProfileAsyncWaiter(Profile* proxy);

  ProfileAsyncWaiter(const ProfileAsyncWaiter&) = delete;
  ProfileAsyncWaiter& operator=(const ProfileAsyncWaiter&) = delete;

  ~ProfileAsyncWaiter();
  void CreateBookmarkModel(
      CreateBookmarkModelResultPtr* out_result);
  CreateBookmarkModelResultPtr CreateBookmarkModel();
  void GetTypedUrls(
      std::vector<TypedUrlPtr>* out_typed_urls);
  std::vector<TypedUrlPtr> GetTypedUrls();
  void GetAddressList(
      std::vector<::owl::mojom::AutofillAddressEntryPtr>* out_addresses);
  std::vector<::owl::mojom::AutofillAddressEntryPtr> GetAddressList();
  void GetCreditCardList(
      std::vector<::owl::mojom::AutofillCreditCardEntryPtr>* out_credit_cards);
  std::vector<::owl::mojom::AutofillCreditCardEntryPtr> GetCreditCardList();
  void SetCookie(
      const ::GURL& url, CookieDataPtr cookie, SetCookieResult* out_result);
  SetCookieResult SetCookie(const ::GURL& url, CookieDataPtr cookie);
  void DeleteCookie(
      const ::GURL& url, CookieDataPtr cookie, DeleteCookieResult* out_result);
  DeleteCookieResult DeleteCookie(const ::GURL& url, CookieDataPtr cookie);
  void GetAllCookies(
      const ::GURL& url, std::vector<CookieDataPtr>* out_cookies);
  std::vector<CookieDataPtr> GetAllCookies(const ::GURL& url);
  void GetCookies(
      const ::GURL& url, const std::string& name, std::vector<CookieDataPtr>* out_cookies);
  std::vector<CookieDataPtr> GetCookies(const ::GURL& url, const std::string& name);
  void GetFaviconFromFaviconUrl(
      const ::GURL& url, ::gfx::ImageSkia* out_image);
  ::gfx::ImageSkia GetFaviconFromFaviconUrl(const ::GURL& url);
  void GetFaviconForPageUrl(
      const ::GURL& url, ::gfx::ImageSkia* out_image);
  ::gfx::ImageSkia GetFaviconForPageUrl(const ::GURL& url);
  void GetDefaultDownloadsLocation(
      ::base::FilePath* out_path);
  ::base::FilePath GetDefaultDownloadsLocation();
  void AddSearchKeyword(
      const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url, std::optional<std::string>* out_id);
  std::optional<std::string> AddSearchKeyword(const ::std::u16string& name, const ::std::u16string& keyword, const ::std::u16string& url);
  void FlushCookies(
      );
  
  void ImportHistory(
      std::vector<HistoryVisitPtr> visits, int64_t* out_imported_visits_count);
  int64_t ImportHistory(std::vector<HistoryVisitPtr> visits);
  void ImportChromePasswords(
      const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key, bool* out_success);
  bool ImportChromePasswords(const ::base::FilePath& profile_path, const std::vector<uint8_t>& decryption_key);
  void ClearBrowsingData(
      const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, bool* out_success);
  bool ClearBrowsingData(const std::vector<ClearBrowsingDataType>& types, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end);
  void ResetProfileSettings(
      );
  
  void GetWebPreferences(
      ::owl::mojom::WebPreferencesPtr* out_prefs);
  ::owl::mojom::WebPreferencesPtr GetWebPreferences();
  void QueryHistory(
      const ::std::u16string& query, QueryHistoryOptionsPtr options, QueryHistoryResponsePtr* out_response);
  QueryHistoryResponsePtr QueryHistory(const ::std::u16string& query, QueryHistoryOptionsPtr options);

 private:
  Profile* const proxy_;
};


class  ProfileClientInterceptorForTesting : public ProfileClient {
  virtual ProfileClient* GetForwardingInterface() = 0;
  void UpdateDisplays(const std::vector<::display::Display>& displays) override;
  void CreateWebContentClient(uint64_t web_content_id, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebContentClient> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebContent> content) override;
  void CreatedWebViewGroup(const std::string& id, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> client_receiver) override;
  void CreatedIsolatedWebView(uint64_t web_content_id, const std::string& group_id, IsolatedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewGroup> group, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewGroupClient> group_client_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> view_client_receiver) override;
  void CreateWindowBridge(::owl::mojom::WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) override;
  void OnMainFrameTypedNavigation(const std::string& url_as_string, const ::std::u16string& title) override;
  void OnHistoryDeletions(bool is_all_history, bool is_from_expiration, std::optional<::base::Time> delete_begin, std::optional<::base::Time> delete_end, const std::optional<std::vector<::GURL>>& restrict_urls, const std::vector<::GURL>& deleted_urls) override;
  void OnFaviconsChanged(const std::vector<::GURL>& page_urls, const std::optional<::GURL>& icon_url) override;
};
class  ProfileClientAsyncWaiter {
 public:
  explicit ProfileClientAsyncWaiter(ProfileClient* proxy);

  ProfileClientAsyncWaiter(const ProfileClientAsyncWaiter&) = delete;
  ProfileClientAsyncWaiter& operator=(const ProfileClientAsyncWaiter&) = delete;

  ~ProfileClientAsyncWaiter();

 private:
  ProfileClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_PROFILE_MOJOM_TEST_UTILS_H_