// owl/mojom/profile.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PROFILE_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_PROFILE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/profile.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "owl/mojom/autocomplete.mojom-shared.h"
#include "owl/mojom/autofill.mojom-shared.h"
#include "owl/mojom/autofill_deprecated.mojom-shared.h"
#include "owl/mojom/bookmark_model.mojom-shared.h"
#include "owl/mojom/download_manager.mojom-shared.h"
#include "owl/mojom/extension_service.mojom-shared.h"
#include "owl/mojom/metrics.mojom-shared.h"
#include "owl/mojom/notification_service.mojom-shared.h"
#include "owl/mojom/search_keyword.mojom-shared.h"
#include "owl/mojom/web_content.mojom-shared.h"
#include "owl/mojom/web_prefs.mojom-shared.h"
#include "owl/mojom/web_view.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "owl/mojom/web_view_group.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"


namespace owl::mojom {
class TypedUrlDataView;

class QueryHistoryItemDataView;

class QueryHistoryResponseDataView;

class QueryHistoryOptionsDataView;

class CookieDataDataView;

class HistoryVisitDataView;

class CreateBookmarkModelResultDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::TypedUrlDataView> {
  using Data = ::owl::mojom::internal::TypedUrl_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::QueryHistoryItemDataView> {
  using Data = ::owl::mojom::internal::QueryHistoryItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::QueryHistoryResponseDataView> {
  using Data = ::owl::mojom::internal::QueryHistoryResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::QueryHistoryOptionsDataView> {
  using Data = ::owl::mojom::internal::QueryHistoryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CookieDataDataView> {
  using Data = ::owl::mojom::internal::CookieData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::HistoryVisitDataView> {
  using Data = ::owl::mojom::internal::HistoryVisit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CreateBookmarkModelResultDataView> {
  using Data = ::owl::mojom::internal::CreateBookmarkModelResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class ClearBrowsingDataType : int32_t {
  
  kBrowsingHistory = 0,
  
  kDownloadHistory = 1,
  
  kCookiesAndSiteData = 2,
  
  kCachedImagesAndFiles = 3,
  
  kPasswords = 4,
  
  kAutofill = 5,
  
  kSiteSettings = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, ClearBrowsingDataType value);
inline bool IsKnownEnumValue(ClearBrowsingDataType value) {
  return internal::ClearBrowsingDataType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SetCookieResult : int32_t {
  
  kSuccess = 0,
  
  kFailure = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SetCookieResult value);
inline bool IsKnownEnumValue(SetCookieResult value) {
  return internal::SetCookieResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeleteCookieResult : int32_t {
  
  kSuccess = 0,
  
  kFailure = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, DeleteCookieResult value);
inline bool IsKnownEnumValue(DeleteCookieResult value) {
  return internal::DeleteCookieResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieSameSite : int32_t {
  
  kUnspecified = 0,
  
  kNone = 1,
  
  kLax = 2,
  
  kStrict = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CookieSameSite value);
inline bool IsKnownEnumValue(CookieSameSite value) {
  return internal::CookieSameSite_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IsolatedWebViewSource : int32_t {
  
  kDevTools = 0,
  
  kNewWindow = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, IsolatedWebViewSource value);
inline bool IsKnownEnumValue(IsolatedWebViewSource value) {
  return internal::IsolatedWebViewSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DownloadURLToFileClientInterfaceBase {};

using DownloadURLToFileClientPtrDataView =
    mojo::InterfacePtrDataView<DownloadURLToFileClientInterfaceBase>;
using DownloadURLToFileClientRequestDataView =
    mojo::InterfaceRequestDataView<DownloadURLToFileClientInterfaceBase>;
using DownloadURLToFileClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DownloadURLToFileClientInterfaceBase>;
using DownloadURLToFileClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DownloadURLToFileClientInterfaceBase>;
class DeferredLoadBlockerInterfaceBase {};

using DeferredLoadBlockerPtrDataView =
    mojo::InterfacePtrDataView<DeferredLoadBlockerInterfaceBase>;
using DeferredLoadBlockerRequestDataView =
    mojo::InterfaceRequestDataView<DeferredLoadBlockerInterfaceBase>;
using DeferredLoadBlockerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeferredLoadBlockerInterfaceBase>;
using DeferredLoadBlockerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeferredLoadBlockerInterfaceBase>;
class ProfileCloseListenerInterfaceBase {};

using ProfileCloseListenerPtrDataView =
    mojo::InterfacePtrDataView<ProfileCloseListenerInterfaceBase>;
using ProfileCloseListenerRequestDataView =
    mojo::InterfaceRequestDataView<ProfileCloseListenerInterfaceBase>;
using ProfileCloseListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfileCloseListenerInterfaceBase>;
using ProfileCloseListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfileCloseListenerInterfaceBase>;
class ProfileInterfaceBase {};

using ProfilePtrDataView =
    mojo::InterfacePtrDataView<ProfileInterfaceBase>;
using ProfileRequestDataView =
    mojo::InterfaceRequestDataView<ProfileInterfaceBase>;
using ProfileAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfileInterfaceBase>;
using ProfileAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfileInterfaceBase>;
class ProfileClientInterfaceBase {};

using ProfileClientPtrDataView =
    mojo::InterfacePtrDataView<ProfileClientInterfaceBase>;
using ProfileClientRequestDataView =
    mojo::InterfaceRequestDataView<ProfileClientInterfaceBase>;
using ProfileClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfileClientInterfaceBase>;
using ProfileClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfileClientInterfaceBase>;


class TypedUrlDataView {
 public:
  TypedUrlDataView() = default;

  TypedUrlDataView(
      internal::TypedUrl_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t unique_id() const {
    return data_->unique_id;
  }
  inline void GetUrlAsStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlAsString(UserType* output) {
    
    auto* pointer = data_->url_as_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int32_t visit_count() const {
    return data_->visit_count;
  }
  int32_t typed_count() const {
    return data_->typed_count;
  }
  inline void GetLastVisitTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastVisitTime(UserType* output) {
    
    auto* pointer = data_->last_visit_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TypedUrl_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryHistoryItemDataView {
 public:
  QueryHistoryItemDataView() = default;

  QueryHistoryItemDataView(
      internal::QueryHistoryItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetVisitTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisitTime(UserType* output) {
    
    auto* pointer = data_->visit_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::QueryHistoryItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryHistoryResponseDataView {
 public:
  QueryHistoryResponseDataView() = default;

  QueryHistoryResponseDataView(
      internal::QueryHistoryResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<QueryHistoryItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::QueryHistoryItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::QueryHistoryResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryHistoryOptionsDataView {
 public:
  QueryHistoryOptionsDataView() = default;

  QueryHistoryOptionsDataView(
      internal::QueryHistoryOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t limit() const {
    return data_->limit;
  }
  inline void GetStartDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStart` instead "
    "of `ReadStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetEndDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEnd` instead "
    "of `ReadEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::QueryHistoryOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieDataDataView {
 public:
  CookieDataDataView() = default;

  CookieDataDataView(
      internal::CookieData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool http_only() const {
    return data_->http_only;
  }
  bool secure() const {
    return data_->secure;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSameSite(UserType* output) const {
    auto data_value = data_->same_site;
    return mojo::internal::Deserialize<::owl::mojom::CookieSameSite>(
        data_value, output);
  }
  CookieSameSite same_site() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::CookieSameSite>(data_->same_site));
  }
  inline void GetExpirationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpirationTime(UserType* output) {
    
    auto* pointer = data_->expiration_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HistoryVisitDataView {
 public:
  HistoryVisitDataView() = default;

  HistoryVisitDataView(
      internal::HistoryVisit_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  std::optional<int64_t> referring_visit_id() const {

    return data_->referring_visit_id_$flag
        ? std::make_optional(data_->referring_visit_id_$value)
        : std::nullopt;
  }
  inline void GetExternalReferrerUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExternalReferrerUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `external_referrer_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExternalReferrerUrl` instead "
    "of `ReadExternalReferrerUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->external_referrer_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<bool> hidden() const {

    return data_->hidden_$flag
        ? std::make_optional(!!data_->hidden_$value)
        : std::nullopt;
  }
  std::optional<int32_t> transition() const {

    return data_->transition_$flag
        ? std::make_optional(data_->transition_$value)
        : std::nullopt;
  }
  std::optional<bool> should_increment_typed_count() const {

    return data_->should_increment_typed_count_$flag
        ? std::make_optional(!!data_->should_increment_typed_count_$value)
        : std::nullopt;
  }
  std::optional<int64_t> opener_visit_id() const {

    return data_->opener_visit_id_$flag
        ? std::make_optional(data_->opener_visit_id_$value)
        : std::nullopt;
  }
  std::optional<bool> consider_for_ntp_most_visited() const {

    return data_->consider_for_ntp_most_visited_$flag
        ? std::make_optional(!!data_->consider_for_ntp_most_visited_$value)
        : std::nullopt;
  }
  std::optional<int64_t> visit_duration() const {

    return data_->visit_duration_$flag
        ? std::make_optional(data_->visit_duration_$value)
        : std::nullopt;
  }
  std::optional<int64_t> redirect_source_visit_id() const {

    return data_->redirect_source_visit_id_$flag
        ? std::make_optional(data_->redirect_source_visit_id_$value)
        : std::nullopt;
  }
  std::optional<int64_t> redirect_destination_visit_id() const {

    return data_->redirect_destination_visit_id_$flag
        ? std::make_optional(data_->redirect_destination_visit_id_$value)
        : std::nullopt;
  }
 private:
  internal::HistoryVisit_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateBookmarkModelResultDataView {
 public:
  CreateBookmarkModelResultDataView() = default;

  CreateBookmarkModelResultDataView(
      internal::CreateBookmarkModelResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeModel() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::owl::mojom::BookmarkModelAssociatedPtrInfoDataView>(
            &data_->model, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::owl::mojom::BookmarkModelClientAssociatedRequestDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateBookmarkModelResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_PROFILE_MOJOM_DATA_VIEW_H_