// owl/mojom/permission_prompt.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/permission_prompt.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/permission_prompt.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* PermissionPromptRequestTypeToStringHelper(PermissionPromptRequestType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PermissionPromptRequestType::kUnknown:
      return "kUnknown";
    case PermissionPromptRequestType::kArSession:
      return "kArSession";
    case PermissionPromptRequestType::kCameraPanTiltZoom:
      return "kCameraPanTiltZoom";
    case PermissionPromptRequestType::kCameraStream:
      return "kCameraStream";
    case PermissionPromptRequestType::kCapturedSurfaceControl:
      return "kCapturedSurfaceControl";
    case PermissionPromptRequestType::kClipboard:
      return "kClipboard";
    case PermissionPromptRequestType::kTopLevelStorageAccess:
      return "kTopLevelStorageAccess";
    case PermissionPromptRequestType::kDiskQuota:
      return "kDiskQuota";
    case PermissionPromptRequestType::kFileSystemAccess:
      return "kFileSystemAccess";
    case PermissionPromptRequestType::kGeolocation:
      return "kGeolocation";
    case PermissionPromptRequestType::kHandTracking:
      return "kHandTracking";
    case PermissionPromptRequestType::kIdentityProvider:
      return "kIdentityProvider";
    case PermissionPromptRequestType::kIdleDetection:
      return "kIdleDetection";
    case PermissionPromptRequestType::kLocalFonts:
      return "kLocalFonts";
    case PermissionPromptRequestType::kLocalNetworkAccess:
      return "kLocalNetworkAccess";
    case PermissionPromptRequestType::kMicStream:
      return "kMicStream";
    case PermissionPromptRequestType::kMidiSysex:
      return "kMidiSysex";
    case PermissionPromptRequestType::kMultipleDownloads:
      return "kMultipleDownloads";
    case PermissionPromptRequestType::kNfcDevice:
      return "kNfcDevice";
    case PermissionPromptRequestType::kNotifications:
      return "kNotifications";
    case PermissionPromptRequestType::kKeyboardLock:
      return "kKeyboardLock";
    case PermissionPromptRequestType::kPointerLock:
      return "kPointerLock";
    case PermissionPromptRequestType::kProtectedMediaIdentifier:
      return "kProtectedMediaIdentifier";
    case PermissionPromptRequestType::kRegisterProtocolHandler:
      return "kRegisterProtocolHandler";
    case PermissionPromptRequestType::kSmartCard:
      return "kSmartCard";
    case PermissionPromptRequestType::kStorageAccess:
      return "kStorageAccess";
    case PermissionPromptRequestType::kVrSession:
      return "kVrSession";
    case PermissionPromptRequestType::kWebAppInstallation:
      return "kWebAppInstallation";
    case PermissionPromptRequestType::kWebPrinting:
      return "kWebPrinting";
    case PermissionPromptRequestType::kWindowManagement:
      return "kWindowManagement";
    default:
      return nullptr;
  }
}

std::string PermissionPromptRequestTypeToString(PermissionPromptRequestType value) {
  const char *str = PermissionPromptRequestTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PermissionPromptRequestType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PermissionPromptRequestType value) {
  return os << PermissionPromptRequestTypeToString(value);
}

namespace internal {


// static
bool PermissionPromptViewButton_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptViewButton_Data* object =
      static_cast<const PermissionPromptViewButton_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

PermissionPromptViewButton_Data::PermissionPromptViewButton_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptRequestItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptRequestItem_Data* object =
      static_cast<const PermissionPromptRequestItem_Data*>(data);


  if (!::owl::mojom::internal::PermissionPromptRequestType_Data
        ::Validate(object->request_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

PermissionPromptRequestItem_Data::PermissionPromptRequestItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptDetails_Data* object =
      static_cast<const PermissionPromptDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requesting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requesting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->extra_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allow_text, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->allow_text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->allow_once_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->block_text, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->block_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_buttons, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& view_buttons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->view_buttons, validation_context,
                                         &view_buttons_validate_params)) {
    return false;
  }

  return true;
}

PermissionPromptDetails_Data::PermissionPromptDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPrompt_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPrompt_Close_Params_Data* object =
      static_cast<const PermissionPrompt_Close_Params_Data*>(data);

  return true;
}

PermissionPrompt_Close_Params_Data::PermissionPrompt_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptClient_Accept_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptClient_Accept_Params_Data* object =
      static_cast<const PermissionPromptClient_Accept_Params_Data*>(data);

  return true;
}

PermissionPromptClient_Accept_Params_Data::PermissionPromptClient_Accept_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptClient_AcceptOnce_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptClient_AcceptOnce_Params_Data* object =
      static_cast<const PermissionPromptClient_AcceptOnce_Params_Data*>(data);

  return true;
}

PermissionPromptClient_AcceptOnce_Params_Data::PermissionPromptClient_AcceptOnce_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptClient_Deny_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptClient_Deny_Params_Data* object =
      static_cast<const PermissionPromptClient_Deny_Params_Data*>(data);

  return true;
}

PermissionPromptClient_Deny_Params_Data::PermissionPromptClient_Deny_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptClient_Dismiss_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptClient_Dismiss_Params_Data* object =
      static_cast<const PermissionPromptClient_Dismiss_Params_Data*>(data);

  return true;
}

PermissionPromptClient_Dismiss_Params_Data::PermissionPromptClient_Dismiss_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionPromptClient_RunViewButton_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PermissionPromptClient_RunViewButton_Params_Data* object =
      static_cast<const PermissionPromptClient_RunViewButton_Params_Data*>(data);

  return true;
}

PermissionPromptClient_RunViewButton_Params_Data::PermissionPromptClient_RunViewButton_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::PermissionPromptRequestType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::PermissionPromptRequestType value) {
  return std::move(context).WriteString(::owl::mojom::PermissionPromptRequestTypeToString(value));
}

} // namespace perfetto