// owl/mojom/password_prompt.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SEND_VALIDATION_H_
#define OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SEND_VALIDATION_H_

#include "owl/mojom/password_prompt.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "owl/mojom/password_prompt.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::owl::mojom::SavePasswordPromptType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::FederatedCredentialsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::FederatedCredentialsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::FederatedCredentials_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::upper_text(input)) in_upper_text = Traits::upper_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->upper_text)::BaseType> upper_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_upper_text,
        upper_text_fragment);

      fragment->upper_text.Set(
          upper_text_fragment.is_null() ? nullptr : upper_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->upper_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upper_text in FederatedCredentials struct");

      decltype(Traits::lower_text(input)) in_lower_text = Traits::lower_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lower_text)::BaseType> lower_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_lower_text,
        lower_text_fragment);

      fragment->lower_text.Set(
          lower_text_fragment.is_null() ? nullptr : lower_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lower_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lower_text in FederatedCredentials struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::UsernamePasswordCredentialsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::UsernamePasswordCredentialsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::UsernamePasswordCredentials_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::username(input)) in_username = Traits::username(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username)::BaseType> username_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_username,
        username_fragment);

      fragment->username.Set(
          username_fragment.is_null() ? nullptr : username_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username in UsernamePasswordCredentials struct");

      decltype(Traits::password(input)) in_password = Traits::password(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->password)::BaseType> password_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_password,
        password_fragment);

      fragment->password.Set(
          password_fragment.is_null() ? nullptr : password_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->password.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password in UsernamePasswordCredentials struct");

      decltype(Traits::all_usernames(input)) in_all_usernames = Traits::all_usernames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_usernames)::BaseType>
          all_usernames_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& all_usernames_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_all_usernames,
        all_usernames_fragment,
        &all_usernames_validate_params);

      fragment->all_usernames.Set(
          all_usernames_fragment.is_null() ? nullptr : all_usernames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->all_usernames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_usernames in UsernamePasswordCredentials struct");

      decltype(Traits::all_passwords(input)) in_all_passwords = Traits::all_passwords(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_passwords)::BaseType>
          all_passwords_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& all_passwords_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_all_passwords,
        all_passwords_fragment,
        &all_passwords_validate_params);

      fragment->all_passwords.Set(
          all_passwords_fragment.is_null() ? nullptr : all_passwords_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->all_passwords.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_passwords in UsernamePasswordCredentials struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::SavePasswordPromptDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::SavePasswordPromptDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::SavePasswordPromptDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::owl::mojom::SavePasswordPromptType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
      mojo::internal::MessageFragment<decltype(fragment->credentials)>
          credentials_fragment(fragment.message());
      credentials_fragment.Claim(&fragment->credentials);
      
      mojo::internal::Serialize<::owl::mojom::PasswordPromptCredentialsDataView, send_validation>(
        in_credentials,
        credentials_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->credentials.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null credentials in SavePasswordPromptDetails struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::owl::mojom::PasswordPromptCredentialsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::owl::mojom::PasswordPromptCredentialsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::owl::mojom::internal::PasswordPromptCredentials_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::owl::mojom::PasswordPromptCredentialsDataView::Tag::kUsernamePasswordCredentials: {
    decltype(Traits::username_password_credentials(input))
    in_username_password_credentials = Traits::username_password_credentials(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_username_password_credentials)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::UsernamePasswordCredentialsDataView, send_validation>(
  in_username_password_credentials,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null username_password_credentials in PasswordPromptCredentials union");
    fragment->data.f_username_password_credentials.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::owl::mojom::PasswordPromptCredentialsDataView::Tag::kFederatedCredentials: {
    decltype(Traits::federated_credentials(input))
    in_federated_credentials = Traits::federated_credentials(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_federated_credentials)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::owl::mojom::FederatedCredentialsDataView, send_validation>(
  in_federated_credentials,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null federated_credentials in PasswordPromptCredentials union");
    fragment->data.f_federated_credentials.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SEND_VALIDATION_H_