// owl/mojom/notification_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/notification_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/notification_service.mojom-params-data.h"
#include "owl/mojom/notification_service.mojom-shared-message-ids.h"

#include "owl/mojom/notification_service.mojom-import-headers.h"
#include "owl/mojom/notification_service.mojom-test-utils.h"


namespace owl::mojom {
// The declaration includes the definition on other builds.

NotificationService::IPCStableHashFunction NotificationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NotificationService>(message.name())) {
    case messages::NotificationService::kNotificationClicked: {
      return &NotificationService::NotificationClicked_Sym::IPCStableHash;
    }
    case messages::NotificationService::kNotificationClosed: {
      return &NotificationService::NotificationClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NotificationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NotificationService>(message.name())) {
      case messages::NotificationService::kNotificationClicked:
            return "Receive owl::mojom::NotificationService::NotificationClicked";
      case messages::NotificationService::kNotificationClosed:
            return "Receive owl::mojom::NotificationService::NotificationClosed";
    }
  } else {
    switch (static_cast<messages::NotificationService>(message.name())) {
      case messages::NotificationService::kNotificationClicked:
            return "Receive reply owl::mojom::NotificationService::NotificationClicked";
      case messages::NotificationService::kNotificationClosed:
            return "Receive reply owl::mojom::NotificationService::NotificationClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NotificationService::NotificationClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcae8d1fa;  // IPCStableHash for owl::mojom::NotificationService::NotificationClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationService::NotificationClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f5901ab;  // IPCStableHash for owl::mojom::NotificationService::NotificationClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NotificationServiceProxy::NotificationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NotificationServiceProxy::NotificationClicked(
    const std::string& in_notification_id, int32_t in_handler_type, const ::GURL& in_origin_url, std::optional<int32_t> in_action_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::NotificationService::NotificationClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler_type"), in_handler_type,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_url"), in_origin_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_index"), in_action_index,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kNotificationClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::NotificationService_NotificationClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in NotificationService.NotificationClicked request");

  params->handler_type = in_handler_type;
  mojo::internal::MessageFragment<
      typename decltype(params->origin_url)::BaseType> origin_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_origin_url,
    origin_url_fragment);

  params->origin_url.Set(
      origin_url_fragment.is_null() ? nullptr : origin_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_url in NotificationService.NotificationClicked request");
  params->action_index_$flag = in_action_index.has_value();
  if (in_action_index.has_value()) {
    params->action_index_$value = in_action_index.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("NotificationClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NotificationServiceProxy::NotificationClosed(
    const std::string& in_notification_id, int32_t in_handler_type, const ::GURL& in_origin_url, bool in_by_user) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::NotificationService::NotificationClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler_type"), in_handler_type,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_url"), in_origin_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("by_user"), in_by_user,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationService::kNotificationClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::NotificationService_NotificationClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in NotificationService.NotificationClosed request");

  params->handler_type = in_handler_type;
  mojo::internal::MessageFragment<
      typename decltype(params->origin_url)::BaseType> origin_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_origin_url,
    origin_url_fragment);

  params->origin_url.Set(
      origin_url_fragment.is_null() ? nullptr : origin_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_url in NotificationService.NotificationClosed request");

  params->by_user = in_by_user;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationService::Name_);
  message.set_method_name("NotificationClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NotificationServiceStubDispatch::Accept(
    NotificationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NotificationService>(message->header()->name)) {
    case messages::NotificationService::kNotificationClicked: {
      DCHECK(message->is_serialized());
      internal::NotificationService_NotificationClicked_Params_Data* params =
          reinterpret_cast<internal::NotificationService_NotificationClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationService.0
      bool success = true;
      std::string p_notification_id{};
      int32_t p_handler_type{};
      ::GURL p_origin_url{};
      std::optional<int32_t> p_action_index{};
      NotificationService_NotificationClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success)
        p_handler_type = input_data_view.handler_type();
      if (success && !input_data_view.ReadOriginUrl(&p_origin_url))
        success = false;
      if (success) {
        p_action_index = input_data_view.action_index();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotificationClicked(        
        std::move(p_notification_id), 
        std::move(p_handler_type), 
        std::move(p_origin_url), 
        std::move(p_action_index));
      return true;
    }
    case messages::NotificationService::kNotificationClosed: {
      DCHECK(message->is_serialized());
      internal::NotificationService_NotificationClosed_Params_Data* params =
          reinterpret_cast<internal::NotificationService_NotificationClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationService.1
      bool success = true;
      std::string p_notification_id{};
      int32_t p_handler_type{};
      ::GURL p_origin_url{};
      bool p_by_user{};
      NotificationService_NotificationClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success)
        p_handler_type = input_data_view.handler_type();
      if (success && !input_data_view.ReadOriginUrl(&p_origin_url))
        success = false;
      if (success)
        p_by_user = input_data_view.by_user();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotificationClosed(        
        std::move(p_notification_id), 
        std::move(p_handler_type), 
        std::move(p_origin_url), 
        std::move(p_by_user));
      return true;
    }
  }
  return false;
}

// static
bool NotificationServiceStubDispatch::AcceptWithResponder(
    NotificationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NotificationService>(message->header()->name)) {
    case messages::NotificationService::kNotificationClicked: {
      break;
    }
    case messages::NotificationService::kNotificationClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNotificationServiceValidationInfo[] = {
    { &internal::NotificationService_NotificationClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NotificationService_NotificationClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool NotificationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::NotificationService::Name_,
    kNotificationServiceValidationInfo);
}

// The declaration includes the definition on other builds.

NotificationServiceClient::IPCStableHashFunction NotificationServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NotificationServiceClient>(message.name())) {
    case messages::NotificationServiceClient::kShowNotification: {
      return &NotificationServiceClient::ShowNotification_Sym::IPCStableHash;
    }
    case messages::NotificationServiceClient::kRemoveNotification: {
      return &NotificationServiceClient::RemoveNotification_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NotificationServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NotificationServiceClient>(message.name())) {
      case messages::NotificationServiceClient::kShowNotification:
            return "Receive owl::mojom::NotificationServiceClient::ShowNotification";
      case messages::NotificationServiceClient::kRemoveNotification:
            return "Receive owl::mojom::NotificationServiceClient::RemoveNotification";
    }
  } else {
    switch (static_cast<messages::NotificationServiceClient>(message.name())) {
      case messages::NotificationServiceClient::kShowNotification:
            return "Receive reply owl::mojom::NotificationServiceClient::ShowNotification";
      case messages::NotificationServiceClient::kRemoveNotification:
            return "Receive reply owl::mojom::NotificationServiceClient::RemoveNotification";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NotificationServiceClient::ShowNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5537e7d;  // IPCStableHash for owl::mojom::NotificationServiceClient::ShowNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NotificationServiceClient::RemoveNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf717d81b;  // IPCStableHash for owl::mojom::NotificationServiceClient::RemoveNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NotificationServiceClientProxy::NotificationServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NotificationServiceClientProxy::ShowNotification(
    const std::string& in_notification_id, int32_t in_handler_type, const ::std::u16string& in_title, const ::std::u16string& in_message, const ::std::u16string& in_display_source, const ::GURL& in_origin_url, const ::gfx::ImageSkia& in_icon) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::NotificationServiceClient::ShowNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler_type"), in_handler_type,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_source"), in_display_source,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_url"), in_origin_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("icon"), in_icon,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationServiceClient::kShowNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::NotificationServiceClient_ShowNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in NotificationServiceClient.ShowNotification request");

  params->handler_type = in_handler_type;
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in NotificationServiceClient.ShowNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in NotificationServiceClient.ShowNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->display_source)::BaseType> display_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_display_source,
    display_source_fragment);

  params->display_source.Set(
      display_source_fragment.is_null() ? nullptr : display_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->display_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null display_source in NotificationServiceClient.ShowNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_url)::BaseType> origin_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_origin_url,
    origin_url_fragment);

  params->origin_url.Set(
      origin_url_fragment.is_null() ? nullptr : origin_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_url in NotificationServiceClient.ShowNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->icon)::BaseType> icon_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_icon,
    icon_fragment);

  params->icon.Set(
      icon_fragment.is_null() ? nullptr : icon_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationServiceClient::Name_);
  message.set_method_name("ShowNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NotificationServiceClientProxy::RemoveNotification(
    const std::string& in_notification_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::NotificationServiceClient::RemoveNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_id"), in_notification_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NotificationServiceClient::kRemoveNotification), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::NotificationServiceClient_RemoveNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notification_id)::BaseType> notification_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_notification_id,
    notification_id_fragment);

  params->notification_id.Set(
      notification_id_fragment.is_null() ? nullptr : notification_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->notification_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null notification_id in NotificationServiceClient.RemoveNotification request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NotificationServiceClient::Name_);
  message.set_method_name("RemoveNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NotificationServiceClientStubDispatch::Accept(
    NotificationServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NotificationServiceClient>(message->header()->name)) {
    case messages::NotificationServiceClient::kShowNotification: {
      DCHECK(message->is_serialized());
      internal::NotificationServiceClient_ShowNotification_Params_Data* params =
          reinterpret_cast<internal::NotificationServiceClient_ShowNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationServiceClient.0
      bool success = true;
      std::string p_notification_id{};
      int32_t p_handler_type{};
      ::std::u16string p_title{};
      ::std::u16string p_message{};
      ::std::u16string p_display_source{};
      ::GURL p_origin_url{};
      ::gfx::ImageSkia p_icon{};
      NotificationServiceClient_ShowNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (success)
        p_handler_type = input_data_view.handler_type();
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadDisplaySource(&p_display_source))
        success = false;
      if (success && !input_data_view.ReadOriginUrl(&p_origin_url))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowNotification(        
        std::move(p_notification_id), 
        std::move(p_handler_type), 
        std::move(p_title), 
        std::move(p_message), 
        std::move(p_display_source), 
        std::move(p_origin_url), 
        std::move(p_icon));
      return true;
    }
    case messages::NotificationServiceClient::kRemoveNotification: {
      DCHECK(message->is_serialized());
      internal::NotificationServiceClient_RemoveNotification_Params_Data* params =
          reinterpret_cast<internal::NotificationServiceClient_RemoveNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NotificationServiceClient.1
      bool success = true;
      std::string p_notification_id{};
      NotificationServiceClient_RemoveNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotificationId(&p_notification_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NotificationServiceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveNotification(        
        std::move(p_notification_id));
      return true;
    }
  }
  return false;
}

// static
bool NotificationServiceClientStubDispatch::AcceptWithResponder(
    NotificationServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NotificationServiceClient>(message->header()->name)) {
    case messages::NotificationServiceClient::kShowNotification: {
      break;
    }
    case messages::NotificationServiceClient::kRemoveNotification: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNotificationServiceClientValidationInfo[] = {
    { &internal::NotificationServiceClient_ShowNotification_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NotificationServiceClient_RemoveNotification_Params_Data::Validate,
     nullptr /* no response */},
};

bool NotificationServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::NotificationServiceClient::Name_,
    kNotificationServiceClientValidationInfo);
}



}  // owl::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void NotificationServiceInterceptorForTesting::NotificationClicked(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, std::optional<int32_t> action_index) {
  GetForwardingInterface()->NotificationClicked(
    std::move(notification_id)
    , 
    std::move(handler_type)
    , 
    std::move(origin_url)
    , 
    std::move(action_index)
    );
}
void NotificationServiceInterceptorForTesting::NotificationClosed(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, bool by_user) {
  GetForwardingInterface()->NotificationClosed(
    std::move(notification_id)
    , 
    std::move(handler_type)
    , 
    std::move(origin_url)
    , 
    std::move(by_user)
    );
}
NotificationServiceAsyncWaiter::NotificationServiceAsyncWaiter(
    NotificationService* proxy) : proxy_(proxy) {}

NotificationServiceAsyncWaiter::~NotificationServiceAsyncWaiter() = default;





void NotificationServiceClientInterceptorForTesting::ShowNotification(const std::string& notification_id, int32_t handler_type, const ::std::u16string& title, const ::std::u16string& message, const ::std::u16string& display_source, const ::GURL& origin_url, const ::gfx::ImageSkia& icon) {
  GetForwardingInterface()->ShowNotification(
    std::move(notification_id)
    , 
    std::move(handler_type)
    , 
    std::move(title)
    , 
    std::move(message)
    , 
    std::move(display_source)
    , 
    std::move(origin_url)
    , 
    std::move(icon)
    );
}
void NotificationServiceClientInterceptorForTesting::RemoveNotification(const std::string& notification_id) {
  GetForwardingInterface()->RemoveNotification(
    std::move(notification_id)
    );
}
NotificationServiceClientAsyncWaiter::NotificationServiceClientAsyncWaiter(
    NotificationServiceClient* proxy) : proxy_(proxy) {}

NotificationServiceClientAsyncWaiter::~NotificationServiceClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif