// owl/mojom/metrics.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_METRICS_MOJOM_H_
#define OWL_MOJOM_METRICS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/metrics.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/metrics.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/metrics.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class MetricsServiceClientProxy;

template <typename ImplRefTraits>
class MetricsServiceClientStub;

class MetricsServiceClientRequestValidator;


class MetricsServiceClient
    : public MetricsServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.MetricsServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MetricsServiceClientInterfaceBase;
  using Proxy_ = MetricsServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MetricsServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = MetricsServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnHistogramSampleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnHistogramSample_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MetricsServiceClient() = default;

  virtual void OnHistogramSample(HistogramSamplePtr sample) = 0;
};

class MetricsServiceProxy;

template <typename ImplRefTraits>
class MetricsServiceStub;

class MetricsServiceRequestValidator;


class MetricsService
    : public MetricsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.MetricsService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MetricsServiceInterfaceBase;
  using Proxy_ = MetricsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MetricsServiceStub<ImplRefTraits>;

  using RequestValidator_ = MetricsServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSubscribeMinVersion = 0,
    kUnsubscribeMinVersion = 0,
    kSetSubscriptionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Subscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unsubscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSubscriptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MetricsService() = default;

  virtual void Subscribe(const std::vector<std::string>& histogram_names) = 0;

  virtual void Unsubscribe(const std::vector<std::string>& histogram_names) = 0;

  virtual void SetSubscriptions(const std::vector<std::string>& histogram_names) = 0;
};



class  MetricsServiceClientProxy
    : public MetricsServiceClient {
 public:
  using InterfaceType = MetricsServiceClient;

  explicit MetricsServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnHistogramSample(HistogramSamplePtr sample) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MetricsServiceProxy
    : public MetricsService {
 public:
  using InterfaceType = MetricsService;

  explicit MetricsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Subscribe(const std::vector<std::string>& histogram_names) final;
  
  void Unsubscribe(const std::vector<std::string>& histogram_names) final;
  
  void SetSubscriptions(const std::vector<std::string>& histogram_names) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MetricsServiceClientStubDispatch {
 public:
  static bool Accept(MetricsServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MetricsServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MetricsServiceClient>>
class MetricsServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MetricsServiceClientStub() = default;
  ~MetricsServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MetricsServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MetricsServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MetricsServiceStubDispatch {
 public:
  static bool Accept(MetricsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MetricsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MetricsService>>
class MetricsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MetricsServiceStub() = default;
  ~MetricsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MetricsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MetricsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MetricsServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MetricsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  HistogramSample {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HistogramSample, T>::value>;
  using DataView = HistogramSampleDataView;
  using Data_ = internal::HistogramSample_Data;

  template <typename... Args>
  static HistogramSamplePtr New(Args&&... args) {
    return HistogramSamplePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HistogramSamplePtr From(const U& u) {
    return mojo::TypeConverter<HistogramSamplePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HistogramSample>::Convert(*this);
  }


  HistogramSample();

  HistogramSample(
      const std::string& histogram_name,
      uint64_t name_hash,
      int32_t sample,
      std::optional<uint64_t> event_id);


  ~HistogramSample();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HistogramSamplePtr>
  HistogramSamplePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistogramSample::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistogramSample::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HistogramSample::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HistogramSample_UnserializedMessageContext<
            UserType, HistogramSample::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HistogramSample::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HistogramSample::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HistogramSample_UnserializedMessageContext<
            UserType, HistogramSample::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HistogramSample::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string histogram_name;
  
  uint64_t name_hash;
  
  int32_t sample;
  
  std::optional<uint64_t> event_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HistogramSample::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
HistogramSamplePtr HistogramSample::Clone() const {
  return New(
      mojo::Clone(histogram_name),
      mojo::Clone(name_hash),
      mojo::Clone(sample),
      mojo::Clone(event_id)
  );
}

template <typename T, HistogramSample::EnableIfSame<T>*>
bool HistogramSample::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->histogram_name, other_struct.histogram_name))
    return false;
  if (!mojo::Equals(this->name_hash, other_struct.name_hash))
    return false;
  if (!mojo::Equals(this->sample, other_struct.sample))
    return false;
  if (!mojo::Equals(this->event_id, other_struct.event_id))
    return false;
  return true;
}

template <typename T, HistogramSample::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.histogram_name < rhs.histogram_name)
    return true;
  if (rhs.histogram_name < lhs.histogram_name)
    return false;
  if (lhs.name_hash < rhs.name_hash)
    return true;
  if (rhs.name_hash < lhs.name_hash)
    return false;
  if (lhs.sample < rhs.sample)
    return true;
  if (rhs.sample < lhs.sample)
    return false;
  if (lhs.event_id < rhs.event_id)
    return true;
  if (rhs.event_id < lhs.event_id)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::HistogramSample::DataView,
                                         ::owl::mojom::HistogramSamplePtr> {
  static bool IsNull(const ::owl::mojom::HistogramSamplePtr& input) { return !input; }
  static void SetToNull(::owl::mojom::HistogramSamplePtr* output) { output->reset(); }

  static const decltype(::owl::mojom::HistogramSample::histogram_name)& histogram_name(
      const ::owl::mojom::HistogramSamplePtr& input) {
    return input->histogram_name;
  }

  static decltype(::owl::mojom::HistogramSample::name_hash) name_hash(
      const ::owl::mojom::HistogramSamplePtr& input) {
    return input->name_hash;
  }

  static decltype(::owl::mojom::HistogramSample::sample) sample(
      const ::owl::mojom::HistogramSamplePtr& input) {
    return input->sample;
  }

  static decltype(::owl::mojom::HistogramSample::event_id) event_id(
      const ::owl::mojom::HistogramSamplePtr& input) {
    return input->event_id;
  }

  static bool Read(::owl::mojom::HistogramSample::DataView input, ::owl::mojom::HistogramSamplePtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_METRICS_MOJOM_H_