// owl/mojom/icloud_passkeys.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_H_
#define OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/icloud_passkeys.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/icloud_passkeys.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/icloud_passkeys.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class ICloudKeychainPasskeyBridgeProxy;

template <typename ImplRefTraits>
class ICloudKeychainPasskeyBridgeStub;

class ICloudKeychainPasskeyBridgeRequestValidator;
class ICloudKeychainPasskeyBridgeResponseValidator;


class ICloudKeychainPasskeyBridge
    : public ICloudKeychainPasskeyBridgeInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ICloudKeychainPasskeyBridge";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ICloudKeychainPasskeyBridgeInterfaceBase;
  using Proxy_ = ICloudKeychainPasskeyBridgeProxy;

  template <typename ImplRefTraits>
  using Stub_ = ICloudKeychainPasskeyBridgeStub<ImplRefTraits>;

  using RequestValidator_ = ICloudKeychainPasskeyBridgeRequestValidator;
  using ResponseValidator_ = ICloudKeychainPasskeyBridgeResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMakeCredentialAuthorizeIfNecessaryMinVersion = 0,
    kGetAssertionAuthorizeIfNecessaryMinVersion = 0,
    kGetCredentialsMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MakeCredentialAuthorizeIfNecessary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAssertionAuthorizeIfNecessary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCredentials_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ICloudKeychainPasskeyBridge() = default;

  using MakeCredentialAuthorizeIfNecessaryCallback = base::OnceCallback<void(MakeCredentialResultPtr)>;
  using MakeCredentialAuthorizeIfNecessaryMojoCallback = base::OnceCallback<void(MakeCredentialResultPtr)>;

  virtual void MakeCredentialAuthorizeIfNecessary(CtapMakeCredentialRequestPtr request, MakeCredentialAuthorizeIfNecessaryCallback callback) = 0;

  using GetAssertionAuthorizeIfNecessaryCallback = base::OnceCallback<void(GetAssertionResultPtr)>;
  using GetAssertionAuthorizeIfNecessaryMojoCallback = base::OnceCallback<void(GetAssertionResultPtr)>;

  virtual void GetAssertionAuthorizeIfNecessary(CtapGetAssertionRequestPtr request, GetAssertionAuthorizeIfNecessaryCallback callback) = 0;

  using GetCredentialsCallback = base::OnceCallback<void(GetCredentialsResultPtr)>;
  using GetCredentialsMojoCallback = base::OnceCallback<void(GetCredentialsResultPtr)>;

  virtual void GetCredentials(const std::string& rp_id, GetCredentialsCallback callback) = 0;

  virtual void Cancel() = 0;
};



class  ICloudKeychainPasskeyBridgeProxy
    : public ICloudKeychainPasskeyBridge {
 public:
  using InterfaceType = ICloudKeychainPasskeyBridge;

  explicit ICloudKeychainPasskeyBridgeProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MakeCredentialAuthorizeIfNecessary(CtapMakeCredentialRequestPtr request, MakeCredentialAuthorizeIfNecessaryCallback callback) final;
  
  void GetAssertionAuthorizeIfNecessary(CtapGetAssertionRequestPtr request, GetAssertionAuthorizeIfNecessaryCallback callback) final;
  
  void GetCredentials(const std::string& rp_id, GetCredentialsCallback callback) final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ICloudKeychainPasskeyBridgeStubDispatch {
 public:
  static bool Accept(ICloudKeychainPasskeyBridge* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ICloudKeychainPasskeyBridge* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ICloudKeychainPasskeyBridge>>
class ICloudKeychainPasskeyBridgeStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ICloudKeychainPasskeyBridgeStub() = default;
  ~ICloudKeychainPasskeyBridgeStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ICloudKeychainPasskeyBridgeStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ICloudKeychainPasskeyBridgeStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ICloudKeychainPasskeyBridgeRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ICloudKeychainPasskeyBridgeResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ICloudKeychainPasskeyResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ICloudKeychainPasskeyResult, T>::value>;
  using DataView = ICloudKeychainPasskeyResultDataView;
  using Data_ = internal::ICloudKeychainPasskeyResult_Data;

  template <typename... Args>
  static ICloudKeychainPasskeyResultPtr New(Args&&... args) {
    return ICloudKeychainPasskeyResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ICloudKeychainPasskeyResultPtr From(const U& u) {
    return mojo::TypeConverter<ICloudKeychainPasskeyResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ICloudKeychainPasskeyResult>::Convert(*this);
  }


  ICloudKeychainPasskeyResult();

  explicit ICloudKeychainPasskeyResult(
      const std::string& raw_attestation_object);


  ~ICloudKeychainPasskeyResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ICloudKeychainPasskeyResultPtr>
  ICloudKeychainPasskeyResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudKeychainPasskeyResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudKeychainPasskeyResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ICloudKeychainPasskeyResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ICloudKeychainPasskeyResult_UnserializedMessageContext<
            UserType, ICloudKeychainPasskeyResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ICloudKeychainPasskeyResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ICloudKeychainPasskeyResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ICloudKeychainPasskeyResult_UnserializedMessageContext<
            UserType, ICloudKeychainPasskeyResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ICloudKeychainPasskeyResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string raw_attestation_object;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  RequestID {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestID, T>::value>;
  using DataView = RequestIDDataView;
  using Data_ = internal::RequestID_Data;

  template <typename... Args>
  static RequestIDPtr New(Args&&... args) {
    return RequestIDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestIDPtr From(const U& u) {
    return mojo::TypeConverter<RequestIDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestID>::Convert(*this);
  }


  RequestID();

  explicit RequestID(
      const std::string& group_id);


  ~RequestID();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestIDPtr>
  RequestIDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestID::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestID::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestID::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestID::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestID::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestID::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestID_UnserializedMessageContext<
            UserType, RequestID::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestID::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestID::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestID_UnserializedMessageContext<
            UserType, RequestID::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestID::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestID::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestID::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestID::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestID::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

















class  PRFInput {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PRFInput, T>::value>;
  using DataView = PRFInputDataView;
  using Data_ = internal::PRFInput_Data;

  template <typename... Args>
  static PRFInputPtr New(Args&&... args) {
    return PRFInputPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PRFInputPtr From(const U& u) {
    return mojo::TypeConverter<PRFInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PRFInput>::Convert(*this);
  }


  PRFInput();

  PRFInput(
      std::optional<std::vector<uint8_t>> id,
      std::vector<uint8_t> input1,
      std::optional<std::vector<uint8_t>> input2);


  ~PRFInput();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PRFInputPtr>
  PRFInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PRFInput::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PRFInput::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PRFInput::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PRFInput_UnserializedMessageContext<
            UserType, PRFInput::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PRFInput::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PRFInput::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PRFInput_UnserializedMessageContext<
            UserType, PRFInput::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PRFInput::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<uint8_t>> id;
  
  std::vector<uint8_t> input1;
  
  std::optional<std::vector<uint8_t>> input2;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PRFInput::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PublicKeyCredentialDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PublicKeyCredentialDescriptor, T>::value>;
  using DataView = PublicKeyCredentialDescriptorDataView;
  using Data_ = internal::PublicKeyCredentialDescriptor_Data;

  template <typename... Args>
  static PublicKeyCredentialDescriptorPtr New(Args&&... args) {
    return PublicKeyCredentialDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PublicKeyCredentialDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<PublicKeyCredentialDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PublicKeyCredentialDescriptor>::Convert(*this);
  }


  PublicKeyCredentialDescriptor();

  PublicKeyCredentialDescriptor(
      std::vector<uint8_t> id,
      std::vector<std::string> transports);


  ~PublicKeyCredentialDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PublicKeyCredentialDescriptorPtr>
  PublicKeyCredentialDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PublicKeyCredentialDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PublicKeyCredentialDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PublicKeyCredentialDescriptor_UnserializedMessageContext<
            UserType, PublicKeyCredentialDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PublicKeyCredentialDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PublicKeyCredentialDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PublicKeyCredentialDescriptor_UnserializedMessageContext<
            UserType, PublicKeyCredentialDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PublicKeyCredentialDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> id;
  
  std::vector<std::string> transports;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CtapMakeCredentialRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CtapMakeCredentialRequest, T>::value>;
  using DataView = CtapMakeCredentialRequestDataView;
  using Data_ = internal::CtapMakeCredentialRequest_Data;

  template <typename... Args>
  static CtapMakeCredentialRequestPtr New(Args&&... args) {
    return CtapMakeCredentialRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CtapMakeCredentialRequestPtr From(const U& u) {
    return mojo::TypeConverter<CtapMakeCredentialRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CtapMakeCredentialRequest>::Convert(*this);
  }


  CtapMakeCredentialRequest();

  CtapMakeCredentialRequest(
      RequestIDPtr request_id,
      const std::string& rp_id,
      std::vector<uint8_t> client_data_hash,
      std::vector<uint8_t> user_id,
      const std::string& user_name,
      UserVerificationRequirement user_verification,
      const std::optional<std::string>& user_display_name,
      bool has_prf,
      PRFInputPtr prf_input,
      LargeBlobSupport large_blob_support,
      std::vector<int32_t> public_key_algorithms,
      bool resident_key_required,
      std::vector<PublicKeyCredentialDescriptorPtr> exclude_list);

CtapMakeCredentialRequest(const CtapMakeCredentialRequest&) = delete;
CtapMakeCredentialRequest& operator=(const CtapMakeCredentialRequest&) = delete;

  ~CtapMakeCredentialRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CtapMakeCredentialRequestPtr>
  CtapMakeCredentialRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CtapMakeCredentialRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CtapMakeCredentialRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CtapMakeCredentialRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CtapMakeCredentialRequest_UnserializedMessageContext<
            UserType, CtapMakeCredentialRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CtapMakeCredentialRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CtapMakeCredentialRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CtapMakeCredentialRequest_UnserializedMessageContext<
            UserType, CtapMakeCredentialRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CtapMakeCredentialRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RequestIDPtr request_id;
  
  std::string rp_id;
  
  std::vector<uint8_t> client_data_hash;
  
  std::vector<uint8_t> user_id;
  
  std::string user_name;
  
  UserVerificationRequirement user_verification;
  
  std::optional<std::string> user_display_name;
  
  bool has_prf;
  
  PRFInputPtr prf_input;
  
  LargeBlobSupport large_blob_support;
  
  std::vector<int32_t> public_key_algorithms;
  
  bool resident_key_required;
  
  std::vector<PublicKeyCredentialDescriptorPtr> exclude_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CtapGetAssertionRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CtapGetAssertionRequest, T>::value>;
  using DataView = CtapGetAssertionRequestDataView;
  using Data_ = internal::CtapGetAssertionRequest_Data;

  template <typename... Args>
  static CtapGetAssertionRequestPtr New(Args&&... args) {
    return CtapGetAssertionRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CtapGetAssertionRequestPtr From(const U& u) {
    return mojo::TypeConverter<CtapGetAssertionRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CtapGetAssertionRequest>::Convert(*this);
  }


  CtapGetAssertionRequest();

  CtapGetAssertionRequest(
      RequestIDPtr request_id,
      const std::string& rp_id,
      std::vector<uint8_t> client_data_hash,
      std::vector<std::vector<uint8_t>> allowed_ids,
      UserVerificationRequirement user_verification,
      std::vector<PRFInputPtr> prf_inputs,
      bool large_blob_read,
      std::optional<std::vector<uint8_t>> large_blob_write);

CtapGetAssertionRequest(const CtapGetAssertionRequest&) = delete;
CtapGetAssertionRequest& operator=(const CtapGetAssertionRequest&) = delete;

  ~CtapGetAssertionRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CtapGetAssertionRequestPtr>
  CtapGetAssertionRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CtapGetAssertionRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CtapGetAssertionRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CtapGetAssertionRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CtapGetAssertionRequest_UnserializedMessageContext<
            UserType, CtapGetAssertionRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CtapGetAssertionRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CtapGetAssertionRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CtapGetAssertionRequest_UnserializedMessageContext<
            UserType, CtapGetAssertionRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CtapGetAssertionRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RequestIDPtr request_id;
  
  std::string rp_id;
  
  std::vector<uint8_t> client_data_hash;
  
  std::vector<std::vector<uint8_t>> allowed_ids;
  
  UserVerificationRequirement user_verification;
  
  std::vector<PRFInputPtr> prf_inputs;
  
  bool large_blob_read;
  
  std::optional<std::vector<uint8_t>> large_blob_write;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CtapGetAssertionRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ICloudCredentialPrfData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ICloudCredentialPrfData, T>::value>;
  using DataView = ICloudCredentialPrfDataDataView;
  using Data_ = internal::ICloudCredentialPrfData_Data;

  template <typename... Args>
  static ICloudCredentialPrfDataPtr New(Args&&... args) {
    return ICloudCredentialPrfDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ICloudCredentialPrfDataPtr From(const U& u) {
    return mojo::TypeConverter<ICloudCredentialPrfDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ICloudCredentialPrfData>::Convert(*this);
  }


  ICloudCredentialPrfData();

  ICloudCredentialPrfData(
      bool prf_enabled,
      std::optional<std::vector<uint8_t>> prf_results);


  ~ICloudCredentialPrfData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ICloudCredentialPrfDataPtr>
  ICloudCredentialPrfDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudCredentialPrfData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudCredentialPrfData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ICloudCredentialPrfData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ICloudCredentialPrfData_UnserializedMessageContext<
            UserType, ICloudCredentialPrfData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ICloudCredentialPrfData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ICloudCredentialPrfData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ICloudCredentialPrfData_UnserializedMessageContext<
            UserType, ICloudCredentialPrfData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ICloudCredentialPrfData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool prf_enabled;
  
  std::optional<std::vector<uint8_t>> prf_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ICloudCredentialPrfData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ICloudCredential {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ICloudCredential, T>::value>;
  using DataView = ICloudCredentialDataView;
  using Data_ = internal::ICloudCredential_Data;

  template <typename... Args>
  static ICloudCredentialPtr New(Args&&... args) {
    return ICloudCredentialPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ICloudCredentialPtr From(const U& u) {
    return mojo::TypeConverter<ICloudCredentialPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ICloudCredential>::Convert(*this);
  }


  ICloudCredential();

  ICloudCredential(
      std::vector<uint8_t> raw_attestation_object,
      std::vector<uint8_t> credential_id,
      ICloudCredentialPrfDataPtr prf_data,
      bool is_bespoke_large_blob);

ICloudCredential(const ICloudCredential&) = delete;
ICloudCredential& operator=(const ICloudCredential&) = delete;

  ~ICloudCredential();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ICloudCredentialPtr>
  ICloudCredentialPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudCredential::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ICloudCredential::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ICloudCredential::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ICloudCredential_UnserializedMessageContext<
            UserType, ICloudCredential::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ICloudCredential::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ICloudCredential::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ICloudCredential_UnserializedMessageContext<
            UserType, ICloudCredential::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ICloudCredential::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> raw_attestation_object;
  
  std::vector<uint8_t> credential_id;
  
  ICloudCredentialPrfDataPtr prf_data;
  
  bool is_bespoke_large_blob;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ICloudCredential::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MakeCredentialResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MakeCredentialResult, T>::value>;
  using DataView = MakeCredentialResultDataView;
  using Data_ = internal::MakeCredentialResult_Data;

  template <typename... Args>
  static MakeCredentialResultPtr New(Args&&... args) {
    return MakeCredentialResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MakeCredentialResultPtr From(const U& u) {
    return mojo::TypeConverter<MakeCredentialResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MakeCredentialResult>::Convert(*this);
  }


  MakeCredentialResult();

  MakeCredentialResult(
      ICloudCredentialPtr credential,
      std::optional<MakeCredentialFailureReason> failure_reason);

MakeCredentialResult(const MakeCredentialResult&) = delete;
MakeCredentialResult& operator=(const MakeCredentialResult&) = delete;

  ~MakeCredentialResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MakeCredentialResultPtr>
  MakeCredentialResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MakeCredentialResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MakeCredentialResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MakeCredentialResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MakeCredentialResult_UnserializedMessageContext<
            UserType, MakeCredentialResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MakeCredentialResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MakeCredentialResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MakeCredentialResult_UnserializedMessageContext<
            UserType, MakeCredentialResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MakeCredentialResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ICloudCredentialPtr credential;
  
  std::optional<MakeCredentialFailureReason> failure_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MakeCredentialResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AuthenticatorData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthenticatorData, T>::value>;
  using DataView = AuthenticatorDataDataView;
  using Data_ = internal::AuthenticatorData_Data;

  template <typename... Args>
  static AuthenticatorDataPtr New(Args&&... args) {
    return AuthenticatorDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthenticatorDataPtr From(const U& u) {
    return mojo::TypeConverter<AuthenticatorDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthenticatorData>::Convert(*this);
  }


  AuthenticatorData();

  AuthenticatorData(
      std::vector<uint8_t> raw_authenticator_data,
      std::vector<uint8_t> signature,
      std::vector<uint8_t> user_id,
      std::vector<uint8_t> credential_id,
      std::optional<std::vector<uint8_t>> hmac_secret,
      std::optional<std::vector<uint8_t>> large_blob,
      bool large_blob_written);


  ~AuthenticatorData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthenticatorDataPtr>
  AuthenticatorDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticatorData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthenticatorData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthenticatorData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthenticatorData_UnserializedMessageContext<
            UserType, AuthenticatorData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthenticatorData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthenticatorData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthenticatorData_UnserializedMessageContext<
            UserType, AuthenticatorData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthenticatorData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> raw_authenticator_data;
  
  std::vector<uint8_t> signature;
  
  std::vector<uint8_t> user_id;
  
  std::vector<uint8_t> credential_id;
  
  std::optional<std::vector<uint8_t>> hmac_secret;
  
  std::optional<std::vector<uint8_t>> large_blob;
  
  bool large_blob_written;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthenticatorData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetAssertionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetAssertionResult, T>::value>;
  using DataView = GetAssertionResultDataView;
  using Data_ = internal::GetAssertionResult_Data;

  template <typename... Args>
  static GetAssertionResultPtr New(Args&&... args) {
    return GetAssertionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetAssertionResultPtr From(const U& u) {
    return mojo::TypeConverter<GetAssertionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetAssertionResult>::Convert(*this);
  }


  GetAssertionResult();

  GetAssertionResult(
      AuthenticatorDataPtr data,
      std::optional<GetAssertionFailureReason> failure_reason);

GetAssertionResult(const GetAssertionResult&) = delete;
GetAssertionResult& operator=(const GetAssertionResult&) = delete;

  ~GetAssertionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetAssertionResultPtr>
  GetAssertionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetAssertionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetAssertionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetAssertionResult_UnserializedMessageContext<
            UserType, GetAssertionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetAssertionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetAssertionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetAssertionResult_UnserializedMessageContext<
            UserType, GetAssertionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetAssertionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AuthenticatorDataPtr data;
  
  std::optional<GetAssertionFailureReason> failure_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetAssertionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ExistingCredential {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExistingCredential, T>::value>;
  using DataView = ExistingCredentialDataView;
  using Data_ = internal::ExistingCredential_Data;

  template <typename... Args>
  static ExistingCredentialPtr New(Args&&... args) {
    return ExistingCredentialPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExistingCredentialPtr From(const U& u) {
    return mojo::TypeConverter<ExistingCredentialPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExistingCredential>::Convert(*this);
  }


  ExistingCredential();

  ExistingCredential(
      std::vector<uint8_t> credential_id,
      const std::optional<std::string>& provider_name,
      std::vector<uint8_t> user_handle,
      const std::string& name);


  ~ExistingCredential();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExistingCredentialPtr>
  ExistingCredentialPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExistingCredential::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExistingCredential::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExistingCredential::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExistingCredential_UnserializedMessageContext<
            UserType, ExistingCredential::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExistingCredential::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExistingCredential::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExistingCredential_UnserializedMessageContext<
            UserType, ExistingCredential::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExistingCredential::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> credential_id;
  
  std::optional<std::string> provider_name;
  
  std::vector<uint8_t> user_handle;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExistingCredential::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetCredentialsResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetCredentialsResult, T>::value>;
  using DataView = GetCredentialsResultDataView;
  using Data_ = internal::GetCredentialsResult_Data;

  template <typename... Args>
  static GetCredentialsResultPtr New(Args&&... args) {
    return GetCredentialsResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetCredentialsResultPtr From(const U& u) {
    return mojo::TypeConverter<GetCredentialsResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetCredentialsResult>::Convert(*this);
  }


  GetCredentialsResult();

  GetCredentialsResult(
      std::optional<std::vector<ExistingCredentialPtr>> credentials,
      std::optional<GetCredentialsFailureReason> failure_reason);

GetCredentialsResult(const GetCredentialsResult&) = delete;
GetCredentialsResult& operator=(const GetCredentialsResult&) = delete;

  ~GetCredentialsResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetCredentialsResultPtr>
  GetCredentialsResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetCredentialsResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetCredentialsResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetCredentialsResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetCredentialsResult_UnserializedMessageContext<
            UserType, GetCredentialsResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetCredentialsResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetCredentialsResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetCredentialsResult_UnserializedMessageContext<
            UserType, GetCredentialsResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetCredentialsResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<ExistingCredentialPtr>> credentials;
  
  std::optional<GetCredentialsFailureReason> failure_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetCredentialsResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ICloudKeychainPasskeyResultPtr ICloudKeychainPasskeyResult::Clone() const {
  return New(
      mojo::Clone(raw_attestation_object)
  );
}

template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>*>
bool ICloudKeychainPasskeyResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->raw_attestation_object, other_struct.raw_attestation_object))
    return false;
  return true;
}

template <typename T, ICloudKeychainPasskeyResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.raw_attestation_object < rhs.raw_attestation_object)
    return true;
  if (rhs.raw_attestation_object < lhs.raw_attestation_object)
    return false;
  return false;
}
template <typename StructPtrType>
PRFInputPtr PRFInput::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(input1),
      mojo::Clone(input2)
  );
}

template <typename T, PRFInput::EnableIfSame<T>*>
bool PRFInput::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->input1, other_struct.input1))
    return false;
  if (!mojo::Equals(this->input2, other_struct.input2))
    return false;
  return true;
}

template <typename T, PRFInput::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.input1 < rhs.input1)
    return true;
  if (rhs.input1 < lhs.input1)
    return false;
  if (lhs.input2 < rhs.input2)
    return true;
  if (rhs.input2 < lhs.input2)
    return false;
  return false;
}
template <typename StructPtrType>
PublicKeyCredentialDescriptorPtr PublicKeyCredentialDescriptor::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(transports)
  );
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>*>
bool PublicKeyCredentialDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->transports, other_struct.transports))
    return false;
  return true;
}

template <typename T, PublicKeyCredentialDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.transports < rhs.transports)
    return true;
  if (rhs.transports < lhs.transports)
    return false;
  return false;
}
template <typename StructPtrType>
RequestIDPtr RequestID::Clone() const {
  return New(
      mojo::Clone(group_id)
  );
}

template <typename T, RequestID::EnableIfSame<T>*>
bool RequestID::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  return true;
}

template <typename T, RequestID::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  return false;
}
template <typename StructPtrType>
CtapMakeCredentialRequestPtr CtapMakeCredentialRequest::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(rp_id),
      mojo::Clone(client_data_hash),
      mojo::Clone(user_id),
      mojo::Clone(user_name),
      mojo::Clone(user_verification),
      mojo::Clone(user_display_name),
      mojo::Clone(has_prf),
      mojo::Clone(prf_input),
      mojo::Clone(large_blob_support),
      mojo::Clone(public_key_algorithms),
      mojo::Clone(resident_key_required),
      mojo::Clone(exclude_list)
  );
}

template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>*>
bool CtapMakeCredentialRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->rp_id, other_struct.rp_id))
    return false;
  if (!mojo::Equals(this->client_data_hash, other_struct.client_data_hash))
    return false;
  if (!mojo::Equals(this->user_id, other_struct.user_id))
    return false;
  if (!mojo::Equals(this->user_name, other_struct.user_name))
    return false;
  if (!mojo::Equals(this->user_verification, other_struct.user_verification))
    return false;
  if (!mojo::Equals(this->user_display_name, other_struct.user_display_name))
    return false;
  if (!mojo::Equals(this->has_prf, other_struct.has_prf))
    return false;
  if (!mojo::Equals(this->prf_input, other_struct.prf_input))
    return false;
  if (!mojo::Equals(this->large_blob_support, other_struct.large_blob_support))
    return false;
  if (!mojo::Equals(this->public_key_algorithms, other_struct.public_key_algorithms))
    return false;
  if (!mojo::Equals(this->resident_key_required, other_struct.resident_key_required))
    return false;
  if (!mojo::Equals(this->exclude_list, other_struct.exclude_list))
    return false;
  return true;
}

template <typename T, CtapMakeCredentialRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.rp_id < rhs.rp_id)
    return true;
  if (rhs.rp_id < lhs.rp_id)
    return false;
  if (lhs.client_data_hash < rhs.client_data_hash)
    return true;
  if (rhs.client_data_hash < lhs.client_data_hash)
    return false;
  if (lhs.user_id < rhs.user_id)
    return true;
  if (rhs.user_id < lhs.user_id)
    return false;
  if (lhs.user_name < rhs.user_name)
    return true;
  if (rhs.user_name < lhs.user_name)
    return false;
  if (lhs.user_verification < rhs.user_verification)
    return true;
  if (rhs.user_verification < lhs.user_verification)
    return false;
  if (lhs.user_display_name < rhs.user_display_name)
    return true;
  if (rhs.user_display_name < lhs.user_display_name)
    return false;
  if (lhs.has_prf < rhs.has_prf)
    return true;
  if (rhs.has_prf < lhs.has_prf)
    return false;
  if (lhs.prf_input < rhs.prf_input)
    return true;
  if (rhs.prf_input < lhs.prf_input)
    return false;
  if (lhs.large_blob_support < rhs.large_blob_support)
    return true;
  if (rhs.large_blob_support < lhs.large_blob_support)
    return false;
  if (lhs.public_key_algorithms < rhs.public_key_algorithms)
    return true;
  if (rhs.public_key_algorithms < lhs.public_key_algorithms)
    return false;
  if (lhs.resident_key_required < rhs.resident_key_required)
    return true;
  if (rhs.resident_key_required < lhs.resident_key_required)
    return false;
  if (lhs.exclude_list < rhs.exclude_list)
    return true;
  if (rhs.exclude_list < lhs.exclude_list)
    return false;
  return false;
}
template <typename StructPtrType>
CtapGetAssertionRequestPtr CtapGetAssertionRequest::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(rp_id),
      mojo::Clone(client_data_hash),
      mojo::Clone(allowed_ids),
      mojo::Clone(user_verification),
      mojo::Clone(prf_inputs),
      mojo::Clone(large_blob_read),
      mojo::Clone(large_blob_write)
  );
}

template <typename T, CtapGetAssertionRequest::EnableIfSame<T>*>
bool CtapGetAssertionRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->rp_id, other_struct.rp_id))
    return false;
  if (!mojo::Equals(this->client_data_hash, other_struct.client_data_hash))
    return false;
  if (!mojo::Equals(this->allowed_ids, other_struct.allowed_ids))
    return false;
  if (!mojo::Equals(this->user_verification, other_struct.user_verification))
    return false;
  if (!mojo::Equals(this->prf_inputs, other_struct.prf_inputs))
    return false;
  if (!mojo::Equals(this->large_blob_read, other_struct.large_blob_read))
    return false;
  if (!mojo::Equals(this->large_blob_write, other_struct.large_blob_write))
    return false;
  return true;
}

template <typename T, CtapGetAssertionRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.rp_id < rhs.rp_id)
    return true;
  if (rhs.rp_id < lhs.rp_id)
    return false;
  if (lhs.client_data_hash < rhs.client_data_hash)
    return true;
  if (rhs.client_data_hash < lhs.client_data_hash)
    return false;
  if (lhs.allowed_ids < rhs.allowed_ids)
    return true;
  if (rhs.allowed_ids < lhs.allowed_ids)
    return false;
  if (lhs.user_verification < rhs.user_verification)
    return true;
  if (rhs.user_verification < lhs.user_verification)
    return false;
  if (lhs.prf_inputs < rhs.prf_inputs)
    return true;
  if (rhs.prf_inputs < lhs.prf_inputs)
    return false;
  if (lhs.large_blob_read < rhs.large_blob_read)
    return true;
  if (rhs.large_blob_read < lhs.large_blob_read)
    return false;
  if (lhs.large_blob_write < rhs.large_blob_write)
    return true;
  if (rhs.large_blob_write < lhs.large_blob_write)
    return false;
  return false;
}
template <typename StructPtrType>
ICloudCredentialPrfDataPtr ICloudCredentialPrfData::Clone() const {
  return New(
      mojo::Clone(prf_enabled),
      mojo::Clone(prf_results)
  );
}

template <typename T, ICloudCredentialPrfData::EnableIfSame<T>*>
bool ICloudCredentialPrfData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->prf_enabled, other_struct.prf_enabled))
    return false;
  if (!mojo::Equals(this->prf_results, other_struct.prf_results))
    return false;
  return true;
}

template <typename T, ICloudCredentialPrfData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.prf_enabled < rhs.prf_enabled)
    return true;
  if (rhs.prf_enabled < lhs.prf_enabled)
    return false;
  if (lhs.prf_results < rhs.prf_results)
    return true;
  if (rhs.prf_results < lhs.prf_results)
    return false;
  return false;
}
template <typename StructPtrType>
ICloudCredentialPtr ICloudCredential::Clone() const {
  return New(
      mojo::Clone(raw_attestation_object),
      mojo::Clone(credential_id),
      mojo::Clone(prf_data),
      mojo::Clone(is_bespoke_large_blob)
  );
}

template <typename T, ICloudCredential::EnableIfSame<T>*>
bool ICloudCredential::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->raw_attestation_object, other_struct.raw_attestation_object))
    return false;
  if (!mojo::Equals(this->credential_id, other_struct.credential_id))
    return false;
  if (!mojo::Equals(this->prf_data, other_struct.prf_data))
    return false;
  if (!mojo::Equals(this->is_bespoke_large_blob, other_struct.is_bespoke_large_blob))
    return false;
  return true;
}

template <typename T, ICloudCredential::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.raw_attestation_object < rhs.raw_attestation_object)
    return true;
  if (rhs.raw_attestation_object < lhs.raw_attestation_object)
    return false;
  if (lhs.credential_id < rhs.credential_id)
    return true;
  if (rhs.credential_id < lhs.credential_id)
    return false;
  if (lhs.prf_data < rhs.prf_data)
    return true;
  if (rhs.prf_data < lhs.prf_data)
    return false;
  if (lhs.is_bespoke_large_blob < rhs.is_bespoke_large_blob)
    return true;
  if (rhs.is_bespoke_large_blob < lhs.is_bespoke_large_blob)
    return false;
  return false;
}
template <typename StructPtrType>
MakeCredentialResultPtr MakeCredentialResult::Clone() const {
  return New(
      mojo::Clone(credential),
      mojo::Clone(failure_reason)
  );
}

template <typename T, MakeCredentialResult::EnableIfSame<T>*>
bool MakeCredentialResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->credential, other_struct.credential))
    return false;
  if (!mojo::Equals(this->failure_reason, other_struct.failure_reason))
    return false;
  return true;
}

template <typename T, MakeCredentialResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.credential < rhs.credential)
    return true;
  if (rhs.credential < lhs.credential)
    return false;
  if (lhs.failure_reason < rhs.failure_reason)
    return true;
  if (rhs.failure_reason < lhs.failure_reason)
    return false;
  return false;
}
template <typename StructPtrType>
AuthenticatorDataPtr AuthenticatorData::Clone() const {
  return New(
      mojo::Clone(raw_authenticator_data),
      mojo::Clone(signature),
      mojo::Clone(user_id),
      mojo::Clone(credential_id),
      mojo::Clone(hmac_secret),
      mojo::Clone(large_blob),
      mojo::Clone(large_blob_written)
  );
}

template <typename T, AuthenticatorData::EnableIfSame<T>*>
bool AuthenticatorData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->raw_authenticator_data, other_struct.raw_authenticator_data))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->user_id, other_struct.user_id))
    return false;
  if (!mojo::Equals(this->credential_id, other_struct.credential_id))
    return false;
  if (!mojo::Equals(this->hmac_secret, other_struct.hmac_secret))
    return false;
  if (!mojo::Equals(this->large_blob, other_struct.large_blob))
    return false;
  if (!mojo::Equals(this->large_blob_written, other_struct.large_blob_written))
    return false;
  return true;
}

template <typename T, AuthenticatorData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.raw_authenticator_data < rhs.raw_authenticator_data)
    return true;
  if (rhs.raw_authenticator_data < lhs.raw_authenticator_data)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.user_id < rhs.user_id)
    return true;
  if (rhs.user_id < lhs.user_id)
    return false;
  if (lhs.credential_id < rhs.credential_id)
    return true;
  if (rhs.credential_id < lhs.credential_id)
    return false;
  if (lhs.hmac_secret < rhs.hmac_secret)
    return true;
  if (rhs.hmac_secret < lhs.hmac_secret)
    return false;
  if (lhs.large_blob < rhs.large_blob)
    return true;
  if (rhs.large_blob < lhs.large_blob)
    return false;
  if (lhs.large_blob_written < rhs.large_blob_written)
    return true;
  if (rhs.large_blob_written < lhs.large_blob_written)
    return false;
  return false;
}
template <typename StructPtrType>
GetAssertionResultPtr GetAssertionResult::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(failure_reason)
  );
}

template <typename T, GetAssertionResult::EnableIfSame<T>*>
bool GetAssertionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->failure_reason, other_struct.failure_reason))
    return false;
  return true;
}

template <typename T, GetAssertionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.failure_reason < rhs.failure_reason)
    return true;
  if (rhs.failure_reason < lhs.failure_reason)
    return false;
  return false;
}
template <typename StructPtrType>
ExistingCredentialPtr ExistingCredential::Clone() const {
  return New(
      mojo::Clone(credential_id),
      mojo::Clone(provider_name),
      mojo::Clone(user_handle),
      mojo::Clone(name)
  );
}

template <typename T, ExistingCredential::EnableIfSame<T>*>
bool ExistingCredential::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->credential_id, other_struct.credential_id))
    return false;
  if (!mojo::Equals(this->provider_name, other_struct.provider_name))
    return false;
  if (!mojo::Equals(this->user_handle, other_struct.user_handle))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, ExistingCredential::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.credential_id < rhs.credential_id)
    return true;
  if (rhs.credential_id < lhs.credential_id)
    return false;
  if (lhs.provider_name < rhs.provider_name)
    return true;
  if (rhs.provider_name < lhs.provider_name)
    return false;
  if (lhs.user_handle < rhs.user_handle)
    return true;
  if (rhs.user_handle < lhs.user_handle)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
GetCredentialsResultPtr GetCredentialsResult::Clone() const {
  return New(
      mojo::Clone(credentials),
      mojo::Clone(failure_reason)
  );
}

template <typename T, GetCredentialsResult::EnableIfSame<T>*>
bool GetCredentialsResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  if (!mojo::Equals(this->failure_reason, other_struct.failure_reason))
    return false;
  return true;
}

template <typename T, GetCredentialsResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  if (lhs.failure_reason < rhs.failure_reason)
    return true;
  if (rhs.failure_reason < lhs.failure_reason)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::ICloudKeychainPasskeyResult::DataView,
                                         ::owl::mojom::ICloudKeychainPasskeyResultPtr> {
  static bool IsNull(const ::owl::mojom::ICloudKeychainPasskeyResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ICloudKeychainPasskeyResultPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ICloudKeychainPasskeyResult::raw_attestation_object)& raw_attestation_object(
      const ::owl::mojom::ICloudKeychainPasskeyResultPtr& input) {
    return input->raw_attestation_object;
  }

  static bool Read(::owl::mojom::ICloudKeychainPasskeyResult::DataView input, ::owl::mojom::ICloudKeychainPasskeyResultPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PRFInput::DataView,
                                         ::owl::mojom::PRFInputPtr> {
  static bool IsNull(const ::owl::mojom::PRFInputPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PRFInputPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PRFInput::id)& id(
      const ::owl::mojom::PRFInputPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::PRFInput::input1)& input1(
      const ::owl::mojom::PRFInputPtr& input) {
    return input->input1;
  }

  static const decltype(::owl::mojom::PRFInput::input2)& input2(
      const ::owl::mojom::PRFInputPtr& input) {
    return input->input2;
  }

  static bool Read(::owl::mojom::PRFInput::DataView input, ::owl::mojom::PRFInputPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::PublicKeyCredentialDescriptor::DataView,
                                         ::owl::mojom::PublicKeyCredentialDescriptorPtr> {
  static bool IsNull(const ::owl::mojom::PublicKeyCredentialDescriptorPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::PublicKeyCredentialDescriptorPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::PublicKeyCredentialDescriptor::id)& id(
      const ::owl::mojom::PublicKeyCredentialDescriptorPtr& input) {
    return input->id;
  }

  static const decltype(::owl::mojom::PublicKeyCredentialDescriptor::transports)& transports(
      const ::owl::mojom::PublicKeyCredentialDescriptorPtr& input) {
    return input->transports;
  }

  static bool Read(::owl::mojom::PublicKeyCredentialDescriptor::DataView input, ::owl::mojom::PublicKeyCredentialDescriptorPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::RequestID::DataView,
                                         ::owl::mojom::RequestIDPtr> {
  static bool IsNull(const ::owl::mojom::RequestIDPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::RequestIDPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::RequestID::group_id)& group_id(
      const ::owl::mojom::RequestIDPtr& input) {
    return input->group_id;
  }

  static bool Read(::owl::mojom::RequestID::DataView input, ::owl::mojom::RequestIDPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CtapMakeCredentialRequest::DataView,
                                         ::owl::mojom::CtapMakeCredentialRequestPtr> {
  static bool IsNull(const ::owl::mojom::CtapMakeCredentialRequestPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CtapMakeCredentialRequestPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::request_id)& request_id(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->request_id;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::rp_id)& rp_id(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->rp_id;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::client_data_hash)& client_data_hash(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->client_data_hash;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::user_id)& user_id(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->user_id;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::user_name)& user_name(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->user_name;
  }

  static decltype(::owl::mojom::CtapMakeCredentialRequest::user_verification) user_verification(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->user_verification;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::user_display_name)& user_display_name(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->user_display_name;
  }

  static decltype(::owl::mojom::CtapMakeCredentialRequest::has_prf) has_prf(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->has_prf;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::prf_input)& prf_input(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->prf_input;
  }

  static decltype(::owl::mojom::CtapMakeCredentialRequest::large_blob_support) large_blob_support(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->large_blob_support;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::public_key_algorithms)& public_key_algorithms(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->public_key_algorithms;
  }

  static decltype(::owl::mojom::CtapMakeCredentialRequest::resident_key_required) resident_key_required(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->resident_key_required;
  }

  static const decltype(::owl::mojom::CtapMakeCredentialRequest::exclude_list)& exclude_list(
      const ::owl::mojom::CtapMakeCredentialRequestPtr& input) {
    return input->exclude_list;
  }

  static bool Read(::owl::mojom::CtapMakeCredentialRequest::DataView input, ::owl::mojom::CtapMakeCredentialRequestPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CtapGetAssertionRequest::DataView,
                                         ::owl::mojom::CtapGetAssertionRequestPtr> {
  static bool IsNull(const ::owl::mojom::CtapGetAssertionRequestPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CtapGetAssertionRequestPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::request_id)& request_id(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->request_id;
  }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::rp_id)& rp_id(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->rp_id;
  }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::client_data_hash)& client_data_hash(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->client_data_hash;
  }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::allowed_ids)& allowed_ids(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->allowed_ids;
  }

  static decltype(::owl::mojom::CtapGetAssertionRequest::user_verification) user_verification(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->user_verification;
  }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::prf_inputs)& prf_inputs(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->prf_inputs;
  }

  static decltype(::owl::mojom::CtapGetAssertionRequest::large_blob_read) large_blob_read(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->large_blob_read;
  }

  static const decltype(::owl::mojom::CtapGetAssertionRequest::large_blob_write)& large_blob_write(
      const ::owl::mojom::CtapGetAssertionRequestPtr& input) {
    return input->large_blob_write;
  }

  static bool Read(::owl::mojom::CtapGetAssertionRequest::DataView input, ::owl::mojom::CtapGetAssertionRequestPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ICloudCredentialPrfData::DataView,
                                         ::owl::mojom::ICloudCredentialPrfDataPtr> {
  static bool IsNull(const ::owl::mojom::ICloudCredentialPrfDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ICloudCredentialPrfDataPtr* output) { output->reset(); }

  static decltype(::owl::mojom::ICloudCredentialPrfData::prf_enabled) prf_enabled(
      const ::owl::mojom::ICloudCredentialPrfDataPtr& input) {
    return input->prf_enabled;
  }

  static const decltype(::owl::mojom::ICloudCredentialPrfData::prf_results)& prf_results(
      const ::owl::mojom::ICloudCredentialPrfDataPtr& input) {
    return input->prf_results;
  }

  static bool Read(::owl::mojom::ICloudCredentialPrfData::DataView input, ::owl::mojom::ICloudCredentialPrfDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ICloudCredential::DataView,
                                         ::owl::mojom::ICloudCredentialPtr> {
  static bool IsNull(const ::owl::mojom::ICloudCredentialPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ICloudCredentialPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ICloudCredential::raw_attestation_object)& raw_attestation_object(
      const ::owl::mojom::ICloudCredentialPtr& input) {
    return input->raw_attestation_object;
  }

  static const decltype(::owl::mojom::ICloudCredential::credential_id)& credential_id(
      const ::owl::mojom::ICloudCredentialPtr& input) {
    return input->credential_id;
  }

  static const decltype(::owl::mojom::ICloudCredential::prf_data)& prf_data(
      const ::owl::mojom::ICloudCredentialPtr& input) {
    return input->prf_data;
  }

  static decltype(::owl::mojom::ICloudCredential::is_bespoke_large_blob) is_bespoke_large_blob(
      const ::owl::mojom::ICloudCredentialPtr& input) {
    return input->is_bespoke_large_blob;
  }

  static bool Read(::owl::mojom::ICloudCredential::DataView input, ::owl::mojom::ICloudCredentialPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::MakeCredentialResult::DataView,
                                         ::owl::mojom::MakeCredentialResultPtr> {
  static bool IsNull(const ::owl::mojom::MakeCredentialResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::MakeCredentialResultPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::MakeCredentialResult::credential)& credential(
      const ::owl::mojom::MakeCredentialResultPtr& input) {
    return input->credential;
  }

  static decltype(::owl::mojom::MakeCredentialResult::failure_reason) failure_reason(
      const ::owl::mojom::MakeCredentialResultPtr& input) {
    return input->failure_reason;
  }

  static bool Read(::owl::mojom::MakeCredentialResult::DataView input, ::owl::mojom::MakeCredentialResultPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::AuthenticatorData::DataView,
                                         ::owl::mojom::AuthenticatorDataPtr> {
  static bool IsNull(const ::owl::mojom::AuthenticatorDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AuthenticatorDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::AuthenticatorData::raw_authenticator_data)& raw_authenticator_data(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->raw_authenticator_data;
  }

  static const decltype(::owl::mojom::AuthenticatorData::signature)& signature(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->signature;
  }

  static const decltype(::owl::mojom::AuthenticatorData::user_id)& user_id(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->user_id;
  }

  static const decltype(::owl::mojom::AuthenticatorData::credential_id)& credential_id(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->credential_id;
  }

  static const decltype(::owl::mojom::AuthenticatorData::hmac_secret)& hmac_secret(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->hmac_secret;
  }

  static const decltype(::owl::mojom::AuthenticatorData::large_blob)& large_blob(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->large_blob;
  }

  static decltype(::owl::mojom::AuthenticatorData::large_blob_written) large_blob_written(
      const ::owl::mojom::AuthenticatorDataPtr& input) {
    return input->large_blob_written;
  }

  static bool Read(::owl::mojom::AuthenticatorData::DataView input, ::owl::mojom::AuthenticatorDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::GetAssertionResult::DataView,
                                         ::owl::mojom::GetAssertionResultPtr> {
  static bool IsNull(const ::owl::mojom::GetAssertionResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::GetAssertionResultPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::GetAssertionResult::data)& data(
      const ::owl::mojom::GetAssertionResultPtr& input) {
    return input->data;
  }

  static decltype(::owl::mojom::GetAssertionResult::failure_reason) failure_reason(
      const ::owl::mojom::GetAssertionResultPtr& input) {
    return input->failure_reason;
  }

  static bool Read(::owl::mojom::GetAssertionResult::DataView input, ::owl::mojom::GetAssertionResultPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::ExistingCredential::DataView,
                                         ::owl::mojom::ExistingCredentialPtr> {
  static bool IsNull(const ::owl::mojom::ExistingCredentialPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ExistingCredentialPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ExistingCredential::credential_id)& credential_id(
      const ::owl::mojom::ExistingCredentialPtr& input) {
    return input->credential_id;
  }

  static const decltype(::owl::mojom::ExistingCredential::provider_name)& provider_name(
      const ::owl::mojom::ExistingCredentialPtr& input) {
    return input->provider_name;
  }

  static const decltype(::owl::mojom::ExistingCredential::user_handle)& user_handle(
      const ::owl::mojom::ExistingCredentialPtr& input) {
    return input->user_handle;
  }

  static const decltype(::owl::mojom::ExistingCredential::name)& name(
      const ::owl::mojom::ExistingCredentialPtr& input) {
    return input->name;
  }

  static bool Read(::owl::mojom::ExistingCredential::DataView input, ::owl::mojom::ExistingCredentialPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::GetCredentialsResult::DataView,
                                         ::owl::mojom::GetCredentialsResultPtr> {
  static bool IsNull(const ::owl::mojom::GetCredentialsResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::GetCredentialsResultPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::GetCredentialsResult::credentials)& credentials(
      const ::owl::mojom::GetCredentialsResultPtr& input) {
    return input->credentials;
  }

  static decltype(::owl::mojom::GetCredentialsResult::failure_reason) failure_reason(
      const ::owl::mojom::GetCredentialsResultPtr& input) {
    return input->failure_reason;
  }

  static bool Read(::owl::mojom::GetCredentialsResult::DataView input, ::owl::mojom::GetCredentialsResultPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_H_