// owl/mojom/icloud_passkeys.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_SHARED_H_
#define OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/icloud_passkeys.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/icloud_passkeys.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::UserVerificationRequirement>
    : public mojo::internal::EnumHashImpl<::owl::mojom::UserVerificationRequirement> {};

template <>
struct hash<::owl::mojom::LargeBlobSupport>
    : public mojo::internal::EnumHashImpl<::owl::mojom::LargeBlobSupport> {};

template <>
struct hash<::owl::mojom::MakeCredentialFailureReason>
    : public mojo::internal::EnumHashImpl<::owl::mojom::MakeCredentialFailureReason> {};

template <>
struct hash<::owl::mojom::GetAssertionFailureReason>
    : public mojo::internal::EnumHashImpl<::owl::mojom::GetAssertionFailureReason> {};

template <>
struct hash<::owl::mojom::GetCredentialsFailureReason>
    : public mojo::internal::EnumHashImpl<::owl::mojom::GetCredentialsFailureReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::UserVerificationRequirement, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::UserVerificationRequirement, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::UserVerificationRequirement>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::LargeBlobSupport, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::LargeBlobSupport, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::LargeBlobSupport>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::MakeCredentialFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::MakeCredentialFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::MakeCredentialFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::GetAssertionFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::GetAssertionFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::GetAssertionFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::GetCredentialsFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::GetCredentialsFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::GetCredentialsFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ICloudKeychainPasskeyResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ICloudKeychainPasskeyResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ICloudKeychainPasskeyResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::raw_attestation_object(input)) in_raw_attestation_object = Traits::raw_attestation_object(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_attestation_object)::BaseType> raw_attestation_object_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_attestation_object,
      raw_attestation_object_fragment);

    fragment->raw_attestation_object.Set(
        raw_attestation_object_fragment.is_null() ? nullptr : raw_attestation_object_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_attestation_object.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_attestation_object in ICloudKeychainPasskeyResult struct");
  }

  static bool Deserialize(::owl::mojom::internal::ICloudKeychainPasskeyResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ICloudKeychainPasskeyResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PRFInputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PRFInputDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PRFInput_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    decltype(Traits::input1(input)) in_input1 = Traits::input1(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input1)::BaseType>
        input1_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input1_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_input1,
      input1_fragment,
      &input1_validate_params);

    fragment->input1.Set(
        input1_fragment.is_null() ? nullptr : input1_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input1.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input1 in PRFInput struct");

    decltype(Traits::input2(input)) in_input2 = Traits::input2(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input2)::BaseType>
        input2_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input2_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_input2,
      input2_fragment,
      &input2_validate_params);

    fragment->input2.Set(
        input2_fragment.is_null() ? nullptr : input2_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::PRFInput_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PRFInputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PublicKeyCredentialDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PublicKeyCredentialDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PublicKeyCredentialDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PublicKeyCredentialDescriptor struct");

    decltype(Traits::transports(input)) in_transports = Traits::transports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transports)::BaseType>
        transports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_transports,
      transports_fragment,
      &transports_validate_params);

    fragment->transports.Set(
        transports_fragment.is_null() ? nullptr : transports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transports in PublicKeyCredentialDescriptor struct");
  }

  static bool Deserialize(::owl::mojom::internal::PublicKeyCredentialDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PublicKeyCredentialDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::RequestIDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::RequestIDDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::RequestID_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in RequestID struct");
  }

  static bool Deserialize(::owl::mojom::internal::RequestID_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::RequestIDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CtapMakeCredentialRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CtapMakeCredentialRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CtapMakeCredentialRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_id)::BaseType> request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::RequestIDDataView>(
      in_request_id,
      request_id_fragment);

    fragment->request_id.Set(
        request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in CtapMakeCredentialRequest struct");

    decltype(Traits::rp_id(input)) in_rp_id = Traits::rp_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rp_id)::BaseType> rp_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id,
      rp_id_fragment);

    fragment->rp_id.Set(
        rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rp_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in CtapMakeCredentialRequest struct");

    decltype(Traits::client_data_hash(input)) in_client_data_hash = Traits::client_data_hash(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_data_hash)::BaseType>
        client_data_hash_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_data_hash_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_data_hash,
      client_data_hash_fragment,
      &client_data_hash_validate_params);

    fragment->client_data_hash.Set(
        client_data_hash_fragment.is_null() ? nullptr : client_data_hash_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_data_hash.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_data_hash in CtapMakeCredentialRequest struct");

    decltype(Traits::user_id(input)) in_user_id = Traits::user_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_id)::BaseType>
        user_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_id,
      user_id_fragment,
      &user_id_validate_params);

    fragment->user_id.Set(
        user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_id in CtapMakeCredentialRequest struct");

    decltype(Traits::user_name(input)) in_user_name = Traits::user_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_name)::BaseType> user_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_user_name,
      user_name_fragment);

    fragment->user_name.Set(
        user_name_fragment.is_null() ? nullptr : user_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_name in CtapMakeCredentialRequest struct");

    
    mojo::internal::Serialize<::owl::mojom::UserVerificationRequirement>(
      Traits::user_verification(input),
      &fragment->user_verification);

    decltype(Traits::user_display_name(input)) in_user_display_name = Traits::user_display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_display_name)::BaseType> user_display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_user_display_name,
      user_display_name_fragment);

    fragment->user_display_name.Set(
        user_display_name_fragment.is_null() ? nullptr : user_display_name_fragment.data());

    fragment->has_prf = Traits::has_prf(input);

    decltype(Traits::prf_input(input)) in_prf_input = Traits::prf_input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_input)::BaseType> prf_input_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::PRFInputDataView>(
      in_prf_input,
      prf_input_fragment);

    fragment->prf_input.Set(
        prf_input_fragment.is_null() ? nullptr : prf_input_fragment.data());

    
    mojo::internal::Serialize<::owl::mojom::LargeBlobSupport>(
      Traits::large_blob_support(input),
      &fragment->large_blob_support);

    decltype(Traits::public_key_algorithms(input)) in_public_key_algorithms = Traits::public_key_algorithms(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key_algorithms)::BaseType>
        public_key_algorithms_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& public_key_algorithms_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_public_key_algorithms,
      public_key_algorithms_fragment,
      &public_key_algorithms_validate_params);

    fragment->public_key_algorithms.Set(
        public_key_algorithms_fragment.is_null() ? nullptr : public_key_algorithms_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_key_algorithms.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_key_algorithms in CtapMakeCredentialRequest struct");

    fragment->resident_key_required = Traits::resident_key_required(input);

    decltype(Traits::exclude_list(input)) in_exclude_list = Traits::exclude_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclude_list)::BaseType>
        exclude_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclude_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::PublicKeyCredentialDescriptorDataView>>(
      in_exclude_list,
      exclude_list_fragment,
      &exclude_list_validate_params);

    fragment->exclude_list.Set(
        exclude_list_fragment.is_null() ? nullptr : exclude_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->exclude_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclude_list in CtapMakeCredentialRequest struct");
  }

  static bool Deserialize(::owl::mojom::internal::CtapMakeCredentialRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CtapMakeCredentialRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::CtapGetAssertionRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::CtapGetAssertionRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::CtapGetAssertionRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_id)::BaseType> request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::RequestIDDataView>(
      in_request_id,
      request_id_fragment);

    fragment->request_id.Set(
        request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in CtapGetAssertionRequest struct");

    decltype(Traits::rp_id(input)) in_rp_id = Traits::rp_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rp_id)::BaseType> rp_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id,
      rp_id_fragment);

    fragment->rp_id.Set(
        rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rp_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in CtapGetAssertionRequest struct");

    decltype(Traits::client_data_hash(input)) in_client_data_hash = Traits::client_data_hash(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_data_hash)::BaseType>
        client_data_hash_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_data_hash_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_data_hash,
      client_data_hash_fragment,
      &client_data_hash_validate_params);

    fragment->client_data_hash.Set(
        client_data_hash_fragment.is_null() ? nullptr : client_data_hash_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_data_hash.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_data_hash in CtapGetAssertionRequest struct");

    decltype(Traits::allowed_ids(input)) in_allowed_ids = Traits::allowed_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_ids)::BaseType>
        allowed_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_allowed_ids,
      allowed_ids_fragment,
      &allowed_ids_validate_params);

    fragment->allowed_ids.Set(
        allowed_ids_fragment.is_null() ? nullptr : allowed_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowed_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_ids in CtapGetAssertionRequest struct");

    
    mojo::internal::Serialize<::owl::mojom::UserVerificationRequirement>(
      Traits::user_verification(input),
      &fragment->user_verification);

    decltype(Traits::prf_inputs(input)) in_prf_inputs = Traits::prf_inputs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_inputs)::BaseType>
        prf_inputs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prf_inputs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::PRFInputDataView>>(
      in_prf_inputs,
      prf_inputs_fragment,
      &prf_inputs_validate_params);

    fragment->prf_inputs.Set(
        prf_inputs_fragment.is_null() ? nullptr : prf_inputs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prf_inputs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prf_inputs in CtapGetAssertionRequest struct");

    fragment->large_blob_read = Traits::large_blob_read(input);

    decltype(Traits::large_blob_write(input)) in_large_blob_write = Traits::large_blob_write(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->large_blob_write)::BaseType>
        large_blob_write_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& large_blob_write_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_large_blob_write,
      large_blob_write_fragment,
      &large_blob_write_validate_params);

    fragment->large_blob_write.Set(
        large_blob_write_fragment.is_null() ? nullptr : large_blob_write_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::CtapGetAssertionRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::CtapGetAssertionRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ICloudCredentialPrfDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ICloudCredentialPrfDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ICloudCredentialPrfData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->prf_enabled = Traits::prf_enabled(input);

    decltype(Traits::prf_results(input)) in_prf_results = Traits::prf_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_results)::BaseType>
        prf_results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prf_results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_prf_results,
      prf_results_fragment,
      &prf_results_validate_params);

    fragment->prf_results.Set(
        prf_results_fragment.is_null() ? nullptr : prf_results_fragment.data());
  }

  static bool Deserialize(::owl::mojom::internal::ICloudCredentialPrfData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ICloudCredentialPrfDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ICloudCredentialDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ICloudCredentialDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ICloudCredential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::raw_attestation_object(input)) in_raw_attestation_object = Traits::raw_attestation_object(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_attestation_object)::BaseType>
        raw_attestation_object_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_attestation_object_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_raw_attestation_object,
      raw_attestation_object_fragment,
      &raw_attestation_object_validate_params);

    fragment->raw_attestation_object.Set(
        raw_attestation_object_fragment.is_null() ? nullptr : raw_attestation_object_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_attestation_object.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_attestation_object in ICloudCredential struct");

    decltype(Traits::credential_id(input)) in_credential_id = Traits::credential_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential_id)::BaseType>
        credential_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id,
      credential_id_fragment,
      &credential_id_validate_params);

    fragment->credential_id.Set(
        credential_id_fragment.is_null() ? nullptr : credential_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credential_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in ICloudCredential struct");

    decltype(Traits::prf_data(input)) in_prf_data = Traits::prf_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_data)::BaseType> prf_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::ICloudCredentialPrfDataDataView>(
      in_prf_data,
      prf_data_fragment);

    fragment->prf_data.Set(
        prf_data_fragment.is_null() ? nullptr : prf_data_fragment.data());

    fragment->is_bespoke_large_blob = Traits::is_bespoke_large_blob(input);
  }

  static bool Deserialize(::owl::mojom::internal::ICloudCredential_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ICloudCredentialDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::MakeCredentialResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::MakeCredentialResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::MakeCredentialResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::credential(input)) in_credential = Traits::credential(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential)::BaseType> credential_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::ICloudCredentialDataView>(
      in_credential,
      credential_fragment);

    fragment->credential.Set(
        credential_fragment.is_null() ? nullptr : credential_fragment.data());
    fragment->failure_reason_$flag = Traits::failure_reason(input).has_value();
    if (Traits::failure_reason(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::MakeCredentialFailureReason>(
        Traits::failure_reason(input).value(),
        &fragment->failure_reason_$value);
    } else {
      fragment->failure_reason_$value =
          static_cast<int32_t>(::owl::mojom::MakeCredentialFailureReason::kMinValue);
    }
  }

  static bool Deserialize(::owl::mojom::internal::MakeCredentialResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::MakeCredentialResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AuthenticatorDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::AuthenticatorDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::AuthenticatorData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::raw_authenticator_data(input)) in_raw_authenticator_data = Traits::raw_authenticator_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_authenticator_data)::BaseType>
        raw_authenticator_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_authenticator_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_raw_authenticator_data,
      raw_authenticator_data_fragment,
      &raw_authenticator_data_validate_params);

    fragment->raw_authenticator_data.Set(
        raw_authenticator_data_fragment.is_null() ? nullptr : raw_authenticator_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_authenticator_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_authenticator_data in AuthenticatorData struct");

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType>
        signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature,
      signature_fragment,
      &signature_validate_params);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in AuthenticatorData struct");

    decltype(Traits::user_id(input)) in_user_id = Traits::user_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_id)::BaseType>
        user_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_id,
      user_id_fragment,
      &user_id_validate_params);

    fragment->user_id.Set(
        user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_id in AuthenticatorData struct");

    decltype(Traits::credential_id(input)) in_credential_id = Traits::credential_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential_id)::BaseType>
        credential_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id,
      credential_id_fragment,
      &credential_id_validate_params);

    fragment->credential_id.Set(
        credential_id_fragment.is_null() ? nullptr : credential_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credential_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in AuthenticatorData struct");

    decltype(Traits::hmac_secret(input)) in_hmac_secret = Traits::hmac_secret(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hmac_secret)::BaseType>
        hmac_secret_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hmac_secret_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_hmac_secret,
      hmac_secret_fragment,
      &hmac_secret_validate_params);

    fragment->hmac_secret.Set(
        hmac_secret_fragment.is_null() ? nullptr : hmac_secret_fragment.data());

    decltype(Traits::large_blob(input)) in_large_blob = Traits::large_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->large_blob)::BaseType>
        large_blob_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& large_blob_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_large_blob,
      large_blob_fragment,
      &large_blob_validate_params);

    fragment->large_blob.Set(
        large_blob_fragment.is_null() ? nullptr : large_blob_fragment.data());

    fragment->large_blob_written = Traits::large_blob_written(input);
  }

  static bool Deserialize(::owl::mojom::internal::AuthenticatorData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::AuthenticatorDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::GetAssertionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::GetAssertionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::GetAssertionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::owl::mojom::AuthenticatorDataDataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    fragment->failure_reason_$flag = Traits::failure_reason(input).has_value();
    if (Traits::failure_reason(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::GetAssertionFailureReason>(
        Traits::failure_reason(input).value(),
        &fragment->failure_reason_$value);
    } else {
      fragment->failure_reason_$value =
          static_cast<int32_t>(::owl::mojom::GetAssertionFailureReason::kMinValue);
    }
  }

  static bool Deserialize(::owl::mojom::internal::GetAssertionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::GetAssertionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::ExistingCredentialDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::ExistingCredentialDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::ExistingCredential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::credential_id(input)) in_credential_id = Traits::credential_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential_id)::BaseType>
        credential_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credential_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_credential_id,
      credential_id_fragment,
      &credential_id_validate_params);

    fragment->credential_id.Set(
        credential_id_fragment.is_null() ? nullptr : credential_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credential_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_id in ExistingCredential struct");

    decltype(Traits::provider_name(input)) in_provider_name = Traits::provider_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->provider_name)::BaseType> provider_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_name,
      provider_name_fragment);

    fragment->provider_name.Set(
        provider_name_fragment.is_null() ? nullptr : provider_name_fragment.data());

    decltype(Traits::user_handle(input)) in_user_handle = Traits::user_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_handle)::BaseType>
        user_handle_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_handle_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_handle,
      user_handle_fragment,
      &user_handle_validate_params);

    fragment->user_handle.Set(
        user_handle_fragment.is_null() ? nullptr : user_handle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_handle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_handle in ExistingCredential struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ExistingCredential struct");
  }

  static bool Deserialize(::owl::mojom::internal::ExistingCredential_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::ExistingCredentialDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::GetCredentialsResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::GetCredentialsResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::GetCredentialsResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credentials)::BaseType>
        credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ExistingCredentialDataView>>(
      in_credentials,
      credentials_fragment,
      &credentials_validate_params);

    fragment->credentials.Set(
        credentials_fragment.is_null() ? nullptr : credentials_fragment.data());
    fragment->failure_reason_$flag = Traits::failure_reason(input).has_value();
    if (Traits::failure_reason(input).has_value()) {
      
      mojo::internal::Serialize<::owl::mojom::GetCredentialsFailureReason>(
        Traits::failure_reason(input).value(),
        &fragment->failure_reason_$value);
    } else {
      fragment->failure_reason_$value =
          static_cast<int32_t>(::owl::mojom::GetCredentialsFailureReason::kMinValue);
    }
  }

  static bool Deserialize(::owl::mojom::internal::GetCredentialsResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::GetCredentialsResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void ICloudKeychainPasskeyResultDataView::GetRawAttestationObjectDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->raw_attestation_object.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PRFInputDataView::GetIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PRFInputDataView::GetInput1DataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->input1.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PRFInputDataView::GetInput2DataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->input2.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PublicKeyCredentialDescriptorDataView::GetIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialDescriptorDataView::GetTransportsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->transports.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void RequestIDDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CtapMakeCredentialRequestDataView::GetRequestIdDataView(
    RequestIDDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = RequestIDDataView(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetClientDataHashDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->client_data_hash.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetUserIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetUserNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetUserDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetPrfInputDataView(
    PRFInputDataView* output) {
  auto pointer = data_->prf_input.Get();
  *output = PRFInputDataView(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetPublicKeyAlgorithmsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->public_key_algorithms.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void CtapMakeCredentialRequestDataView::GetExcludeListDataView(
    mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output) {
  auto pointer = data_->exclude_list.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>(pointer, message_);
}


inline void CtapGetAssertionRequestDataView::GetRequestIdDataView(
    RequestIDDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = RequestIDDataView(pointer, message_);
}
inline void CtapGetAssertionRequestDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CtapGetAssertionRequestDataView::GetClientDataHashDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->client_data_hash.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CtapGetAssertionRequestDataView::GetAllowedIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->allowed_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void CtapGetAssertionRequestDataView::GetPrfInputsDataView(
    mojo::ArrayDataView<PRFInputDataView>* output) {
  auto pointer = data_->prf_inputs.Get();
  *output = mojo::ArrayDataView<PRFInputDataView>(pointer, message_);
}
inline void CtapGetAssertionRequestDataView::GetLargeBlobWriteDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->large_blob_write.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ICloudCredentialPrfDataDataView::GetPrfResultsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->prf_results.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ICloudCredentialDataView::GetRawAttestationObjectDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->raw_attestation_object.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ICloudCredentialDataView::GetCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ICloudCredentialDataView::GetPrfDataDataView(
    ICloudCredentialPrfDataDataView* output) {
  auto pointer = data_->prf_data.Get();
  *output = ICloudCredentialPrfDataDataView(pointer, message_);
}


inline void MakeCredentialResultDataView::GetCredentialDataView(
    ICloudCredentialDataView* output) {
  auto pointer = data_->credential.Get();
  *output = ICloudCredentialDataView(pointer, message_);
}


inline void AuthenticatorDataDataView::GetRawAuthenticatorDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->raw_authenticator_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticatorDataDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticatorDataDataView::GetUserIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticatorDataDataView::GetCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticatorDataDataView::GetHmacSecretDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->hmac_secret.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticatorDataDataView::GetLargeBlobDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->large_blob.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void GetAssertionResultDataView::GetDataDataView(
    AuthenticatorDataDataView* output) {
  auto pointer = data_->data.Get();
  *output = AuthenticatorDataDataView(pointer, message_);
}


inline void ExistingCredentialDataView::GetCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ExistingCredentialDataView::GetProviderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->provider_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExistingCredentialDataView::GetUserHandleDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_handle.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ExistingCredentialDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GetCredentialsResultDataView::GetCredentialsDataView(
    mojo::ArrayDataView<ExistingCredentialDataView>* output) {
  auto pointer = data_->credentials.Get();
  *output = mojo::ArrayDataView<ExistingCredentialDataView>(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::UserVerificationRequirement> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::UserVerificationRequirement value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::LargeBlobSupport> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::LargeBlobSupport value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::MakeCredentialFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::MakeCredentialFailureReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::GetAssertionFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::GetAssertionFailureReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::GetCredentialsFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::GetCredentialsFailureReason value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_SHARED_H_