// owl/mojom/extension_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_EXTENSION_SERVICE_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_EXTENSION_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/extension_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class ExtensionInfoDataView;

class ExtensionMenuItemDataView;

class ExtensionMenuItemIdDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::ExtensionInfoDataView> {
  using Data = ::owl::mojom::internal::ExtensionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ExtensionMenuItemDataView> {
  using Data = ::owl::mojom::internal::ExtensionMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ExtensionMenuItemIdDataView> {
  using Data = ::owl::mojom::internal::ExtensionMenuItemId_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class ExtensionMenuItemType : int32_t {
  
  kNormal = 0,
  
  kCheckbox = 1,
  
  kRadioButton = 2,
  
  kSeparator = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ExtensionMenuItemType value);
inline bool IsKnownEnumValue(ExtensionMenuItemType value) {
  return internal::ExtensionMenuItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ExtensionServiceClientInterfaceBase {};

using ExtensionServiceClientPtrDataView =
    mojo::InterfacePtrDataView<ExtensionServiceClientInterfaceBase>;
using ExtensionServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<ExtensionServiceClientInterfaceBase>;
using ExtensionServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ExtensionServiceClientInterfaceBase>;
using ExtensionServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ExtensionServiceClientInterfaceBase>;
class ExtensionServiceInterfaceBase {};

using ExtensionServicePtrDataView =
    mojo::InterfacePtrDataView<ExtensionServiceInterfaceBase>;
using ExtensionServiceRequestDataView =
    mojo::InterfaceRequestDataView<ExtensionServiceInterfaceBase>;
using ExtensionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ExtensionServiceInterfaceBase>;
using ExtensionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ExtensionServiceInterfaceBase>;


class ExtensionInfoDataView {
 public:
  ExtensionInfoDataView() = default;

  ExtensionInfoDataView(
      internal::ExtensionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconPath(UserType* output) {
    
    auto* pointer = data_->icon_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionMenuItemDataView {
 public:
  ExtensionMenuItemDataView() = default;

  ExtensionMenuItemDataView(
      internal::ExtensionMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ExtensionMenuItemIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = !data_->id.is_null() ? &data_->id : nullptr;
    return mojo::internal::Deserialize<::owl::mojom::ExtensionMenuItemIdDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::owl::mojom::ExtensionMenuItemType>(
        data_value, output);
  }
  ExtensionMenuItemType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::ExtensionMenuItemType>(data_->type));
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<ExtensionMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::ExtensionMenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionMenuItemIdDataView {
 public:
  using Tag = internal::ExtensionMenuItemId_Data::ExtensionMenuItemId_Tag;

  ExtensionMenuItemIdDataView() = default;

  ExtensionMenuItemIdDataView(
      internal::ExtensionMenuItemId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_id() const { return data_->tag == Tag::kId; }
  int64_t id() const {
    CHECK(is_id());
    return data_->data.f_id;
  }
  bool is_string_id() const { return data_->tag == Tag::kStringId; }
  inline void GetStringIdDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStringId(UserType* output) const {
    
    CHECK(is_string_id());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_string_id.Get(), output, message_);
  }

 private:
  internal::ExtensionMenuItemId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_EXTENSION_SERVICE_MOJOM_DATA_VIEW_H_