// owl/mojom/download_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/download_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/download_manager.mojom-params-data.h"
#include "owl/mojom/download_manager.mojom-shared-message-ids.h"

#include "owl/mojom/download_manager.mojom-import-headers.h"
#include "owl/mojom/download_manager.mojom-test-utils.h"


namespace owl::mojom {
DownloadItem::DownloadItem()
    : guid(),
      state(),
      target_file_path(),
      percent_complete(),
      total_bytes(),
      received_bytes(),
      current_speed(),
      time_remaining(),
      end_time() {}

DownloadItem::DownloadItem(
    const std::string& guid_in,
    DownloadState state_in,
    const ::base::FilePath& target_file_path_in,
    int32_t percent_complete_in,
    int64_t total_bytes_in,
    int64_t received_bytes_in,
    int64_t current_speed_in,
    std::optional<::base::TimeDelta> time_remaining_in,
    ::base::Time end_time_in)
    : guid(std::move(guid_in)),
      state(std::move(state_in)),
      target_file_path(std::move(target_file_path_in)),
      percent_complete(std::move(percent_complete_in)),
      total_bytes(std::move(total_bytes_in)),
      received_bytes(std::move(received_bytes_in)),
      current_speed(std::move(current_speed_in)),
      time_remaining(std::move(time_remaining_in)),
      end_time(std::move(end_time_in)) {}

DownloadItem::~DownloadItem() = default;

void DownloadItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DownloadState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_file_path"), this->target_file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "percent_complete"), this->percent_complete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_bytes"), this->total_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "received_bytes"), this->received_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_speed"), this->current_speed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_remaining"), this->time_remaining,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_time"), this->end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DownloadItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DownloadManager::IPCStableHashFunction DownloadManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DownloadManager>(message.name())) {
    case messages::DownloadManager::kGetAllDownloads: {
      return &DownloadManager::GetAllDownloads_Sym::IPCStableHash;
    }
    case messages::DownloadManager::kCancelDownload: {
      return &DownloadManager::CancelDownload_Sym::IPCStableHash;
    }
    case messages::DownloadManager::kOpenDownload: {
      return &DownloadManager::OpenDownload_Sym::IPCStableHash;
    }
    case messages::DownloadManager::kRemoveDownload: {
      return &DownloadManager::RemoveDownload_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DownloadManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DownloadManager>(message.name())) {
      case messages::DownloadManager::kGetAllDownloads:
            return "Receive owl::mojom::DownloadManager::GetAllDownloads";
      case messages::DownloadManager::kCancelDownload:
            return "Receive owl::mojom::DownloadManager::CancelDownload";
      case messages::DownloadManager::kOpenDownload:
            return "Receive owl::mojom::DownloadManager::OpenDownload";
      case messages::DownloadManager::kRemoveDownload:
            return "Receive owl::mojom::DownloadManager::RemoveDownload";
    }
  } else {
    switch (static_cast<messages::DownloadManager>(message.name())) {
      case messages::DownloadManager::kGetAllDownloads:
            return "Receive reply owl::mojom::DownloadManager::GetAllDownloads";
      case messages::DownloadManager::kCancelDownload:
            return "Receive reply owl::mojom::DownloadManager::CancelDownload";
      case messages::DownloadManager::kOpenDownload:
            return "Receive reply owl::mojom::DownloadManager::OpenDownload";
      case messages::DownloadManager::kRemoveDownload:
            return "Receive reply owl::mojom::DownloadManager::RemoveDownload";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DownloadManager::GetAllDownloads_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5c341e3;  // IPCStableHash for owl::mojom::DownloadManager::GetAllDownloads
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManager::CancelDownload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e2c0f83;  // IPCStableHash for owl::mojom::DownloadManager::CancelDownload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManager::OpenDownload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe5af4c8;  // IPCStableHash for owl::mojom::DownloadManager::OpenDownload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManager::RemoveDownload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd9d2855;  // IPCStableHash for owl::mojom::DownloadManager::RemoveDownload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DownloadManager_GetAllDownloads_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DownloadManager_GetAllDownloads_ForwardToCallback(
      DownloadManager::GetAllDownloadsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DownloadManager_GetAllDownloads_ForwardToCallback(const DownloadManager_GetAllDownloads_ForwardToCallback&) = delete;
  DownloadManager_GetAllDownloads_ForwardToCallback& operator=(const DownloadManager_GetAllDownloads_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DownloadManager::GetAllDownloadsCallback callback_;
};

DownloadManagerProxy::DownloadManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DownloadManagerProxy::GetAllDownloads(
    GetAllDownloadsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::DownloadManager::GetAllDownloads");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManager::kGetAllDownloads), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManager_GetAllDownloads_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManager::Name_);
  message.set_method_name("GetAllDownloads");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DownloadManager_GetAllDownloads_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DownloadManagerProxy::CancelDownload(
    const std::string& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManager::CancelDownload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManager::kCancelDownload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManager_CancelDownload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in DownloadManager.CancelDownload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManager::Name_);
  message.set_method_name("CancelDownload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerProxy::OpenDownload(
    const std::string& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManager::OpenDownload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManager::kOpenDownload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManager_OpenDownload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in DownloadManager.OpenDownload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManager::Name_);
  message.set_method_name("OpenDownload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerProxy::RemoveDownload(
    const std::string& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManager::RemoveDownload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManager::kRemoveDownload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManager_RemoveDownload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in DownloadManager.RemoveDownload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManager::Name_);
  message.set_method_name("RemoveDownload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DownloadManager_GetAllDownloads_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DownloadManager::GetAllDownloadsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DownloadManager_GetAllDownloads_ProxyToResponder> proxy(
        new DownloadManager_GetAllDownloads_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DownloadManager_GetAllDownloads_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DownloadManager_GetAllDownloads_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DownloadManager_GetAllDownloads_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DownloadManager::GetAllDownloadsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<DownloadItemPtr> in_items);
};

bool DownloadManager_GetAllDownloads_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DownloadManager_GetAllDownloads_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DownloadManager_GetAllDownloads_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DownloadManager.0
  bool success = true;
  std::vector<DownloadItemPtr> p_items{};
  DownloadManager_GetAllDownloads_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadItems(&p_items))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DownloadManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_items));
  }
  return true;
}

void DownloadManager_GetAllDownloads_ProxyToResponder::Run(
    std::vector<DownloadItemPtr> in_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::DownloadManager::GetAllDownloads", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type std::vector<DownloadItemPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManager::kGetAllDownloads), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManager_GetAllDownloads_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->items)::BaseType>
      items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::DownloadItemDataView>>(
    in_items,
    items_fragment,
    &items_validate_params);

  params->items.Set(
      items_fragment.is_null() ? nullptr : items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null items in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManager::Name_);
  message.set_method_name("GetAllDownloads");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DownloadManagerStubDispatch::Accept(
    DownloadManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DownloadManager>(message->header()->name)) {
    case messages::DownloadManager::kGetAllDownloads: {
      break;
    }
    case messages::DownloadManager::kCancelDownload: {
      DCHECK(message->is_serialized());
      internal::DownloadManager_CancelDownload_Params_Data* params =
          reinterpret_cast<internal::DownloadManager_CancelDownload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManager.1
      bool success = true;
      std::string p_guid{};
      DownloadManager_CancelDownload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelDownload(        
        std::move(p_guid));
      return true;
    }
    case messages::DownloadManager::kOpenDownload: {
      DCHECK(message->is_serialized());
      internal::DownloadManager_OpenDownload_Params_Data* params =
          reinterpret_cast<internal::DownloadManager_OpenDownload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManager.2
      bool success = true;
      std::string p_guid{};
      DownloadManager_OpenDownload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDownload(        
        std::move(p_guid));
      return true;
    }
    case messages::DownloadManager::kRemoveDownload: {
      DCHECK(message->is_serialized());
      internal::DownloadManager_RemoveDownload_Params_Data* params =
          reinterpret_cast<internal::DownloadManager_RemoveDownload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManager.3
      bool success = true;
      std::string p_guid{};
      DownloadManager_RemoveDownload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveDownload(        
        std::move(p_guid));
      return true;
    }
  }
  return false;
}

// static
bool DownloadManagerStubDispatch::AcceptWithResponder(
    DownloadManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DownloadManager>(message->header()->name)) {
    case messages::DownloadManager::kGetAllDownloads: {
      internal::DownloadManager_GetAllDownloads_Params_Data* params =
          reinterpret_cast<
              internal::DownloadManager_GetAllDownloads_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DownloadManager.0
      bool success = true;
      DownloadManager_GetAllDownloads_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManager::Name_, 0, false);
        return false;
      }
      auto callback =
          DownloadManager_GetAllDownloads_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllDownloads(std::move(callback));
      return true;
    }
    case messages::DownloadManager::kCancelDownload: {
      break;
    }
    case messages::DownloadManager::kOpenDownload: {
      break;
    }
    case messages::DownloadManager::kRemoveDownload: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDownloadManagerValidationInfo[] = {
    { &internal::DownloadManager_GetAllDownloads_Params_Data::Validate,
     &internal::DownloadManager_GetAllDownloads_ResponseParams_Data::Validate},
    { &internal::DownloadManager_CancelDownload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManager_OpenDownload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManager_RemoveDownload_Params_Data::Validate,
     nullptr /* no response */},
};

bool DownloadManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::DownloadManager::Name_,
    kDownloadManagerValidationInfo);
}

bool DownloadManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::DownloadManager::Name_,
    kDownloadManagerValidationInfo);
}
// The declaration includes the definition on other builds.

DownloadManagerClient::IPCStableHashFunction DownloadManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DownloadManagerClient>(message.name())) {
    case messages::DownloadManagerClient::kOnDownloadCreated: {
      return &DownloadManagerClient::OnDownloadCreated_Sym::IPCStableHash;
    }
    case messages::DownloadManagerClient::kOnDownloadUpdated: {
      return &DownloadManagerClient::OnDownloadUpdated_Sym::IPCStableHash;
    }
    case messages::DownloadManagerClient::kOnDownloadOpened: {
      return &DownloadManagerClient::OnDownloadOpened_Sym::IPCStableHash;
    }
    case messages::DownloadManagerClient::kOnDownloadRemoved: {
      return &DownloadManagerClient::OnDownloadRemoved_Sym::IPCStableHash;
    }
    case messages::DownloadManagerClient::kOnDownloadDestroyed: {
      return &DownloadManagerClient::OnDownloadDestroyed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DownloadManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DownloadManagerClient>(message.name())) {
      case messages::DownloadManagerClient::kOnDownloadCreated:
            return "Receive owl::mojom::DownloadManagerClient::OnDownloadCreated";
      case messages::DownloadManagerClient::kOnDownloadUpdated:
            return "Receive owl::mojom::DownloadManagerClient::OnDownloadUpdated";
      case messages::DownloadManagerClient::kOnDownloadOpened:
            return "Receive owl::mojom::DownloadManagerClient::OnDownloadOpened";
      case messages::DownloadManagerClient::kOnDownloadRemoved:
            return "Receive owl::mojom::DownloadManagerClient::OnDownloadRemoved";
      case messages::DownloadManagerClient::kOnDownloadDestroyed:
            return "Receive owl::mojom::DownloadManagerClient::OnDownloadDestroyed";
    }
  } else {
    switch (static_cast<messages::DownloadManagerClient>(message.name())) {
      case messages::DownloadManagerClient::kOnDownloadCreated:
            return "Receive reply owl::mojom::DownloadManagerClient::OnDownloadCreated";
      case messages::DownloadManagerClient::kOnDownloadUpdated:
            return "Receive reply owl::mojom::DownloadManagerClient::OnDownloadUpdated";
      case messages::DownloadManagerClient::kOnDownloadOpened:
            return "Receive reply owl::mojom::DownloadManagerClient::OnDownloadOpened";
      case messages::DownloadManagerClient::kOnDownloadRemoved:
            return "Receive reply owl::mojom::DownloadManagerClient::OnDownloadRemoved";
      case messages::DownloadManagerClient::kOnDownloadDestroyed:
            return "Receive reply owl::mojom::DownloadManagerClient::OnDownloadDestroyed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DownloadManagerClient::OnDownloadCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b1e51f4;  // IPCStableHash for owl::mojom::DownloadManagerClient::OnDownloadCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManagerClient::OnDownloadUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f23ed35;  // IPCStableHash for owl::mojom::DownloadManagerClient::OnDownloadUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManagerClient::OnDownloadOpened_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8bde2624;  // IPCStableHash for owl::mojom::DownloadManagerClient::OnDownloadOpened
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManagerClient::OnDownloadRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15d507d5;  // IPCStableHash for owl::mojom::DownloadManagerClient::OnDownloadRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DownloadManagerClient::OnDownloadDestroyed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15511186;  // IPCStableHash for owl::mojom::DownloadManagerClient::OnDownloadDestroyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DownloadManagerClientProxy::DownloadManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DownloadManagerClientProxy::OnDownloadCreated(
    DownloadItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManagerClient::OnDownloadCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type DownloadItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManagerClient::kOnDownloadCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManagerClient_OnDownloadCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DownloadItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in DownloadManagerClient.OnDownloadCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManagerClient::Name_);
  message.set_method_name("OnDownloadCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerClientProxy::OnDownloadUpdated(
    DownloadItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManagerClient::OnDownloadUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type DownloadItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManagerClient::kOnDownloadUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManagerClient_OnDownloadUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DownloadItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in DownloadManagerClient.OnDownloadUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManagerClient::Name_);
  message.set_method_name("OnDownloadUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerClientProxy::OnDownloadOpened(
    DownloadItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManagerClient::OnDownloadOpened", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type DownloadItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManagerClient::kOnDownloadOpened), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManagerClient_OnDownloadOpened_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DownloadItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in DownloadManagerClient.OnDownloadOpened request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManagerClient::Name_);
  message.set_method_name("OnDownloadOpened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerClientProxy::OnDownloadRemoved(
    DownloadItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManagerClient::OnDownloadRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type DownloadItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManagerClient::kOnDownloadRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManagerClient_OnDownloadRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DownloadItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in DownloadManagerClient.OnDownloadRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManagerClient::Name_);
  message.set_method_name("OnDownloadRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DownloadManagerClientProxy::OnDownloadDestroyed(
    DownloadItemPtr in_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DownloadManagerClient::OnDownloadDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item"), in_item,
                        "<value of type DownloadItemPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DownloadManagerClient::kOnDownloadDestroyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DownloadManagerClient_OnDownloadDestroyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item)::BaseType> item_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DownloadItemDataView>(
    in_item,
    item_fragment);

  params->item.Set(
      item_fragment.is_null() ? nullptr : item_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->item.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null item in DownloadManagerClient.OnDownloadDestroyed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DownloadManagerClient::Name_);
  message.set_method_name("OnDownloadDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DownloadManagerClientStubDispatch::Accept(
    DownloadManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DownloadManagerClient>(message->header()->name)) {
    case messages::DownloadManagerClient::kOnDownloadCreated: {
      DCHECK(message->is_serialized());
      internal::DownloadManagerClient_OnDownloadCreated_Params_Data* params =
          reinterpret_cast<internal::DownloadManagerClient_OnDownloadCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManagerClient.0
      bool success = true;
      DownloadItemPtr p_item{};
      DownloadManagerClient_OnDownloadCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDownloadCreated(        
        std::move(p_item));
      return true;
    }
    case messages::DownloadManagerClient::kOnDownloadUpdated: {
      DCHECK(message->is_serialized());
      internal::DownloadManagerClient_OnDownloadUpdated_Params_Data* params =
          reinterpret_cast<internal::DownloadManagerClient_OnDownloadUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManagerClient.1
      bool success = true;
      DownloadItemPtr p_item{};
      DownloadManagerClient_OnDownloadUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDownloadUpdated(        
        std::move(p_item));
      return true;
    }
    case messages::DownloadManagerClient::kOnDownloadOpened: {
      DCHECK(message->is_serialized());
      internal::DownloadManagerClient_OnDownloadOpened_Params_Data* params =
          reinterpret_cast<internal::DownloadManagerClient_OnDownloadOpened_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManagerClient.2
      bool success = true;
      DownloadItemPtr p_item{};
      DownloadManagerClient_OnDownloadOpened_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManagerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDownloadOpened(        
        std::move(p_item));
      return true;
    }
    case messages::DownloadManagerClient::kOnDownloadRemoved: {
      DCHECK(message->is_serialized());
      internal::DownloadManagerClient_OnDownloadRemoved_Params_Data* params =
          reinterpret_cast<internal::DownloadManagerClient_OnDownloadRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManagerClient.3
      bool success = true;
      DownloadItemPtr p_item{};
      DownloadManagerClient_OnDownloadRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManagerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDownloadRemoved(        
        std::move(p_item));
      return true;
    }
    case messages::DownloadManagerClient::kOnDownloadDestroyed: {
      DCHECK(message->is_serialized());
      internal::DownloadManagerClient_OnDownloadDestroyed_Params_Data* params =
          reinterpret_cast<internal::DownloadManagerClient_OnDownloadDestroyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DownloadManagerClient.4
      bool success = true;
      DownloadItemPtr p_item{};
      DownloadManagerClient_OnDownloadDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItem(&p_item))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DownloadManagerClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDownloadDestroyed(        
        std::move(p_item));
      return true;
    }
  }
  return false;
}

// static
bool DownloadManagerClientStubDispatch::AcceptWithResponder(
    DownloadManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DownloadManagerClient>(message->header()->name)) {
    case messages::DownloadManagerClient::kOnDownloadCreated: {
      break;
    }
    case messages::DownloadManagerClient::kOnDownloadUpdated: {
      break;
    }
    case messages::DownloadManagerClient::kOnDownloadOpened: {
      break;
    }
    case messages::DownloadManagerClient::kOnDownloadRemoved: {
      break;
    }
    case messages::DownloadManagerClient::kOnDownloadDestroyed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDownloadManagerClientValidationInfo[] = {
    { &internal::DownloadManagerClient_OnDownloadCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManagerClient_OnDownloadUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManagerClient_OnDownloadOpened_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManagerClient_OnDownloadRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DownloadManagerClient_OnDownloadDestroyed_Params_Data::Validate,
     nullptr /* no response */},
};

bool DownloadManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::DownloadManagerClient::Name_,
    kDownloadManagerClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::DownloadItem::DataView, ::owl::mojom::DownloadItemPtr>::Read(
    ::owl::mojom::DownloadItem::DataView input,
    ::owl::mojom::DownloadItemPtr* output) {
  bool success = true;
  ::owl::mojom::DownloadItemPtr result(::owl::mojom::DownloadItem::New());
  
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadTargetFilePath(&result->target_file_path))
        success = false;
      if (success)
        result->percent_complete = input.percent_complete();
      if (success)
        result->total_bytes = input.total_bytes();
      if (success)
        result->received_bytes = input.received_bytes();
      if (success)
        result->current_speed = input.current_speed();
      if (success && !input.ReadTimeRemaining(&result->time_remaining))
        success = false;
      if (success && !input.ReadEndTime(&result->end_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void DownloadManagerInterceptorForTesting::GetAllDownloads(GetAllDownloadsCallback callback) {
  GetForwardingInterface()->GetAllDownloads(std::move(callback));
}
void DownloadManagerInterceptorForTesting::CancelDownload(const std::string& guid) {
  GetForwardingInterface()->CancelDownload(
    std::move(guid)
    );
}
void DownloadManagerInterceptorForTesting::OpenDownload(const std::string& guid) {
  GetForwardingInterface()->OpenDownload(
    std::move(guid)
    );
}
void DownloadManagerInterceptorForTesting::RemoveDownload(const std::string& guid) {
  GetForwardingInterface()->RemoveDownload(
    std::move(guid)
    );
}
DownloadManagerAsyncWaiter::DownloadManagerAsyncWaiter(
    DownloadManager* proxy) : proxy_(proxy) {}

DownloadManagerAsyncWaiter::~DownloadManagerAsyncWaiter() = default;


void DownloadManagerAsyncWaiter::GetAllDownloads(
    std::vector<DownloadItemPtr>* out_items) {
  base::RunLoop loop;
  proxy_->GetAllDownloads(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<DownloadItemPtr>* out_items
,
             std::vector<DownloadItemPtr> items) {*out_items = std::move(items);
            loop->Quit();
          },
          &loop,
          out_items));
  loop.Run();
}

std::vector<DownloadItemPtr> DownloadManagerAsyncWaiter::GetAllDownloads(
    ) {
  std::vector<DownloadItemPtr> async_wait_result;
  GetAllDownloads(&async_wait_result);
  return async_wait_result;
}




void DownloadManagerClientInterceptorForTesting::OnDownloadCreated(DownloadItemPtr item) {
  GetForwardingInterface()->OnDownloadCreated(
    std::move(item)
    );
}
void DownloadManagerClientInterceptorForTesting::OnDownloadUpdated(DownloadItemPtr item) {
  GetForwardingInterface()->OnDownloadUpdated(
    std::move(item)
    );
}
void DownloadManagerClientInterceptorForTesting::OnDownloadOpened(DownloadItemPtr item) {
  GetForwardingInterface()->OnDownloadOpened(
    std::move(item)
    );
}
void DownloadManagerClientInterceptorForTesting::OnDownloadRemoved(DownloadItemPtr item) {
  GetForwardingInterface()->OnDownloadRemoved(
    std::move(item)
    );
}
void DownloadManagerClientInterceptorForTesting::OnDownloadDestroyed(DownloadItemPtr item) {
  GetForwardingInterface()->OnDownloadDestroyed(
    std::move(item)
    );
}
DownloadManagerClientAsyncWaiter::DownloadManagerClientAsyncWaiter(
    DownloadManagerClient* proxy) : proxy_(proxy) {}

DownloadManagerClientAsyncWaiter::~DownloadManagerClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif