// owl/mojom/context_menu_params.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_H_
#define OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/context_menu_params.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/context_menu_params.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/context_menu_params.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace owl::mojom {








class  ContextMenuParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContextMenuParams, T>::value>;
  using DataView = ContextMenuParamsDataView;
  using Data_ = internal::ContextMenuParams_Data;

  template <typename... Args>
  static ContextMenuParamsPtr New(Args&&... args) {
    return ContextMenuParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContextMenuParamsPtr From(const U& u) {
    return mojo::TypeConverter<ContextMenuParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContextMenuParams>::Convert(*this);
  }


  ContextMenuParams();

  ContextMenuParams(
      const ::GURL& page_url,
      const ::GURL& frame_url,
      bool is_subframe,
      const ::gfx::Point& location_in_web_contents_origin_upper_left,
      const ::GURL& link_url,
      const ::std::u16string& link_text,
      const ::GURL& src_url,
      const ::std::u16string& selection_text,
      int32_t x,
      int32_t y,
      ::blink::mojom::ContextMenuDataMediaType media_type,
      int32_t media_flags,
      ::network::mojom::ReferrerPolicy referrer_policy,
      std::optional<uint64_t> render_frame_view_id,
      int32_t frame_routing_id,
      int32_t frame_process_id,
      bool has_image_contents,
      const ::std::u16string& suggested_filename,
      bool is_editable,
      int32_t edit_flags,
      const ::std::u16string& misspelled_word,
      std::vector<::std::u16string> dictionary_suggestions);


  ~ContextMenuParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContextMenuParamsPtr>
  ContextMenuParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextMenuParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextMenuParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContextMenuParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContextMenuParams_UnserializedMessageContext<
            UserType, ContextMenuParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContextMenuParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContextMenuParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContextMenuParams_UnserializedMessageContext<
            UserType, ContextMenuParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContextMenuParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL page_url;
  
  ::GURL frame_url;
  
  bool is_subframe;
  
  ::gfx::Point location_in_web_contents_origin_upper_left;
  
  ::GURL link_url;
  
  ::std::u16string link_text;
  
  ::GURL src_url;
  
  ::std::u16string selection_text;
  
  int32_t x;
  
  int32_t y;
  
  ::blink::mojom::ContextMenuDataMediaType media_type;
  
  int32_t media_flags;
  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  std::optional<uint64_t> render_frame_view_id;
  
  int32_t frame_routing_id;
  
  int32_t frame_process_id;
  
  bool has_image_contents;
  
  ::std::u16string suggested_filename;
  
  bool is_editable;
  
  int32_t edit_flags;
  
  ::std::u16string misspelled_word;
  
  std::vector<::std::u16string> dictionary_suggestions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ContextMenuParamsPtr ContextMenuParams::Clone() const {
  return New(
      mojo::Clone(page_url),
      mojo::Clone(frame_url),
      mojo::Clone(is_subframe),
      mojo::Clone(location_in_web_contents_origin_upper_left),
      mojo::Clone(link_url),
      mojo::Clone(link_text),
      mojo::Clone(src_url),
      mojo::Clone(selection_text),
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(media_type),
      mojo::Clone(media_flags),
      mojo::Clone(referrer_policy),
      mojo::Clone(render_frame_view_id),
      mojo::Clone(frame_routing_id),
      mojo::Clone(frame_process_id),
      mojo::Clone(has_image_contents),
      mojo::Clone(suggested_filename),
      mojo::Clone(is_editable),
      mojo::Clone(edit_flags),
      mojo::Clone(misspelled_word),
      mojo::Clone(dictionary_suggestions)
  );
}

template <typename T, ContextMenuParams::EnableIfSame<T>*>
bool ContextMenuParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_url, other_struct.page_url))
    return false;
  if (!mojo::Equals(this->frame_url, other_struct.frame_url))
    return false;
  if (!mojo::Equals(this->is_subframe, other_struct.is_subframe))
    return false;
  if (!mojo::Equals(this->location_in_web_contents_origin_upper_left, other_struct.location_in_web_contents_origin_upper_left))
    return false;
  if (!mojo::Equals(this->link_url, other_struct.link_url))
    return false;
  if (!mojo::Equals(this->link_text, other_struct.link_text))
    return false;
  if (!mojo::Equals(this->src_url, other_struct.src_url))
    return false;
  if (!mojo::Equals(this->selection_text, other_struct.selection_text))
    return false;
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->media_type, other_struct.media_type))
    return false;
  if (!mojo::Equals(this->media_flags, other_struct.media_flags))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->render_frame_view_id, other_struct.render_frame_view_id))
    return false;
  if (!mojo::Equals(this->frame_routing_id, other_struct.frame_routing_id))
    return false;
  if (!mojo::Equals(this->frame_process_id, other_struct.frame_process_id))
    return false;
  if (!mojo::Equals(this->has_image_contents, other_struct.has_image_contents))
    return false;
  if (!mojo::Equals(this->suggested_filename, other_struct.suggested_filename))
    return false;
  if (!mojo::Equals(this->is_editable, other_struct.is_editable))
    return false;
  if (!mojo::Equals(this->edit_flags, other_struct.edit_flags))
    return false;
  if (!mojo::Equals(this->misspelled_word, other_struct.misspelled_word))
    return false;
  if (!mojo::Equals(this->dictionary_suggestions, other_struct.dictionary_suggestions))
    return false;
  return true;
}

template <typename T, ContextMenuParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_url < rhs.page_url)
    return true;
  if (rhs.page_url < lhs.page_url)
    return false;
  if (lhs.frame_url < rhs.frame_url)
    return true;
  if (rhs.frame_url < lhs.frame_url)
    return false;
  if (lhs.is_subframe < rhs.is_subframe)
    return true;
  if (rhs.is_subframe < lhs.is_subframe)
    return false;
  if (lhs.location_in_web_contents_origin_upper_left < rhs.location_in_web_contents_origin_upper_left)
    return true;
  if (rhs.location_in_web_contents_origin_upper_left < lhs.location_in_web_contents_origin_upper_left)
    return false;
  if (lhs.link_url < rhs.link_url)
    return true;
  if (rhs.link_url < lhs.link_url)
    return false;
  if (lhs.link_text < rhs.link_text)
    return true;
  if (rhs.link_text < lhs.link_text)
    return false;
  if (lhs.src_url < rhs.src_url)
    return true;
  if (rhs.src_url < lhs.src_url)
    return false;
  if (lhs.selection_text < rhs.selection_text)
    return true;
  if (rhs.selection_text < lhs.selection_text)
    return false;
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.media_type < rhs.media_type)
    return true;
  if (rhs.media_type < lhs.media_type)
    return false;
  if (lhs.media_flags < rhs.media_flags)
    return true;
  if (rhs.media_flags < lhs.media_flags)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.render_frame_view_id < rhs.render_frame_view_id)
    return true;
  if (rhs.render_frame_view_id < lhs.render_frame_view_id)
    return false;
  if (lhs.frame_routing_id < rhs.frame_routing_id)
    return true;
  if (rhs.frame_routing_id < lhs.frame_routing_id)
    return false;
  if (lhs.frame_process_id < rhs.frame_process_id)
    return true;
  if (rhs.frame_process_id < lhs.frame_process_id)
    return false;
  if (lhs.has_image_contents < rhs.has_image_contents)
    return true;
  if (rhs.has_image_contents < lhs.has_image_contents)
    return false;
  if (lhs.suggested_filename < rhs.suggested_filename)
    return true;
  if (rhs.suggested_filename < lhs.suggested_filename)
    return false;
  if (lhs.is_editable < rhs.is_editable)
    return true;
  if (rhs.is_editable < lhs.is_editable)
    return false;
  if (lhs.edit_flags < rhs.edit_flags)
    return true;
  if (rhs.edit_flags < lhs.edit_flags)
    return false;
  if (lhs.misspelled_word < rhs.misspelled_word)
    return true;
  if (rhs.misspelled_word < lhs.misspelled_word)
    return false;
  if (lhs.dictionary_suggestions < rhs.dictionary_suggestions)
    return true;
  if (rhs.dictionary_suggestions < lhs.dictionary_suggestions)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::ContextMenuParams::DataView,
                                         ::owl::mojom::ContextMenuParamsPtr> {
  static bool IsNull(const ::owl::mojom::ContextMenuParamsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::ContextMenuParamsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::ContextMenuParams::page_url)& page_url(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->page_url;
  }

  static const decltype(::owl::mojom::ContextMenuParams::frame_url)& frame_url(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->frame_url;
  }

  static decltype(::owl::mojom::ContextMenuParams::is_subframe) is_subframe(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->is_subframe;
  }

  static const decltype(::owl::mojom::ContextMenuParams::location_in_web_contents_origin_upper_left)& location_in_web_contents_origin_upper_left(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->location_in_web_contents_origin_upper_left;
  }

  static const decltype(::owl::mojom::ContextMenuParams::link_url)& link_url(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->link_url;
  }

  static const decltype(::owl::mojom::ContextMenuParams::link_text)& link_text(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->link_text;
  }

  static const decltype(::owl::mojom::ContextMenuParams::src_url)& src_url(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->src_url;
  }

  static const decltype(::owl::mojom::ContextMenuParams::selection_text)& selection_text(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->selection_text;
  }

  static decltype(::owl::mojom::ContextMenuParams::x) x(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->x;
  }

  static decltype(::owl::mojom::ContextMenuParams::y) y(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->y;
  }

  static decltype(::owl::mojom::ContextMenuParams::media_type) media_type(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->media_type;
  }

  static decltype(::owl::mojom::ContextMenuParams::media_flags) media_flags(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->media_flags;
  }

  static decltype(::owl::mojom::ContextMenuParams::referrer_policy) referrer_policy(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->referrer_policy;
  }

  static decltype(::owl::mojom::ContextMenuParams::render_frame_view_id) render_frame_view_id(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->render_frame_view_id;
  }

  static decltype(::owl::mojom::ContextMenuParams::frame_routing_id) frame_routing_id(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->frame_routing_id;
  }

  static decltype(::owl::mojom::ContextMenuParams::frame_process_id) frame_process_id(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->frame_process_id;
  }

  static decltype(::owl::mojom::ContextMenuParams::has_image_contents) has_image_contents(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->has_image_contents;
  }

  static const decltype(::owl::mojom::ContextMenuParams::suggested_filename)& suggested_filename(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->suggested_filename;
  }

  static decltype(::owl::mojom::ContextMenuParams::is_editable) is_editable(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->is_editable;
  }

  static decltype(::owl::mojom::ContextMenuParams::edit_flags) edit_flags(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->edit_flags;
  }

  static const decltype(::owl::mojom::ContextMenuParams::misspelled_word)& misspelled_word(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->misspelled_word;
  }

  static const decltype(::owl::mojom::ContextMenuParams::dictionary_suggestions)& dictionary_suggestions(
      const ::owl::mojom::ContextMenuParamsPtr& input) {
    return input->dictionary_suggestions;
  }

  static bool Read(::owl::mojom::ContextMenuParams::DataView input, ::owl::mojom::ContextMenuParamsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_H_