// owl/mojom/context_menu_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/context_menu_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class ContextMenuParamsDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::ContextMenuParamsDataView> {
  using Data = ::owl::mojom::internal::ContextMenuParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


class ContextMenuParamsDataView {
 public:
  ContextMenuParamsDataView() = default;

  ContextMenuParamsDataView(
      internal::ContextMenuParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageUrl(UserType* output) {
    
    auto* pointer = data_->page_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFrameUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameUrl(UserType* output) {
    
    auto* pointer = data_->frame_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_subframe() const {
    return data_->is_subframe;
  }
  inline void GetLocationInWebContentsOriginUpperLeftDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationInWebContentsOriginUpperLeft(UserType* output) {
    
    auto* pointer = data_->location_in_web_contents_origin_upper_left.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetLinkUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkUrl(UserType* output) {
    
    auto* pointer = data_->link_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLinkTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkText(UserType* output) {
    
    auto* pointer = data_->link_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSrcUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcUrl(UserType* output) {
    
    auto* pointer = data_->src_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionText(UserType* output) {
    
    auto* pointer = data_->selection_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  int32_t x() const {
    return data_->x;
  }
  int32_t y() const {
    return data_->y;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMediaType(UserType* output) const {
    auto data_value = data_->media_type;
    return mojo::internal::Deserialize<::blink::mojom::ContextMenuDataMediaType>(
        data_value, output);
  }
  ::blink::mojom::ContextMenuDataMediaType media_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ContextMenuDataMediaType>(data_->media_type));
  }
  int32_t media_flags() const {
    return data_->media_flags;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  std::optional<uint64_t> render_frame_view_id() const {

    return data_->render_frame_view_id_$flag
        ? std::make_optional(data_->render_frame_view_id_$value)
        : std::nullopt;
  }
  int32_t frame_routing_id() const {
    return data_->frame_routing_id;
  }
  int32_t frame_process_id() const {
    return data_->frame_process_id;
  }
  bool has_image_contents() const {
    return data_->has_image_contents;
  }
  inline void GetSuggestedFilenameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestedFilename(UserType* output) {
    
    auto* pointer = data_->suggested_filename.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool is_editable() const {
    return data_->is_editable;
  }
  int32_t edit_flags() const {
    return data_->edit_flags;
  }
  inline void GetMisspelledWordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMisspelledWord(UserType* output) {
    
    auto* pointer = data_->misspelled_word.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDictionarySuggestionsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionarySuggestions(UserType* output) {
    
    auto* pointer = data_->dictionary_suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::ContextMenuParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_CONTEXT_MENU_PARAMS_MOJOM_DATA_VIEW_H_