// owl/mojom/bookmark_model.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_BOOKMARK_MODEL_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_BOOKMARK_MODEL_MOJOM_TEST_UTILS_H_

#include "owl/mojom/bookmark_model.mojom.h"


namespace owl::mojom {


class  BookmarkModelInterceptorForTesting : public BookmarkModel {
  virtual BookmarkModel* GetForwardingInterface() = 0;
  void GetBookmarks(GetBookmarksCallback callback) override;
  void AddFolder(const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, AddFolderCallback callback) override;
  void AddURL(const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, AddURLCallback callback) override;
  void Update(const ::base::Uuid& uuid, const ::std::u16string& title, const std::optional<::GURL>& url) override;
  void UpdateLastUsedTime(const ::base::Uuid& uuid) override;
  void Move(const ::base::Uuid& uuid, const ::base::Uuid& parent_uuid, int32_t index) override;
  void Remove(const ::base::Uuid& uuid) override;
  void ImportBookmarks(std::vector<BookmarkNodePtr> bookmark_bar_bookmarks, std::vector<BookmarkNodePtr> other_bookmarks) override;
};
class  BookmarkModelAsyncWaiter {
 public:
  explicit BookmarkModelAsyncWaiter(BookmarkModel* proxy);

  BookmarkModelAsyncWaiter(const BookmarkModelAsyncWaiter&) = delete;
  BookmarkModelAsyncWaiter& operator=(const BookmarkModelAsyncWaiter&) = delete;

  ~BookmarkModelAsyncWaiter();
  void GetBookmarks(
      BookmarksPtr* out_bookmarks);
  BookmarksPtr GetBookmarks();
  void AddFolder(
      const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index, std::optional<::base::Uuid>* out_uuid);
  std::optional<::base::Uuid> AddFolder(const ::std::u16string& title, const ::base::Uuid& parent_uuid, int32_t index);
  void AddURL(
      const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index, std::optional<::base::Uuid>* out_uuid);
  std::optional<::base::Uuid> AddURL(const ::std::u16string& title, const ::GURL& url, const ::base::Uuid& parent_uuid, int32_t index);

 private:
  BookmarkModel* const proxy_;
};


class  BookmarkModelClientInterceptorForTesting : public BookmarkModelClient {
  virtual BookmarkModelClient* GetForwardingInterface() = 0;
  void OnBookmarkUpdated(BookmarkNodePtr node) override;
};
class  BookmarkModelClientAsyncWaiter {
 public:
  explicit BookmarkModelClientAsyncWaiter(BookmarkModelClient* proxy);

  BookmarkModelClientAsyncWaiter(const BookmarkModelClientAsyncWaiter&) = delete;
  BookmarkModelClientAsyncWaiter& operator=(const BookmarkModelClientAsyncWaiter&) = delete;

  ~BookmarkModelClientAsyncWaiter();

 private:
  BookmarkModelClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_BOOKMARK_MODEL_MOJOM_TEST_UTILS_H_