// owl/mojom/bookmark_model.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/bookmark_model.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/bookmark_model.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* BookmarkTypeToStringHelper(BookmarkType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BookmarkType::kURL:
      return "kURL";
    case BookmarkType::kFolder:
      return "kFolder";
    case BookmarkType::kBookmarkBar:
      return "kBookmarkBar";
    case BookmarkType::kOtherNode:
      return "kOtherNode";
    case BookmarkType::kMobile:
      return "kMobile";
    default:
      return nullptr;
  }
}

std::string BookmarkTypeToString(BookmarkType value) {
  const char *str = BookmarkTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BookmarkType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BookmarkType value) {
  return os << BookmarkTypeToString(value);
}

namespace internal {


// static
bool BookmarkNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkNode_Data* object =
      static_cast<const BookmarkNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;


  if (!::owl::mojom::internal::BookmarkType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

BookmarkNode_Data::BookmarkNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Bookmarks_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Bookmarks_Data* object =
      static_cast<const Bookmarks_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmark_bar_node, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bookmark_bar_node, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->other_node, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->other_node, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mobile_node, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mobile_node, validation_context))
    return false;

  return true;
}

Bookmarks_Data::Bookmarks_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_GetBookmarks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_GetBookmarks_Params_Data* object =
      static_cast<const BookmarkModel_GetBookmarks_Params_Data*>(data);

  return true;
}

BookmarkModel_GetBookmarks_Params_Data::BookmarkModel_GetBookmarks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_GetBookmarks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_GetBookmarks_ResponseParams_Data* object =
      static_cast<const BookmarkModel_GetBookmarks_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmarks, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bookmarks, validation_context))
    return false;

  return true;
}

BookmarkModel_GetBookmarks_ResponseParams_Data::BookmarkModel_GetBookmarks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_AddFolder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_AddFolder_Params_Data* object =
      static_cast<const BookmarkModel_AddFolder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_AddFolder_Params_Data::BookmarkModel_AddFolder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_AddFolder_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_AddFolder_ResponseParams_Data* object =
      static_cast<const BookmarkModel_AddFolder_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_AddFolder_ResponseParams_Data::BookmarkModel_AddFolder_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_AddURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_AddURL_Params_Data* object =
      static_cast<const BookmarkModel_AddURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_uuid, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_AddURL_Params_Data::BookmarkModel_AddURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_AddURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_AddURL_ResponseParams_Data* object =
      static_cast<const BookmarkModel_AddURL_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_AddURL_ResponseParams_Data::BookmarkModel_AddURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_Update_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_Update_Params_Data* object =
      static_cast<const BookmarkModel_Update_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

BookmarkModel_Update_Params_Data::BookmarkModel_Update_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_UpdateLastUsedTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_UpdateLastUsedTime_Params_Data* object =
      static_cast<const BookmarkModel_UpdateLastUsedTime_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_UpdateLastUsedTime_Params_Data::BookmarkModel_UpdateLastUsedTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_Move_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_Move_Params_Data* object =
      static_cast<const BookmarkModel_Move_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_Move_Params_Data::BookmarkModel_Move_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_Remove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_Remove_Params_Data* object =
      static_cast<const BookmarkModel_Remove_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

BookmarkModel_Remove_Params_Data::BookmarkModel_Remove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModel_ImportBookmarks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModel_ImportBookmarks_Params_Data* object =
      static_cast<const BookmarkModel_ImportBookmarks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bookmark_bar_bookmarks, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bookmark_bar_bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bookmark_bar_bookmarks, validation_context,
                                         &bookmark_bar_bookmarks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->other_bookmarks, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& other_bookmarks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->other_bookmarks, validation_context,
                                         &other_bookmarks_validate_params)) {
    return false;
  }

  return true;
}

BookmarkModel_ImportBookmarks_Params_Data::BookmarkModel_ImportBookmarks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarkModelClient_OnBookmarkUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarkModelClient_OnBookmarkUpdated_Params_Data* object =
      static_cast<const BookmarkModelClient_OnBookmarkUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->node, validation_context))
    return false;

  return true;
}

BookmarkModelClient_OnBookmarkUpdated_Params_Data::BookmarkModelClient_OnBookmarkUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::BookmarkType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::BookmarkType value) {
  return std::move(context).WriteString(::owl::mojom::BookmarkTypeToString(value));
}

} // namespace perfetto