// owl/mojom/autocomplete.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOCOMPLETE_MOJOM_H_
#define OWL_MOJOM_AUTOCOMPLETE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autocomplete.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/autocomplete.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/autocomplete.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class AutocompleteControllerProxy;

template <typename ImplRefTraits>
class AutocompleteControllerStub;

class AutocompleteControllerRequestValidator;


class AutocompleteController
    : public AutocompleteControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutocompleteController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutocompleteControllerInterfaceBase;
  using Proxy_ = AutocompleteControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutocompleteControllerStub<ImplRefTraits>;

  using RequestValidator_ = AutocompleteControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDestroyMinVersion = 0,
    kStartMinVersion = 0,
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutocompleteController() = default;

  virtual void Destroy() = 0;

  virtual void Start(const ::std::u16string& input, std::optional<uint32_t> cursor_position, ::mojo::PendingAssociatedRemote<AutocompleteClient> client) = 0;

  virtual void Stop() = 0;
};

class AutocompleteClientProxy;

template <typename ImplRefTraits>
class AutocompleteClientStub;

class AutocompleteClientRequestValidator;


class AutocompleteClient
    : public AutocompleteClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutocompleteClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutocompleteClientInterfaceBase;
  using Proxy_ = AutocompleteClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutocompleteClientStub<ImplRefTraits>;

  using RequestValidator_ = AutocompleteClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResultsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutocompleteClient() = default;

  virtual void OnResults(AutocompleteResultsPtr results, bool is_done) = 0;
};



class  AutocompleteControllerProxy
    : public AutocompleteController {
 public:
  using InterfaceType = AutocompleteController;

  explicit AutocompleteControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Destroy() final;
  
  void Start(const ::std::u16string& input, std::optional<uint32_t> cursor_position, ::mojo::PendingAssociatedRemote<AutocompleteClient> client) final;
  
  void Stop() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AutocompleteClientProxy
    : public AutocompleteClient {
 public:
  using InterfaceType = AutocompleteClient;

  explicit AutocompleteClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResults(AutocompleteResultsPtr results, bool is_done) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutocompleteControllerStubDispatch {
 public:
  static bool Accept(AutocompleteController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutocompleteController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutocompleteController>>
class AutocompleteControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutocompleteControllerStub() = default;
  ~AutocompleteControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutocompleteControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutocompleteControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutocompleteClientStubDispatch {
 public:
  static bool Accept(AutocompleteClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutocompleteClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutocompleteClient>>
class AutocompleteClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutocompleteClientStub() = default;
  ~AutocompleteClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutocompleteClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutocompleteClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutocompleteControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutocompleteClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  AutocompleteMatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteMatch, T>::value>;
  using DataView = AutocompleteMatchDataView;
  using Data_ = internal::AutocompleteMatch_Data;

  template <typename... Args>
  static AutocompleteMatchPtr New(Args&&... args) {
    return AutocompleteMatchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteMatchPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteMatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteMatch>::Convert(*this);
  }


  AutocompleteMatch();

  AutocompleteMatch(
      AutocompleteMatchType type,
      const ::std::u16string& fill_into_edit,
      const ::std::u16string& inline_autocompletion,
      double score,
      const ::GURL& target_url,
      const ::std::u16string& title);


  ~AutocompleteMatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteMatchPtr>
  AutocompleteMatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteMatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteMatch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AutocompleteMatchType type;
  
  ::std::u16string fill_into_edit;
  
  ::std::u16string inline_autocompletion;
  
  double score;
  
  ::GURL target_url;
  
  ::std::u16string title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutocompleteResults {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteResults, T>::value>;
  using DataView = AutocompleteResultsDataView;
  using Data_ = internal::AutocompleteResults_Data;

  template <typename... Args>
  static AutocompleteResultsPtr New(Args&&... args) {
    return AutocompleteResultsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteResultsPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteResultsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteResults>::Convert(*this);
  }


  AutocompleteResults();

  explicit AutocompleteResults(
      std::vector<AutocompleteMatchPtr> matches);

AutocompleteResults(const AutocompleteResults&) = delete;
AutocompleteResults& operator=(const AutocompleteResults&) = delete;

  ~AutocompleteResults();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteResultsPtr>
  AutocompleteResultsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResults::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResults::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteResults::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteResults_UnserializedMessageContext<
            UserType, AutocompleteResults::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteResults::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteResults::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteResults_UnserializedMessageContext<
            UserType, AutocompleteResults::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteResults::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<AutocompleteMatchPtr> matches;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteResults::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AutocompleteMatchPtr AutocompleteMatch::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(fill_into_edit),
      mojo::Clone(inline_autocompletion),
      mojo::Clone(score),
      mojo::Clone(target_url),
      mojo::Clone(title)
  );
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool AutocompleteMatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->fill_into_edit, other_struct.fill_into_edit))
    return false;
  if (!mojo::Equals(this->inline_autocompletion, other_struct.inline_autocompletion))
    return false;
  if (!mojo::Equals(this->score, other_struct.score))
    return false;
  if (!mojo::Equals(this->target_url, other_struct.target_url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.fill_into_edit < rhs.fill_into_edit)
    return true;
  if (rhs.fill_into_edit < lhs.fill_into_edit)
    return false;
  if (lhs.inline_autocompletion < rhs.inline_autocompletion)
    return true;
  if (rhs.inline_autocompletion < lhs.inline_autocompletion)
    return false;
  if (lhs.score < rhs.score)
    return true;
  if (rhs.score < lhs.score)
    return false;
  if (lhs.target_url < rhs.target_url)
    return true;
  if (rhs.target_url < lhs.target_url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteResultsPtr AutocompleteResults::Clone() const {
  return New(
      mojo::Clone(matches)
  );
}

template <typename T, AutocompleteResults::EnableIfSame<T>*>
bool AutocompleteResults::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->matches, other_struct.matches))
    return false;
  return true;
}

template <typename T, AutocompleteResults::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.matches < rhs.matches)
    return true;
  if (rhs.matches < lhs.matches)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::AutocompleteMatch::DataView,
                                         ::owl::mojom::AutocompleteMatchPtr> {
  static bool IsNull(const ::owl::mojom::AutocompleteMatchPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutocompleteMatchPtr* output) { output->reset(); }

  static decltype(::owl::mojom::AutocompleteMatch::type) type(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->type;
  }

  static const decltype(::owl::mojom::AutocompleteMatch::fill_into_edit)& fill_into_edit(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->fill_into_edit;
  }

  static const decltype(::owl::mojom::AutocompleteMatch::inline_autocompletion)& inline_autocompletion(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->inline_autocompletion;
  }

  static decltype(::owl::mojom::AutocompleteMatch::score) score(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->score;
  }

  static const decltype(::owl::mojom::AutocompleteMatch::target_url)& target_url(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->target_url;
  }

  static const decltype(::owl::mojom::AutocompleteMatch::title)& title(
      const ::owl::mojom::AutocompleteMatchPtr& input) {
    return input->title;
  }

  static bool Read(::owl::mojom::AutocompleteMatch::DataView input, ::owl::mojom::AutocompleteMatchPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::AutocompleteResults::DataView,
                                         ::owl::mojom::AutocompleteResultsPtr> {
  static bool IsNull(const ::owl::mojom::AutocompleteResultsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutocompleteResultsPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::AutocompleteResults::matches)& matches(
      const ::owl::mojom::AutocompleteResultsPtr& input) {
    return input->matches;
  }

  static bool Read(::owl::mojom::AutocompleteResults::DataView input, ::owl::mojom::AutocompleteResultsPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_AUTOCOMPLETE_MOJOM_H_