// owl/mojom/autocomplete.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOCOMPLETE_MOJOM_SHARED_H_
#define OWL_MOJOM_AUTOCOMPLETE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autocomplete.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/autocomplete.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::AutocompleteConfiguration>
    : public mojo::internal::EnumHashImpl<::owl::mojom::AutocompleteConfiguration> {};

template <>
struct hash<::owl::mojom::AutocompleteMatchType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::AutocompleteMatchType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutocompleteConfiguration, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::AutocompleteConfiguration, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::AutocompleteConfiguration>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutocompleteMatchType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::AutocompleteMatchType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::AutocompleteMatchType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutocompleteMatchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::AutocompleteMatchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::AutocompleteMatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::owl::mojom::AutocompleteMatchType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::fill_into_edit(input)) in_fill_into_edit = Traits::fill_into_edit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fill_into_edit)::BaseType> fill_into_edit_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_fill_into_edit,
      fill_into_edit_fragment);

    fragment->fill_into_edit.Set(
        fill_into_edit_fragment.is_null() ? nullptr : fill_into_edit_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fill_into_edit.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fill_into_edit in AutocompleteMatch struct");

    decltype(Traits::inline_autocompletion(input)) in_inline_autocompletion = Traits::inline_autocompletion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inline_autocompletion)::BaseType> inline_autocompletion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_inline_autocompletion,
      inline_autocompletion_fragment);

    fragment->inline_autocompletion.Set(
        inline_autocompletion_fragment.is_null() ? nullptr : inline_autocompletion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inline_autocompletion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inline_autocompletion in AutocompleteMatch struct");

    fragment->score = Traits::score(input);

    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_url)::BaseType> target_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_target_url,
      target_url_fragment);

    fragment->target_url.Set(
        target_url_fragment.is_null() ? nullptr : target_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_url in AutocompleteMatch struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in AutocompleteMatch struct");
  }

  static bool Deserialize(::owl::mojom::internal::AutocompleteMatch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::AutocompleteMatchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::AutocompleteResultsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::AutocompleteResultsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::AutocompleteResults_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::matches(input)) in_matches = Traits::matches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matches)::BaseType>
        matches_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::AutocompleteMatchDataView>>(
      in_matches,
      matches_fragment,
      &matches_validate_params);

    fragment->matches.Set(
        matches_fragment.is_null() ? nullptr : matches_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->matches.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null matches in AutocompleteResults struct");
  }

  static bool Deserialize(::owl::mojom::internal::AutocompleteResults_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::AutocompleteResultsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void AutocompleteMatchDataView::GetFillIntoEditDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->fill_into_edit.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetInlineAutocompletionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->inline_autocompletion.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void AutocompleteResultsDataView::GetMatchesDataView(
    mojo::ArrayDataView<AutocompleteMatchDataView>* output) {
  auto pointer = data_->matches.Get();
  *output = mojo::ArrayDataView<AutocompleteMatchDataView>(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::AutocompleteConfiguration> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::AutocompleteConfiguration value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::AutocompleteMatchType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::AutocompleteMatchType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_AUTOCOMPLETE_MOJOM_SHARED_H_